# Monsters

## Elements Of A Stat Block

### Name

This is what most people call this kind of creature. Some creatures have alternate names, regional names, or even specific titles, all of which are included in its lore.

### Challenge Rating (CR)

A creature's challenge rating (CR) tells you how great a threat the creature is. An appropriately equipped and well - rested party of four adventurers should be able to defeat a creature with a CR equal to its level without suffering any deaths. For example, a party of four 3rd-level characters should find a creature with a CR of 3 to be a worthy challenge, but not a deadly one.

Creatures that are significantly weaker than 1st-level characters have a challenge rating lower than 1. Creatures with a challenge rating of 0 are insignificant except in large numbers. Some creatures present a greater challenge than even a typical 20th-level party can handle. These creatures have a CR of 21 or higher and are specifically designed to test player skill.

A creature's CR is used to determine several aspects of the creature, such as the experience points (XP) it provides when defeated and its proficiency bonus (PB).

### Experience Points (XP)

The number of experience points a creature is worth is based on its CR, as detailed in the Experience Points by Challenging Rating table. Typically, XP is awarded for defeating a creature, although the GM may also award XP for creatively avoiding or neutralizing the threat posed by the creature.

#### Table: Experience Points By Challenge Rating

|  CR |      XP |
| --: | ------: |
|   0 |      10 |
| 1/8 |      25 |
| 1/4 |      50 |
| 1/2 |     100 |
|   1 |     200 |
|   2 |     450 |
|   3 |     700 |
|   4 |   1,100 |
|   5 |   1,800 |
|   6 |   2,300 |
|   7 |   2,900 |
|   8 |   3,900 |
|   9 |   5,000 |
|  10 |   5,900 |
|  11 |   7,200 |
|  12 |   8,400 |
|  13 |  10,000 |
|  14 |  11,500 |
|  15 |  13,000 |
|  16 |  15,000 |
|  17 |  18,000 |
|  18 |  20,000 |
|  19 |  22,000 |
|  20 |  25,000 |
|  21 |  33,000 |
|  22 |  41,000 |
|  23 |  50,000 |
|  24 |  62,000 |
|  25 |  75,000 |
|  26 |  90,000 |
|  27 | 105,000 |
|  28 | 120,000 |
|  29 | 135,000 |
|  30 | 155,000 |

### Proficiency Bonus (PB)

Like PCs, creatures have a proficiency bonus (PB) based on their CR, as detailed in the Proficiency Bonus by Challenging Rating table. The PB is used to calculate many of the statistics within a creature's stat block, but the PB doesn't actually appear in the stat block.

All statistics derived from a creature's PB have the PB already included in the stat block. **You don't need to add the PB to any number in a creature's stat block.** You might need a creature's PB for other things, however, such as when a creature casts a spell that requires an attack roll.

#### Table: Proficiency Bonus By Challenge Rating

| CR    |  PB |
| ----- | --: |
| 00–04 |  +2 |
| 05–08 |  +3 |
| 09–12 |  +4 |
| 13–16 |  +5 |
| 17–20 |  +6 |
| 21–24 |  +7 |
| 25–28 |  +8 |
| 29+   |  +9 |

### Size

This is the relative size of the creature. A creature can be Tiny, Small, Medium, Large, Huge, or Gargantuan. The Size Categories table shows how much space a creature of a particular size occupies on a battle map or grid.

#### Table: Size Categories

| SIZE       | SPACE                 | EXAMPLES            |
| ---------- | --------------------- | ------------------- |
| Tiny       | 2.5 x 2.5 ft.         | Imp, sprite         |
| Small      | 5 x 5 ft.             | Giant rat, goblin   |
| Medium     | 5 x 5 ft.             | Orc, werewolf       |
| Large      | 10 x 10 ft.           | Hippogriff, ogre    |
| Huge       | 15 x 15 ft.           | Fire giant, treant  |
| Gargantuan | 20 x 20 ft. or larger | Kraken, purple worm |

### Type

A creature's type speaks to its fundamental nature. Certain spells, magic items, class features, and other effects interact in special ways with creatures of a particular type. For example, an arrow of dragon slaying deals extra damage to creatures of the Dragon type, such as red dragons, dragon turtles, and wyverns. Here is an overview of each of the creature types.

- **Aberrations** are utterly alien beings.
- **Beasts** are living creatures of the natural world.
- **Celestials** dwell in higher realms outside of measurable or material reality.
- **Constructs** are made, not born.
- **Dragons** are large, reptilian creatures of ancient origin and tremendous power.
- **Elementals** are creatures born of raw elemental forces.
- **Fey** are magical creatures closely tied to the forces of nature.
- **Fiends** dwell in lower realms outside of measurable or material reality.
- **Giants** are enormous, powerful beings that tower over most creatures.
- **Humanoids** are usually bipedal and often warm - blooded, including humans and a prodigious variety of other lineages.
- **Monstrosities** are frightening, abnormal, unnatural creatures that are almost never benign.
- **Oozes** are gelatinous predators typically without fixed forms.
- **Plants** are vegetable creatures, not ordinary flora.
- **Undead** are creatures that have previously died and been brought to a state of nightmarish undeath through necromantic magic, curses, or divine intervention.

#### Categories

Some creatures fall into categories that are a bit more specific than their creature types but not as game rule - related as tags (though some categories are the same as some tags, such as demon or golem). This categorization denotes the creatures are more closely related to each other than they are to other creatures of their same creature type, but there aren't many game rules that reference or rely on that category. However, categories can be helpful when determining which creatures are similar to each other, might be found together, or might work alongside each other. For example, bugbears, goblins, and hobgoblins are all part of the goblin family, regularly work together, and often inhabit the same areas. As such, they are listed as "Goblin, Creature Name" in this book.

#### Tags

Creatures may have various tags that further specify their creature type. If a creature has a tag, it is listed in the creature's stat block in parentheses after size and type. Tags indicate creatures that can be targeted by specific spells, magic items, and other features available to PCs. For example, the _moonbeam_ spell has special effects against creatures with the Shapechanger tag.

If a creature has a subtag, the creature is subject to effects related to both its tag and its subtag, though only the subtag is listed in its stat block. For example, a werewolf is both a Lycanthrope and a Shapechanger - though only Lycanthrope is listed in its stat block - and it is affected by spells, magic items, and other features that affect Shapechangers or Lycanthropes. The following are the most commonly used tags and their associated subtags:

**Animal.** A creature not of the Beast type but that shares enough characteristics with Beasts that it can be affected by spells, features, or other abilities that specifically target Beasts, such as the speak with animals spell.

**Golem.** A specific type of Construct that is almost always humanoid in shape, is typically crafted wholly out of a specific material, and has some magical connection to its creator. This connection might be that the golem was made from the remains of the creator's loved one, made with some of the creator's blood, made from an object with great sentimental significance to the creator, or made with some other object or material personal to the creator.

**Outsider.** A creature from another plane or realm not bound by laws of material or measurable reality. When an outsider is slain, its physical remains, other than any equipment it is wearing or carrying, disappear after 1 hour, and revives on its home plane. An outsider can be permanently destroyed only if it is slain on its home plane, or if a _wish_ spell is cast after it is slain on the Material Plane. There are a wide range of Outsiders from a variety of planes and realms. Some of the most common Outsiders are Angels, Demons, and Devils, which are defined as the following:

- **Angel.** A specific kind of Celestial Outsider bound in service to gods of good and order.
- **Demon.** A specific type of Fiend Outsider bound to the forces of evil and chaos.
- **Devil.** A specific type of Fiend Outsider bound in service to gods or fiendish lords of evil and order.

**Shapechanger.** A creature capable of changing form, such as a werewolf, doppelganger, or vampire. This tag applies only to creatures with the natural ability to change their shape. It doesn't apply to creatures that use magic- whether or not that magic is innate to the creature - to change their shape, such as gold dragons.

- **Lycanthrope.** A specific kind of Humanoid Shapechanger that changes its shape due to an animalistic curse called lycanthropy, allowing the creature to transform to and from a Beast form, its Humanoid form, and a hybrid of the two. The curse is typically passed by an attack from another Lycanthrope or by the creature having a Lycanthrope parent. Though all Lycanthropes are Shapechangers, not all Shapechangers are Lycanthropes.

### Armor Class (AC)

Armor class (AC) represents the creature's defenses. The higher the number, the more difficult the creature is to hit in combat. The kind of armor a creature uses (if any) or any special defenses a creature has (if any) are placed in parentheses after the AC value to help you alter the creature's AC if the armor is removed or the special defense is negated.

The AC included in each stat block has been calculated using the following formula. Keep in mind that AC is calculated before proficiency bonus (PB) is added to the Ability Modifiers:

**AC** = 10 + DEX modifier + any additional bonuses (from equipment, natural armor, or special traits)

### Hit Points (HP)

Hit points (HP) represent the health and vitality of the creature. The higher the number, the harder it is to kill or knock out the creature. Unlike PCs, creatures typically die or are destroyed when reduced to 0 HP.

### Speed

A creature's speed defines how far it can move during a single round of combat. If the creature has multiple ways to move (such as swimming or flying), those are also listed in this section.

All creatures have a walking speed, simply called speed.

Creatures with no ground - based movement have a walking speed of 0 feet. Some creatures have one or more of the following additional ways to move.

#### Burrow

A creature with a burrowing speed can move through sand, earth, mud, or ice. A creature can't burrow through solid rock unless it has a trait that allows it to do so. A creature can't drag a grappled creature along with it while burrowing, unless it has the ability to leave a tunnel when it burrows.

#### Climb

A creature with a climbing speed can move on vertical surfaces with no check required. The creature doesn't need to spend extra movement to climb.

#### Fly

A creature with a flying speed can move by flying. Some creatures can hover, which makes them hard to knock out of the air. Such a creature stops hovering when it dies. If a creature can hover, the word "hover" appears in parentheses after its flying speed.

#### Swim

A creature with a swimming speed can move easily through liquid and doesn't need to spend extra movement to swim.

#### Using Different Speeds

If a creature has more than one speed, such as a walking and flying speed, it can switch back and forth between its speeds during its move. Whenever the creature switches, subtract the distance the creature has already moved from the new speed. The result determines how much farther the creature can move. If the result is 0 or less, the creature can't use the new speed during the current move.

For example, if a creature has a speed of 30 and a flying speed of 60, the creature could fly 20 feet, then walk 10 feet, and then leap into the air to fly 30 feet more.

### Perception

The Perception Value shows how observant the creature is, regardless of whether it's actively observing its surroundings. This Perception Value is calculated using a creature's Wisdom (WIS).

A PC attempting to hide from, sneak around, or stage a surprise attack against a creature must make a DEX (Stealth) check. If the result is equal to or higher than the creature's Perception Value, the PC succeeds and remains undetected. If it is lower, the PC fails, and the creature detects the character. For example, a goblin has a Perception Value of 9. A PC's DEX (Stealth) check result must be a 9 or better for the PC to successfully sneak past the goblin.

The Perception Value included in each stat block has been calculated using the following formula. Some creatures are naturally perceptive, which allows them to add their PB or even double their PB when calculating their Perception Value. In such cases, the Perception Value in the stat block already includes that bonus.

Perception Value = 10 + WIS modifier

### Stealth

The Stealth Value shows how readily a creature evades notice - either to sneak around or stage a surprise attack.

Stealth is calculated using a creature's Dexterity (DEX).

A PC searching for unseen foes must make a WIS

(Perception) check. If the result is equal to or higher than the creature's Stealth score, the PC succeeds and detects signs of the creature. If it is lower, the PC fails, and the creature remains undetected. For example, a goblin has a Stealth Value of 14. A PC's WIS (Perception) check result must be a 14 or better to detect the goblin when it is trying to hide from the PC.

The Stealth Value included in each stat block has been calculated using the following formula. Some creatures are naturally stealthy, which allows them to add their PB or even double their PB when calculating their Stealth Value. In such cases, the Stealth Value in the stat block already includes that bonus.

**Stealth Value** = 10 + DEX modifier

**_Hiding._** When a monster takes the Hide action, it doesn't roll a DEX (Stealth) check. Instead, it uses the Stealth Value in its stat block.

### Vulnerable, Resistant, and Immune

Some creatures are vulnerable, resistant, or immune to certain kinds of damage or conditions. Particular creatures are even vulnerable, resistant, or immune to damage from nonmagical attacks. A magical attack is an attack delivered by a spell, a magic item, or another magical source.

**_Multiple Protective Sources._** Multiple instances of a creature being resistant or vulnerable to a type of damage count as only one instance. For example, if a creature has resistance to fire damage, such as a from its natural capabilities or the _protection from energy_ spell, as well as resistance to nonmagical damage, such as from the _gaseous form_ spell, the damage of a nonmagical fire is reduced by half against the creature, not reduced by three - quarters.

**_Conditions and Damage._** Each creature has only one line for each of the following categories. This means that a creature resistant to cold damage and the grappled condition lists both cold and grappled in the Resistant line. In many cases, a creature being vulnerable, resistant, or immune to a condition or type of damage is due to its creature type, which is noted as the associated trait's name in the appropriate category line and detailed in the traits section of the stat block. For example, the ettercap's Monstrosity Resilience trait makes it resistant to exhaustion and the frightened condition. The ettercap's Resistant line, therefore, lists Monstrosity Resilience.

#### Vulnerable

If a creature is vulnerable to a type of damage and it takes damage of that type, the damage is doubled against the creature. For example, a creature vulnerable to fire damage takes double damage from a _fireball_ spell or flaming oil.

A creature that is vulnerable to a condition has disadvantage on checks and saves made to avoid becoming affected by that condition or to end it.

#### Resistant

If a creature is resistant to a type of damage and it takes damage of that type, the damage is halved (rounded down) against the creature.

A creature that is resistant to a condition has advantage on checks and saves made to avoid becoming affected by that condition or to end it.

#### Immune

If a creature is immune to a type of damage, it doesn't take damage of that type or lose hit points when subjected to that type of damage. If a spell, class feature, or other effect deals damage of a type to which a creature is immune and has an extra effect, such as causing the charmed or frightened condition, the creature doesn't take that damage, but it might still be subjected to that extra effect. For example, a creature immune to slashing damage would be immune to the slashing damage of a ghoul's Claws, but it might still become paralyzed if it fails the Claws' CON save.

A creature that is immune to a condition automatically succeeds on checks and saves to avoid the condition and otherwise can't be affected by that condition.

### Senses

Creatures primarily perceive the world by sight. This is called vision. Creatures usually have secondary senses of hearing, smell, and touch that also allow them to interact with the environment, but vision is considered the "standard" primary sense.

If a creature has no unusual sensory capacity, the Senses section is marked with "-" and denotes a creature can see as an average human.

If a creature has one of the following specialized senses that allows it to perceive in some way other than "standard" vision, it is noted in the Senses line, followed by a radius in feet that defines the sense's maximum range.

**_Senses and Targeting._** When a creature targets another with an attack, effect, or other feature, the creature must be able to see or sense the target with at least one of its listed senses, and the target can't be behind total cover, unless that attack, effect, or feature states otherwise.

#### Darkvision

A creature with darkvision can see in nonmagical darkness.

The creature can see in dim light within the radius as if it were bright light and can see in darkness as if it were dim light. A creature can't discern color in darkness, only shades of gray. Many nocturnal creatures and creatures that live underground have this special sense.

#### Keensense

A creature with keensense can precisely perceive its surroundings using some other sense than vision. Creatures without vision, such as morlocks and gelatinous cubes, typically have this special sense, as do creatures with echolocation or other extraordinary sense, such as bats and true dragons.

If a creature has no other form of sensing, it has a parenthetical note to this effect, indicating that the radius of its keensense defines the maximum range of its perception.

#### Tremorsense

A creature with tremorsense can detect and pinpoint the source of vibrations if it and the source are in contact with the same ground or similar solid substance. Tremorsense can't be used to detect flying creatures or creatures with the Incorporeal Movement trait. A creature with tremorsense is considered to have line of sight to any creature in contact with the same ground as it, although obstacles between the creature and its target can still provide the target with cover. Many burrowing creatures, such as ankhegs and purple worms, have this special sense.

#### Truesight

A creature with truesight can see clearly in normal and magical darkness, see invisible creatures and objects, automatically detect and succeed on saves against visual illusions, and perceive the original form of a shapechanger or creature that is transformed by magic. Furthermore, the creature can see into the Ethereal Plane within range. Powerful or exceptionally magical creatures, such as balors and solars, have this special sense.

### Languages

The languages that a creature can speak are listed in alphabetical order. If a creature can understand a language but can't speak it, that is noted on this line. A "-" indicates that a creature neither speaks nor understands any language. Most languages are specific to a particular heritage or culture; a few are based on faith, commerce, or traveler's tongues.

#### Telepathy

Telepathy is a magical ability that allows a creature to mentally communicate with another creature within a specified range. A telepathic creature can start or end a telepathic conversation at will, without using an action, like talking. A telepathic creature doesn't need to see a contacted creature to communicate, it only needs to be in range.

A telepathic creature can communicate with a creature that doesn't have telepathy. The contacted creature doesn't need to share a language with the telepathic creature to communicate, but it must understand at least one language. The contacted creature can receive and respond to telepathic messages, but it can't start or end telepathic communication.

Contact breaks if two creatures are no longer within range of each other or if the telepathic creature contacts a different creature. While a telepathic creature is incapacitated, it can't start telepathy, and any contact ends.

A creature in an antimagic field or in any location where magic doesn't function can't send or receive telepathic messages.

### Ability Modifiers

Every creature has six ability modifiers: Strength (STR), Dexterity (DEX), Constitution (CON), Intelligence (INT), Wisdom (WIS), and Charisma (CHA). These modifiers are used to determine pre - calculated elements of a stat block, such as attack and damage. More importantly, the GM uses them whenever a creature must make:

- A save. The GM rolls a d20 and adds the relevant ability modifier.
- An ability check. The GM rolls a d20 and adds whichever ability modifier is most relevant.

If a creature is particularly good at checks and saves involving a certain ability, the creature's proficiency bonus (PB) has already been added into the ability modifiers presented in the stat block. **You don't need to add PB to any number in a stat block** - it is already included.

### Traits

Traits are a creature's special characteristics that are likely to be relevant in combat. These are often passive features the creature has, such as the ability to breathe underwater or increased Stealth in particular types of terrain. In a stat block, traits appear after a creature's ability modifiers but before any actions.

**_Is It Magical or Not?_** Creatures have a variety of magical and nonmagical traits and other features. If a trait or feature is described as working like a spell, then it is considered magical and doesn't function inside an area where magic doesn't function, such as the area of the antimagic field spell. If a trait or feature doesn't name a spell or if that trait or feature's text states it isn't magical, then it can function normally regardless of if magic functions in an area. For example, the storm giant's Influence Weather trait and the lich's Levitate bonus action are both described as working like specific spells and are therefore magical.

### Actions

When a creature takes its action, it can choose from the options in the Actions section of its stat block or use one of the actions available to all creatures, such as the Dash or Hide action.

#### Melee And Ranged Attacks

The most common actions that a creature takes in combat are melee and ranged attacks. These can be spell attacks or weapon attacks, where the "weapon" might be a manufactured item or a natural weapon, such as a claw or tail spike.

Creature vs. Target. The target of a melee or ranged attack is usually either one creature or one target. The difference is that a "target" can be a creature, object, or structure.

This designator on an attack reflects the creature's natural inclination, but it doesn't mean a tyrannosaurus rex can't or won't bite at a door to get to a creature it can smell on the other side. This designator helps reflect that a creature like a tyrannosaurus rex isn't likely to strategically attack pillars of a building to make the building collapse on its prey or to otherwise attack an object or structure in a way that isn't directly related to reaching its prey.

**_Hit._** Any damage dealt and other effects that occur when an attack hits a target are described after the "Hit:" notation.

**_Ammunition._** A creature carries enough ammunition to make its ranged attacks. A creature generally has 2d4 pieces of ammunition for a thrown weapon attack, and 2d10 pieces of ammunition for a projectile weapon, such as a bow or crossbow.

**_Spell Attacks and Antimagic._** A creature in an _antimagic field_ or in any location where magic doesn't function can't cast spells or make spell attacks. Similarly, targets in an _antimagic field_ are immune to the damage and effects of spell attacks and spells from outside of the field.

#### Multiattack

A creature that can make multiple attacks on its turn has the Multiattack action. A creature can't use Multiattack when making an opportunity attack, which must be a single melee attack.

#### Spellcasting

A creature with the Spellcasting action can cast spells through innate magical talent. Unless noted otherwise, a spell of 1st circle or higher is always cast at its lowest possible circle and can't be cast at a higher circle. If a creature has a cantrip where its spellcaster level matters and no level is given, use the creature's challenge rating.

A creature doesn't adhere to the tenets, restrictions, or requirements of specific spellcasting classes, sources of magic, or similar spellcasting structures found among player characters, as a creature's spellcasting is unique to the creature. A creature's spells can't be swapped out with other spells.

##### Spell Save DCs And Spells With Attacks

The Spellcasting action always lists the creature's spellcasting ability and the spell save DC for its spells. When a spell listed in this action requires an attack roll, use the creature's spellcasting ability modifier + the creature's PB to determine the creature's total attack bonus.

##### Spell Components

The Spellcasting action always notes if the creature doesn't need to use a particular type of spell component, such as material components. If no exception is listed in the creature's Spellcasting action, the creature must provide all necessary components to cast the spell. For the purposes of casting a spell, a creature needs free use of at least one limb to produce gestures for somatic components rather than specifically free use of one hand.

### Bonus Actions

If a creature can do something special with its bonus action, that information is contained here. If a creature has no special bonus action, this section is absent.

### Reactions

If a creature can do something special with its reaction, that information is contained here. If a creature has no special reaction, this section is absent.

### Limited Usage

Some traits or actions have restrictions on the number of times they can be used. Common examples:

**_X/Day._** This means a special ability can be used a limited number of times in a day, where "X" is a number (often 1 or 3). The creature must finish a long rest to regain expended uses. For example, "1/Day" means a special ability can be used once and then the creature must finish a long rest to use it again.

**_Recharge X–Y._** This means a creature can use a special ability once. Afterward, the ability has a random chance of recharging during each round of combat. "X" and "Y" are values on a d6 (often 5 and 6). At the start of each of the creature's turns, roll a d6. If the result is in the range of numbers in the recharge notation, the creature regains the use of the special ability. The ability also recharges when the creature finishes a short or long rest. For example, "Recharge 5–6" means a creature can use the special ability once. Then, at the start of the creature's turn, it regains the use of that ability if it rolls a 5 or 6 on a d6.

**_Recharge after a Short or Long Rest._** This means that a creature can use a special ability once and then must finish a short or long rest to use it again.

**_Situational._** This covers a lot of territory where an ability can be used only after a certain requirement is met. This information always appears in parentheses. For example, Vicious Bound (44 HP or Fewer) means a creature can't use the Vicious Bound action unless it has 44 hit points (HP) or fewer remaining.

### Equipment

A stat block rarely refers to equipment, other than a creature's armor or weapons. A creature that customarily wears clothes, such as a Humanoid, is assumed to be dressed appropriately.

If a spellcasting creature needs material components to cast its spells, assume that it has what it needs to cast the spells in its stat block.

## Legendary Creatures

A legendary creature can do things that ordinary creatures can't. It can take special actions outside its turn, and it might exert magical influence for miles around. If a creature assumes the form of a legendary creature, such as through a spell, it doesn't gain that form's legendary actions, lair actions, or regional effects.

### Legendary Actions

A legendary creature can take a certain number of special actions - called legendary actions - outside its turn. Only one legendary action option can be used at a time and only at the end of another creature's turn. A creature regains its spent legendary actions at the start of its turn. It doesn't have to use them, and it can't use them while incapacitated or otherwise unable to take actions. If surprised, it can't use them until after its first turn in the combat.

### Lairs

A legendary creature might have a section describing its lair and the special effects it can create while there, either by act of will or simply by being present. Such a section applies only to a legendary creature that spends a great deal of time in its lair.

#### Lair Actions

If a legendary creature has lair actions, it can use them to harness the ambient magic in its lair. On initiative count 20 (losing all initiative ties), it can use one of its lair action options. It can't do so while incapacitated or otherwise unable to take actions. If surprised, it can't use one until after its first turn in the combat.

**Regional Effects**

The mere presence of a legendary creature can have strange and wondrous effects on its environment, as noted in this section. Regional effects end abruptly or dissipate over time when the legendary creature dies.

## Monsters A to Z

### Aboleth (CR 10)

_Large Aberration_

- **Armor Class** 17 (natural armor)
- **Hit Points** 165
- **Speed** 10 ft., swim 40 ft.
- **Perception** 20
- **Stealth** 9
- **Resistant** acid | Aberrant Resilience
- **Immune** psychic
- **Senses** darkvision 120 ft.
- **Languages** Deep Speech, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +6 |  +8 |  +6 |  +4 |

- **_Aberrant Resilience._** The aboleth is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Amphibious._** The aboleth can breathe air and water.
- **_Legendary Resistance (3/Day)._** If the aboleth fails a save, it can choose to succeed instead.
- **_Probing Telepathy._** If a creature the aboleth can see communicates telepathically with the aboleth, the aboleth learns the creature's greatest desires.
- **_Slime Pox._** Characterized by the slimy pustules that erupt across the victim's body, _slime pox_ is a disease that infects creatures attacked by an aboleth or that come into contact with an aboleth's slime. Until the disease is cured, the infected creature can breathe air and water, can't regain HP except when underwater, and takes 6 (1d12) acid damage for every 1 hour it remains outside of water or without moisture applied to its skin. Every 24 hours that elapse, the infected creature must make a DC 16 CHA save. Each time a creature fails this save, it views the infecting aboleth more and more favorably, becoming the aboleth's doting and protective thrall after three failed saves.

  The successes and failures don't need to be consecutive, but once a creature has acquired three of a kind, it no longer has to make this save, resulting in either the creature becoming a thrall of the aboleth or an autonomous - though infected - creature. _Slime pox_ can be cured only by the heal spell or similar magic.

- **_Slimy Skin._** The aboleth is coated in an otherworldly mucus. A creature that touches the aboleth or that hits it with a melee attack while within 5 feet of it must succeed on a DC 16 CON save or be infected with _slime pox_ (see the Slime Pox trait).

**Actions**

- **_Multiattack._** The aboleth makes three Tentacle or Psychic Bolt attacks. If two Tentacle attacks hit one target, the target must succeed on a DC 16 CON save or contract the _slime pox_ disease (see the Slime Pox trait).
- **_Tentacle._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 15 (3d6+5) bludgeoning damage.
- **_Psychic Bolt._** _Ranged Spell Attack:_ +8 to hit, range 120 ft., one target. _Hit:_ 14 (3d6+4) psychic damage.
- **_Psychic Torrent (Recharge 5 - 6)._** The aboleth floods the minds of up to three creatures it can see within 60 feet of it with random and horrific memories from its eons - long life. Each target must make a DC 16 WIS save. On a failure, a creature takes 49 (14d6) psychic damage and is incapacitated until the end of its next turn, as its mind reels from the torrent of images, thoughts, and memories. On a success, a creature takes half the damage and isn't incapacitated.

**Legendary Actions**

The aboleth can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The aboleth regains spent legendary actions at the start of its turn.

- **_Detect._** The aboleth automatically detects every creature and trap within 60 feet of it, pinpointing the current location of each.
- **_Swim._** The aboleth swims up to half its speed without provoking opportunity attacks.
- **_Slime Drain (Costs 2 Actions)._** One Creature Infected With _Slime Pox_ within 30 feet of the aboleth takes 10 (3d6) acid damage, and the aboleth regains HP equal to the damage the creature takes.

### Angels

#### Deva (CR 10)

_Medium Celestial (Angel)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 165
- **Speed** 30 ft., fly 90 ft.
- **Perception** 19
- **Stealth** 14
- **Resistant** Angelic Resilience
- **Immune** Angelic Resilience
- **Senses** darkvision 120 ft.
- **Languages** all, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +4 |  +4 |  +3 |  +9 |  +9 |

- **_Angelic Resilience._** The deva is resistant to radiant damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and the charmed and frightened conditions.
- **_Angelic Senses._** The deva can pinpoint the location of Aberrations, Celestials, Fiends, and Undead within 30 feet of it and knows if a place or object it can sense is consecrated or desecrated.
- **_Angelic Weapons._** The deva's weapon attacks are magical. When the deva hits with any weapon, the weapon deals an extra 4d8 radiant damage (included in the attack).
- **_Immortal Nature._** The deva doesn't require food, drink, or sleep.
- **_Magic Resistance._** The deva has advantage on saves against spells and other magical effects.
- **_Reviving Prayer._** The deva spends 10 minutes praying to its deity for the safe return of the soul of a slain creature. At the end of the prayer, the deva touches a creature that has been dead no more than 24 hours and returns the creature to life with a number of HP equal to half its HP maximum. Reviving Prayer can't return to life a creature that has died of old age, nor can it restore any missing body parts. A creature restored to life in this way can't be returned to life by this deva again for 30 days.

**Actions**

- **_Multiattack._** The deva makes three Mace attacks.
- **_Mace._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) bludgeoning damage plus 18 (4d8) radiant damage.
- **_Healing Touch (3/Day)._** The deva touches another creature. The target magically regains 20 (4d8+2) HP and is freed from any curse, disease, poison, blindness, or deafness.

**Bonus Actions**

- **_Change Shape._** The deva magically transforms into a Large or smaller Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Celestial. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the deva's choice). It reverts to its true form if it dies. In a new form, the deva retains its Angelic Resilience, Angelic Senses, and Immortal Nature traits and its HP, HD, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Planetar (CR 16)

_Large Celestial (Angel)_

- **Armor Class** 19 (natural armor)
- **Hit Points** 242
- **Speed** 40 ft., fly 120 ft.
- **Perception** 21
- **Stealth** 15
- **Resistant** Angelic Resilience
- **Immune** Angelic Resilience
- **Senses** truesight 120 ft.
- **Languages** all, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +5 | +12 |  +4 | +11 | +11 |

- **_Angelic Resilience._** The planetar is resistant to radiant damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and the charmed and frightened conditions.
- **_Angelic Senses._** The planetar can pinpoint the location of Aberrations, Celestials, Fiends, and Undead within 30 feet of it and knows if a place or object it can sense is consecrated or desecrated.
- **_Angelic Weapons._** The planetar's weapon attacks are magical. When it hits with any weapon, the weapon deals an extra 7d8 radiant damage (included in the attack).
- **_Divine Awareness._** The planetar knows if it hears a lie.
- **_Divine Protection._** Aberrations, Celestials, Fiends, and Undead have disadvantage on attack rolls against the planetar.
- **_Immortal Nature._** The planetar doesn't require food, drink, or sleep.
- **_Magic Resistance._** The planetar has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The planetar makes two Greatsword attacks, or it makes three Radiant Bolt attacks. It can replace one attack with a use of Spellcasting. If two Greatsword or Radiant Bolt attacks hit one creature, the target must succeed on a DC 19 CON save or be blinded until the end of its next turn.
- **_Greatsword._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 21 (4d6+7) slashing damage plus 31 (7d8) radiant damage.
- **_Radiant Bolt._** _Ranged Spell Attack:_ +11 to hit, range 60 ft., one target. _Hit:_ 33 (6d8+6) radiant damage.
- **_Radiant Burst (Recharge 6)._** A pulse of divine power ripples out from the planetar's golden halo. Each hostile creature within 15 feet of the planetar must make a DC 19 DEX save, taking 56 (16d6) radiant damage on a failed save, or half as much damage on a successful one. Each friendly creature within 15 feet of the planetar is empowered with divine energy and has advantage on all melee attack rolls it makes before the start of the planetar's next turn.
- **_Healing Touch (4/Day)._** The planetar touches another creature. The target magically regains 30 (6d8+3) HP and is freed from any curse, disease, poison, blindness, or deafness.
- **_Spellcasting._** The planetar casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 19).
  - At will: _command_, _invisibility_ (self only)
  - 3/day each: _daylight_, _raise dead_ (as an action)

#### Solar (CR 21)

_Large Celestial (Angel)_

- **Armor Class** 21 (natural armor)
- **Hit Points** 306
- **Speed** 50 ft., fly 150 ft.
- **Perception** 24
- **Stealth** 16
- **Resistant** Angelic Resilience
- **Immune** necrotic, poison | poisoned | Angelic Resilience
- **Senses** truesight 120 ft.
- **Languages** all, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +6 |  +8 | +14 | +14 | +17 |

- **_Angelic Resilience._** The solar is resistant to radiant damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and the charmed and frightened conditions.
- **_Angelic Senses._** The solar can pinpoint the location of Aberrations, Celestials, Fiends, and Undead within 30 feet of it and knows if a place or object it can sense is consecrated or desecrated.
- **_Angelic Weapons._** The solar's weapon attacks are magical. When the solar hits with any weapon, the weapon deals an extra 6d8 radiant damage (included in the attack).
- **_Divine Awareness._** The solar knows if it hears a lie.
- **_Divine Protection._** Aberrations, Celestials, Fiends, and Undead have disadvantage on attack rolls against the solar.
- **_Immortal Nature._** The solar doesn't require food, drink, or sleep.
- **_Legendary Resistance (3/Day)._** If the solar fails a save, it can choose to succeed instead.
- **_Magic Resistance._** The solar has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The solar makes three Greatsword or Holy Fire Bolt attacks. It can replace one attack with a use of Spellcasting. If two Greatsword or Holy Fire Bolt attacks hit one creature, the target must succeed on a DC 22 CON save or be blinded until the end of its next turn.
- **_Greatsword._** _Melee Weapon Attack:_ +15 to hit, reach 5 ft., one target. _Hit:_ 22 (4d6+8) slashing damage plus 27 (6d8) radiant damage.
- **_Holy Fire Bolt._** _Ranged Spell Attack:_ +14 to hit, range 60 ft., one target. _Hit:_ 34 (6d8+7) radiant damage plus 14 (4d6) fire damage.
- **_Healing Touch (4/Day)._** The solar touches another creature. The target magically regains 40 (8d8+4) HP and is freed from any curse, disease, poison, blindness, or deafness.
- **_Spellcasting._** The solar casts one of the following spells, requiring no material components and using WIS as the spellcasting ability (spell save DC 22).
  - At will: _command_, _invisibility_ (self only)
  - 3/day each: _greater restoration_, _resurrection_ (as an action)
  - 1/day: _holy aura_

**Bonus Actions**

- **_Celestial Tactics._** The solar uses one of the following tactics:
  - **Empower Strikes.** The solar sends divine power into the weapons of up to two friendly creatures it can see within 30 feet of it. Each target has advantage on the next weapon attack roll it makes before the start of the solar's next turn. If that attack hits, the weapon deals an extra 7 (2d6) radiant damage.
  - **Inspire Resolve.** One friendly creature the solar can see within 30 feet of it gains 14 (4d6) temporary HP and becomes immune to the charmed and frightened conditions until the start of the solar's next turn, ending any effect currently causing the target to be charmed or frightened.
  - **Manipulate Battlefield.** The solar commands up to three friendly creatures it can see to reposition themselves on the battlefield. Each target can use a reaction to move up to half its speed in a direction of the solar's choice. This movement is unaffected by difficult terrain and doesn't provoke opportunity attacks.

**Legendary Actions**

The solar can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The solar regains spent legendary actions at the start of its turn.

- **_Teleport._** The solar magically teleports, along with any equipment it is wearing or carrying, up to 120 feet to an unoccupied space it can see.
- **_Searing Burst (Costs 2 Actions)._** The Solar Emits Divine Energy. Each creature of its choice within 10 feet of it must make a DC 22 DEX save, taking 14 (4d6) fire damage and 14 (4d6) radiant damage on a failed save, or half as much damage on a successful one.
- **_Intimidating Glare (Costs 3 Actions)._** The Solar Glares At Up To Three creatures it can see within 30 feet of it. Each target must succeed on a DC 22 CHA save or be cowed until the end of its next turn. While cowed, a creature's speed is halved, and it can't look at the solar.

### Animated Objects

#### Animated Armor (CR 1)

_Medium Construct_

- **Armor Class** 18 (natural armor)
- **Hit Points** 34
- **Speed** 25 ft.
- **Perception** 8
- **Stealth** 10
- **Vulnerable** acid
- **Resistant** slashing
- **Immune** blinded, deafened | Construct Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +1 |  -5 |  -2 |  -5 |

- **_Antimagic Susceptibility._** The armor is incapacitated while in the area of an antimagic field. If targeted by _dispel magic_, the armor must succeed on a CON save against the caster's spell save DC or fall unconscious for 1 minute.
- **_Construct Nature._** The armor doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The armor is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_False Appearance._** While the armor remains motionless, it is indistinguishable from a normal suit of armor.

**Actions**

- **_Multiattack._** The animated armor makes two Slam attacks.
- **_Slam._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) bludgeoning damage.

**Bonus Actions**

- **_Helmet Bash (19 HP or Fewer)._** The animated armor slams its helmet into a creature it can sense within 5 feet of it. The target must succeed on a DC 13 STR save or take 5 (2d4) bludgeoning damage and be knocked prone.

#### Flying Sword (CR 1/4)

_Small Construct_

- **Armor Class** 16 (natural armor)
- **Hit Points** 11
- **Speed** 0 ft., fly 50 ft. (hover)
- **Perception** 7
- **Stealth** 13
- **Vulnerable** acid
- **Resistant** piercing
- **Immune** blinded, deafened, prone | Construct Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +3 |  +0 |  -5 |  -3 |  -5 |

- **_Antimagic Susceptibility._** The sword is incapacitated while in the area of an antimagic field. If targeted by _dispel magic_, the sword must succeed on a CON save against the caster's spell save DC or fall unconscious for 1 minute.
- **_Construct Nature._** The sword doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The sword is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_False Appearance._** While the sword remains motionless and isn't flying, it is indistinguishable from a normal sword.

**Actions**

- **_Slash._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 5 (1d8+1) slashing damage.

**Bonus Actions**

- **_Whirling Blade (6 HP or Fewer)._** The flying sword makes a Slash attack against a target it can sense within 5 feet of it.

#### Rug of Smothering (CR 2)

_Large Construct_

- **Armor Class** 12
- **Hit Points** 45
- **Speed** 10 ft., fly 15 ft. (hover)
- **Perception** 8
- **Stealth** 14
- **Vulnerable** fire
- **Immune** blinded, deafened | Construct Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +0 |  -5 |  -4 |  -5 |

- **_Antimagic Susceptibility._** The rug is incapacitated while in the area of an antimagic field. If targeted by _dispel magic_, the rug must succeed on a CON save against the caster's spell save DC or fall unconscious for 1 minute.
- **_Construct Nature._** The rug doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The rug is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Damage Transfer._** While it is grappling a creature, the rug takes only half the damage dealt to it (rounded down), and the creature grappled by the rug takes the other half.
- **_False Appearance._** While the rug remains motionless and isn't flying, it is indistinguishable from a normal rug.

**Actions**

- **_Smother._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one Medium or smaller creature. _Hit:_ 12 (2d8+3) bludgeoning damage, and the target is grappled (escape DC 13). Until this grapple ends, the target is restrained, blinded, and unable to breathe, and the rug can't fly and can't Smother another target.
- **_Squeeze Prey._** The rug of smothering tightens around a creature it is grappling. The target must make a DC 13 STR save, taking 18 (4d8) bludgeoning damage on a failed save, or half as much damage on a successful one. A breathing creature that fails this save by 5 or more has the remaining air squeezed from its lungs and begins suffocating.

**Bonus Actions**

- **_Rolling Charge (25 HP or Fewer)._** If it isn't grappling a creature, the rug curls up and rolls along the ground up to triple its speed straight toward a creature it can sense. If it stops within 5 feet of the target, it can make one Smother attack against the target.

### Ankheg (CR 2)

_Large Monstrosity (Animal)_

- **Armor Class** 14 (natural armor)
- **Hit Points** 57
- **Speed** 30 ft., burrow 10 ft.
- **Perception** 11
- **Stealth** 12
- **Resistant** acid | Monstrosity Resilience
- **Senses** darkvision 60 ft., tremorsense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +1 |  -5 |  +1 |  -2 |

- **_Monstrosity Resilience._** The ankheg is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage plus 9 (2d8) acid damage. If the target is a Large or smaller creature, it is grappled (escape DC 13). Until this grapple ends, the ankheg can't Bite another target.
- **_Acid Spray (Recharge 6)._** The ankheg spits acid in a line that is 30 feet long and 5 feet wide, provided it has no creature grappled. Each creature in that line must make a DC 13 DEX save, taking 18 (4d8) acid damage on a failed save, or half as much damage on a successful one.

**Bonus Actions**

- **_Save for Later._** The ankheg quickly digs a small hole and stuffs one creature grappled by it into the hole, burying the creature and ending the grapple. A buried creature is restrained and unable to breathe or stand up. A creature, including the buried creature, can take its action to free the buried creature by succeeding on a DC 13 STR check.

### Azer (CR 2)

_Medium Elemental_

- **Armor Class** 17 (natural armor, shield)
- **Hit Points** 49
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 11
- **Immune** fire, poison | poisoned
- **Senses** -
- **Languages** Dwarvish, Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +4 |  +1 |  +1 |  +0 |

- **_Heated Body._** A creature that touches the azer or hits it with a melee attack while within 5 feet of it takes 3 (1d6) fire damage.
- **_Heated Weapons._** When the azer hits with a metal melee weapon, the weapon deals an extra 3 (1d6) fire damage (included in the attack).
- **_Illumination._** The azer sheds bright light in a 10 - foot radius and dim light for an additional 10 feet.

**Actions**

- **_Multiattack._** The azer makes two Warhammer attacks.
- **_Warhammer._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage, or 8 (1d10+3) bludgeoning damage if used with two hands, plus 3 (1d6) fire damage.

**Bonus Actions**

- **_Blazing Bulwark._** The azer creates fire in a 15 - foot line that is 1 foot wide, originating from a point the azer can see within 15 feet of it. This line is an opaque wall that is 3 feet tall and provides half - cover to creatures behind it. A creature that moves through the line takes damage as if it touched the azer. The line of fire lasts for 1 minute or until the azer uses this bonus action again.

### Balara (CR 6)

_Large Undead_

- **Armor Class** 17 (natural armor)
- **Hit Points** 114
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 12
- **Resistant** necrotic
- **Immune** charmed, frightened | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -2 |  +2 |  -1 |

- **_Terrifying Luminance._** When a creature that can see the balara's glowing ribcage starts its turn within 30 feet of the balara, the balara can force it to make a DC 14 WIS save if the balara isn't incapacitated and can see the creature. On a failure, the creature is frightened until the start of its next turn, as the visions, fear, and pain of the last moments of several animals flash through its mind. While frightened, the creature's speed is reduced to 0, and it can't use reactions. Unless surprised, a creature can avert its eyes to avoid the save at the start of its turn. If the creature does so, it can't see the balara until the start of its next turn, when it can avert its eyes again. If the creature looks at the balara in the meantime, it must immediately make the save.
- **_Undead Nature._** The balara doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The balara is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The balara makes one Bite attack and two Claw attacks, or it makes three Necrotic Bolt attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 16 (3d8+3) piercing damage plus 4 (1d8) necrotic damage, and the target can't regain HP until the start of the balara's next turn.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (3d6+3) slashing damage.
- **_Necrotic Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 15 (3d8+2) necrotic damage, and the target can't regain HP until the start of the balara's next turn.

**Reactions**

- **_Relentless Pursuit._** When a creature the balara can see moves away from it, the balara can move up to half its speed toward that creature. This movement doesn't provoke opportunity attacks.

### Basilisk (CR 3)

_Medium Monstrosity_

- **Armor Class** 15 (natural armor)
- **Hit Points** 68
- **Speed** 20 ft.
- **Perception** 9
- **Stealth** 9
- **Resistant** poison | petrified | Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  -1 |  +2 |  -4 |  -1 |  -2 |

- **_Monstrosity Resilience._** The basilisk is resistant to exhaustion and to the frightened condition.
- **_Petrifying Gaze._** When a creature that can see the basilisk's eyes starts its turn within 30 feet of the basilisk, the basilisk can force it to make a DC 12 CON save if the basilisk isn't incapacitated and can see the creature. On a failure, the creature magically begins to turn to stone and is restrained. The restrained creature must repeat the save at the end of its next turn, becoming petrified on a failure or ending the effect on a success. The petrification lasts until the creature is freed by the greater restoration spell or other magic. Unless surprised, a creature can avert its eyes to avoid the save at the start of its turn. If the creature does so, it can't see the basilisk until the start of its next turn, when it can avert its eyes again. If the creature looks at the basilisk in the meantime, it must immediately make the save. If the basilisk sees itself reflected on a polished surface within 30 feet of it and in an area of bright light, the basilisk mistakes itself for a rival and is affected by its own gaze.

**Actions**

- **_Multiattack._** The basilisk makes two Bite or Poison Spit attacks. If both Bite or Poison Spit attacks hit one creature, the target is poisoned until the end of its next turn.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage plus 7 (2d6) poison damage.
- **_Poison Spit._** _Ranged Weapon Attack:_ +5 to hit, range 20/60 ft., one target. _Hit:_ 13 (3d6+3) poison damage.

### Behir (CR 11)

_Huge Monstrosity_

- **Armor Class** 17 (natural armor)
- **Hit Points** 223
- **Speed** 50 ft., climb 40 ft.
- **Perception** 16
- **Stealth** 17
- **Resistant** Monstrosity Resilience
- **Immune** lightning
- **Senses** darkvision 90 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +3 |  +4 |  -2 |  +6 |  +1 |

- **_Lightning Absorption._** Whenever the behir is subjected to lighting damage, it takes no damage and instead regains a number of HP equal to the lightning damage dealt.
- **_Monstrosity Resilience._** The behir is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The behir makes one Bite attack and one Constrict attack. It can replace its Bite attack with a use of Swallow.
- **_Bite._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 22 (3d10+6) piercing damage plus 27 (6d8) lightning damage.
- **_Constrict._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one Large or smaller creature. _Hit:_ 17 (2d10+6) bludgeoning damage. If the target is Large or smaller and the behir isn't already grappling a creature, the target is grappled (escape DC 16). Until this grapple ends, the target is restrained, and the behir can't Constrict another target.
- **_Swallow._** The behir makes one Bite attack against a Medium or smaller target it is grappling. If the attack hits, the target is also swallowed, and the grapple ends. While swallowed, the target is blinded and restrained, it has total cover against attacks and other effects outside the behir, and it takes 21 (6d6) acid damage at the start of each of the behir's turns. A behir can have only one creature swallowed at a time. If the behir takes 30 damage or more on a single turn from the swallowed creature, the behir must succeed on a DC 14 CON save at the end of that turn or regurgitate the creature, which falls prone in a space within 10 feet of the behir. If the behir dies, a swallowed creature is no longer restrained by it and can escape from the corpse by using 15 feet of movement, exiting prone.
- **_Lightning Breath (Recharge 5 - 6)._** The behir exhales lightning in a 30 - foot line that is 5 feet wide. Each creature in that line must make a DC 16 DEX save, taking 54 (12d8) lightning damage on a failed save, or half as much damage on a successful one.

### Black Pudding (CR 4)

_Large Ooze_

- **Armor Class** 7
- **Hit Points** 122
- **Speed** 20 ft., climb 20 ft.
- **Perception** 8
- **Stealth** 9
- **Resistant** Ooze Resilience
- **Immune** acid, lightning, slashing | grappled | Ooze Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -3 |  +3 |  -5 |  -2 |  -5 |

- **_Amorphous._** The pudding can move through a space as narrow as 1 inch wide without squeezing.
- **_Corrosive Form._** A creature that touches the pudding or hits it with a melee attack while within 5 feet of it takes 4 (1d8) acid damage. Any nonmagical weapon made of metal or wood that hits the pudding corrodes. After dealing damage, the weapon takes a permanent and cumulative -1 penalty to damage rolls. If its penalty drops to -5, the weapon is destroyed. Nonmagical ammunition made of metal or wood that hits the pudding is destroyed after dealing damage. The pudding can eat through a panel of nonmagical wood or metal in its space that is up to 2 inches thick in 1 round.
- **_Ooze Nature._** The pudding doesn't require sleep.
- **_Ooze Resilience._** The pudding is resistant to the restrained condition, and it is immune to exhaustion and to the blinded, charmed, deafened, frightened, and prone conditions.
- **_Spider Climb._** The pudding can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Multiattack._** The black pudding makes two Pseudopod attacks.
- **_Pseudopod._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) bludgeoning damage plus 9 (2d8) acid damage. In addition, nonmagical armor worn by the target is partly dissolved and takes a permanent and cumulative -1 penalty to the AC it offers. Armor reduced to an AC of 10 is destroyed.

**Bonus Actions**

- **_Dampen Light._** The black pudding dims the light around it. The radius of each light source within 60 feet of it is halved until the start of its next turn. The pudding can't use this action while in sunlight.

**Reactions**

- **_Split._** When a pudding that is Medium or larger is subjected to lightning or slashing damage, it splits into two new puddings if it has at least 10 HP. Each new pudding has HP equal to half the original pudding's, rounded down. New puddings are one size smaller than the original pudding.

### Blink Dog (CR 1/4)

_Medium Fey_

- **Armor Class** 13
- **Hit Points** 14
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 15
- **Resistant** Fey Resilience
- **Senses** -
- **Languages** Blink Dog, understands Sylvan but can't speak it

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +3 |  +1 |  +0 |  +1 |  +0 |

- **_Fey Resilience._** The blink dog is resistant to the charmed and unconscious conditions.
- **_Heightened Hearing and Smell._** The blink dog's Perception is 18 while perceiving by hearing or smell.
- **_Pack Tactics._** The blink dog has advantage on attack rolls against a creature if at least one of the dog's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.
- **_Teleport (Recharge 4 - 6)._** The blink dog teleports, along with any equipment it is wearing or carrying, up to 40 feet to an unoccupied space it can see. Before or after teleporting, the dog can make one Bite attack.

### Bulette (CR 5)

_Large Monstrosity_

- **Armor Class** 17 (natural armor)
- **Hit Points** 108
- **Speed** 40 ft., burrow 40 ft.
- **Perception** 16
- **Stealth** 10
- **Resistant** bludgeoning | Monstrosity Resilience
- **Senses** darkvision 60 ft., tremorsense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +0 |  +5 |  -4 |  +0 |  -3 |

- **_Monstrosity Resilience._** The bulette is resistant to exhaustion and to the frightened condition.
- **_Standing Leap._** The bulette's long jump is up to 30 feet and its high jump is up to 15 feet, with or without a running start.

**Actions**

- **_Multiattack._** The bulette makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 20 (3d10+4) piercing damage.
- **_Deadly Leap (Recharge 5 - 6)._** The bulette leaps up to 30 feet, diving onto a point it can see or sense within that range and landing on its feet with a thunderous crash. It occupies a space of its choice within 5 feet of that point, and each creature within 10 feet of that point must make a DC 15 STR save. On a failure, a creature takes 14 (4d6) bludgeoning damage and 14 (4d6) thunder damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone. Any creature in the bulette's space is then pushed into an unoccupied space within 5 feet of the bulette. If no unoccupied space is within range, the creature instead falls prone in the bulette's space.

**Bonus Actions**

- **_Seek Prey._** The bulette looks and sniffs around for new prey, releasing a satisfied, guttural chirp when it settles on one. One creature the bulette can see or sense within 30 feet of it and that can see or hear the bulette must make a DC 15 WIS save. On a failure, the target is frightened until the end of its next turn, and the bulette has advantage on the next attack roll it makes against the creature before the start of its next turn.

### Centaur (CR 2)

_Large Monstrosity_

- **Armor Class** 12
- **Hit Points** 63
- **Speed** 50 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** Monstrosity Resilience
- **Senses** -
- **Languages** Elvish, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +2 |  -1 |  +3 |  +0 |

- **_Monstrosity Resilience._** The centaur is resistant to exhaustion and to the frightened condition.
- **_Trampling Charge._** If the centaur moves at least 30 feet straight toward a creature and then hits it with a Pike attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the centaur can make one Hooves attack against it as a bonus action.

**Actions**

- **_Multiattack._** The centaur makes one Hooves attack and one Pike attack, or it makes three Longbow attacks.
- **_Hooves._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage.
- **_Pike._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 9 (1d10+4) piercing damage.
- **_Longbow._** _Ranged Weapon Attack:_ +4 to hit, range 150/600 ft., one target. _Hit:_ 6 (1d8+2) piercing damage.

**Reactions**

- **_Defensive Kick._** When a creature the centaur can see within 5 feet of it hits it with an attack, the centaur can kick the attacker. The attacker must succeed on a DC 14 STR save or be knocked prone or pushed up to 5 feet away from the centaur (the centaur's choice).

### Chimera (CR 6)

_Large Monstrosity_

- **Armor Class** 14 (natural armor)
- **Hit Points** 126
- **Speed** 30 ft., fly 60 ft.
- **Perception** 18
- **Stealth** 10
- **Resistant** Multiple Heads, Monstrosity Resilience
- **Immune** fire
- **Senses** darkvision 60 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +4 |  -3 |  +5 |  +0 |

- **_Bickering Heads._** The chimera is perpetually one step away from arguing with itself. A creature that can see the chimera can use a bonus action on its turn to appeal to one of the chimera's heads with bribes (dragon), praise (lion), displays of magic (goat), or other clever manipulation of a head's desires. The chimera must succeed on a DC 15 WIS save or succumb to that desire.

  If the lion or goat head succumbs, the chimera has disadvantage on the next Bite or Headbutt attack it makes before the end of its next turn. If the dragon head succumbs, creatures caught in the chimera's next Fire Breath have advantage on the save, provided the chimera uses the breath within the next 1 minute. Once a head has succumbed to a desire, that head can't succumb again for the next 24 hours.

- **_Monstrosity Resilience._** The chimera is resistant to exhaustion and to the frightened condition.
- **_Multiple Heads._** The chimera has three heads and is resistant to the blinded, charmed, deafened, frightened, stunned, and unconscious conditions.

**Actions**

- **_Multiattack._** The chimera makes one Bite attack, one Headbutt attack, and two Claws attacks, or it can make two Claws attacks and use Fire Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) piercing damage.
- **_Headbutt._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 10 (1d12+4) bludgeoning damage.
- **_Claws._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon head exhales fire in a 15 - foot cone. Each creature in that area must make a DC 15 DEX save, taking 27 (6d8) fire damage on a failed save, or half as much damage on a successful one.

### Chuul (CR 4)

_Large Aberration_

- **Armor Class** 15 (natural armor)
- **Hit Points** 80
- **Speed** 30 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 10
- **Resistant** Aberrant Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** understands Deep Speech but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +3 |  -3 |  +2 |  -3 |

- **_Aberrant Resilience._** The chuul is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Amphibious._** The chuul can breathe air and water.
- **_Sense Magic._** The chuul senses and can pinpoint the location of magic within 120 feet of it. If it senses magic and can see the creature or object bearing the magic it senses, it sees a faint aura around that creature or object.

**Actions**

- **_Multiattack._** The chuul makes two Pincer attacks.
- **_Pincer._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 17 (3d8+4) bludgeoning damage. If the target is Large or smaller, it is grappled (escape DC 14). The chuul has two pincers, each of which can grapple only one target.
- **_Wild Reach (Recharge 5 - 6)._** The chuul taps into ancient memories of magic and reaches toward nearby magic with an unpracticed grasp, releasing a burst of energy. Each creature within 15 feet of the chuul must make a DC 14 DEX save, taking 21 (6d6) damage on a failed save, or half as much damage on a successful one. If a magic item, spell effect, or spellcaster is within 30 feet of the chuul, the burst is pure arcane energy, dealing force damage. If no magic is within 30 feet of the chuul, the burst pulls from the chuul's own life force, dealing necrotic damage. If the damage is necrotic, the chuul takes necrotic damage as if it succeeded on the save.

**Bonus Actions**

- **_Paralyzing Tentacles._** One creature grappled by the chuul must succeed on a DC 14 CON save or be poisoned for 1 minute. Until this poison ends, the creature is paralyzed. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

### Cloaker (CR 8)

_Large Aberration_

- **Armor Class** 14 (natural armor)
- **Hit Points** 105
- **Speed** 10 ft., fly 40 ft.
- **Perception** 11
- **Stealth** 15
- **Resistant** Aberrant Resilience
- **Senses** darkvision 60 ft.
- **Languages** Deep Speech, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +5 |  +1 |  +1 |  +1 |  +2 |

- **_Aberrant Resilience._** The cloaker is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Damage Transfer._** While attached to a creature, the cloaker takes only half the damage dealt to it (rounded down), and that creature takes the other half.
- **_False Appearance._** While the cloaker remains motionless without its underside exposed, it is indistinguishable from a dark leather cloak.
- **_Light Sensitivity._** While in bright light, the cloaker has disadvantage on attack rolls, and its Perception is 6 when perceiving by sight.

**Actions**

- **_Multiattack._** The cloaker makes one Bite attack and two Tail attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 18 (4d6+4) piercing damage, and if the target is Large or smaller, the cloaker attaches to it. If the cloaker has advantage on the attack roll, the cloaker attaches to the target's head, and the target is blinded and unable to breathe while the cloaker is attached. While attached, the cloaker can't make Bite attacks, and at the start of each of the cloaker's turns, the target takes 18 (4d6+4) piercing damage. The attached cloaker moves with the target whenever the target moves, requiring none of the cloaker's movement. It can detach itself by spending 5 feet of its movement on its turn. A creature, including the target, can take its action to detach the cloaker by succeeding on a DC 15 STR check.
- **_Tail._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 17 (3d8+4) slashing damage.
- **_Moan (Recharge 6)._** The cloaker releases a deep, thrumming moan that rattles the nerves of all who hear it. Each creature within 30 feet of the cloaker that can hear the moan and that isn't an Aberration must make a DC 15 WIS save. On a failure, a creature takes 40 (9d8) psychic damage and is frightened until the end of its next turn. On a success, a creature takes half the damage and isn't frightened.

**Bonus Actions**

- **_Cloak of Shadows (3/Day)._** While the cloaker isn't in bright light, it pulls shadows around itself, partially obscuring its form. For 1 minute or until the cloaker is hit with an attack, the cloaker's Stealth is 20, and creatures have disadvantage on attack rolls against the cloaker.

### Cockatrice (CR 1/2)

_Small Monstrosity_

- **Armor Class** 11
- **Hit Points** 25
- **Speed** 20 ft., fly 40 ft.
- **Perception** 11
- **Stealth** 11
- **Resistant** petrified | Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +1 |  +1 |  -4 |  +1 |  -3 |

- **_Monstrosity Resilience._** The cockatrice is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Serrated Beak._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 6 (2d4+1) slashing damage, and the target must succeed on a DC 11 CON save or be restrained as it begins to turn to stone. The creature must repeat the save at the end of its next turn. On a success, the effect ends. On a failure, the creature is petrified for 24 hours.

**Reactions**

- **_Shrieking Crow._** When a creature the cockatrice can see within 30 feet of it attacks it, the cockatrice can let out a startling crow. The attacker must succeed on a DC 11 WIS save or have disadvantage on the attack roll.

### Couatl (CR 4)

_Medium Celestial_

- **Armor Class** 17 (natural armor)
- **Hit Points** 77
- **Speed** 30 ft., fly 90 ft.
- **Perception** 17
- **Stealth** 15
- **Resistant** Celestial Resilience
- **Immune** psychic
- **Senses** truesight 120 ft.
- **Languages** all, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +5 |  +3 |  +4 |  +7 |  +6 |

- **_Celestial Resilience._** The couatl is resistant to radiant damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks.
- **_Inscrutable._** The couatl is immune to any effect that would sense its emotions or read its thoughts, as well as divination spells or effects, such as scrying or detecting its location, that it refuses. WIS (Insight) checks made to ascertain the couatl's intentions or sincerity have disadvantage.
- **_Magic Resistance._** The couatl has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The couatl's weapon attacks are magical.

**Actions**

- **_Multiattack._** The couatl makes one Bite attack and one Constrict attack.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 8 (1d6+5) piercing damage plus 14 (4d6) poison damage. If the poison damage reduces the target to 0 HP, the couatl can choose for the target to be stable but poisoned for 1 hour, even after regaining HP, and is unconscious while poisoned in this way.
- **_Constrict._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 12 (2d6+5) bludgeoning damage, and the target is grappled (escape DC 15) if it is a Medium or smaller creature. Until this grapple ends, the target is restrained, and the couatl can't Constrict another target.
- **_Healing Hiss (3/Day)._** The couatl croons a soothing hiss at a creature it can sense within 5 feet of it. The target magically regains 10 (3d6) HP and is freed from any disease or poison.

**Bonus Actions**

- **_Change Shape._** The couatl magically transforms into a Large or smaller Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Celestial. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the couatl's choice). It reverts to its true form if it dies. In a new form, the couatl retains its Celestial Resilience and Inscrutable traits and its HP, HD, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action and the Rainbow Shield reaction. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Reactions**

- **_Rainbow Shield._** When a creature the couatl can see within 30 feet of it, including itself, is targeted with an attack, the couatl can interpose a shield of rainbow - hued light between the attacker and the creature. The attacker has disadvantage on the attack roll. If the protected creature hasn't attacked or harmed another creature within the last minute, the attacker's attack misses instead.

### Crimson Jelly (CR 1/2)

_Tiny Ooze_

- **Armor Class** 12
- **Hit Points** 20
- **Speed** 0 ft., fly 60 ft. (hover), swim 30 ft.
- **Perception** 10
- **Stealth** 14
- **Resistant** Ooze Resilience
- **Immune** necrotic | grappled | Ooze Resilience
- **Senses** keensense 10 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +4 |  +0 |  -5 |  +0 |  -1 |

- **_Amorphous._** The crimson jelly can move through space as narrow as 1 inch wide without squeezing.
- **_Blood Sense._** The crimson jelly can pinpoint, by scent, the location of creatures that aren't Constructs or Undead and that don't have all of their HP within 60 feet of it and can sense the general direction of such creatures within 1 mile of it.
- **_Ooze Nature._** The crimson jelly doesn't require sleep.
- **_Ooze Resilience._** The crimson jelly is resistant to the restrained condition, and it is immune to exhaustion and to the blinded, charmed, deafened, frightened, and prone conditions.
- **_Tainted Attacks._** A creature that is reduced to 0 HP by a crimson jelly must succeed on a DC 9 CHA save or suffer one level of exhaustion. While a creature suffers from this exhaustion, it loses most of its memories aside from basic information about itself, such as its name and its capabilities, and it is wracked with nightmarish visions that include a crimson rune.
- **_Transparent._** While in an area of dim or bright light, the crimson jelly is invisible. While in darkness, creatures without darkvision can see the jelly's faint crimson glow.

**Actions**

- **_Feeding Paddles._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) necrotic damage. The crimson jelly gains temporary HP equal to the necrotic damage dealt, and it attaches to the target. If the jelly had advantage on this attack, it attaches to the target's face, leaving the target unable to breathe or speak while the jelly is attached.

  While attached, the crimson jelly can use only the Feeding Paddles action, and it moves with the target whenever the target moves, requiring none of the jelly's movement. The Crimson jelly can detach itself by spending 5 feet of its movement. A creature, including the target, can take its action to detach the jelly by succeeding on a DC 12 STR check.

**Bonus Actions**

- **_Reproduce (Requires Temporary HP)._** While the crimson jelly has 1 or more temporary HP, it can split part of itself off into a new crimson jelly with HP equal to the original crimson jelly's temporary HP. The original crimson jelly then loses any temporary HP it has. The new crimson jelly otherwise has all the same statistics as its parent, except the new jelly can't gain temporary HP from Feeding Paddles attacks until it finishes a long rest.

### Darkmantle (CR 1/2)

_Small Monstrosity_

- **Armor Class** 11
- **Hit Points** 25
- **Speed** 10 ft., fly 30 ft.
- **Perception** 10
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -4 |  +0 |  -3 |

- **_Echolocation._** The darkmantle can't use its keensense while deafened.
- **_False Appearance._** While the darkmantle remains motionless, it is indistinguishable from a cave formation, such as a stalactite or stalagmite.
- **_Jagged Hide._** A creature that hits the darkmantle with a melee attack while within 5 feet of it takes 2 (1d4) piercing damage.
- **_Monstrosity Resilience._** The darkmantle is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Crush._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d6+3) bludgeoning damage, and the darkmantle attaches to it. If the target is Medium or smaller and the darkmantle has advantage on the attack roll, the darkmantle attaches to the target's head, and the target is blinded and unable to breathe while the darkmantle is attached. While attached, the darkmantle can't make Crush attacks, and at the start of each of the darkmantle's turns, the target takes 6 (1d6+3) bludgeoning damage.

  The attached darkmantle moves with the target whenever the target moves, requiring none of the darkmantle's movement. It can detach itself by spending 5 feet of its movement on its turn. A creature, including the target, can take its action to detach the darkmantle by succeeding on a DC 13 STR check.

- **_Topple._** While attached to a creature, the darkmantle swings its body to throw off the balance of the creature to which it is attached. The attached target must succeed on a DC 13 DEX save or be knocked prone. If the target fails the save and is already prone, it is restrained while the darkmantle is attached to it, as the darkmantle pins it to the ground.

**Bonus Actions**

- **_Darkness Aura (1/Day)._** A 15 - foot radius of magical darkness extends out from the darkmantle, moves with it, and spreads around corners. The darkness lasts as long as the darkmantle maintains concentration, up to 10 minutes (as if concentrating on a spell). Darkvision can't penetrate this darkness, and no natural light can illuminate it. If any of the darkness overlaps with an area of light created by a spell of 2nd level or lower, the spell creating the light is dispelled.

### Death Dog (CR 1)

_Medium Monstrosity (Animal)_

- **Armor Class** 12
- **Hit Points** 40
- **Speed** 40 ft.
- **Perception** 15
- **Stealth** 14
- **Resistant** Multiple Heads, Monstrosity Resilience
- **Senses** darkvision 120 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +2 |  -4 |  +1 |  -2 |

- **_Monstrosity Resilience._** The death dog is resistant to exhaustion and to the frightened condition.
- **_Multiple Heads._** The death dog has two heads and is resistant to the blinded, charmed, deafened, frightened, stunned, and unconscious conditions.

**Actions**

- **_Multiattack._** The death dog makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) piercing damage. If the target is a creature, it must succeed on a DC 12 CON save or contract a disease. Until the disease is cured, the target is poisoned. Every 24 hours that elapse, the infected creature must repeat the save, reducing its HP maximum by 5 (2d4) on a failure. This reduction lasts until the creature finishes a long rest after the disease is cured. The creature dies if the disease reduces its HP maximum to 0.

**Bonus Actions**

- **_Dual Bark._** The death dog's two heads bark at creatures in two 15 - foot cones. Each creature in the area of a cone must succeed on a DC 12 CON save or be deafened until the end of its next turn. If the cones overlap each other, each creature in overlapping cones must make only one save with disadvantage rather than one save for each cone.

### Death Knight (CR 8)

_Medium Undead_

- **Armor Class** 18 (plate)
- **Hit Points** 140
- **Speed** 30 ft.
- **Perception** 15
- **Stealth** 5 (10 without armor)
- **Vulnerable** radiant
- **Immune** necrotic | frightened | Undead Resilience
- **Senses** darkvision 90 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +3 |  +1 |  +5 |  +4 |

- **_Disgraced Rejuvenation._** Unless redeemed, a destroyed death knight returns in 1d4 days, regaining all its HP and becoming active again within 10 feet of where it died.
- **_Magic Resistance._** The death knight has advantage on saves against spells and other magical effects.
- **_Undead Nature._** The death knight doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The death knight is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The death knight makes three Greatsword or Necrotic Bolt attacks.
- **_Greatsword._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage and 7 (2d6) necrotic damage.
- **_Necrotic Bolt._** _Ranged Spell Attack:_ +7 to hit, range 60 ft., one target. _Hit:_ 18 (4d6+4) necrotic damage.

**Bonus Actions**

- **_Champion's Challenge._** The death knight challenges one creature it can see within 30 feet of it. The target must succeed on a DC 15 CHA save or have disadvantage on attack rolls against creatures that aren't the knight until the end of its next turn.

**Reactions**

- **_Parry._** The death knight adds 3 to its AC against one melee attack that would hit it. To do so, the death knight must see the attacker and be wielding a melee weapon.
- **_Soul Drain._** When the death knight reduces a Humanoid to 0 HP, it can absorb the creature's soul. The target must succeed on a DC 15 WIS save or immediately die, its soul becoming trapped in the death knight's sword. The death knight has advantage on attack rolls for 1 minute after absorbing a soul.

  The creature can't be restored to life until the death knight is permanently destroyed.

### Demons

#### Balor (CR 19)

_Huge Fiend (Demon)_

- **Armor Class** 19 (natural armor)
- **Hit Points** 292
- **Speed** 40 ft., fly 80 ft.
- **Perception** 19
- **Stealth** 12
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** fire | Demonic Resilience
- **Senses** truesight 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +14 |  +2 | +12 |  +5 |  +9 | +12 |

- **_Demonic Flames._** Creatures resistant to fire damage aren't resistant to fire damage dealt by the balor. Creatures immune to fire damage are still immune to the balor's fire damage.
- **_Demonic Resilience._** The balor is resistant to cold and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Diving Assault._** If the balor is flying and moves at least 30 feet straight toward a creature and then hits it with a Gore attack on the same turn, that target must succeed on a DC 20 STR save or be knocked prone. If the target is prone, the balor can make one Longsword attack against it as a bonus action.
- **_Flaming Weapons._** The balor's weapon attacks are magical. When the balor hits with any weapon, the weapon deals an extra 3d8 fire damage (included in the attack).
- **_Fire Aura._** At the start of each of the balor's turns, each creature within 10 feet of it takes 13 (3d8) fire damage, and flammable objects in the aura that aren't being worn or carried ignite.
- **_Magic Resistance._** The balor has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The balor makes one Gore attack, one Longsword attack, and one Whip attack.
- **_Gore._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) piercing damage plus 13 (3d8) fire damage.
- **_Longsword._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 21 (3d8+8) slashing damage, or 24 (3d10+8) slashing damage if used with two hands, plus 13 (3d8) fire damage. If the balor scores a critical hit, it rolls damage dice three times, instead of twice.
- **_Whip._** _Melee Weapon Attack:_ +14 to hit, reach 30 ft., one target. _Hit:_ 15 (3d4+8) slashing damage plus 13 (3d8) fire damage, and the target must succeed on a DC 20 STR save or be pulled up to 25 feet toward the balor.

**Bonus Actions**

- **_Teleport._** The balor magically teleports, along with any equipment it is wearing or carrying, up to 60 feet to an unoccupied space it can see.

#### Dretch (CR 1/4)

_Small Fiend (Demon)_

- **Armor Class** 11 (natural armor)
- **Hit Points** 13
- **Speed** 20 ft.
- **Perception** 9
- **Stealth** 10
- **Resistant** Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** darkvision 60 ft.
- **Languages** Abyssal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -3 |  -1 |  -4 |

- **_Abyssal Rejuvenation._** Unlike other outsiders, a dretch that dies in its home plane of the Abyss is restored in a new body in 1d10 days, regaining all its HP and becoming active again. The new body appears in a random location in the Abyss. Only sprinkling holy water on the dretch's remains can prevent this trait from functioning.
- **_Demonic Resilience._** The dretch is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage plus 2 (1d4) poison damage.

**Bonus Actions**

- **_Fetid Cloud (1/Day)._** A 10 - foot radius cloud of disgusting green gas extends out from the dretch, moves with it, and spreads around corners. The cloud's area is lightly obscured and lasts 1 minute or until a strong wind disperses it. A creature that starts its turn in the cloud must succeed on a DC 11 CON save or be poisoned until the start of its next turn. While poisoned in this way, a creature can take either an action or a bonus action on its turn, not both, and can't take reactions.

#### Glabrezu (CR 9)

_Large Fiend (Demon)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 154
- **Speed** 40 ft.
- **Perception** 17
- **Stealth** 12
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** truesight 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +2 |  +9 |  +4 |  +7 |  +7 |

- **_Demonic Resilience._** The glabrezu is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The glabrezu has advantage on saves against spells and other magical effects.
- **_Point Blank Grappler._** When the glabrezu makes a Crackling Flame Bolt attack, it doesn't have disadvantage on the attack roll from being within 5 feet of a hostile creature, provided it is grappling that creature.

**Actions**

- **_Multiattack._** The glabrezu makes two Claw attacks and two Pincer attacks, or it makes four Crackling Flame Bolt attacks. It can replace both Claw attacks with two Crackling Flame Bolt attacks.
- **_Claw._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 10 (2d4+5) slashing damage plus 3 (1d6) fire damage and 3 (1d6) lightning damage.
- **_Pincer._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 16 (2d10+5) bludgeoning damage. If the target is a Medium or smaller creature, it is grappled (escape DC 17). The glabrezu has two pincers, each of which can grapple only one target.
- **_Crackling Flame Bolt._** _Ranged Spell Attack:_ +7 to hit, range 60 ft., one target. _Hit:_ 6 (1d6+3) fire damage plus 10 (3d6) lightning damage.

**Bonus Actions**

- **_Manipulating Whispers._** The glabrezu whispers in the mind of a creature it can see within 120 feet of it, encouraging the creature to commit wicked acts. The target must succeed on a DC 17 CHA save or succumb to one of the following urges:
  - **Boastful Stance.** The target is overcome with surety of its own battle prowess, momentarily letting down its guard. Creatures have advantage on attack rolls against the target until the start of the glabrezu's next turn.
  - **Confirmation of Wealth.** The target is briefly overcome with the desire to confirm the amount and status of its valuables. It uses either an action or bonus action on its next turn (the glabrezu's choice) to count and take stock of its valuables.
  - **Wrathful Strike.** Anger fills the target, and it immediately lashes out at those nearby. The target uses its reaction to make one melee weapon attack against a creature of the glabrezu's choice within 5 feet of the target.

#### Golmana (CR 7)

_Medium Fiend (Demon)_

- **Armor Class** 15 (natural armor)
- **Hit Points** 118
- **Speed** 40 ft.
- **Perception** 14
- **Stealth** 16
- **Resistant** Demonic Resilience
- **Immune** blinded, frightened | Demonic Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** Abyssal, Void Speech, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +2 |  -1 |  +1 |  +2 |

- **_Demonic Resilience._** The golmana is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Heightened Hearing._** The golmana's Perception is 19 when perceiving by hearing.
- **_Magic Resistance._** The golmana has advantage on saves against spells and other magical effects.
- **_Spider Climb._** The golmana can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Multiattack._** The golmana makes two Claws attacks and one Tail attack. If both Claws attacks hit a Medium or smaller creature, the target is grappled (escape DC 15). Until this grapple ends, the target is restrained, and the golmana can't make Claws attacks against other targets.
- **_Claws._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 17 (3d8+4) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 13 (2d8+4) piercing damage.
- **_Void Screech (Recharge 5 - 6)._** The golmana lets out a keening screech in a 30 - foot cone. Each creature that isn't a Fiend in that area must make a DC 15 CON save. On a failure, a creature takes 14 (4d6) necrotic damage and 18 (4d8) thunder damage, and it has disadvantage on the next attack roll it makes before the start of the golmana's next turn, as brief contact with the energies of the Void destabilizes the creature. On a success, a creature takes half the damage and doesn't suffer this disadvantage on its next attack roll.

**Bonus Actions**

- **_Consuming Rend._** The golmana violently digs its small, torso claws into one creature it is grappling. The target must make a DC 15 DEX save, taking 7 (2d6) slashing damage on a failed save, or half as much damage on a successful one. The golmana then regains HP equal to the damage dealt.

#### Hezrou (CR 8)

_Large Fiend (Demon)_

- **Armor Class** 16 (natural armor)
- **Hit Points** 138
- **Speed** 30 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 13
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** darkvision 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +3 |  +8 |  -3 |  +4 |  +1 |

- **_Amphibious._** The hezrou can breathe air and water.
- **_Demonic Resilience._** The hezrou is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The hezrou has advantage on saving throws against spells and other magical effects.
- **_Speak with Frogs and Toads._** The hezrou can communicate with frogs and toads as if they shared a language.
- **_Standing Leap._** The hezrou's long jump is up to 20 feet and its high jump is up to 10 feet, with or without a running start.
- **_Stench._** A creature that starts its turn within 10 feet of the hezrou must succeed on a DC 16 CON save or be poisoned until the start of its next turn. On a success, the creature is immune to the hezrou's Stench for the next 24 hours.

**Actions**

- **_Multiattack._** The hezrou makes one Sticky Tongue attack, one Bite attack, and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 15 (2d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 17 (3d8+4) slashing damage.
- **_Sticky Tongue._** _Melee Weapon Attack:_ +7 to hit, reach 20 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage, and the target must succeed on a DC 16 STR save or be pulled up to 15 feet toward the hezrou.

**Bonus Actions**

- **_Quick Leap._** The hezrou jumps horizontally up to 20 feet to an unoccupied space it can see without provoking opportunity attacks.

#### Husk Demon (CR 4)

_Medium Fiend (Demon)_

- **Armor Class** 15
- **Hit Points** 82
- **Speed** 40 ft., fly 25 ft.
- **Perception** 13
- **Stealth** 15
- **Resistant** Demonic Resilience
- **Immune** necrotic | exhaustion, prone | Demonic Resilience
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Void Speech, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +5 |  +3 |  -2 |  -1 |  -3 |

- **_Amorphous._** The husk demon can move through a space as narrow as 1 inch wide without squeezing.
- **_Demonic Resilience._** The husk demon is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The husk demon has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The husk demon makes two Life Drain attacks.
- **_Life Drain._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d8+3) slashing damage plus 9 (2d8) necrotic damage, and the husk demon regains HP equal to half the necrotic damage dealt. The target must succeed on a DC 15 CON save or its HP maximum is reduced by an amount equal to the necrotic damage taken. This reduction lasts until the creatures finishes a long rest. The target dies if this effect reduces its HP maximum to 0.

**Bonus Actions**

- **_Soul Feed._** The husk demon feasts on the light in the soul of up to two creatures it can see within 20 feet of it, causing one of the following effects. Each target must succeed on a DC 15 CHA save or suffer the chosen effect. A creature that fails the save against Soul Feed two rounds in a row suffers one level of exhaustion.
  - **Happiness Feast.** The husk demon feasts on the target's happiness, causing the target to become crestfallen. The target has disadvantage on attack rolls until the end of its next turn.
  - **Hope Feast.** The husk demon feasts on the target's hope, causing the target to become despondent. The target has disadvantage on saves until the end of its next turn.
  - **Motivation Feast.** The husk demon feasts on the target's motivation, causing the target to lose its ambitions and become apathetic. The target's speed is halved until the end of its next turn.

#### Marilith (CR 16)

_Large Fiend (Demon)_

- **Armor Class** 18 (natural armor)
- **Hit Points** 217
- **Speed** 40 ft.
- **Perception** 18
- **Stealth** 15
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** truesight 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +5 | +10 |  +4 |  +8 | +10 |

- **_Demonic Resilience._** The marilith is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Flaming Weapons._** The marilith's weapon attacks are magical. When it hits with any weapon, the weapon deals an extra 2d6 fire damage (included in the attack).
- **_Magic Resistance._** The marilith has advantage on saves against spells and other magical effects.
- **_Reactive._** The marilith gets up to five extra reactions, but these extra reactions can be used only for Parry.

**Actions**

- **_Multiattack._** The marilith makes two Dagger attacks, two Mace attacks, and two Longsword attacks. It can replace two Dagger attacks with a Tail attack.
- **_Dagger._** _Melee or Ranged Weapon Attack:_ +9 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 9 (2d4+4) piercing damage plus 7 (2d6) fire damage.
- **_Mace._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage plus 7 (2d6) fire damage.
- **_Longsword._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage plus 7 (2d6) fire damage.
- **_Tail._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one creature. _Hit:_ 20 (3d10+4) bludgeoning damage plus 7 (2d6) fire damage. If the target is Medium or smaller, it is grappled (escape DC 17). Until this grapple ends, the target is restrained, the marilith can automatically hit the target with its Tail, and the marilith can't make Tail attacks against other targets.

**Bonus Actions**

- **_Marilith Tactics._** The marilith shouts one of the following commands at up to two friendly creatures it can see within 30 feet of it:
  - **March!** Each target can use a reaction to move up to half its speed in a direction of the marilith's choice. This movement is unaffected by difficult terrain and doesn't provoke opportunity attacks.
  - **Protect Yourself!** Each target gains the marilith's Parry reaction until the start of the marilith's next turn.
  - **Remember Your Training!** Each target has advantage on the next weapon attack roll it makes before the start of the marilith's next turn.
- **_Teleport._** The marilith magically teleports, along with any equipment it is wearing or carrying, up to 60 feet to an unoccupied space it can see.

**Reactions**

- **_Parry._** The marilith adds 5 to its AC against one melee attack that would hit it. To do so, the marilith must see the attacker and be wielding a melee weapon.

#### Mire Fiend (CR 5)

_Medium Fiend (Demon)_

- **Armor Class** 16 (natural armor)
- **Hit Points** 94
- **Speed** 40 ft., swim 40 ft.
- **Perception** 15
- **Stealth** 16
- **Resistant** Demonic Resilience
- **Immune** acid | Demonic Resilience
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Abyssal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +6 |  +4 |  -3 |  +2 |  -2 |

- **_Amphibious._** The mire fiend can breathe air and water.
- **_Demonic Resilience._** The mire fiend is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The mire fiend has advantage on saves against spells and other magical effects.
- **_Pack Tactics._** The mire fiend has advantage on attack rolls against a creature if at least one of the mire fiend's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Swamp Camouflage._** The mire fiend's Stealth is 21 while in swampy terrain.

**Actions**

- **_Multiattack._** The mire fiend makes one Mandibles attack, one Spear attack, and one Stinger attack.
- **_Mandibles._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 12 (2d8+3) slashing damage.
- **_Spear._** Melee Weapon or Ranged Attack: +5 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 5 (1d6+2) piercing damage, or 6 (1d8+2) piercing damage if used with two hands to make a melee attack.
- **_Stinger._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one creature. _Hit:_ 5 (1d4+3) piercing damage plus 10 (3d6) poison damage, and the target must succeed on a DC 14 CON save or be poisoned.
- **_Stunning Snap (Recharge 5 - 6)._** If the mire fiend has no creature grappled, it snaps its mandibles together with great force, creating a miniature sonic boom in a 30 - foot cone.

  Each creature in that area must make a DC 14 CON save. On a failure, a creature takes 21 (6d6) thunder damage and is stunned until the end of its next turn. On a success, a creature takes half the damage and isn't stunned.

**Reactions**

- **_Acidic Retribution._** When the mire fiend takes damage, including any damage that reduces it to 0 HP, it can expel acid from its stinger in a 15 - foot line that is 5 feet wide. Each creature in that line must make a DC 14 DEX save, taking 10 (3d6) acid damage on a failed save, or half as much damage on a successful one.

#### Nalfeshnee (CR 13)

_Large Fiend (Demon)_

- **Armor Class** 18 (natural armor)
- **Hit Points** 196
- **Speed** 20 ft., fly 30 ft.
- **Perception** 16
- **Stealth** 10
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** truesight 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 | +11 |  +8 |  +6 |  +7 |

- **_Demonic Resilience._** The nalfeshnee is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Horrific Nimbus._** The nalfeshnee magically emits scintillating, multicolored light that disorients and frightens mortals. Each creature that isn't an Aberration, Celestial, or Fiend and that starts its turn within 15 feet of the nalfeshnee must succeed on a DC 16 WIS save or be frightened until the start of its next turn. A creature that fails the save by 5 or more must take the Dash action on its turn and move away from the nalfeshnee by the safest available route, unless there is nowhere to move.
- **_Magic Resistance._** The nalfeshnee has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The nalfeshnee makes one Bite attack, one Gore attack, and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 28 (4d8+5) piercing damage. If this attack hits a frightened creature, the nalfeshnee regains HP equal to half the damage dealt.
- **_Claw._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 19 (4d6+5) slashing damage.
- **_Gore._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 21 (3d10+5) piercing damage, and the target must succeed on a DC 16 STR save or be knocked prone.

**Bonus Actions**

- **_Teleport._** The nalfeshnee magically teleports, along with any equipment it is wearing or carrying, up to 60 feet to an unoccupied space it can see.

**Reactions**

- **_Sudden Feast._** When a creature the nalfeshnee can see within 20 feet of it is reduced to 0 HP or dies, the nalfeshnee can move up to its speed toward the creature without provoking opportunity attacks then feast on the creature, if it moves to within 5 feet of the creature. The nalfeshnee regains HP equal to twice the creature's CR or class level, and the creature has disadvantage on the next death save it makes, if it is making death saves.

#### Quasit (CR 1)

_Tiny Fiend (Demon)_

- **Armor Class** 13
- **Hit Points** 35
- **Speed** 40 ft.
- **Perception** 10
- **Stealth** 15
- **Resistant** Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** darkvision 120 ft.
- **Languages** Abyssal, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +5 |  +0 |  -2 |  +0 |  +0 |

- **_Demonic Resilience._** The quasit is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The quasit has advantage on saving throws against spells and other magical effects.

**Actions**

- **_Claws (True Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) piercing damage, and the target must succeed on a DC 13 CON save or take 5 (2d4) poison damage and be poisoned for 1 minute. The target can repeat the saving throw at the end of each of its turns, ending the effect on itself on a success.
- **_Slam (Beast Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning, piercing, or slashing damage (based on the type of damage dealt by the Beast form's primary attack, such as Bite).
- **_Invisibility (True Form Only)._** The quasit magically turns invisible until it attacks, uses Scare, or uses Change Shape, or until its concentration ends (as if concentrating on a spell). Any equipment the quasit wears or carries is invisible with it.

**Bonus Actions**

- **_Change Shape._** The quasit magically transforms into a Medium or smaller Beast that has a CR no higher than its own or back into its true form, which is a Fiend. Its statistics, other than its size and speed, are the same in each form.

  Any equipment it is wearing or carrying transforms with it. It reverts to its true form if it dies.

- **_Scare (1/Day; True Form Only)._** One creature of the quasit's choice within 20 feet of it must succeed on a DC 13 WIS save or be frightened for 1 minute. The target can repeat the saving throw at the end of each of its turns, ending the effect on itself on a success.

#### Unska (CR 5)

_Medium Fiend (Demon)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 88
- **Speed** 20 ft., climb 20 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** Demonic Resilience
- **Immune** charmed, frightened | Demonic Resilience
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -1 |  +0 |  +2 |

- **_Demonic Resilience._** The unska is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The unska has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The unska makes two Claw attacks and one Tongue attack, or it makes three Ink Blast attacks.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage plus 3 (1d6) poison damage, and the target must succeed on a DC 14 CON save or be poisoned for 1 minute. While poisoned, the target has disadvantage on saves against the unska's Whirl of Ink. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Tongue._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 12 (2d8+3) piercing damage. The target must succeed on a DC 14 CON save, or its HP maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if its HP maximum is reduced to 0.
- **_Ink Blast._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 12 (3d6+2) poison damage, and the target must succeed on a DC 14 CON save or have disadvantage on the next save it makes against the unska's Whirl of Ink before the start of the unska's next turn.

**Bonus Actions**

- **_Whirl of Ink._** Tattoos leap off the unska's body and latch onto a creature the unska can see within 30 feet of it. The target must succeed on a DC 14 WIS save or be charmed, disoriented, or frightened (the unska's choice) until the end of its next turn. When a disoriented creature moves, it moves in a random direction.

#### Vrock (CR 6)

_Large Fiend (Demon)_

- **Armor Class** 15 (natural armor)
- **Hit Points** 110
- **Speed** 40 ft., fly 60 ft.
- **Perception** 16
- **Stealth** 15
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Demonic Resilience
- **Immune** Demonic Resilience
- **Senses** darkvision 120 ft.
- **Languages** Abyssal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +5 |  +4 |  -1 |  +6 |  +2 |

- **_Demonic Resilience._** The vrock is resistant to cold, fire, and lightning damage. In addition, it is immune to poison damage and to the poisoned condition.
- **_Magic Resistance._** The vrock has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The vrock makes one Beak attack and two Talon attacks.
- **_Beak._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage.
- **_Talon._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 14 (2d10+3) slashing damage.
- **_Wing Spores (Recharge 5 - 6)._** The vrock shakes a cloud of toxic spores from its wings. Each creature within 15 feet of it must make a DC 15 CON save. On a failure, a creature takes 28 (8d6) poison damage and is poisoned for 1 minute. On a success, a creature takes half the damage and isn't poisoned. While poisoned, a creature takes 3 (1d6) poison damage at the start of each of its turns. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. Emptying a vial of holy water on the poisoned creature also ends the effect on it.

**Bonus Actions**

- **_Startling Screech._** The vrock emits a horrific screech at one creature it can see within 30 feet of it. The target must succeed on a DC 14 CON save or be able to take either an action or bonus action on its turn, not both, and it can't take reactions.

### Devils

#### Barbed Devil (CR 5)

_Medium Fiend (Devil)_

- **Armor Class** 15 (natural armor)
- **Hit Points** 94
- **Speed** 30 ft.
- **Perception** 18
- **Stealth** 13
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +3 |  +7 |  +1 |  +5 |  +5 |

- **_Barbed Death._** When the barbed devil dies, its body withers, leaving behind a mass of spikes on the ground in a 10 - foot radius centered on the devil's body. The area becomes difficult terrain for 1 minute, and when a creature moves into or within the area, it takes 2d6 piercing damage for every 5 feet it travels.
- **_Barbed Hide._** A creature that hits the barbed devil with a melee attack while within 5 feet of it takes 3 (1d6) piercing damage. A creature that starts its turn grappling or grappled by the barbed devil takes 3 (1d6) piercing damage.
- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The devil makes two Claw attacks and one Tail attack, or it makes three Hurl Flame attacks.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage.
- **_Tail._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage.
- **_Hurl Flame._** _Ranged Spell Attack:_ +5 to hit, range 150 ft., one target. _Hit:_ 12 (3d6+2) fire damage. If the target is a flammable object that isn't being worn or carried, it also catches fire.

#### Bearded Devil (CR 3)

_Medium Fiend (Devil)_

- **Armor Class** 13 (natural armor)
- **Hit Points** 63
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 12
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +2 |  +4 |  -1 |  +2 |  +0 |

- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.
- **_Show Mettle._** While it can see a superior devil, such as a barbed devil, pit fiend, or similar, the bearded devil has advantage on saves against being charmed and frightened.

**Actions**

- **_Multiattack._** The devil makes two Beard Spines attacks and one Glaive attack.
- **_Beard Spines._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 8 (2d4+3) piercing damage, and the target must succeed on a DC 13 CON save or be poisoned for 1 minute. While poisoned in this way, the target can't regain HP. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Glaive._** _Melee Weapon Attack:_ +5 to hit, reach 10 ft., one target. _Hit:_ 8 (1d10+3) slashing damage. If the target is a creature other than a Construct or Undead, it must succeed on a DC 13 CON save or lose 3 (1d6) HP at the start of each of its turns due to an infernal wound. Each time the devil hits the wounded target with this attack, the damage dealt by the wound increases by 3 (1d6). Any creature can take an action to stanch the wound with a successful DC 10 WIS (Medicine) check. The wound also closes if the target receives magical healing, provided the target is capable of regaining HP.

**Bonus Actions**

- **_Enhance Pain._** The bearded devil enhances the pain in one creature it can see within 30 feet of it that is poisoned from the devil's Beard Spines attack or suffering an infernal wound from the devil's Glaive attack. The target must succeed on a DC 13 CON save or be incapacitated until the end of its next turn, as it doubles over in pain.

#### Bone Devil (CR 9)

_Large Fiend (Devil)_

- **Armor Class** 18 (natural armor)
- **Hit Points** 144
- **Speed** 40 ft., fly 40 ft.
- **Perception** 16
- **Stealth** 13
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +4 |  +5 |  +6 |  +7 |

- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The devil makes two Claw attacks and one Sting attack.
- **_Claw._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 17 (3d8+4) slashing damage.
- **_Sting._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage plus 14 (4d6) poison damage, and the target must succeed on a DC 15 CON save or be poisoned for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Bonus Actions**

- **_Devilish Command._** The bone devil shouts one of the following commands at one creature it can see within 30 feet of it. The target must succeed on a DC 15 CHA save or obey the command. A lesser devil, such as a barbed devil or lemure, has disadvantage on this save.
  - **Attack.** The target uses its reaction to make one melee or ranged attack (the devil's choice) against one creature the target can see within its weapon's range.
  - **Beg for Mercy.** The target immediately falls prone and can't cast spells with verbal components on its next turn as it is magically compelled to speak pleas of mercy.
  - **Flee.** The target uses its reaction to move up to its speed directly away from the bone devil. This movement doesn't provoke opportunity attacks, but the target doesn't avoid damaging terrain, such as lava.

#### Chain Devil (CR 8)

_Medium Fiend (Devil)_

- **Armor Class** 16 (natural armor)
- **Hit Points** 138
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 12
- **Resistant** grappled | Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +7 |  +0 |  +4 |  +5 |

- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The devil makes four Chain attacks.
- **_Chain._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 8 (1d8+4) slashing damage plus 7 (2d6) piercing damage, and the target is grappled (escape DC 15). Until the grapple ends, the target is restrained and takes 14 (4d6) piercing damage at the start of each of its turns, and the chain devil can't use the same Chain on another target.

**Bonus Actions**

- **_Animate Chains._** The chain devil commands chains it can see within 60 feet of it that aren't being worn or carried to grab up to two creatures it can see within 10 feet of at least one commanded chain. Each creature must succeed on a DC 15 DEX save or be restrained. A creature, including the restrained creature, can take its action to free the restrained creature by succeeding on a DC 15 STR check. The devil can have up to two creatures restrained in this way at a time. If it uses this bonus action to restrain a third, the effect ends on one of the previous targets (the devil's choice).

**Reactions**

- **_Unnerving Mask._** When a creature the devil can see starts its turn within 30 feet of the devil, the devil can command its mask to shift to look like one of the creature's departed loved ones or bitter enemies. If the creature can see the mask, it must succeed on a DC 15 WIS save or be frightened until the end of its turn.

#### Erinyes (CR 12)

_Medium Fiend (Devil)_

- **Armor Class** 18 (plate)
- **Hit Points** 147
- **Speed** 30 ft., fly 60 ft.
- **Perception** 16
- **Stealth** 17
- **Resistant** charmed, frightened | Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** truesight 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +7 |  +8 |  +2 |  +6 |  +8 |

- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Disciplined Fighter._** At the start of each of its turns, the erinyes chooses one of the following fighting styles to adopt, which lasts until the start of the erinyes's next turn.
  - **Aggressive.** The erinyes has advantage on the first attack it makes on its turn, but the next attack roll against the erinyes has advantage.
  - **Retributive.** The next time the erinyes is hit by a melee weapon attack from a creature within 5 feet of it, the erinyes can make one Longsword attack against the attacker (no action required).
  - **Defensive.** The next time erinyes uses the Parry reaction, it takes only half the damage if the attack hits and regains 18 (4d8) HP if the attack doesn't hit.
- **_Poisonous Weapons._** The erinyes's weapon attacks are magical. When the erinyes hits with any weapon, the weapon deals an extra 4d8 poison damage (included in the attack).
- **_Magic Resistance._** The erinyes has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The erinyes makes three Longsword or Longbow attacks.
- **_Longsword._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 8 (1d8+4) slashing damage, or 9 (1d10+4) slashing damage if used with two hands, plus 18 (4d8) poison damage.
- **_Longbow._** _Ranged Weapon Attack:_ +7 to hit, range 150/600 ft., one target. _Hit:_ 7 (1d8+3) piercing damage plus 18 (4d8) poison damage, and the target must succeed on a DC 16 CON save or be poisoned for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Reactions**

- **_Parry._** The erinyes adds 4 to its AC against one melee attack that would hit it. To do so, the erinyes must see the attacker and be wielding a melee weapon.

#### Horned Devil (CR 11)

_Large Fiend (Devil)_

- **Armor Class** 18 (natural armor)
- **Hit Points** 185
- **Speed** 20 ft., fly 60 ft.
- **Perception** 17
- **Stealth** 17
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +7 |  +5 |  +1 |  +7 |  +7 |

- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The devil makes two Fork attacks and one Tail attack, or it makes three Hurl Flame attacks.
- **_Fork._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 19 (3d8+6) piercing damage.
- **_Tail._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 22 (3d10+6) piercing damage. If the target is a creature other than a Construct or Undead, it must succeed on a DC 17 CON save or lose 10 (3d6) HP at the start of each of its turns due to an infernal wound. Each time the devil hits the wounded target with this attack, the damage dealt by the wound increases by 10 (3d6). Any creature can take an action to stanch the wound with a successful DC 12 WIS (Medicine) check. The wound also closes if the target receives magical healing.
- **_Hurl Flame._** _Ranged Spell Attack:_ +7 to hit, range 150 ft., one target. _Hit:_ 20 (5d6+3) fire damage. If the target is a flammable object that isn't being worn or carried, it also catches fire.

**Bonus Actions**

- **_Headbutt._** The horned devil slams its horned head into a creature it can see within 5 feet of it. The target must make a DC 17 STR save. On a failure, the target takes 7 (2d6) bludgeoning damage and is knocked prone. On a success, the target takes half the damage and isn't knocked prone.

#### Ice Devil (CR 14)

_Large Fiend (Devil)_

- **Armor Class** 18 (natural armor)
- **Hit Points** 193
- **Speed** 40 ft.
- **Perception** 17
- **Stealth** 17
- **Resistant** blinded | Devilish Resilience
- **Immune** cold | Devilish Resilience
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +7 |  +9 |  +4 |  +7 |  +9 |

- **_Devil's Sight._** Magical darkness doesn't impede the devil's darkvision.
- **_Devilish Resilience._** The devil is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The devil has advantage on saves against spells and other magical effects.
- **_Snow Walk._** The devil can move across icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn't cost it extra movement.

**Actions**

- **_Multiattack._** The devil makes two Claw attacks and one Tail attack, or it makes three Icicle Shard attacks.
- **_Claws._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) slashing damage plus 18 (4d8) cold damage.
- **_Tail._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 15 (3d6+5) bludgeoning damage plus 18 (4d8) cold damage.
- **_Icicle Shard._** _Ranged Spell Attack:_ +9 to hit, range 120 ft., one target. _Hit:_ 13 (2d8+4) piercing damage plus 18 (4d8) cold damage.

**Bonus Actions**

- **_Ice Wall._** The ice devil causes a wall of ice to magically rise from the ground at a point it can see within 60 feet of it. The wall is up to 30 feet long, 10 feet high, and 5 feet thick. It can be any shape, as long as its base is connected to the ground. If the wall cuts through a creature's space when it appears, the creature is pushed to one side (the devil's choice). If a creature would be surrounded on all sides by the wall, it can make a DC 17 DEX save. On a success, it can use its reaction to move up to its speed so that it is no longer enclosed by the wall.

  The wall lasts 1 minute, until the devil creates a new wall, or until the devil dies. Each 10 - foot section of the wall has AC 5, 30 HP, is vulnerable to fire damage, and is immune to acid, cold, necrotic, poison, and psychic damage.

**Reactions**

- **_Ice Shield._** When the ice devil or a friendly creature it can see is hit by an attack, the devil can create a magical barrier of ice to disrupt the attack. The target halves the damage from the attack.

#### Imp (CR 1)

_Tiny Fiend (Devil)_

- **Armor Class** 13
- **Hit Points** 31
- **Speed** 20 ft., fly 40 ft.
- **Perception** 11
- **Stealth** 15
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +3 |  +1 |  +0 |  +1 |  +4 |

- **_Devil's Sight._** Magical darkness doesn't impede the imp's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Magic Resistance._** The imp has advantage on saves against spells and other magical effects.

**Actions**

- **_Slam (Beast Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning, piercing, or slashing damage (based on the type of damage dealt by the Beast form's primary attack, such as Bite).
- **_Sting (True Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) piercing damage, and the target must make a DC 12 CON save, taking 10 (3d6) poison damage on a failed save, or half as much damage on a successful one.
- **_Invisibility (True Form Only)._** The imp magically turns invisible until it attacks or uses Change Shape, or until its concentration ends (as if concentrating on a spell). Any equipment the imp wears or carries is invisible with it.

**Bonus Actions**

- **_Change Shape._** The imp magically transforms into a Medium or smaller Beast that has a CR no higher than its own or back into its true form, which is a Fiend. Without wings, it loses its flying speed. Its statistics, other than its size and speed, are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its true form if it dies.

#### Lemure (CR 1/4)

_Medium Fiend (Devil)_

- **Armor Class** 8
- **Hit Points** 17
- **Speed** 15 ft.
- **Perception** 10
- **Stealth** 7
- **Resistant** Devilish Resilience
- **Immune** Devilish Resilience
- **Senses** darkvision 120 ft.
- **Languages** Infernal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  -2 |  +1 |  -3 |  +0 |  -4 |

- **_Devil's Sight._** Magical darkness doesn't impede the lemure's darkvision.
- **_Devilish Resilience._** The devil is resistant to cold damage. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Hellish Rejuvenation._** Unlike other outsiders, a lemure that dies in its home plane of the Hells is restored in a new body in 1d10 days, regaining all its HP and becoming active again. The new body appears in the Hells within 1 mile of where it was slain. Only sprinkling holy water on the lemure's remains can prevent this trait from functioning.

**Actions**

- **_Fist._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage plus 2 (1d4) fire damage.

**Bonus Actions**

- **_Rippling Heat (1/Day)._** The lemure exudes an aura of extreme heat for 1 minute. Each creature that starts its turn within 15 feet of the lemure and that isn't a devil must succeed on a DC 11 CON save or be weakened until the start of its next turn. A weakened creature has disadvantage on all attack rolls, and it deals only half damage with weapon attacks that use Strength. A creature that fails this save by 5 or more suffers one level of exhaustion. A creature that has suffered a level of exhaustion from this lemure's Rippling Heat can't suffer another level from this lemure's Rippling Heat for 24 hours.

#### Pit Fiend (CR 20)

_Large Fiend (Devil)_

- **Armor Class** 19 (natural armor)
- **Hit Points** 323
- **Speed** 30 ft., fly 60 ft.
- **Perception** 20
- **Stealth** 18
- **Resistant** Devilish Resilience
- **Immune** charmed, frightened | Devilish Resilience
- **Senses** truesight 120 ft.
- **Languages** Infernal, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +8 | +13 |  +6 | +10 |  +7 |

- **_Aura of the Devil Lord._** Each hostile creature that starts its turn within 20 feet of the pit fiend must succeed on a DC 21 WIS save or be frightened until the start of its next turn. Each friendly devil within 20 feet of the pit fiend is immune to the charmed and frightened conditions and has advantage on the first attack roll it makes on each of its turns.
- **_Devilish Resilience._** The devil is resistant to cold damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to fire damage and poison damage and to the poisoned condition.
- **_Flaming Weapons._** The pit fiend's weapon attacks are magical. When the fiend hits with any weapon, the weapon deals an extra 4d6 fire damage (included in the attack).
- **_Magic Resistance._** The pit fiend has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The pit fiend makes one Bite attack, one Gore attack, one Mace attack, and one Tail attack, or it makes four Hurl Flame attacks. If two Hurl Flame attacks hit one creature, each creature within 10 feet of the target must make a DC 21 DEX save as the fire bursts outward from the target, taking 14 (4d6) fire damage on a failed save, or half as much damage on a successful one.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 5 ft., one target. _Hit:_ 22 (4d6+8) piercing damage plus 14 (4d6) fire damage and 13 (3d8) poison damage. The target must succeed on a DC 21 CON save or be poisoned. While poisoned in this way, the target can't regain HP. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Gore._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 17 (2d8+8) piercing damage plus 14 (4d6) fire damage.
- **_Mace._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) bludgeoning damage plus 14 (4d6) fire damage.
- **_Tail._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 24 (3d10+8) bludgeoning damage plus 14 (4d6) fire damage, and the target must succeed on a DC 21 STR save or be knocked prone.
- **_Hurl Flame._** _Ranged Spell Attack:_ +10 to hit, range 120 ft., one target. _Hit:_ 25 (6d6+4) fire damage.

### Dinosaurs

#### Plesiosaurus (CR 2)

_Large Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 60
- **Speed** 20 ft., swim 40 ft.
- **Perception** 13
- **Stealth** 14
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +3 |  -4 |  +1 |  -3 |

- **_Hardy._** Any critical hit against the dinosaur becomes a normal hit.
- **_Hold Breath._** The plesiosaurus can hold its breath for 1 hour.

**Actions**

- **_Multiattack._** The plesiosaurus makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 11 (2d6+4) piercing damage.

**Bonus Actions**

- **_Flipper Slam._** While underwater, the plesiosaurus slams its flippers together, sending a shockwave of water in a 15 - foot cone. Each creature in the area must succeed on a DC 13 CON save or be off - balance until the end of its next turn. While off - balance, a creature's speed is halved, and it has disadvantage on the first attack roll it makes on each of its turns.

#### Triceratops (CR 5)

_Huge Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 126
- **Speed** 50 ft.
- **Perception** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  -1 |  +3 |  -4 |  +0 |  -3 |

- **_Hardy._** Any critical hit against the dinosaur becomes a normal hit.
- **_Trampling Charge._** If the triceratops moves at least 20 feet straight toward a creature and then hits it with a Gore attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the triceratops can make one Stomp attack against it as a bonus action.

**Actions**

- **_Multiattack._** The triceratops makes two Gore attacks.
- **_Gore._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 19 (3d8+6) piercing damage.
- **_Stomp._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one prone creature. _Hit:_ 17 (2d10+6) bludgeoning damage.

**Bonus Actions**

- **_Warning Bugle._** The triceratops emits a piercing call in a 30 - foot cone, signaling its impending attack. Each creature in the area must succeed on a DC 14 WIS save or be frightened until the end of its next turn. If the triceratops uses this bonus action before moving the requisite 20 feet for Trampling Charge, the target of its charge has disadvantage on this save, and the triceratops can make a Stomp attack against the prone target without needing to use a bonus action, provided the target fails the STR save from the charge.

#### Tyrannosaurus Rex (CR 8)

_Huge Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 184
- **Speed** 50 ft.
- **Perception** 14
- **Stealth** 9
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +0 |  +4 |  -4 |  +1 |  -1 |

- **_Hardy._** Any critical hit against the dinosaur becomes a normal hit.

**Actions**

- **_Multiattack._** The tyrannosaurus makes one Bite attack and one Tail attack. It can't make both attacks against the same target.
- **_Bite._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one creature. _Hit:_ 31 (4d12+5) piercing damage. If the target is a Large or smaller creature, it is grappled (escape DC 16). Until this grapple ends, the target is restrained, and the tyrannosaurus can't Bite another target.
- **_Tail._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one creature. _Hit:_ 23 (4d8+5) bludgeoning damage.

**Bonus Actions**

- **_Rending Shake._** While grappling a creature, the tyrannosaurus shakes its head, tearing at the creature. The grappled creature must succeed on a DC 16 STR save or take 6 (1d12) slashing damage and be thrown up to 20 feet in a random direction and knocked prone. If the thrown target strikes a solid surface, the target takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target is thrown at another creature, that creature must succeed on a DC 16 DEX save or take the same damage and be knocked prone.

#### Velociraptor (CR 1/2)

_Small Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 25
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 14
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +4 |  +1 |  -3 |  +1 |  -2 |

- **_Hardy._** Any critical hit against the dinosaur becomes a normal hit.
- **_Pack Tactics._** The velociraptor has advantage on attack rolls against a creature if at least one of its allies is within 5 feet of the target and the ally isn't incapacitated.

**Actions**

- **_Multiattack._** The velociraptor makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage. If the target is a Medium or smaller creature, it is grappled (escape DC 12). Until this grapple ends, the target is restrained, and the velociraptor can't Bite another target.
- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage.
- **_Maul._** The velociraptor uses its claws to rip into one creature it is grappling. The target must make a DC 12 STR save, taking 10 (4d4) slashing damage on a failed save, or half as much damage on a successful one.

### Doppelganger (CR 3)

_Medium Monstrosity (Shapechanger)_

- **Armor Class** 14
- **Hit Points** 80
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 16
- **Immune** charmed
- **Senses** darkvision 60 ft.
- **Languages** Common, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +4 |  +2 |  +0 |  +3 |  +4 |

- **_Convincing Mimicry (Humanoid Form Only)._** The doppelganger can mimic any Humanoid's body and voice it has seen and heard nearly perfectly. A creature very familiar with the individual Humanoid the doppelganger is pretending to be can tell the doppelganger is an imitation with a successful DC 20 WIS (Insight) check.
- **_Revealed Intentions._** While reading a creature's mind, the doppelganger has advantage on CHA checks against the creature, knows the creature's current mood, and knows if the creature speaks a lie. In addition, the doppelganger has advantage on attack rolls against the creature.

**Actions**

- **_Multiattack._** The doppelganger makes two Slam or Psychic Bolt attacks.
- **_Slam._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage.
- **_Psychic Bolt._** _Ranged Spell Attack:_ +4 to hit, range 60 ft., one target. _Hit:_ 13 (2d10+2) psychic damage.

**Bonus Actions**

- **_Change Shape._** The doppelganger transforms into a Small or Medium Humanoid it has seen or back into its true form, which is Monstrosity. Its statistics, other than its size and speed, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.
- **_Read Thoughts._** The doppelganger magically reads the surface thoughts - what is foremost in the mind at the moment - of one creature within 60 feet of it. The effect can penetrate barriers, but 3 feet of wood or dirt, 2 feet of stone, 2 inches of metal, or a thin sheet of lead blocks it. While the target is in range, the doppelganger can continue reading the target's thoughts until its concentration is broken (as if concentrating on a spell) or it uses Read Thoughts on a different target.

### Dragons

#### Dragon Turtle (CR 17)

_Gargantuan Dragon_

- **Armor Class** 20 (natural armor)
- **Hit Points** 318
- **Speed** 20 ft., swim 40 ft.
- **Perception** 17
- **Stealth** 16
- **Resistant** fire
- **Senses** darkvision 120 ft.
- **Languages** Aquan, Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +6 | +11 |  +0 |  +7 |  +1 |

- **_Amphibious._** The dragon turtle can breathe air and water.
- **_Siege Monster._** The dragon turtle deals double damage to objects and structures.

**Actions**

- **_Multiattack._** The dragon turtle makes one Bite attack, two Claw attacks, and one Tail attack. If it is latched onto a vehicle, it can instead make four Claw attacks and one Tail attack.
- **_Bite._** _Melee Weapon Attack:_ +13 to hit, reach 15 ft., one target. _Hit:_ 33 (4d12+7) piercing damage plus 7 (2d6) fire damage. Instead of dealing damage, the dragon turtle can choose to latch onto the target, if the target is a vehicle, such as a ship or wagon. If the vehicle is Huge or smaller, its speed is reduced to 0, and it can't be moved until the dragon turtle is killed or ends this effect. If the vehicle is Gargantuan, the vehicle's speed is halved, and the turtle moves with it when it moves. While latched onto a vehicle in this way, the turtle can make Bite attacks against only the vehicle and such attacks automatically hit. The turtle can end this effect at any time (no action required).
- **_Claw._** _Melee Weapon Attack:_ +13 to hit, reach 10 ft., one target. _Hit:_ 20 (3d8+7) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +13 to hit, reach 15 ft., one target. _Hit:_ 29 (4d10+7) bludgeoning damage. If the target is a creature, it must succeed on a DC 19 STR save or be pushed up to 15 feet away from the dragon turtle and knocked prone.
- **_Steam Breath (Recharge 5 - 6)._** The dragon turtle exhales scalding steam in a 60 - foot cone. Each creature in that area must make a DC 19 CON save, taking 56 (16d6) fire damage on a failed save, or half as much damage on a successful one. Being underwater doesn't grant resistance against this damage.

**Reactions**

- **_Siege Follow - Through._** If the dragon turtle destroys an object or structure with an attack, it can make a Bite or Tail attack against a creature it can see within 5 feet of that object or structure.

#### Black Dragon Wyrmling (CR 2)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 51
- **Speed** 30 ft., fly 60 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 14
- **Immune** acid | poisoned
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +4 |  +3 |  +0 |  +2 |  +3 |

- **_Amphibious._** The black dragon can breathe air and water.
- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (1d10+3) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) slashing damage.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 15 - foot line that is 5 feet wide. Each creature in that line must make a DC 11 DEX save, taking 22 (5d8) acid damage on a failed save, or half as much damage on a successful one.

#### Young Black Dragon (CR 7)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 136
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 17
- **Stealth** 15
- **Immune** acid | poisoned
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +5 |  +6 |  +1 |  +4 |  +5 |

- **_Acidic Vapors._** After the black dragon uses its Acid Breath, acid clings to its mouth, throat, and nostrils for a time, evaporating as the dragon breathes. While the dragon's Acid Breath is unavailable, acidic vapors surround it, and each creature that starts its turn within 10 feet of the dragon must succeed on a DC 15 CON save or be poisoned until the start of its next turn.
- **_Amphibious._** The dragon can breathe air and water.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 3 - foot line that is 5 feet wide. Each creature in that line must make a DC 15 DEX save, taking 49 (11d8) acid damage on a failed save, or half as much damage on a successful one.

#### Adult Black Dragon (CR 14)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 238
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 22
- **Stealth** 17
- **Immune** acid | poisoned
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +7 | +10 |  +2 |  +7 |  +8 |

- **_Acidic Vapors._** After the black dragon uses its Acid Breath, acid clings to its mouth, throat, and nostrils for a time, evaporating as the dragon breathes. While the dragon's Acid Breath is unavailable, acidic vapors surround it, and each creature that starts its turn within 20 feet of the dragon must succeed on a DC 18 CON save or be poisoned until the start of its next turn.
- **_Amphibious._** The dragon can breathe air and water.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +12 to hit, reach 10 ft., one target. _Hit:_ 18 (2d10+7) piercing damage plus 4 (1d8) acid damage.
- **_Claw._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 14 (2d6+7) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +12 to hit, reach 15 ft., one target. _Hit:_ 16 (2d8+7) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 16 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 60 - foot line that is 5 feet wide. Each creature in that line must make a DC 18 DEX save, taking 49 (11d8) acid damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 16 CHA save or be vulnerable to acid damage until the end of its next turn. A target resistant to acid damage isn't resistant to it for the duration. A target immune to acid damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 20 DEX save or take 14 (2d6+7) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Black Dragon (CR 20)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 355
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 25
- **Stealth** 18
- **Immune** acid | poisoned
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +8 | +13 |  +3 |  +9 | +10 |

- **_Acidic Vapors._** After the black dragon uses its Acid Breath, acid clings to its mouth, throat, and nostrils for a time, evaporating as the dragon breathes. While the dragon's Acid Breath is unavailable, acidic vapors surround it, and each creature that starts its turn within 30 feet of the dragon must succeed on a DC 21 CON save or be poisoned until the start of its next turn.
- **_Amphibious._** The dragon can breathe air and water.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +15 to hit, reach 15 ft., one target. _Hit:_ 20 (2d10+9) piercing damage plus 9 (2d8) acid damage.
- **_Claw._** _Melee Weapon Attack:_ +15 to hit, reach 10 ft., one target. _Hit:_ 16 (2d6+9) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +15 to hit, reach 20 ft., one target. _Hit:_ 18 (2d8+9) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 18 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 90 - foot line that is 10 feet wide. Each creature in that line must make a DC 21 DEX save, taking 67 (15d8) acid damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 18 CHA save or be vulnerable to acid damage until the end of its next turn. A target resistant to acid damage isn't resistant to it for the duration. A target immune to acid damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 23 DEX save or take 16 (2d6+9) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Blue Dragon Wyrmling (CR 3)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 68
- **Speed** 30 ft., burrow 15 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** lightning
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +4 |  +1 |  +2 |  +4 |

- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (1d10+3) piercing damage plus 3 (1d6) lightning damage.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) slashing damage.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 30 - foot line that is 5 feet wide. Each creature in that line must make a DC 12 DEX save, taking 27 (5d10) lightning damage on a failed save, or half as much damage on a successful one.

#### Young Blue Dragon (CR 9)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 175
- **Speed** 40 ft., burrow 20 ft., fly 80 ft.
- **Perception** 19
- **Stealth** 14
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +4 |  +8 |  +2 |  +5 |  +7 |

- **_Charged Hide._** When the blue dragon hasn't exhaled its Lightning Breath, the electric charge builds up across its body. While the dragon's Lightning Breath is available, it emits wild sparks of electricity, and each creature that starts its turn within 10 feet of the dragon must succeed on a DC 16 CON save or be incapacitated until the start of its next turn.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 16 (2d10+5) piercing damage plus 5 (1d10) lightning damage.
- **_Claw._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) slashing damage.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 60 - foot line that is 5 feet wide. Each creature in that line must make a DC 16 DEX save, taking 55 (10d10) lightning damage on a failed save, or half as much damage on a successful one.

#### Adult Blue Dragon (CR 16)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 267
- **Speed** 40 ft., burrow 30 ft., fly 80 ft.
- **Perception** 22
- **Stealth** 15
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +5 | +11 |  +3 |  +7 |  +9 |

- **_Charged Hide._** When the blue dragon hasn't exhaled its Lightning Breath, the electric charge builds up across its body. While the dragon's Lightning Breath is available, it emits wild sparks of electricity, and each creature that starts its turn within 20 feet of the dragon must succeed on a DC 19 CON save or be incapacitated until the start of its next turn.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +12 to hit, reach 10 ft., one target. _Hit:_ 18 (2d10+7) piercing damage plus 5 (1d10) lightning damage.
- **_Claw._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 14 (2d6+7) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +12 to hit, reach 15 ft., one target. _Hit:_ 16 (2d8+7) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 17 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 90 - foot line that is 5 feet wide. Each creature in that line must make a DC 19 DEX save, taking 66 (12d10) lightning damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 17 CHA save or be vulnerable to lightning damage until the end of its next turn. A target resistant to lightning damage isn't resistant to it for the duration. A target immune to lightning damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 20 DEX save or take 14 (2d6+7) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Blue Dragon (CR 20)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 355
- **Speed** 40 ft., burrow 40 ft., fly 80 ft.
- **Perception** 27
- **Stealth** 16
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +6 | +14 |  +4 |  +9 | +11 |

- **_Charged Hide._** When the blue dragon hasn't exhaled its Lightning Breath, the electric charge builds up across its body. While the dragon's Lightning Breath is available, it emits wild sparks of electricity, and each creature that starts its turn within 30 feet of the dragon must succeed on a DC 22 CON save or be incapacitated until the start of its next turn.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +15 to hit, reach 15 ft., one target. _Hit:_ 20 (2d10+9) piercing damage plus 11 (2d10) lightning damage.
- **_Claw._** _Melee Weapon Attack:_ +15 to hit, reach 10 ft., one target. _Hit:_ 16 (2d6+9) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +15 to hit, reach 20 ft., one target. _Hit:_ 18 (2d8+9) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 19 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 120 - foot line that is 10 feet wide. Each creature in that line must make a DC 22 DEX save, taking 99 (18d10) lightning damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 19 CHA save or be vulnerable to lightning damage until the end of its next turn. A target resistant to lightning damage isn't resistant to it for the duration. A target immune to lightning damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 23 DEX save or take 16 (2d6+9) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Brass Dragon Wyrmling (CR 1)

_Medium Dragon_

- **Armor Class** 16 (natural armor)
- **Hit Points** 36
- **Speed** 30 ft., burrow 15 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** fire
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +3 |  +0 |  +2 |  +3 |

- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 12 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (1d10+2) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 30 - foot line that is 5 feet wide. Each creature in that line must make a DC 11 DEX save, taking 14 (4d6) fire damage on a failed save, or half as much damage on a successful one.
- **_Sleep Breath (Recharge 6)._** The dragon exhales sleep gas in a 15 - foot cone. Each creature in that area must succeed on a DC 11 CON save or fall unconscious for 1 minute. This effect ends for a creature if the creature takes damage or another creature uses an action to wake it.

#### Young Brass Dragon (CR 6)

_Large Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 119
- **Speed** 40 ft., burrow 20 ft., fly 80 ft.
- **Perception** 16
- **Stealth** 13
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +6 |  +1 |  +3 |  +5 |

- **_Suffocating Heat._** After the brass dragon uses its Fire Breath, the air around it is devoid of moisture and lacking in breathable air. While the dragon's Fire Breath is unavailable, each creature that requires air to breathe, other than the dragon, and that starts its turn within 10 feet of the dragon must succeed on a DC 14 CON save or begin suffocating. A creature that fails this save for two consecutive rounds falls unconscious until it takes damage or another creature uses an action to wake it.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Sleep Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 60 - foot line that is 5 feet wide. Each creature in that line must make a DC 14 DEX save, taking 35 (10d6) fire damage on a failed save, or half as much damage on a successful one.
- **_Sleep Breath (Recharge 6)._** The dragon exhales sleep gas in a 30 - foot cone. Each creature in that area must succeed on a DC 14 CON save or fall unconscious for 1 minute. This effect ends for a creature if the creature takes damage or another creature uses an action to wake it.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Adult Brass Dragon (CR 13)

_Huge Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 225
- **Speed** 40 ft., burrow 30 ft., fly 80 ft.
- **Perception** 21
- **Stealth** 15
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +5 | +10 |  +2 |  +6 |  +8 |

- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Suffocating Heat._** As the **young brass dragon**, except it affects creatures within 20 feet of the dragon, and the save DC is 18.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Sleep Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +11 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +11 to hit, reach 15 ft., one target. _Hit:_ 15 (2d8+6) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 16 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 90 - foot line that is 5 feet wide. Each creature in that line must make a DC 18 DEX save, taking 45 (13d6) fire damage on a failed save, or half as much damage on a successful one.
- **_Sleep Breath (Recharge 6)._** The dragon exhales sleep gas in a 60 - foot cone. Each creature in that area must succeed on a DC 18 CON save or fall unconscious for 5 minutes. This effect ends for a creature if the creature takes damage or another creature uses an action to wake it.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 16 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 19 DEX save or take 13 (2d6+6) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Brass Dragon (CR 17)

_Gargantuan Dragon_

- **Armor Class** 20 (natural armor)
- **Hit Points** 284
- **Speed** 40 ft., burrow 40 ft., fly 80 ft.
- **Perception** 24
- **Stealth** 16
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +6 | +13 |  +3 |  +8 | +10 |

- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Suffocating Heat._** As the **young brass dragon**, except it affects creatures within 30 feet of the dragon, and the save DC is 21.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Sleep Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 15 ft., one target. _Hit:_ 19 (2d10+8) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +14 to hit, reach 20 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 18 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 120 - foot line that is 10 feet wide. Each creature in that line must make a DC 21 DEX save, taking 70 (20d6) fire damage on a failed save, or half as much damage on a successful one.
- **_Sleep Breath (Recharge 6)._** The dragon exhales sleep gas in a 90 - foot cone. Each creature in that area must succeed on a DC 21 CON save or fall unconscious for 10 minutes. This effect ends for a creature if the creature takes damage or another creature uses an action to wake it.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 18 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 24 DEX save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Bronze Dragon Wyrmling (CR 2)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 51
- **Speed** 30 ft., fly 60 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** lightning
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +4 |  +1 |  +2 |  +4 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (1d10+3) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) slashing damage.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 30 - foot line that is 5 feet wide. Each creature in that line must make a DC 12 DEX save, taking 16 (3d10) lightning damage on a failed save, or half as much damage on a successful one.
- **_Repulsion Breath (Recharge 6)._** The dragon exhales repulsion energy in a 15 - foot cone. Each creature in that area must succeed on a DC 12 STR save or be pushed up to 5 feet away from the dragon.

#### Young Bronze Dragon (CR 8)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 148
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 17
- **Stealth** 13
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +3 |  +7 |  +2 |  +4 |  +6 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Lightning Extraction._** After the bronze dragon uses its Lightning Breath, its body begins recharging with lightning, pulling electricity from nearby creatures. While the dragon's Lightning Breath is unavailable, each creature that starts its turn within 10 feet of the dragon must make a DC 15 CON save. On a failure, a creature can use either an action or a bonus action on its turn, not both.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Repulsion Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 16 (2d10+5) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) slashing damage.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 60 - foot line that is 5 feet wide. Each creature in that line must make a DC 15 DEX save, taking 49 (9d10) lightning damage on a failed save, or half as much damage on a successful one.
- **_Repulsion Breath (Recharge 6)._** The dragon exhales repulsion energy in a 30 - foot cone. Each creature in that area must succeed on a DC 15 STR save or be pushed up to 15 feet away from the dragon.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Adult Bronze Dragon (CR 15)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 255
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 22
- **Stealth** 15
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +5 | +11 |  +3 |  +7 |  +9 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Lightning Extraction._** As the **young bronze dragon**, except it affects creatures within 20 feet of the dragon, and the save DC is 19.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Repulsion Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +12 to hit, reach 10 ft., one target. _Hit:_ 18 (2d10+7) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 14 (2d6+7) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +12 to hit, reach 15 ft., one target. _Hit:_ 16 (2d8+7) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 17 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 90 - foot line that is 5 feet wide. Each creature in that line must make a DC 19 DEX save, taking 60 (11d10) lightning damage on a failed save, or half as much damage on a successful one.
- **_Repulsion Breath (Recharge 6)._** The dragon exhales repulsion energy in a 60 - foot cone. Each creature in that area must succeed on a DC 19 STR save or be pushed up to 30 feet away from the dragon.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 17 CHA save or be vulnerable to lightning damage until the end of its next turn. A target resistant to lightning damage isn't resistant to it for the duration. A target immune to lightning damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 20 DEX save or take 14 (2d6+7) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Bronze Dragon (CR 19)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 314
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 27
- **Stealth** 16
- **Immune** lightning
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +6 | +14 |  +4 |  +9 | +11 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Lightning Extraction._** As the **young bronze dragon**, except it affects creatures within 30 feet of the dragon, and the save DC is 22.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Repulsion Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +15 to hit, reach 15 ft., one target. _Hit:_ 20 (2d10+9) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +15 to hit, reach 10 ft., one target. _Hit:_ 16 (2d6+9) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +15 to hit, reach 20 ft., one target. _Hit:_ 18 (2d8+9) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 19 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Lightning Breath (Recharge 5 - 6)._** The dragon exhales lightning in a 120 - foot line that is 10 feet wide. Each creature in that line must make a DC 22 DEX save, taking 88 (16d10) lightning damage on a failed save, or half as much damage on a successful one.
- **_Repulsion Breath (Recharge 6)._** The dragon exhales repulsion energy in a 90 - foot cone. Each creature in that area must succeed on a DC 22 STR save or be pushed up to 45 feet away from the dragon.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 19 CHA save or be vulnerable to lightning damage until the end of its next turn. A target resistant to lightning damage isn't resistant to it for the duration. A target immune to lightning damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 23 DEX save or take 16 (2d6+9) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Copper Dragon Wyrmling (CR 1)

_Medium Dragon_

- **Armor Class** 16 (natural armor)
- **Hit Points** 36
- **Speed** 30 ft., climb 30 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 13
- **Immune** acid
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +3 |  +3 |  +2 |  +2 |  +3 |

- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 12 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (1d10+2) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 30 - foot line that is 5 feet wide. Each creature in that line must make a DC 11 DEX save, taking 18 (4d8) acid damage on a failed save, or half as much damage on a successful one.
- **_Slowing Breath (Recharge 6)._** The dragon exhales slowing gas in a 15 - foot cone. Each creature in that area must make a DC 11 CON save. On a failure, the creature can't use reactions, its speed is halved, and it can't make more than one attack on its turn. In addition, the creature can use either an action or a bonus action on its turn, not both. These effects last for 1 minute. The creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

#### Young Copper Dragon (CR 7)

_Large Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 144
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 17
- **Stealth** 14
- **Immune** acid
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +4 |  +6 |  +3 |  +4 |  +5 |

- **_Corrosive Scales._** When the copper dragon hasn't spit its Acid Breath, the acid built up within the dragon causes the patina on its scales to spread to weapons that strike it. While the dragon's Acid Breath is available, any weapon made of metal that hits the dragon corrodes. After dealing damage, the weapon takes a permanent and cumulative -1 penalty to damage rolls. If a nonmagical weapon's penalty drops to -5, the weapon is destroyed. Nonmagical ammunition made of metal that hits the dragon is destroyed after dealing damage. A magical weapon can't have a penalty greater than -5, and a magical weapon removes this penalty after 24 hours or after its attuned wielder finishes a long rest.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Slowing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 60 - foot line that is 5 feet wide. Each creature in that line must make a DC 14 DEX save, taking 40 (9d8) acid damage on a failed save, or half as much damage on a successful one.
- **_Slowing Breath (Recharge 6)._** As the **copper dragon wyrmling**, except it is a 30 - foot cone, and the save DC is 14.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Adult Copper Dragon (CR 14)

_Huge Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 252
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 22
- **Stealth** 16
- **Immune** acid
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +6 | +10 |  +4 |  +7 |  +8 |

- **_Corrosive Scales._** As the **young copper dragon**.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Slowing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +11 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +11 to hit, reach 15 ft., one target. _Hit:_ 15 (2d8+6) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 16 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 90 - foot line that is 5 feet wide. Each creature in that line must make a DC 18 DEX save, taking 54 (12d8) acid damage on a failed save, or half as much damage on a successful one.
- **_Slowing Breath (Recharge 6)._** As the **copper dragon wyrmling**, except it is a 60 - foot cone, and the save DC is 18.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 16 CHA save or be vulnerable to acid damage until the end of its next turn. A target resistant to acid damage isn't resistant to it for the duration. A target immune to acid damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 19 DEX save or take 13 (2d6+6) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Copper Dragon (CR 18)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 297
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 27
- **Stealth** 16
- **Immune** acid
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +6 | +13 |  +5 |  +9 | +10 |

- **_Corrosive Scales._** As the **young copper dragon**.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Slowing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +15 to hit, reach 15 ft., one target. _Hit:_ 19 (2d10+8) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +15 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +15 to hit, reach 20 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 18 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Acid Breath (Recharge 5 - 6)._** The dragon exhales acid in a 120 - foot line that is 10 feet wide. Each creature in that line must make a DC 21 DEX save, taking 76 (17d8) acid damage on a failed save, or half as much damage on a successful one.
- **_Slowing Breath (Recharge 6)._** As the **copper dragon wyrmling**, except it is a 90 - foot cone, and the save DC is 21.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 18 CHA save or be vulnerable to acid damage until the end of its next turn. A target resistant to acid damage isn't resistant to it for the duration. A target immune to acid damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 22 DEX save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Gold Dragon Wyrmling (CR 3)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 68
- **Speed** 30 ft., fly 60 ft., swim 30 ft.
- **Perception** 17
- **Stealth** 14
- **Immune** fire
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +4 |  +5 |  +2 |  +5 |  +4 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (1d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 15 - foot cone. Each creature in that area must make a DC 13 DEX save, taking 33 (6d10) fire damage on a failed save, or half as much damage on a successful one.
- **_Weakening Breath (Recharge 6)._** The dragon exhales weakening gas in a 15 - foot cone. Each creature in that area must succeed on a DC 13 STR save or have disadvantage on STR - based attack rolls, STR checks, and STR saves for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

#### Young Gold Dragon (CR 10)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 193
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 22
- **Stealth** 16
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +6 |  +9 |  +3 |  +8 |  +7 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Golden Splendor._** When the gold dragon hasn't unleashed its Fire Breath, its scales gleam and sparkle like molten gold or a pile of gold coins. While the dragon's Fire Breath is available, each creature that starts its turn within 10 feet of the dragon must succeed on a DC 17 CHA save or be charmed until the start of its next turn.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Weakening Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 30 - foot cone. Each creature in that area must make a DC 17 DEX save, taking 66 (12d10) fire damage on a failed save, or half as much damage on a successful one.
- **_Weakening Breath (Recharge 6)._** As the **gold dragon wyrmling**, except it is a 30 - foot cone, and the save DC is 17.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Adult Gold Dragon (CR 17)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 301
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 27
- **Stealth** 18
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +8 | +13 |  +4 | +11 | +10 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Golden Splendor._** As the **young gold dragon**, except it affects creatures within 20 feet of the dragon, and the save DC is 21.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Weakening Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 19 (2d10+8) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +14 to hit, reach 5 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +14 to hit, reach 15 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 18 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 60 - foot cone. Each creature in that area must make a DC 21 DEX save, taking 71 (13d10) fire damage on a failed save, or half as much damage on a successful one.
- **_Weakening Breath (Recharge 6)._** As the **gold dragon wyrmling**, except it is a 60 - foot cone, and the save DC is 21.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 18 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 22 DEX save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Gold Dragon (CR 21)

_Gargantuan Dragon_

- **Armor Class** 22 (natural armor)
- **Hit Points** 382
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 30
- **Stealth** 19
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +9 | +16 |  +5 | +13 | +12 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Golden Splendor._** As the **young gold dragon**, except it affects creatures within 30 feet of the dragon, and the save DC is 24.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Weakening Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +17 to hit, reach 15 ft., one target. _Hit:_ 21 (2d10+10) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +17 to hit, reach 10 ft., one target. _Hit:_ 17 (2d6+10) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +17 to hit, reach 20 ft., one target. _Hit:_ 19 (2d8+10) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 20 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 90 - foot cone. Each creature in that area must make a DC 24 DEX save, taking 110 (20d10) fire damage on a failed save, or half as much damage on a successful one.
- **_Weakening Breath (Recharge 6)._** As the **gold dragon wyrmling**, except it is a 90 - foot cone, and the save DC is 24.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 20 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 25 DEX save or take 17 (2d6+10) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Green Dragon Wyrmling (CR 2)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 51
- **Speed** 30 ft., fly 60 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 13
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +3 |  +3 |  +4 |  +2 |  +3 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 12 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (1d10+2) piercing damage plus 3 (1d6) poison damage.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Poison Breath (Recharge 5 - 6)._** The dragon exhales poisonous gas in a 15 - foot cone. Each creature in that area must make a DC 11 CON save, taking 21 (6d6) poison damage on a failed save, or half as much damage on a successful one.

#### Young Green Dragon (CR 8)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 148
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 17
- **Stealth** 14
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +4 |  +6 |  +5 |  +4 |  +5 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Hallucinogenic Gas._** After the green dragon exhales its Poison Breath, wisps of poisonous gas laced with the alchemical taint that permeates the dragon's body linger around it. While the dragon's Poison Breath is unavailable, each creature that starts its turn within 10 feet of the dragon must succeed on a DC 14 WIS save or be terrified, as the gas causes the creature to experience frightful hallucinations. A terrified creature is frightened, and its speed is reduced to 0.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage plus 7 (2d6) poison damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Poison Breath (Recharge 5 - 6)._** The dragon exhales poisonous gas in a 30 - foot cone. Each creature in that area must make a DC 14 CON save, taking 42 (12d6) poison damage on a failed save, or half as much damage on a successful one.

#### Adult Green Dragon (CR 15)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 255
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 22
- **Stealth** 16
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +6 | +10 |  +6 |  +7 |  +8 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Hallucinogenic Gas._** After the green dragon exhales its Poison Breath, wisps of poisonous gas laced with the alchemical taint that permeates the dragon's body linger around it. While the dragon's Poison Breath is unavailable, each creature that starts its turn within 20 feet of the dragon must succeed on a DC 18 WIS save or be terrified, as the gas causes the creature to experience frightful hallucinations. A terrified creature is frightened, and its speed is reduced to 0.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage plus 7 (2d6) poison damage.
- **_Claw._** _Melee Weapon Attack:_ +11 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +11 to hit, reach 15 ft., one target. _Hit:_ 15 (2d8+6) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 16 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Poison Breath (Recharge 5 - 6)._** The dragon exhales poisonous gas in a 60 - foot cone. Each creature in that area must make a DC 18 CON save, taking 56 (16d6) poison damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 16 CHA save or be vulnerable to poison damage until the end of its next turn. A target resistant to poison damage isn't resistant to it for the duration. A target immune to poison damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 19 DEX save or take 13 (2d6+6) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Green Dragon (CR 19)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 333
- **Speed** 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 25
- **Stealth** 17
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +7 | +13 |  +7 |  +9 | +10 |

- **_Amphibious._** The dragon can breathe air and water.
- **_Hallucinogenic Gas._** After the green dragon exhales its Poison Breath, wisps of poisonous gas laced with the alchemical taint that permeates the dragon's body linger around it. While the dragon's Poison Breath is unavailable, each creature that starts its turn within 30 feet of the dragon must succeed on a DC 21 WIS save or be terrified, as the gas causes the creature to experience frightful hallucinations. A terrified creature is frightened, and its speed is reduced to 0.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +15 to hit, reach 15 ft., one target. _Hit:_ 19 (2d10+8) piercing damage plus 10 (3d6) poison damage.
- **_Claw._** _Melee Weapon Attack:_ +15 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +15 to hit, reach 20 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 18 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Poison Breath (Recharge 5 - 6)._** The dragon exhales poisonous gas in a 90 - foot cone. Each creature in that area must make a DC 21 CON save, taking 84 (24d6) poison damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 18 CHA save or be vulnerable to poison damage until the end of its next turn. A target resistant to poison damage isn't resistant to it for the duration. A target immune to poison damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 22 DEX save or take 22 (4d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Red Dragon Wyrmling (CR 3)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 68
- **Speed** 30 ft., climb 30 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** fire
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +5 |  +1 |  +2 |  +4 |

- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (1d10+4) piercing damage plus 3 (1d6) fire damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 15foot cone. Each creature in that area must make a DC 13 DEX save, taking 28 (8d6) fire damage on a failed save, or half as much damage on a successful one.

#### Young Red Dragon (CR 10)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 193
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 18
- **Stealth** 14
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +4 |  +9 |  +2 |  +4 |  +8 |

- **_Boil Over._** When the red dragon hasn't unleashed its Fire Breath, the heat builds and rolls outward from it. While the dragon's Fire Breath is available, it emits immense heat, and each creature that starts its turn within 10 feet of the dragon must succeed on a DC 17 CON save or take 7 (2d6) fire damage.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage plus 3 (1d6) fire damage.
- **_Claw._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 30 - foot cone. Each creature in that area must make a DC 17 DEX save, taking 56 (16d6) fire damage on a failed save, or half as much damage on a successful one.

#### Adult Red Dragon (CR 17)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 301
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 23
- **Stealth** 16
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +6 | +13 |  +3 |  +7 | +11 |

- **_Boil Over._** When the red dragon hasn't unleashed its Fire Breath, the heat builds and rolls outward from it. While the dragon's Fire Breath is available, it emits immense heat, and each creature that starts its turn within 20 feet of the dragon must succeed on a DC 21 CON save or take 7 (2d6) fire damage. A creature that fails this save by 5 or more also suffers one level of exhaustion.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 19 (2d10+8) piercing damage plus 7 (2d6) fire damage.
- **_Claw._** _Melee Weapon Attack:_ +14 to hit, reach 5 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +14 to hit, reach 15 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 19 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 60 - foot cone. Each creature in that area must make a DC 21 DEX save, taking 63 (18d6) fire damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 19 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 22 DEX save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Red Dragon (CR 21)

_Gargantuan Dragon_

- **Armor Class** 22 (natural armor)
- **Hit Points** 382
- **Speed** 40 ft., climb 40 ft., fly 80 ft.
- **Perception** 26
- **Stealth** 17
- **Immune** fire
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +7 | +16 |  +4 |  +9 | +13 |

- **_Boil Over._** When the red dragon hasn't unleashed its Fire Breath, the heat builds and rolls outward from it. While the dragon's Fire Breath is available, it emits immense heat, and each creature that starts its turn within 30 feet of the dragon must succeed on a DC 24 CON save or take 7 (2d6) fire damage. A creature that fails this save by 5 or more also suffers one level of exhaustion.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +17 to hit, reach 15 ft., one target. _Hit:_ 21 (2d10+10) piercing damage plus 14 (4d6) fire damage.
- **_Claw._** _Melee Weapon Attack:_ +17 to hit, reach 10 ft., one target. _Hit:_ 17 (2d6+10) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +17 to hit, reach 20 ft., one target. _Hit:_ 19 (2d8+10) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 21 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Fire Breath (Recharge 5 - 6)._** The dragon exhales fire in a 90 - foot cone. Each creature in that area must make a DC 24 DEX save, taking 105 (30d6) fire damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 21 CHA save or be vulnerable to fire damage until the end of its next turn. A target resistant to fire damage isn't resistant to it for the duration. A target immune to fire damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 25 DEX save or take 17 (2d6+10) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

**Lair Actions**

On initiative count 20 (losing initiative ties), the dragon can take a lair action to cause one of the following effects; the dragon can't use the same effect two rounds in a row:

- **Collapse.** The ceiling on a point the dragon can see within 120 feet of it collapses, covering a 20 - foot square area on the ground directly below that point. Each creature in that area must succeed on a DC 15 DEX save or be knocked prone and buried under the rubble. A buried creature is restrained and unable to breathe or stand up. A creature, including the buried creature, can take its action to free the buried creature by succeeding on a DC 15 STR check while within reach of the buried creature.
- **Swirling Ash.** Searing ash blasts a point the dragon can see within 120 feet of it. Each creature within 30 feet of that point must make a DC 15 CON save. On a failure, a creature takes 10 (3d6) fire damage and is blinded until the end of its next turn. On a success, a creature takes half the damage and isn't blinded. The ash ignites flammable objects within 30 feet of that point that aren't being worn or carried.
- **Conflagrate.** One creature the dragon can see within 120 feet of it becomes tethered to the Elemental Plane of Fire. The target must succeed on a DC 15 CHA save or be burned for 1 minute. While burned, the target takes 7 (2d6) fire damage at the start of each of its turns. The effect ends early if the target takes cold damage, is submerged in water, or the burn is removed with a greater restoration spell or similar magic.

**Regional Effects**

The region containing a red dragon's lair is suffused with fiery chaos, which creates one or more of the following effects:

- **Acid Rain.** Within 10 miles of the red dragon's lair, precipitation is oily and stinks of sulfur. Snow in the area may be gray or black as it falls, appearing like ash, though its temperature is unchanged.
- **Incited Rage.** Creatures within 3 miles of the red dragon's lair are quick to anger and slow to forgive. Such creatures have disadvantage on CHA checks, except CHA (Intimidation), and Beasts in the area that aren't domesticated are more aggressive than normal.
- **Unnatural Heat.** Within 1 mile of the red dragon's lair, temperatures are unnaturally high. Vegetation in the area withers and eventually crumbles to dust. Creatures in the area require twice as much water as normal each day to survive, and each creature in the area must succeed on a DC 10 CON save every hour it remains in the area or suffer one level of exhaustion. Creatures that are resistant or immune to fire damage are unaffected by this regional effect.

  If the dragon dies, these effects fade in 1d10 days.

#### Silver Dragon Wyrmling (CR 2)

_Medium Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 51
- **Speed** 30 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** cold
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +5 |  +1 |  +2 |  +4 |

- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (1d10+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 15 - foot cone. Each creature in that area must make a DC 13 CON save, taking 18 (4d8) cold damage on a failed save, or half as much damage on a successful one.
- **_Paralyzing Breath (Recharge 6)._** The dragon exhales paralyzing gas in a 15 - foot cone. Each creature in that area must succeed on a DC 13 CON save or be paralyzed for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

#### Young Silver Dragon (CR 9)

_Large Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 175
- **Speed** 40 ft., fly 80 ft.
- **Perception** 19
- **Stealth** 14
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +4 |  +9 |  +2 |  +5 |  +7 |

- **_Freezing Fog._** After the silver dragon uses its Cold Breath, freezing fog surrounds it. While the dragon's Cold Breath is unavailable, each creature that starts its turn within 10 feet of the dragon must succeed on a DC 17 CON save or be restrained until the start of its next turn.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Paralyzing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +10 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 30 - foot cone. Each creature in that area must make a DC 17 CON save, taking 54 (12d8) cold damage on a failed save, or half as much damage on a successful one.
- **_Paralyzing Breath (Recharge 6)._** As the **silver dragon wyrmling**, except it is a 30 - foot cone, and the save DC is 17.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

#### Adult Silver Dragon (CR 16)

_Huge Dragon_

- **Armor Class** 19 (natural armor)
- **Hit Points** 267
- **Speed** 40 ft., fly 80 ft.
- **Perception** 22
- **Stealth** 15
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +5 | +12 |  +3 |  +7 |  +9 |

- **_Freezing Fog._** As the **young silver dragon**, except it affects creatures within 20 feet of the dragon, and the save DC is 20.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Paralyzing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +13 to hit, reach 10 ft., one target. _Hit:_ 19 (2d10+8) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +13 to hit, reach 5 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +13 to hit, reach 15 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 17 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 60 - foot cone. Each creature in that area must make a DC 20 CON save, taking 58 (13d8) cold damage on a failed save, or half as much damage on a successful one.
- **_Paralyzing Breath (Recharge 6)._** As the **silver dragon wyrmling**, except it is a 60 - foot cone, and the save DC is 20.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 17 CHA save or be vulnerable to cold damage until the end of its next turn. A target resistant to cold damage isn't resistant to it for the duration. A target immune to cold damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 21 Dexterity save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient Silver Dragon (CR 20)

_Gargantuan Dragon_

- **Armor Class** 21 (natural armor)
- **Hit Points** 355
- **Speed** 40 ft., fly 80 ft.
- **Perception** 25
- **Stealth** 16
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +6 | +15 |  +4 |  +9 | +11 |

- **_Freezing Fog._** As the **young silver dragon**, except it affects creatures within 30 feet of the dragon, and the save DC is 23.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks. It can replace its Bite attack with a use of Paralyzing Breath, if available.
- **_Bite._** _Melee Weapon Attack:_ +17 to hit, reach 15 ft., one target. _Hit:_ 21 (2d10+10) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +17 to hit, reach 10 ft., one target. _Hit:_ 17 (2d6+10) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +17 to hit, reach 20 ft., one target. _Hit:_ 19 (2d8+10) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 19 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 90 - foot cone. Each creature in that area must make a DC 23 CON save, taking 99 (22d8) cold damage on a failed save, or half as much damage on a successful one.
- **_Paralyzing Breath (Recharge 6)._** As the **silver dragon wyrmling**, except it is a 90 - foot cone, and the save DC is 23.

**Bonus Actions**

- **_Change Shape._** The dragon magically transforms into a Beast or Humanoid that has a challenge rating no higher than its own, or back into its true form, which is Dragon. Any equipment it is wearing or carrying transforms with it or is borne by the new form (the dragon's choice). It reverts to its true form if it dies. In a new form, the dragon retains its Legendary Resistance trait and its HP, ability to speak, proficiencies, and INT, WIS, and CHA scores, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 19 CHA save or be vulnerable to cold damage until the end of its next turn. A target resistant to cold damage isn't resistant to it for the duration. A target immune to cold damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 24 DEX save or take 17 (2d6+10) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### White Dragon Wyrmling (CR 2)

_Medium Dragon_

- **Armor Class** 16 (natural armor)
- **Hit Points** 54
- **Speed** 30 ft., burrow 15 ft., fly 60 ft., swim 30 ft.
- **Perception** 14
- **Stealth** 12
- **Immune** cold
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +4 |  -3 |  +2 |  +2 |

- **_Ice Walk._** The dragon can move across and climb icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn't cost it extra movement.
- **_Pounce._** If the dragon moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 12 STR save or be knocked prone. If the target is prone, the dragon can make one Claw attack against it as a bonus action.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and one Claw attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (1d10+2) piercing damage plus 2 (1d4) cold damage.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 15 - foot cone. Each creature in that area must make a DC 12 CON save, taking 22 (5d8) cold damage on a failed save, or half as much damage on a successful one.

#### Young White Dragon (CR 6)

_Large Dragon_

- **Armor Class** 17 (natural armor)
- **Hit Points** 126
- **Speed** 40 ft., burrow 20 ft., fly 80 ft., swim 40 ft.
- **Perception** 17
- **Stealth** 13
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +7 |  -2 |  +4 |  +4 |

- **_Ice Walk._** The dragon can move across and climb icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn’t cost it extra movement.
- **_Numbing Chill._** When the white dragon hasn’t unleashed its Cold Breath, the cold builds up within it and ripples outward from it. While the dragon’s Cold Breath is available, it emits a numbing chill, and each creature that starts its turn within 10 feet of the dragon must succeed on a DC 15 CON save or its speed is reduced by 10 feet.

**Actions**

- **_Multiattack._** The dragon makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) piercing damage plus 4 (1d8) cold damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 30 - foot cone. Each creature in that area must make a DC 15 CON save, taking 31 (7d8) cold damage on a failed save, or half as much damage on a successful one.

#### Adult White Dragon (CR 13)

_Huge Dragon_

- **Armor Class** 18 (natural armor)
- **Hit Points** 238
- **Speed** 40 ft., burrow 30 ft., fly 80 ft., swim 40 ft.
- **Perception** 22
- **Stealth** 15
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +5 | +11 |  -1 |  +7 |  +7 |

- **_Ice Walk._** The dragon can move across and climb icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn't cost it extra movement.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Numbing Chill._** When the white dragon hasn't unleashed its Cold Breath, the cold builds up within it and ripples outward from it. While the dragon's Cold Breath is available, it emits a numbing chill, and each creature that starts its turn within 20 feet of the dragon must succeed on a DC 19 CON save or its speed is reduced by 15 feet.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 17 (2d10+6) piercing damage plus 4 (1d8) cold damage.
- **_Claw._** _Melee Weapon Attack:_ +11 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +11 to hit, reach 15 ft., one target. _Hit:_ 15 (2d8+6) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 15 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 60 - foot cone. Each creature in that area must make a DC 19 CON save, taking 45 (10d8) cold damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 15 CHA save or be vulnerable to cold damage until the end of its next turn. A target resistant to cold damage isn't resistant to it for the duration. A target immune to cold damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 10 feet of the dragon must succeed on a DC 19 DEX save or take 13 (2d6+6) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Ancient White Dragon (CR 17)

_Gargantuan Dragon_

- **Armor Class** 20 (natural armor)
- **Hit Points** 301
- **Speed** 40 ft., burrow 40 ft., fly 80 ft., swim 40 ft.
- **Perception** 25
- **Stealth** 16
- **Immune** cold
- **Senses** darkvision 120 ft., keensense 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +6 | +14 |  +0 |  +9 |  +9 |

- **_Ice Walk._** The dragon can move across and climb icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn't cost it extra movement.
- **_Legendary Resistance (3/Day)._** If the dragon fails a save, it can choose to succeed instead.
- **_Numbing Chill._** When the white dragon hasn't unleashed its Cold Breath, the cold builds up within it and ripples outward from it. While the dragon's Cold Breath is available, it emits a numbing chill, and each creature that starts its turn within 30 feet of the dragon must succeed on a DC 22 CON save or its speed is halved.

**Actions**

- **_Multiattack._** The dragon uses its Frightful Presence. It then makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 15 ft., one target. _Hit:_ 19 (2d10+8) piercing damage plus 9 (2d8) cold damage.
- **_Claw._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 15 (2d6+8) slashing damage.
- **_Tail._** _Melee Weapon Attack:_ +14 to hit, reach 20 ft., one target. _Hit:_ 17 (2d8+8) bludgeoning damage.
- **_Frightful Presence._** Each creature of the dragon's choice that is within 120 feet of the dragon and aware of it must succeed on a DC 17 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the dragon's Frightful Presence for the next 24 hours.
- **_Cold Breath (Recharge 5 - 6)._** The dragon exhales an icy blast in a 90 - foot cone. Each creature in that area must make a DC 22 CON save, taking 63 (14d8) cold damage on a failed save, or half as much damage on a successful one.

**Legendary Actions**

The dragon can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The dragon regains spent legendary actions at the start of its turn.

- **_Detect._** The dragon automatically detects every creature and trap within 30 feet of it, pinpointing the current location of each.
- **_Tail Attack._** The dragon makes a Tail attack.
- **_Elemental Roar (Costs 2 Actions)._** The Dragon Roars At Up To Two creatures of its choice within 120 feet of it. Each target must succeed on a DC 17 CHA save or be vulnerable to cold damage until the end of its next turn. A target resistant to cold damage isn't resistant to it for the duration. A target immune to cold damage is still immune to it, even if the target fails the save.
- **_Wing Attack (Costs 2 Actions)._** The Dragon Beats Its Wings. Each creature within 15 feet of the dragon must succeed on a DC 22 DEX save or take 15 (2d6+8) bludgeoning damage and be knocked prone. The dragon can then fly up to half its flying speed without provoking opportunity attacks.

#### Pseudodragon (CR 1/4)

_Tiny Dragon_

- **Armor Class** 13 (natural armor)
- **Hit Points** 12
- **Speed** 15 ft., fly 60 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** poison | poisoned
- **Senses** darkvision 60 ft., keensense 10 ft.
- **Languages** understands Common and Draconic but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +2 |  +1 |  +0 |  +3 |  +0 |

- **_Heightened Senses._** The pseudodragon's Perception is 18 when perceiving by sight, hearing, or smell.
- **_Magic Resistance._** The pseudodragon has advantage on saves against spells and other magical effects.
- **_Limited Telepathy._** The pseudodragon can magically communicate simple ideas, emotions, and images telepathically with any creature within 100 feet of it that can understand a language.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) piercing damage.
- **_Sting._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 4 (1d4+2) piercing damage plus 2 (1d4) poison damage, and the target must succeed on a DC 11 CON save or be poisoned for 1 hour. If the creature fails the save by 5 or more, it falls unconscious while poisoned in this way, or until it takes damage or another creature uses an action to shake it awake.
- **_Puff of Smoke (1/Day)._** The pseudodragon exhales a cloud of smoke in a 10 - foot - radius sphere centered on itself. The sphere spreads around corners, and its area is heavily obscured. It lasts for 1 minute or until a wind of moderate or greater speed (at least 10 miles per hour) disperses it.

#### Scorch Drake (CR 6)

_Large Dragon_

- **Armor Class** 15 (natural armor)
- **Hit Points** 145
- **Speed** 40 ft., fly 60 ft.
- **Perception** 15
- **Stealth** 11
- **Vulnerable** cold
- **Immune** fire
- **Senses** darkvision 60 ft.
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +4 |  -2 |  +5 |  -1 |

- **_Heat Shimmer._** Creatures more than 30 feet from the scorch drake have disadvantage on WIS (Perception) checks to see the drake.
- **_Scalding Blood._** A creature that hits the scorch drake with a melee attack while within 5 feet of the drake takes 3 (1d6) fire damage and must succeed on a DC 15 DEX save or ignite. Until a creature takes an action to douse the fire, an ignited creature takes 3 (1d6) fire damage at the start of each of its turns.

**Actions**

- **_Multiattack._** The scorch drake makes one Bite and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing and 3 (1d6) fire damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing and 3 (1d6) fire damage.
- **_Fire Breath (Recharge 5 - 6)._** The scorch drake spits liquid fire in a 30 - foot cone. Each creature in that area must make a DC 15 DEX save. On a failure, a creature takes 24 (7d6) fire damage and ignites. On a success, a creature takes half the damage and doesn't ignite. Until a creature takes an action to douse the fire, an ignited creature takes 3 (1d6) fire damage at the start of each of its turns. This fire ignites flammable objects in the line that aren't being worn or carried.

**Bonus Actions**

- **_Fan the Flames._** The scorch drake flaps its wings in the direction of one ignited creature it can see within 15 feet of it. The flames coating the target flare up and generate excess smoke. The target must succeed on a DC 15 CON save or be blinded until the end of its next turn.

### Drider (CR 6)

_Large Monstrosity_

- **Armor Class** 18 (natural armor)
- **Hit Points** 112
- **Speed** 30 ft., climb 30 ft.
- **Perception** 15
- **Stealth** 19
- **Resistant** Fey Ancestry, Monstrosity Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft.
- **Languages** Elvish, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +6 |  +4 |  +1 |  +2 |  +1 |

- **_Fey Ancestry._** The drider is resistant to the charmed condition, and magic can't put the drider to sleep.
- **_Monstrosity Resilience._** The drider is resistant to exhaustion and to the frightened condition.
- **_Spider Climb._** The drider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Sunlight Sensitivity._** While in sunlight, the drider has disadvantage on attack rolls, and its Perception is 10 when perceiving by sight.
- **_Web Sense._** While in contact with a web, the drider knows the exact location of any other creature in contact with the same web.
- **_Web Walker._** The drider ignores movement restrictions caused by webbing.

**Actions**

- **_Multiattack._** The drider makes one Longsword attack and two Skewer attacks, or it makes three Web Shot attacks.
- **_Longsword._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) slashing damage, or 8 (1d10+3) slashing damage if used with two hands.
- **_Skewer._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d6+3) piercing damage plus 13 (3d8) poison damage.
- **_Web Shot._** _Ranged Weapon Attack:_ +6 to hit, range 30/60 ft., one target. _Hit:_ 14 (2d10+3) bludgeoning damage, and the target must succeed on a DC 15 STR save or be restrained by webbing. A creature, including the restrained target, can take its action to break the webbing and free the restrained target by succeeding on a DC 15 STR check.

### Dryad (CR 1)

_Medium Fey_

- **Armor Class** 15 (natural armor)
- **Hit Points** 38
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 15
- **Resistant** Fey Resilience
- **Senses** darkvision 60 ft.
- **Languages** Elvish, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +0 |  +2 |  +4 |  +4 |

- **_Fey Resilience._** The dryad is resistant to the charmed and unconscious conditions.
- **_Magic Resistance._** The dryad has advantage on saves against spells and other magical effects.
- **_One with the Forest._** While in a forest, the dryad can't be surprised, and it leaves behind no tracks or other traces of its passage.
- **_Speak with Beasts and Plants._** The dryad can communicate with Beasts and Plants as if they shared a language.
- **_Tree Stride._** Once on its turn, the dryad can use 10 feet of its movement to step magically into one living tree within its reach and emerge from a second living tree within 60 feet of the first tree, appearing in an unoccupied space within 5 feet of the second tree. Both trees must be Large or larger.

**Actions**

- **_Multiattack._** The dryad makes two Vine Whip or Blast of Pollen attacks. If both Vine Whip attacks hit one creature, the target must succeed on a DC 14 STR save or be restrained by vines until the end of its next turn.
- **_Vine Whip._** _Melee Weapon Attack:_ +4 to hit, reach 10 ft., one target. _Hit:_ 6 (1d8+2) slashing damage.
- **_Blast of Pollen._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 7 (1d6+4) poison damage.

**Bonus Actions**

- **_Charming Scent._** The dryad emits an alluring, floral scent toward one Beast or Humanoid it can see within 30 feet of it. The target must succeed on a DC 14 WIS save or be charmed for 1 minute. While charmed, the target views the dryad as an ally and views the dryad's requests favorably, though it isn't under the dryad's control. The charmed creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. The dryad can have up to two creatures charmed in this way at a time.
- **_Forest's Aid (21 HP or Fewer, 1/Day)._** The dryad magically calls a horde of squirrels, rabbits, mice, and other small animals native to the forest. The horde uses the statistics of 1 swarm of rats. The called creatures arrive on initiative count 20 of the next round, acting as allies of the dryad and obeying its spoken commands. They remain for 1 hour, until the dryad dies, or until the dryad dismisses them as a bonus action.

### Duergar (CR 1)

_Medium Humanoid_

- **Armor Class** 16 (scale mail, shield)
- **Hit Points** 32
- **Speed** 25 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** poison | poisoned | Duergar Resilience
- **Senses** darkvision 120 ft.
- **Languages** Dwarvish, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +2 |  +0 |  +0 |  -1 |

- **_Duergar Resilience._** The duergar is resistant to the charmed and paralyzed conditions, and it has advantage on saves against spells and illusions.
- **_Reduce._** If the duergar starts its turn enlarged, it can choose to end the effect and return to its normal size (no action required).
- **_Sunlight Sensitivity._** While in sunlight, the duergar has disadvantage on attack rolls, and its Perception is 5 when perceiving by sight.

**Actions**

- **_War Pick._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) piercing damage, or 11 (2d8+2) piercing damage while enlarged.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 5 (1d6+2) piercing damage, or 9 (2d6+2) piercing damage while enlarged.
- **_Invisibility._** The duergar magically turns invisible until it attacks or uses Enlarge, or until its concentration ends (as if concentrating on a spell). Any equipment the duergar wears or carries is invisible with it.

**Bonus Actions**

- **_Enlarge._** The duergar magically increases in size, along with any equipment it is wearing or carrying. While enlarged, the duergar is Large, doubles its damage dice on weapon attacks (included in the attacks), and makes STR checks and saves with advantage. While enlarged, it also can no longer use the Invisibility action. If the duergar lacks the room to become Large, this bonus action fails.

**Reactions**

- **_Shield Wall._** The duergar adds 2 to its AC against one weapon attack that would hit it. To do so, the duergar must be wielding a shield and within 5 feet of another duergar that is also wielding a shield.

### Elementals

#### Air Elemental (CR 5)

_Large Elemental_

- **Armor Class** 15
- **Hit Points** 94
- **Speed** 0 ft., fly 90 ft. (hover)
- **Perception** 13
- **Stealth** 15
- **Resistant** thunder | Elemental Resilience
- **Immune** lightning | Elemental Resilience
- **Senses** darkvision 60 ft.
- **Languages** Auran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +5 |  +2 |  -2 |  +0 |  -2 |

- **_Air Form._** The elemental can enter a hostile creature's space and stop there. It can move through a space as narrow as 1 inch wide without squeezing.
- **_Cloud Camouflage._** The elemental's Stealth is 20 while in clouds, fog, or windy weather.
- **_Elemental Nature._** The elemental doesn't require air, food, drink, or sleep.
- **_Elemental Resilience._** The elemental is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to poison damage, to exhaustion, and to the grappled, paralyzed, petrified, poisoned, prone, restrained, and unconscious conditions.

**Actions**

- **_Multiattack._** The elemental makes two Wind Lash or Lightning Bolt attacks.
- **_Wind Lash._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 18 (3d8+5) bludgeoning damage.
- **_Lightning Bolt._** _Ranged Weapon Attack:_ +8 to hit, range 30/120 ft., one target. _Hit:_ 18 (3d8+5) lightning damage.
- **_Whirlwind (Recharge 4 - 6)._** Each creature in the elemental's space must make a DC 13 STR save. On a failure, a target takes 18 (3d8+5) bludgeoning damage and is flung up 20 feet away from the elemental in a random direction and knocked prone. If a thrown target strikes an object, such as a wall or floor, the target takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target is thrown at another creature, that creature must succeed on a DC 13 DEX save or take the same damage and be knocked prone. If the save is successful, the target takes half the bludgeoning damage and isn't flung away or knocked prone.

**Reactions**

- **_Thunderous Retreat._** When a creature the air elemental can see deals damage to it, the elemental can expel a crack of thunder and move up to 15 feet to an unoccupied space it can see. Each creature within 5 feet of the space the elemental left must succeed on a DC 13 CON save or take 7 (2d6) thunder damage.

#### Earth Elemental (CR 5)

_Large Elemental_

- **Armor Class** 17 (natural armor)
- **Hit Points** 114
- **Speed** 30 ft., burrow 30 ft.
- **Perception** 13
- **Stealth** 9
- **Vulnerable** thunder
- **Resistant** Elemental Resilience
- **Immune** lightning | Elemental Resilience
- **Senses** darkvision 60 ft., tremorsense 60 ft.
- **Languages** Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +5 |  -2 |  +0 |  -3 |

- **_Earth Glide._** The elemental can burrow through nonmagical, unworked earth and stone. While doing so, the elemental doesn't disturb the material through which it moves.
- **_Earthen Camouflage._** The elemental's Stealth is 14 while in muddy, rocky, sandy, or stony terrain.
- **_Elemental Nature._** The elemental doesn't require air, food, drink, or sleep.
- **_Elemental Resilience._** The elemental is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to poison damage, to exhaustion, and to the paralyzed, petrified, poisoned, and unconscious conditions.
- **_Siege Monster._** The elemental deals double damage to objects and structures.

**Actions**

- **_Multiattack._** The elemental makes three Slam attacks, or it makes two Lob Stone attacks. If two Slam or Lob Stone attacks hit one creature, the target must succeed on a DC 16 STR save or be knocked prone.
- **_Slam._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 14 (2d8+5) bludgeoning damage.
- **_Lob Stone._** _Ranged Weapon Attack:_ +8 to hit, range 20/60 ft., one target. _Hit:_ 21 (3d10+5) bludgeoning damage.

**Bonus Actions**

- **_Earth Tremor (Recharge 4 - 6)._** The earth elemental causes the ground on a point it can see within 30 feet of it to rumble and shake violently. Each creature within 10 feet of that point must succeed on a DC 16 DEX save or be knocked prone.

#### Fire Elemental (CR 5)

_Large Elemental_

- **Armor Class** 13
- **Hit Points** 110
- **Speed** 50 ft.
- **Perception** 10
- **Stealth** 13
- **Resistant** Elemental Resilience
- **Immune** fire | Elemental Resilience
- **Senses** darkvision 60 ft.
- **Languages** Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +3 |  -2 |  +0 |  -2 |

- **_Elemental Nature._** The fire elemental doesn't require air, food, drink, or sleep.
- **_Elemental Resilience._** The fire elemental is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to poison damage, to exhaustion, and to the grappled, paralyzed, petrified, poisoned, prone, restrained, and unconscious conditions.
- **_Fire Camouflage._** The fire elemental's Stealth is 18 while in a Medium or larger fire.
- **_Fire Form._** The elemental can move through a space as narrow as 1 inch wide without squeezing. A creature that touches the elemental or hits it with a melee attack while within 5 feet of it takes 5 (1d10) fire damage. In addition, the elemental can enter a hostile creature's space and stop there. The first time it enters a creature's space on a turn, that creature must succeed on a DC 14 DEX save or take 5 (1d10) fire damage and catch fire; until a creature takes an action to douse the fire, the burning creature takes 5 (1d10) fire damage at the start of each of its turns.
- **_Illumination._** The elemental sheds bright light in a 30 - foot radius and dim light for an additional 30 feet.
- **_Water Susceptibility._** For every 5 feet the elemental moves in water, or for every gallon of water splashed on it, it takes 1 cold damage.

**Actions**

- **_Multiattack._** The elemental makes two Fiery Touch or Spit Fire attacks.
- **_Fiery Touch._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) fire damage. If the target is a creature or a flammable object, it ignites. Until a creature takes an action to douse the fire, the target takes 5 (1d10) fire damage at the start of each of its turns.
- **_Spit Fire._** _Ranged Weapon Attack:_ +6 to hit, range 30/120 ft., one target. _Hit:_ 16 (3d8+3) fire damage.

**Bonus Actions**

- **_Fiery Dash (Recharge 4 - 6)._** The elemental moves up to 20 feet in a straight line and can move through the space of any Large or smaller creature without provoking opportunity attacks. Each space along that line catches fire until the start of the elemental's next turn. A creature that enters a burning space for the first time on a turn or starts its turn there must succeed on a DC 14 DEX save or take 5 (1d10) fire damage.

#### Water Elemental (CR 5)

_Large Elemental_

- **Armor Class** 14 (natural armor)
- **Hit Points** 104
- **Speed** 30 ft., swim 90 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** Elemental Resilience
- **Immune** acid | Elemental Resilience
- **Senses** darkvision 60 ft.
- **Languages** Aquan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +4 |  -2 |  +0 |  -1 |

- **_Elemental Nature._** The elemental doesn't require air, food, drink, or sleep.
- **_Elemental Resilience._** The elemental is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to poison damage, to exhaustion, and to the grappled, paralyzed, petrified, poisoned, prone, restrained, and unconscious conditions.
- **_Freeze._** If the elemental takes cold damage, it partially freezes, and its speed is reduced by 20 feet until the end of its next turn.
- **_Purify Water._** If the water elemental sits in a body of slow - flowing or standing water, such as a spring, small creek, or lake, for at least 1 hour, the water becomes purified and rendered free of poison and disease. In slow - flowing water, this purification fades 1 hour after the elemental leaves the water. In standing water, this purification lasts until a contaminant enters the water while the elemental isn't in it.
- **_Water Form._** The elemental can enter a hostile creature's space and stop there. It can move through a space as narrow as 1 inch wide without squeezing.
- **_Water Camouflage._** The water elemental's Stealth is 17 while in a Medium or larger body of water.

**Actions**

- **_Multiattack._** The water elemental makes two Water Tendril or Water Bolt attacks. If both Water Tendril attacks hit one creature, it can use Whelm on the target, if available.
- **_Water Tendril._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 17 (3d8+4) bludgeoning damage, and the target is grappled (escape DC 15) if it is Large or smaller. The water elemental can have up to three targets grappled at a time.
- **_Water Bolt._** _Ranged Weapon Attack:_ +5 to hit, range 30/120 ft., one target. _Hit:_ 16 (4d6+2) bludgeoning damage.
- **_Whelm (Recharge 4 - 6)._** The water elemental envelops one creature it is grappling, and the grapple ends. While enveloped, the target is restrained, unable to breathe unless it can breathe water, can't be hit by the elemental's Water Tendril, and it takes 9 (2d8) bludgeoning damage at the start of each of the elemental's turns.

  When the elemental moves, the enveloped creature moves with it. The elemental can have only one creature enveloped at a time. A creature within 5 feet of the elemental, including the target, can take its action to free the target from the elemental by succeeding on a DC 15 STR check.

**Bonus Actions**

- **_Purify Blood (3/Day)._** The water elemental touches a willing creature that isn't a Construct or Undead. The target is cured of the poisoned condition and of any disease afflicting it.

### Elf

#### Drow (CR 1/4)

_Medium Humanoid_

- **Armor Class** 15 (chain shirt)
- **Hit Points** 12
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 14
- **Resistant** Fey Ancestry
- **Senses** darkvision 120 ft.
- **Languages** Elvish, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +0 |  +0 |  +0 |  +1 |

- **_Fey Ancestry._** The drow is resistant to the charmed condition, and magic can't put the drow to sleep.
- **_Sunlight Sensitivity._** While in sunlight, the drow has disadvantage on attack rolls, and its Perception is 7 when perceiving by sight.

**Actions**

- **_Shortsword._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Hand Crossbow._** _Ranged Weapon Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Bonus Actions**

- **_Poison Weapon._** The drow coats one weapon it is wearing or carrying in one of the following poisons. Each time the drow hits a creature with that weapon, the target must succeed on a DC 11 CON save or be poisoned for 1 minute and suffer the chosen poison's effect while poisoned in this way. The poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. The poison remains on the weapon until the start of the drow's next turn.
  - **Beetle's Bite.** The target's speed is halved while poisoned.
  - **Dark Caress.** The target is blinded while poisoned.
  - **Nightmare's Kiss.** The target is frightened of the drow while poisoned.
  - **Slumber's Call.** The target falls unconscious while poisoned or until it takes damage or another creature uses an action to wake it.

### Ettercap (CR 2)

_Medium Monstrosity_

- **Armor Class** 13
- **Hit Points** 54
- **Speed** 30 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +1 |  -3 |  +3 |  -1 |

- **_Monstrosity Resilience._** The ettercap is resistant to exhaustion and to the frightened condition.
- **_Spider Climb._** The ettercap can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Web Sense._** While in contact with a web, the ettercap knows the exact location of any other creature in contact with the same web.
- **_Web Walker._** The ettercap ignores movement restrictions caused by webbing.

**Actions**

- **_Multiattack._** The ettercap makes one Bite attack and one Claws attack, or it makes two Spit Poison attacks.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d8+3) piercing damage plus 4 (1d8) poison damage. The target must succeed on a DC 13 CON save or be poisoned for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.
- **_Spit Poison._** _Ranged Weapon Attack:_ +5 to hit, range 20/60 ft., one target. _Hit:_ 11 (2d8+3) poison damage.

**Bonus Actions**

- **_Web (Recharge 4 - 6)._** The ettercap launches a gob of webbing at one creature it can see within 30 feet of it. The target must succeed on a DC 13 DEX save or be restrained. A creature, including the restrained target, can take its action to free the target from the webbing by succeeding on a DC 13 STR check. The webbing can also be attacked and destroyed (AC 10; HP 5; vulnerability to fire damage; immunity to bludgeoning, poison, and psychic damage).

### Ettin (CR 4)

_Large Giant_

- **Armor Class** 12 (natural armor)
- **Hit Points** 95
- **Speed** 40 ft.
- **Perception** 14
- **Stealth** 9
- **Vulnerable** Giant Attributes
- **Resistant** Giant Attributes, Multiple Heads
- **Senses** darkvision 60 ft.
- **Languages** Giant, Orc

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +3 |  -2 |  +0 |  -1 |

- **_Giant Attributes._** The ettin is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Multiple Heads._** The ettin has two heads and is resistant to the blinded, charmed, deafened, frightened, stunned, and unconscious conditions.
- **_Obstinate._** The ettin has advantage on WIS and CHA saves.
- **_Wakeful._** When one of the ettin's heads is asleep, its other head is awake.

**Actions**

- **_Multiattack._** The ettin makes one Knobbed Club attack and one Spiked Club attack.
- **_Knobbed Club._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 18 (3d8+5) bludgeoning damage, and the target must succeed on a DC 15 STR save or be incapacitated until the end of its next turn, as the blow knocks the wind out of the target. This weapon is wielded by the right head.
- **_Spiked Club._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 18 (3d8+5) piercing damage, and the target must succeed on a DC 15 CON save or be poisoned for 1 minute, as bits of rotten meat clinging to the club's spikes coat the target's wound. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success. This weapon is wielded by the left head.

**Bonus Actions**

- **_That One!_** One of the ettin's heads picks a creature the ettin can see within 30 feet of it, gaining advantage on its next attack against that creature. The other head doesn't like being told what to do and has disadvantage on its next attack against that creature. Each weapon attack notes which head controls that weapon.

### Feral Hunter (CR 3)

_Medium Fey_

- **Armor Class** 14 (leather armor)
- **Hit Points** 83
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 15
- **Vulnerable** necrotic
- **Resistant** frightened | Fey Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +0 |  +0 |  +2 |  +1 |

- **_Fey Resilience._** The feral hunter is resistant to the charmed and unconscious conditions.
- **_Heightened Senses._** The feral hunter's Perception is 19 when perceiving by sight, hearing, or smell.
- **_Precise._** A weapon that deals piercing damage deals one extra die of its damage when the feral hunter hits with it (included in the attack).
- **_Woodland Walk._** Difficult terrain composed of nonmagical plants doesn't cost the feral hunter extra movement. In addition, the feral hunter can pass through nonmagical plants without being slowed by them and without taking damage from them if they have thorns, spines, or a similar hazard.

**Actions**

- **_Multiattack._** The feral hunter makes two Hunting Knife or Longbow attacks.
- **_Hunting Knife._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage.
- **_Longbow._** _Ranged Weapon Attack:_ +5 to hit, range 150/600 ft., one target. _Hit:_ 12 (2d8+3) piercing damage.

**Bonus Actions**

- **_Mark Quarry._** The feral hunter marks one creature it can see within 30 feet of it as its quarry until the start of the feral hunter's next turn. When the feral hunter hits the marked creature with a weapon attack, the weapon deals an extra 1d6 damage of the weapon's type to the target.

**Reactions**

- **_Reposition._** When the feral hunter takes damage, it can move up to 10 feet without provoking opportunity attacks.

### Flinderbeast (CR 1)

_Small Fey_

- **Armor Class** 14
- **Hit Points** 38
- **Speed** 30 ft., climb 20 ft.
- **Perception** 13
- **Stealth** 16
- **Resistant** acid | Fey Resilience
- **Senses** darkvision 60 ft.
- **Languages** Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +4 |  +0 |  -2 |  +1 |  +3 |

- **_Fey Resilience._** The flinderbeast is resistant to the charmed and unconscious conditions.
- **_Heightened Hearing and Smell._** The flinderbeast's Perception 18 when perceiving by hearing or smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) piercing damage plus 3 (1d6) acid damage.
- **_Acid Spit._** _Ranged Weapon Attack:_ +6 to hit, range 20/60 ft., one target. _Hit:_ 11 (2d6+4) acid damage.
- **_Breath of Flinders (Recharge 5 - 6)._** The flinderbeast exhales splinters in a 15 - foot cone. Each creature in that area must make a DC 14 DEX save, taking 18 (4d8) piercing damage on a failed save, or half as much damage on a successful one.

**Bonus Actions**

- **_Short Step._** The flinderbeast teleports to an unoccupied space it can see within 15 feet of it.

**Reactions**

- **_Catch Snack._** When the flinderbeast is the target of a ranged weapon attack that uses ammunition made mostly of wood, such as an arrow, the flinderbeast can attempt to catch and eat the ammunition. The flinderbeast must make a DC 14 DEX save. On a success, it gains 3 (1d6) temporary HP and prevents the attack's damage.

### Fungi

#### Shrieker (CR 0)

_Medium Plant_

- **Armor Class** 5
- **Hit Points** 7
- **Speed** 10 ft.
- **Perception** 6
- **Stealth** 5
- **Resistant** thunder | Plant Resilience
- **Immune** blinded, deafened, frightened
- **Senses** keensense 30 ft. (blind beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -5 |  -5 |  +0 |  -5 |  -4 |  -5 |

- **_False Appearance._** While the shrieker remains motionless, it is indistinguishable from an ordinary fungus.
- **_Plant Resilience._** The shrieker is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Thunderous Burst._** The shrieker emits a concentrated burst of sound at one creature it can sense within 30 feet of it. The target must make a DC 10 DEX save, taking 2 (1d4) thunder damage on a failed save, or half as much damage on a successful one.

**Bonus Actions**

- **_Shriek._** The shrieker emits a high - pitched shriek audible within 300 feet of it. Each creature within 30 feet of it that isn't a Plant and that can hear the shriek must succeed on a DC 10 WIS save or be frightened until the shriek ends. The shrieker must use a bonus action on its subsequent turns to continue shrieking. It can stop shrieking at any time. The shriek ends if the shrieker is incapacitated.

  A frightened creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. A creature that successfully saves is immune to the frightened effect of this shrieker's Shriek for the next 24 hours.

**Reactions**

- **_Startled Shriek._** When bright light or a creature other than a Plant moves to within 30 feet of the shrieker, the shrieker can use Shriek, if it isn't already shrieking.

#### Violet Fungus (CR 1/4)

_Medium Plant_

- **Armor Class** 10
- **Hit Points** 14
- **Speed** 15 ft.
- **Perception** 6
- **Stealth** 5
- **Resistant** necrotic | Plant Resilience
- **Immune** blinded, deafened, frightened
- **Senses** keensense 30 ft. (blind beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  +0 |  -5 |  -4 |  -5 |

- **_False Appearance._** While the violet fungus remains motionless, it is indistinguishable from an ordinary fungus.
- **_Plant Resilience._** The violet fungus is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Rotting Touch._** _Melee Weapon Attack:_ +2 to hit, reach 10 ft., one creature. _Hit:_ 5 (2d4) necrotic damage.

**Bonus Actions**

- **_Necrotic Spores (8 HP or Fewer)._** The violet fungus sends out a burst of necrotic - laced spores, rapidly rotting nearby flesh. Each creature within 10 feet of the violet fungus that isn't a Construct must make a DC 10 CON save, taking 5 (2d4) necrotic damage on a failed save, or half as much damage on a successful one.

### Gargoyle (CR 2)

_Medium Elemental_

- **Armor Class** 15 (natural armor)
- **Hit Points** 52
- **Speed** 30 ft., fly 60 ft.
- **Perception** 10
- **Stealth** 10
- **Resistant** bludgeoning, piercing, and slashing from nonmagical attacks
- **Immune** poison | exhaustion, petrified, poisoned
- **Senses** darkvision 60 ft.
- **Languages** Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +5 |  -2 |  +0 |  -2 |

- **_Diving Pounce._** If the gargoyle is flying and moves at least 20 feet straight toward a creature and then hits it with a Claws attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the gargoyle can make one Bite attack against it as a bonus action.
- **_False Appearance._** While the gargoyle remains motionless, it is indistinguishable from an inanimate statue.

**Actions**

- **_Multiattack._** The gargoyle makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage.

**Reactions**

- **_Fearsome Mien._** When a creature the gargoyle can see hits it with an attack, the gargoyle can shift its face to appear more monstrous. The attacker must succeed on a DC 13 WIS save or be frightened of the gargoyle until the end of its next turn.

### Gelatinous Cube (CR 2)

_Large Ooze_

- **Armor Class** 6
- **Hit Points** 75
- **Speed** 15 ft.
- **Perception** 8
- **Stealth** 7
- **Vulnerable** cold
- **Resistant** Ooze Resilience
- **Immune** acid, piercing | Ooze Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  -4 |  +5 |  -5 |  -2 |  -5 |

- **_Ooze Cube._** The cube takes up its entire space. Other creatures can enter the space, but are subjected to the cube's Engulf and have disadvantage on the save. Creatures inside the cube can be seen but have total cover. A creature within 5 feet of the cube can take an action to pull a creature or object out of the cube. Doing so requires a successful DC 13 STR check, and the creature making the attempt takes 10 (3d6) acid damage.

  The cube can hold only one Large creature or up to four Medium or smaller creatures inside it at a time.

- **_Ooze Nature._** The cube doesn't require sleep.
- **_Ooze Resilience._** The cube is resistant to the grappled and restrained conditions, and it is immune to exhaustion and to the blinded, charmed, deafened, frightened, and prone conditions.
- **_Transparent._** While motionless, the cube's Stealth is 15, even when the cube is in plain sight.

**Actions**

- **_Pseudopod._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 10 (3d6) acid damage.
- **_Engulf._** The cube moves up to its speed. While doing so, it can enter a Large or smaller creature's space. When the cube enters a creature's space, the creature must make a DC 13 DEX save. On a success, the creature can choose to be pushed 5 feet back or to the side of the cube. A creature that chooses not to be pushed suffers the consequences of a failed save. On a failed save, the cube enters the creature's space, the creature takes 10 (3d6) acid damage, and is engulfed. The engulfed creature can't breathe, is restrained, and takes 21 (6d6) acid damage at the start of each of the cube's turns. When the cube moves, the engulfed creature moves with it.

  An engulfed creature can try to escape by taking an action to make a DC 13 STR check. On a success, the creature escapes and enters a space of its choice within 5 feet of the cube.

**Reactions**

- **_Skewer Prey._** When the gelatinous cube is subjected to piercing damage, it can move a random creature engulfed by it to intercept the attack. The creature takes the piercing damage as if it were the target.

### Genies

#### Djinni (CR 11)

_Large Elemental (Outsider)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 216
- **Speed** 30 ft., fly 90 ft.
- **Perception** 17
- **Stealth** 16
- **Immune** lightning, thunder
- **Senses** darkvision 120 ft.
- **Languages** Auran, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +6 |  +6 |  +2 |  +7 |  +9 |

- **_Nebulous (Cloud Form Only)._** The djinni's Stealth is 21, it can hover while flying, can't manipulate objects or attack, and it can pass through any space air can pass through without squeezing. In addition, it can enter and hide in any Tiny or larger container, such as a pouch, lamp, backpack, or barrel.

**Actions**

- **_Multiattack._** The djinni makes three Scimitar or Storm Bolt attacks.
- **_Scimitar._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) slashing damage plus 14 (4d6) lightning damage or thunder damage (the djinni's choice).
- **_Storm Bolt._** _Ranged Spell Attack:_ +9 to hit, range 120 ft., one target. _Hit:_ 18 (3d8+5) lightning damage plus 7 (2d6) thunder damage.
- **_Create Air Elemental (1/Day)._** The djinni magically creates one air - based Elemental of CR 5 or lower in an unoccupied space the djinni can see within 30 feet of it. The elemental acts as an ally of the djinni, obeying its spoken commands. The elemental remains for 1 hour, until the djinni dies, or until the djinni dismisses it as a bonus action.
- **_Travel the Planes (1/Day)._** The djinni transports itself to a different plane of existence. This works like the plane shift spell, except it can affect only itself and can't use this action to banish an unwilling creature.

**Bonus Actions**

- **_Create Whirlwind._** The djinni creates whirlwinds of air around up to two creatures it can see within 60 feet of it. Each target must succeed on a DC 17 STR check or be restrained by a whirlwind. A creature, including the target, can take its action to free the restrained target by succeeding on a DC 17 STR check.

  While at least one creature is restrained by one of these whirlwinds, the djinni can use this bonus action to move the whirlwind up to 30 feet, and the restrained target moves with it.

- **_Genie Shape._** The djinni magically transforms into a Medium cloud of sparkling, blue air or back into its bipedal form. Its statistics are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its bipedal form if it dies. The djinni can't use this bonus action to transform into its bipedal form while inside a Medium or smaller container.

#### Efreeti (CR 11)

_Large Elemental (Outsider)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 223
- **Speed** 40 ft., fly 60 ft.
- **Perception** 16
- **Stealth** 11
- **Immune** fire
- **Senses** darkvision 120 ft.
- **Languages** Common, Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +1 |  +7 |  +7 |  +6 |  +7 |

- **_Nebulous (Cloud Form Only)._** The efreeti's Stealth is 16, it can hover while flying, can't manipulate objects or attack, and it can pass through any space air can pass through without squeezing. In addition, it can enter and hide in any Tiny or larger container, such as a pouch, lamp, backpack, or barrel.

**Actions**

- **_Multiattack._** The efreeti makes three Scimitar or Hurl Flame attacks.
- **_Scimitar._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) slashing damage plus 10 (3d6) fire damage.
- **_Hurl Flame._** _Ranged Spell Attack:_ +7 to hit, range 120 ft., one target. _Hit:_ 24 (6d6+3) fire damage.
- **_Create Fire Elemental (1/Day)._** The efreeti magically creates one fire - based Elemental of CR 5 or lower in an unoccupied space the efreeti can see within 30 feet of it. The elemental acts as an ally of the efreeti, obeying its spoken commands. The elemental remains for 1 hour, until the efreeti dies, or until the efreeti dismisses it as a bonus action.
- **_Travel the Planes (1/Day)._** The efreeti transports itself to a different plane of existence. This works like the plane shift spell, except it can affect only itself and can't use this action to banish an unwilling creature.

**Bonus Actions**

- **_Blazing Palisade._** The efreeti magically creates a translucent wall of fire along a solid surface at a point it can see within 30 feet of it. The wall can be up to 1 foot thick, up to 45 feet long, and up to 5 feet high, and it can be any shape. Each creature in a space where the fire appears must succeed on a DC 15 DEX save or take 7 (2d6) fire damage. A creature that successfully saves can move to the wall's edge, out of the fire. A creature that enters the wall for the first time on a turn or ends its turn within 5 feet of the wall must succeed on a DC 15 DEX save or take 7 (2d6) fire damage. The efreeti can have only one fire wall active at a time. If it creates another, the previous fire wall disappears.
- **_Genie Shape._** The efreeti magically transforms into a Medium cloud of thick smoke filled with sparks of fire or back into its bipedal form. Its statistics are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its bipedal form if it dies. The efreeti can't use this bonus action to transform into its bipedal form while inside a Medium or smaller container.

#### Hinn (CR 11)

_Large Elemental (Outsider)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 199
- **Speed** 30 ft., burrow 30 ft., fly 60 ft.
- **Perception** 17
- **Stealth** 15
- **Resistant** prone
- **Immune** petrified
- **Senses** darkvision 120 ft.
- **Languages** Common, Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +1 | +11 |  +2 |  +7 |  +8 |

- **_Earth Glide._** The hinn can burrow through nonmagical, unworked earth and stone. While doing so, the hinn doesn't disturb the material through which it moves.
- **_Nebulous (Cloud Form Only)._** The hinn's Stealth is 20, it can hover while flying, can't manipulate objects or attack, and it can pass through any space air can pass through without squeezing. In addition, it can enter and hide in any Tiny or larger container, such as a pouch, lamp, backpack, or barrel.

**Actions**

- **_Multiattack._** The hinn makes three Gem - Studded Mace or Lob Stone attacks. If two Gem - Studded Mace attacks hit one creature, the target must succeed on a DC 16 CON save or be stunned until the end of its next turn.
- **_Gem - Studded Mace._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 13 (2d6+6) bludgeoning damage plus 9 (2d8) piercing damage.
- **_Lob Stone._** _Ranged Weapon Attack:_ +10 to hit, range 20/60 ft., one target. _Hit:_ 22 (3d10+6) bludgeoning damage.
- **_Create Earth Elemental (1/Day)._** The hinn magically creates one earth - based Elemental of CR 5 or lower in an unoccupied space the hinn can see within 30 feet of it. The elemental acts as an ally of the hinn, obeying its spoken commands. The elemental remains for 1 hour, until the hinn dies, or until the hinn dismisses it as a bonus action.
- **_Travel the Planes (1/Day)._** The hinn transports itself to a different plane of existence. This works like the plane shift spell, except it can affect only itself and can't use this action to banish an unwilling creature.

**Bonus Actions**

- **_Churned Earth._** The hinn causes the ground on a point it can see within 60 feet of it to erupt. Each creature within 15 feet of that point must succeed on a DC 16 DEX save or take 10 (3d6) bludgeoning damage and be knocked prone.
- **_Genie Shape._** The hinn magically transforms into a Medium cloud of dust filled with miniscule clashing, bursting, and reforming rocks or back into its bipedal form. Its statistics are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its bipedal form if it dies. The hinn can't use this bonus action to transform into its bipedal form while inside a Medium or smaller container.

#### Sila (CR 11)

_Large Elemental (Outsider)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 216
- **Speed** 30 ft., fly 60 ft., swim 90 ft.
- **Perception** 16
- **Stealth** 16
- **Immune** acid, cold
- **Senses** darkvision 120 ft.
- **Languages** Aquan, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +6 |  +6 |  +7 |  +2 |  +9 |

- **_Amphibious._** The sila can breathe air and water.
- **_Fluid Body (Bipedal Form Only)._** The sila can move through the space of any creature, regardless of size, and a creature of any size can move through a sila's space. In addition, the sila can move through a space as narrow as 1 inch wide without squeezing.
- **_Nebulous (Cloud Form Only)._** The sila's Stealth is 21, it can hover while flying, can't manipulate objects or attack, and it can pass through any space air or water can pass through without squeezing. In addition, it can enter and hide in any Tiny or larger container, such as a pouch, lamp, backpack, or barrel.

**Actions**

- **_Multiattack._** The sila makes four Cold - Infused Jambiya or Water Burst attacks. If two Water Burst attacks hit one creature, the target must succeed on a DC 17 STR save or be pushed up to 15 feet away from the sila.
- **_Cold - Infused Jambiya._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 14 (2d8+5) slashing damage plus 5 (2d4) cold damage.
- **_Water Burst._** _Ranged Spell Attack:_ +9 to hit, range 60 ft., one target. _Hit:_ 19 (4d6+5) bludgeoning damage.
- **_Create Water Elemental (1/Day)._** The sila magically creates one water - based Elemental of CR 5 or lower in an unoccupied space the sila can see within 30 feet of it. The elemental acts as an ally of the sila, obeying its spoken commands. The elemental remains for 1 hour, until the sila dies, or until the sila dismisses it as a bonus action.
- **_Travel the Planes (1/Day)._** The sila transports itself to a different plane of existence. This works like the plane shift spell, except it can affect only itself and can't use this action to banish an unwilling creature.

**Bonus Actions**

- **_Clouded Eyes._** The sila condenses the air or water around the head or eyes of up to two creatures it can see within 30 feet of it. Each target must succeed on a DC 17 DEX save or be blinded until the end of its next turn.
- **_Genie Shape._** The sila magically transforms into a Medium cloud of thick mist that leaves droplets of water on everything it touches or back into its bipedal form. Its statistics are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its bipedal form if it dies. The sila can't use this bonus action to transform into its bipedal form while inside a Medium or smaller container.

### Ghost (CR 4)

_Medium Undead_

- **Armor Class** 12
- **Hit Points** 68
- **Speed** 0 ft., fly 40 ft. (hover)
- **Perception** 13
- **Stealth** 11
- **Resistant** acid, fire, lightning, thunder; bludgeoning, piercing, and lashing from nonmagical attacks
- **Immune** cold, necrotic | charmed, frightened, grappled, paralyzed, petrified, prone, restrained | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** any languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +2 |  +0 |  +0 |  +3 |  +4 |

- **_Ethereal Sight._** The ghost can see 60 feet into the Ethereal Plane when it is on the Material Plane, and vice versa.
- **_Incorporeal Movement._** The ghost can move through other creatures and objects as if they were difficult terrain. It takes 5 (1d10) force damage if it ends its turn inside an object.
- **_Undead Nature._** The ghost doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The ghost is immune to poison damage, to exhaustion, and to the poisoned condition.
- **_Unfinished Business._** Unless its unfinished business is fulfilled, a destroyed ghost returns in 1d4 days, regaining all its HP and becoming active again within 10 feet of where it died. If presented with an object or piece of information related to its unfinished business, the ghost must succeed on a DC 13 WIS save or be incapacitated until the end of its next turn. After it has been incapacitated by a particular source, the ghost can't be incapacitated by that same source again for 24 hours. If presented with everything it needs to complete its unfinished business, the ghost permanently dies after completing it.

**Actions**

- **_Multiattack._** The ghost makes two Withering Touch or Telekinetic Throw attacks.
- **_Withering Touch._** Melee Spell Attack: +6 to hit, reach 5 ft., one target. _Hit:_ 18 (4d6+4) necrotic damage.
- **_Telekinetic Throw._** _Ranged Weapon Attack:_ +4 to hit, range 20/60 ft., one target. _Hit:_ 17 (6d4+2) bludgeoning, piercing, or slashing damage, depending on the type of object thrown. The ghost can throw only Small or smaller objects within range that aren't being worn or carried.
- **_Horrify (Recharge 5 - 6)._** The ghost speaks a haunting phrase, reveals the wounds from its death, or performs some other expression to scare creatures in a 30 - foot cone. Each creature in that area must make a DC 14 WIS save. On a failure, a creature takes 21 (6d6) psychic damage and is frightened until the end of its next turn. On a success, a creature takes half the damage and isn't frightened. A creature that fails the save by 5 or more increases its age in years by 10 percent, rounded up. This aging can be reversed with a greater restoration spell or similar magic, but only within 24 hours of the aging occurring.

**Bonus Actions**

- **_Etherealness._** The ghost enters the Ethereal Plane from the Material Plane, or vice versa. It is visible on the Material Plane while it is in the Ethereal Plane, and vice versa, yet it can't affect or be affected by anything on the other plane.

### Ghouls

#### Ghoul (CR 1)

_Medium Undead_

- **Armor Class** 13
- **Hit Points** 34
- **Speed** 30 ft., climb 30 ft.
- **Perception** 12
- **Stealth** 14
- **Immune** charmed | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +0 |  -2 |  +2 |  -2 |

- **_Hungry Dead Nature._** The ghoul doesn't require air or sleep. In addition, it must consume at least 2 pounds of raw meat every 24 hours, or it loses its immunity to exhaustion and risks starvation until it does so. While it has any levels of exhaustion from starvation, the ghoul can't remove levels of exhaustion until it consumes at least 4 pounds of raw meat.
- **_Spider Climb._** The ghoul can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Undead Resilience._** The ghoul is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The ghoul makes one Bite attack and one Claws attack. If both attacks hit a creature that isn't a Construct or Undead, the target must succeed on a DC 13 CON save or contract ghoul hunger (see the Ghoul Hunger sidebar).
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage. If the target is a creature that isn't a Construct or Undead, it must succeed on a DC 13 CON save or be paralyzed for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.

#### Ghast (CR 2)

_Medium Undead_

- **Armor Class** 13
- **Hit Points** 48
- **Speed** 30 ft., climb 30 ft.
- **Perception** 12
- **Stealth** 13
- **Resistant** necrotic
- **Immune** charmed | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +3 |  +0 |  +0 |  +2 |  -1 |

- **_Hungry Dead Nature._** The ghast doesn't require air or sleep. In addition, it must consume at least 2 pounds of raw meat every 24 hours, or it loses its immunity to exhaustion and risks starvation until it does so. While it has any levels of exhaustion from starvation, the ghast can't remove levels of exhaustion until it consumes at least 4 pounds of raw meat.
- **_Spider Climb._** The ghast can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Stench._** A creature that starts its turn within 5 feet of the ghast must succeed on a DC 13 CON save or be poisoned until the start of its next turn. On a success, the creature is immune to the ghast's Stench for 24 hours.
- **_Turning Defiance._** The ghast and any ghouls within 30 feet of it have advantage on saves against effects that turn undead.
- **_Undead Resilience._** The ghast is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The ghast makes one Bite attack and two Claws attacks. If one Bite attack and at least one Claws attack hit a creature that isn't a Construct or Undead, the target must succeed on a DC 13 CON save or contract ghoul hunger (see the Ghoul Hunger sidebar).
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage. If the target is a creature that isn't a Construct or Undead, it must succeed on a DC 13 CON save or be paralyzed for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.

### Giants

#### Cloud Giant (CR 9)

_Huge Giant_

- **Armor Class** 14 (natural armor)
- **Hit Points** 175
- **Speed** 40 ft., fly 60 ft.
- **Perception** 17
- **Stealth** 10
- **Vulnerable** Giant Attributes
- **Resistant** cold | Giant Attributes
- **Senses** -
- **Languages** Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +0 | +10 |  +1 |  +7 |  +8 |

- **_Cloudsight._** The cloud giant can see through areas obscured by clouds, fog, smoke, and steam without penalty.
- **_Giant Attributes._** The cloud giant is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Heightened Smell._** The cloud giant's Perception is 22 when perceiving by smell.

**Actions**

- **_Multiattack._** The cloud giant makes three Cloud - Coated Mace attacks, or it makes two Wind Burst attacks.
- **_Cloud - Coated Mace._** _Melee Weapon Attack:_ +12 to hit, reach 10 ft., one target. _Hit:_ 18 (3d6+8) piercing damage plus 4 (1d8) cold damage.
- **_Wind Burst._** _Ranged Spell Attack:_ +8 to hit, range 150 ft., one target. _Hit:_ 31 (5d10+4) bludgeoning damage, and the target must succeed on a DC 16 STR save or be pushed up to 10 feet away from the cloud giant and knocked prone.

**Bonus Actions**

- **_Cloud Cover._** The cloud giant creates a 20 - foot cube of clouds centered on a point it can see within 60 feet of it. The cube spreads around corners, and its area is heavily obscured. The cloud lasts for 1 minute, until the cloud giant dies, or until the cloud giant uses this bonus action again.
- **_Condense._** The cloud giant causes a 20 - foot - radius sphere of cloud, fog, smoke, or steam centered on a point it can see within 60 feet of it to become as thick as mud, making the area difficult terrain for creatures moving through it. A creature that starts its turn in the hardened cloud must succeed on a DC 15 STR save or be restrained until the start of its next turn. The cloud remains condensed for 1 minute, until the cloud giant dies, or until the cloud giant uses this bonus action again.

**Reactions**

- **_Cirrus Deflection._** The cloud giant creates a bit of hardened cloud between it and an attacker, increasing the giant's AC by 4. To do so, it must be able to see the attacker.

#### Fire Giant (CR 9)

_Huge Giant_

- **Armor Class** 18 (plate)
- **Hit Points** 175
- **Speed** 30 ft.
- **Perception** 16
- **Stealth** 13
- **Vulnerable** Giant Attributes
- **Resistant** Giant Attributes
- **Immune** fire
- **Senses** -
- **Languages** Dwarven, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +3 | +10 |  +0 |  +2 |  +8 |

- **_Giant Attributes._** The fire giant is resistant to the stunned condition, and it is vulnerable to the prone condition.

**Actions**

- **_Multiattack._** The fire giant makes two Flaming Greatsword or Lava Boulder attacks.
- **_Flaming Greatsword._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 28 (6d6+7) slashing damage plus 4 (1d8) fire damage.
- **_Lava Boulder._** _Ranged Weapon Attack:_ +7 to hit, range 60/240 ft., one target. _Hit:_ 19 (3d10+3) bludgeoning damage plus 13 (3d8) fire damage.
- **_Volcanic Burst (Recharge 5 - 6)._** The fire giant expels built - up heat from within itself, sending a blast of lava outward. Each creature within 15 feet of the fire giant must make a DC 16 DEX save. On a failure, a creature takes 36 (8d8) fire damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone. A creature that fails this save has disadvantage on the next save it makes against the giant's Pyroclastic Surge before the start of the giant's next turn.

**Bonus Actions**

- **_Pyroclastic Surge._** A burst of volcanic gas and rock fragments flows in a 60 - foot - line that is 5 feet wide from the fire giant's outstretched hand. Each creature in the line must succeed on a DC 16 DEX save or be poisoned until the end of its next turn and pushed up to 15 feet away from the giant. A creature that fails the save by 5 or more is petrified in volcanic ash for 1 hour or until a creature spends 1 minute soaking the petrified creature in cool water.

#### Frost Giant (CR 8)

_Huge Giant_

- **Armor Class** 14 (hide armor)
- **Hit Points** 166
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 12
- **Vulnerable** Giant Attributes
- **Resistant** blinded | Giant Attributes
- **Immune** cold
- **Senses** -
- **Languages** Common, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +2 |  +8 |  -1 |  +3 |  +4 |

- **_Giant Attributes._** The frost giant is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Ice Walk._** The frost giant can move across icy surfaces without needing to make an ability check. In addition, difficult terrain composed of ice or snow doesn't cost it extra movement.
- **_Snowsight._** The frost giant can see through areas obscured by snowfall, sleet, and other wintry precipitation without penalty.

**Actions**

- **_Multiattack._** The giant makes two Icy Greataxe or Ice Boulder attacks.
- **_Icy Greataxe._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 25 (3d12+6) slashing damage plus 4 (1d8) cold damage.
- **_Ice Boulder._** _Ranged Weapon Attack:_ +6 to hit, range 60/240 ft., one target. _Hit:_ 18 (3d10+2) bludgeoning damage plus 9 (2d8) cold damage.
- **_Avalanche (Recharge 5 - 6)._** The frost giant sends out a wave of snow in a 30 - foot cone. Each creature in that area must make a DC 16 DEX save. On a failure, a creature takes 14 (4d6) bludgeoning damage and 18 (4d8) cold damage and is buried. On a success, a creature takes half the damage and isn't buried. A buried creature is restrained and unable to breathe or stand up. A creature, including the buried creature, can take its action to free the buried creature by succeeding on a DC 16 STR check.

**Bonus Actions**

- **_Wintry Blast._** A blast of wintry air extends in a 30 - foot line that is 5 feet wide from the frost giant's outstretched hand. Each creature in the line must succeed on a DC 16 CON save or its speed is halved until the end of its next turn. A creature that fails the save by 5 or more is petrified in ice for 1 hour or until a creature spends 1 minute warming the petrified creature.

#### Hill Giant (CR 5)

_Huge Giant_

- **Armor Class** 12 (hide armor)
- **Hit Points** 126
- **Speed** 40 ft.
- **Perception** 12
- **Stealth** 9
- **Vulnerable** Giant Attributes
- **Resistant** poison | poisoned | Giant Attributes
- **Senses** -
- **Languages** Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +7 |  -3 |  -1 |  -2 |

- **_Giant Attributes._** The hill giant is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Show of Might._** The hill giant can use STR instead of CHA when making CHA (Intimidation) checks.

**Actions**

- **_Multiattack._** The giant makes two Spiked Tree Branch or Rotten Snack attacks.
- **_Spiked Tree Branch._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 14 (2d8+5) bludgeoning damage plus 5 (2d4) piercing damage.
- **_Rotten Snack._** _Ranged Weapon Attack:_ +8 to hit, range 60/240 ft., one target. _Hit:_ 12 (2d6+5) bludgeoning damage plus 7 (2d6) poison damage, and the target must succeed on a DC 16 CON save or be poisoned until the end of its next turn.

**Bonus Actions**

- **_Body Bounce._** The hill giant bumps its stomach, hip, shoulder, knee, or other part of its body into a creature within 10 feet of it. The target must succeed on a DC 16 STR save or be pushed up to 10 feet away from the giant and knocked prone.

#### Stone Giant (CR 7)

_Huge Giant_

- **Armor Class** 17 (natural armor)
- **Hit Points** 156
- **Speed** 40 ft.
- **Perception** 14
- **Stealth** 15
- **Vulnerable** thunder | Giant Attributes
- **Resistant** lightning | petrified | Giant Attributes
- **Senses** darkvision 60 ft.
- **Languages** Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +5 |  +8 |  +0 |  +4 |  -1 |

- **_Giant Attributes._** The stone giant is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Stone Camouflage._** The giant's Stealth is 20 while in rocky terrain.

**Actions**

- **_Multiattack._** The giant makes two Stony Fist or Rock attacks.
- **_Stony Fist._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 24 (4d8+6) bludgeoning damage. The target is grappled (escape DC 17) if it is a Large or smaller creature and the stone giant isn't already grappling a creature.
- **_Rock._** _Ranged Weapon Attack:_ +9 to hit, range 60/240 ft., one target. _Hit:_ 28 (4d10+6) bludgeoning damage. If the target is a creature, it must succeed on a DC 17 STR save or be knocked prone.

**Bonus Actions**

- **_Wrestle._** The stone giant performs one of the following wrestling maneuvers against one creature it is grappling. The target must succeed on a DC 17 STR save or suffer the listed effect until the stone giant uses this bonus action again or until the grapple ends.
  - **Armbar.** The target has disadvantage on attack rolls and on checks made to escape the grapple.
  - **Chinlock.** The target can't speak and can't cast spells with verbal components.
  - **Takedown.** The target is knocked prone and restrained.
  - **Throw.** The target is thrown up to 30 feet in a random direction and knocked prone, ending the grapple. If a thrown target strikes a solid surface, the target takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target is thrown at another creature, that creature must succeed on a DC 17 DEX save or take the same damage and be knocked prone.

**Reactions**

- **_Missile Deflection._** If a creature the giant can see makes a ranged weapon attack against the giant, the giant can add 3 to its AC. If the attack misses, the giant can catch the missile, provided the attack included a projectile, and throw it back at the attacker, using the giant's normal ranged weapon attack bonus and the weapon's normal damage.

#### Storm Giant (CR 13)

_Huge Giant_

- **Armor Class** 16 (scale mail)
- **Hit Points** 243
- **Speed** 50 ft., swim 50 ft.
- **Perception** 19
- **Stealth** 12
- **Vulnerable** Giant Attributes
- **Resistant** cold | Giant Attributes
- **Immune** lightning, thunder
- **Senses** -
- **Languages** Common, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +14 |  +2 | +10 |  +3 |  +9 |  +9 |

- **_Amphibious._** The giant can breathe air and water.
- **_Giant Attributes._** The giant is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Influence Weather._** Nearby weather responds to the storm giant's desires. At the start of each minute, the storm giant can choose to change the precipitation, temperature, and wind within 3 miles of it by one stage, up or down (no action required). This effect works like the changing weather conditions aspect of the control weather spell, except the conditions change immediately and the storm giant can't change the temperature by more than one stage up or down from the area's standard temperature.
- **_Stormsight._** The storm giant can see through areas obscured by clouds, fog, rain, snow, and storms without penalty.
- **_Updraft._** While in an area open to the sky, the storm giant has a flying speed of 30 feet.

**Actions**

- **_Multiattack._** The giant makes three Greatsword attacks, or it makes four Lightning Bolt attacks.
- **_Greatsword._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 30 (6d6+9) slashing damage.
- **_Lightning Bolt._** _Ranged Spell Attack:_ +9 to hit, range 150 ft., one target. _Hit:_ 22 (4d8+4) lightning damage. If the giant scores a critical hit, the target must succeed on a DC 17 CON save or be paralyzed until the end of its next turn.
- **_Thunderous Strike (Recharge 5 - 6)._** The giant hurls a magical lightning bolt at a point it can see within 500 feet of it. Each creature within 10 feet of that point must make a DC 17 DEX save. On a failure, a creature takes 36 (8d8) lightning damage and 21 (6d6) thunder damage and is stunned until the end of its next turn. On a success, a creature takes half the damage and isn't stunned.

**Reactions**

- **_Stormy Rebuke._** When a creature the storm giant can see hits it with a melee attack while within 5 feet of the giant, the giant can send a stormy blast at the creature. The attacker must succeed on a DC 17 STR save or be pushed up to 15 feet away from the giant and knocked prone.

### Gibbering Mouther (CR 2)

_Medium Aberration_

- **Armor Class** 9
- **Hit Points** 72
- **Speed** 10 ft., swim 10 ft.
- **Perception** 10
- **Stealth** 9
- **Resistant** Aberrant Resilience
- **Immune** prone
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  -1 |  +3 |  -4 |  +0 |  -2 |

- **_Aberrant Ground._** The ground within 10 feet of the mouther is dough - like difficult terrain. A creature that starts its turn in the area must succeed on a DC 13 STR save or its speed is halved until the start of its next turn.
- **_Aberrant Resilience._** The mouther is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Gibbering._** The mouther babbles incoherently while it can see any creature and isn't incapacitated. A creature that starts its turn within 20 feet of the mouther and that can hear the gibbering must succeed on a DC 13 WIS save or it can't take reactions until the start of its next turn and must roll a d8 to determine what it does during its turn. On a 1 to 4, the creature does nothing. On a 5 or 6, the creature takes no action or bonus action and moves its full speed in a randomly determined direction. On a 7 or 8, the creature makes a melee attack against a randomly determined creature within its reach or does nothing if it can't make such an attack.

**Actions**

- **_Multiattack._** The gibbering mouther makes two Bite attacks. If both attacks hit one Medium or smaller creature, the target must succeed on a DC 13 STR save or be knocked prone.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 11 (2d8+2) piercing damage.
- **_Rend Mind._** One creature the mouther can see within 30 feet of it must succeed on a DC 13 WIS save or take 18 (4d8) psychic damage and suffer a random, short - term dread effect for 1 minute

**Bonus Actions**

- **_Blinding Spittle._** The mouther spits an otherworldly goo at up to two creatures it can see within 30 feet of it. Each target must succeed on a DC 13 DEX save or be blinded until the end of its next turn.

### Gnoll (CR 1/2)

_Medium Humanoid_

- **Armor Class** 15 (hide armor, shield)
- **Hit Points** 22
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 13
- **Senses** darkvision 60 ft.
- **Languages** Gnoll

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +0 |  -2 |  +0 |  -2 |

- **_Heightened Smell._** The gnoll's Perception is 15 when perceiving by smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) piercing damage.
- **_Spear._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 5 (1d6+2) piercing damage, or 6 (1d8+2) piercing damage if used with two hands to make a melee attack.

**Bonus Actions**

- **_Taunting Bark._** The gnoll lets out a high - pitched laugh and taunts one creature it can see within 30 feet of it. The target must make a DC 12 CHA save. On a failure, a creature takes 2 (1d4) psychic damage and must spend its next turn moving up to its speed toward the gnoll and make one attack against the gnoll.

**Reactions**

- **_Rampage._** When the gnoll reduces a creature to 0 HP, it can move up to half its speed and make one Bite attack. If it does, attack rolls against it have advantage until the start of its next turn.

### Deep Gnome (CR 1/2)

_Small Humanoid_

- **Armor Class** 15 (chain shirt)
- **Hit Points** 23
- **Speed** 20 ft.
- **Perception** 12
- **Stealth** 12
- **Senses** darkvision 120 ft.
- **Languages** Gnomish, Terran, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +2 |  +1 |  +0 |  -1 |

- **_Gnome Cunning._** The deep gnome has advantage on INT, WIS, and CHA saves against magic.
- **_Stone Camouflage._** The deep gnome's Stealth is 17 while in rocky terrain.

**Actions**

- **_War Pick._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) piercing damage.
- **_Crystalline Dart._** _Ranged Weapon Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 7 (2d4+2) piercing damage.

**Bonus Actions**

- **_Infused Weapon._** The deep gnome crushes a magic - infused crystal on the end of its war pick. Until the start of the gnome's next turn the war pick is magical and deals an extra 2 (1d4) force damage when the gnome hits with it.
- **_Discordant Shatter._** The deep gnome throws a magic - infused crystal at a point it can see within 30 feet of it, shattering the crystal, which emits a rapid series of discordant waves of magic. Each creature within 10 feet of that point must succeed on a DC 12 CON save or be incapacitated until the end of its next turn. A creature sensitive to or proficient in the use of magic, such as a spellcaster, has disadvantage on this save.

**Reactions**

- **_Crystalline Flash._** When a creature the deep gnome can see within 5 feet of it attacks it, it can throw a magic - infused crystal on the ground, shattering the crystal in a brilliant flash of light. If the attacker uses sight to perceive the gnome, the attacker must succeed on a DC 12 DEX save or have disadvantage on the attack roll.

### Goblins

#### Bugbear (CR 1)

_Medium Humanoid_

- **Armor Class** 14 (hide armor)
- **Hit Points** 40
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 16
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +2 |  +1 |  -1 |  +0 |  -1 |

- **_Brutal._** A melee weapon deals one extra die of its damage when the bugbear hits with it (included in the attack).

**Actions**

- **_Spiked Club._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage. A surprised target takes an extra 4 (1d8) piercing damage and must succeed on a DC 13 CON save or be stunned until the end of its next turn.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +6 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 11 (2d6+4) piercing damage in melee or 7 (1d6+4) piercing damage at range.

#### Bugbear Champion (CR 4)

_Medium Humanoid_

- **Armor Class** 17 (chain shirt, shield)
- **Hit Points** 85
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 16
- **Resistant** charmed, frightened
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +2 |  +2 |  +1 |  +1 |  +0 |

- **_Brutal._** A melee weapon deals one extra die of its damage when the bugbear hits with it (included in the attack).

**Actions**

- **_Multiattack._** The bugbear champion makes two Spiked Club attacks and one Shield Smash attack, or it makes three Javelin attacks.
- **_Spiked Club._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) piercing damage.
- **_Shield Smash._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) bludgeoning damage. If the target is a creature, it must succeed on a DC 14 STR save or be knocked prone.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +5 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 10 (2d6+3) piercing damage in melee or 5 (1d6+2) piercing damage at range.

**Reactions**

- **_Stubborn Attacker (Recharge 5 - 6)._** When the champion misses with an attack, it can change that miss to a hit.

#### Goblin (CR 1/4)

_Small Humanoid_

- **Armor Class** 15 (leather armor, shield)
- **Hit Points** 12
- **Speed** 30 ft.
- **Perception** 9
- **Stealth** 14
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +4 |  +0 |  +0 |  -1 |  -1 |

**Actions**

- **_Scimitar._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Shortbow._** _Ranged Weapon Attack:_ +4 to hit, range 80/320 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Gang Up (1/Day)._** The goblin moves up to half its speed toward a creature it can see. Each friendly goblin within 30 feet of the goblin can use its reaction to join the gang up and move up to half its speed toward the same target. This movement doesn't provoke opportunity attacks. If the initiating goblin is within 5 feet of the target, the target must make a DC 12 DEX save, taking 5 (2d4) bludgeoning damage on a failed save, or half as much damage on a successful one. For each goblin after the first that participated in the gang up and that is within 10 feet of the target, the damage increases by 1 as arrows, knives, sharp pocket scraps, and similar "weapons" fly at the target from all angles. Afterwards, each goblin after the first that participated in the gang up can't use Gang Up until it finishes a short or long rest.

**Bonus Actions**

- **_Nimble Escape._** The goblin takes the Disengage or Hide action.

#### Goblin Captain (CR 1)

_Small Humanoid_

- **Armor Class** 17 (chain shirt, shield)
- **Hit Points** 32
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 14
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +4 |  +0 |  +1 |  +1 |  +0 |

**Actions**

- **_Multiattack._** The goblin captain makes two Scimitar or Shortbow attacks. If both attacks hit one target, the goblin captain can make one extra Scimitar or Shortbow attack.
- **_Scimitar._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.
- **_Shortbow._** _Ranged Weapon Attack:_ +4 to hit, range 80/320 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Bonus Actions**

- **_Get That One!_** The goblin captain points at a target and calls out to a friendly goblin it can see within 30 feet of it. The chosen goblin can use its reaction to move up to half its speed and make one melee attack against the target.
- **_Nimble Escape._** The goblin takes the Disengage or Hide action.

**Reactions**

- **_Protect Me!_** When a creature the goblin captain can see targets it with an attack, the captain can sidestep behind an ally within 5 feet of it, moving to an unoccupied space within 5 feet of the ally. The chosen ally becomes the target of the attack instead.

### Hobgoblin (CR 1/2)

_Medium Humanoid_

- **Armor Class** 18 (chain mail, shield)
- **Hit Points** 18
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 8 (13 without armor)
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +1 |  +1 |  +0 |  +0 |  -1 |

**Actions**

- **_Multiattack._** The hobgoblin makes two Longsword or Longbow attacks.
- **_Longsword._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 5 (1d8+1) slashing damage, or 6 (1d10+1) slashing damage if used with two hands.
- **_Longbow._** _Ranged Weapon Attack:_ +3 to hit, range 150/600 ft., one target. _Hit:_ 5 (1d8+1) piercing damage.

**Bonus Actions**

- **_Tactical Analysis._** The hobgoblin briefly studies one creature it can see within 30 feet of it. It has advantage on the next attack roll it makes against that creature before the start of the hobgoblin's next turn.

### Hobgoblin Commander (CR 3)

_Medium Humanoid_

- **Armor Class** 17 (half plate)
- **Hit Points** 72
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 9 (14 without armor)
- **Resistant** charmed, frightened
- **Senses** darkvision 60 ft.
- **Languages** Common, Goblin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +2 |  +1 |  +0 |  +2 |

- **_Unshakable Command._** Each friendly creature within 30 feet of the hobgoblin commander can't be charmed or frightened while the commander isn't incapacitated.

**Actions**

- **_Multiattack._** The hobgoblin commander makes three Greatsword or Longbow attacks.
- **_Greatsword._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 9 (2d6+2) slashing damage.
- **_Longbow._** _Ranged Weapon Attack:_ +4 to hit, range 150/600 ft., one target. _Hit:_ 6 (1d8+2) piercing damage.

**Bonus Actions**

- **_Martial Tactics._** The hobgoblin commander employs one of the following tactics:
  - **Emboldening Shout.** One friendly creature within 30 feet of the hobgoblin commander that it can see gains 7 (2d6) temporary HP until the start of the commander's next turn.
  - **Pressing Advance.** The commander moves up to half its speed and commands one friendly creature it can see within 30 feet of it to also move. The target can use its reaction to move up to half its speed in the direction of the commander's choosing. This movement for both creatures is unaffected by difficult terrain and doesn't provoke opportunity attacks.

### Golems

#### Clay Golem (CR 9)

_Large Construct (Golem)_

- **Armor Class** 14 (natural armor)
- **Hit Points** 163
- **Speed** 20 ft.
- **Perception** 9
- **Stealth** 9
- **Immune** acid | Golem Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +4 |  -4 |  -1 |  -5 |

- **_Acid Absorption._** Whenever the golem is subjected to acid damage, it takes no damage and instead regains HP equal to the acid damage dealt.
- **_Construct Nature._** The golem doesn't require air, food, drink, or sleep.
- **_Fire Weakness._** When the clay golem takes fire damage, its body temporarily hardens like baked clay. Until the end of its next turn, the golem's speed is reduced by 10 feet, it can't use Mold Hand, and its AC becomes 18.
- **_Golem Resilience._** The golem is immune to poison and psychic damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and to the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Immutable Form._** The golem is immune to any spell or effect that would alter its form.
- **_Magic Resistance._** The golem has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The golem's weapon attacks are magical.

**Actions**

- **_Multiattack._** The golem makes three Slam attacks.
- **_Slam._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 21 (3d10+5) bludgeoning, piercing, or slashing damage, as determined by Mold Hand. The target must succeed on a DC 16 STR save or suffer an effect based on the type of damage: knocked prone (bludgeoning), pushed up to 10 feet away from the golem (piercing), or its speed is reduced by 10 feet until the end of its next turn (slashing).
- **_Haste (Recharge 5 - 6)._** Until the end of its next turn, the golem magically gains a +2 bonus to its AC, has advantage on DEX saves, and can make a Slam attack as a bonus action.

**Bonus Actions**

- **_Mold Hand._** The clay golem molds its hand into the shape of a weapon or back into a hand. The golem's Slam attack deals bludgeoning, piercing, or slashing damage, depending on the type of weapon chosen, until the golem uses this bonus action again. For example, a hand shaped like an axe deals slashing damage.

#### Flesh Golem (CR 5)

_Medium Construct (Golem)_

- **Armor Class** 9
- **Hit Points** 129
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 9
- **Immune** lightning | Flesh Golem Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -1 |  +4 |  -2 |  +0 |  -3 |

- **_Aversion of Fire._** If the golem takes fire damage, it loses its immunity to the frightened condition and has disadvantage on attack rolls and ability checks until the end of its next turn.
- **_Berserk (55 HP or Fewer)._** When the golem starts its turn, roll a d6. On a 6, the golem goes berserk. On each of its turns while berserk, the golem attacks the nearest creature it can see. If no creature is near enough to move to and attack, the golem attacks an object, with preference for an object smaller than itself. Once the golem goes berserk, it continues to do so until it is destroyed or regains all its HP. The golem's creator, if within 60 feet of the berserk golem, can try to calm it by speaking firmly and persuasively. The golem must be able to hear its creator, who must take an action to make a DC 15 CHA (Persuasion) check. If the check succeeds, the golem ceases being berserk. If the golem takes damage while still at 55 HP or fewer, the golem might go berserk again.
- **_Construct Nature._** The golem doesn't require air, food, drink, or sleep.
- **_Flesh Golem Resilience._** The golem is immune to poison damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and to the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Immutable Form._** The golem is immune to any spell or effect that would alter its form.
- **_Lightning Absorption._** Whenever the golem is subjected to lightning damage, it takes no damage and instead regains HP equal to the lightning damage dealt.
- **_Magic Resistance._** The golem has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The golem's weapon attacks are magical.

**Actions**

- **_Multiattack._** The golem makes two Slam attacks.
- **_Slam._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 17 (3d8+4) bludgeoning damage.
- **_Creator's Anguish (Recharge 5 - 6)._** The golem releases a wave of emotional anguish from its core. Each creature within 15 feet of the golem must make a DC 15 WIS save. On a failure, a creature takes 31 (9d6) psychic damage and is incapacitated until the end of its next turn, as its mind fills with memories of its greatest failures. On a success, a creature takes half the damage and isn't incapacitated.

#### Iron Golem (CR 16)

_Large Construct (Golem)_

- **Armor Class** 20 (natural armor, shield)
- **Hit Points** 201
- **Speed** 30 ft.
- **Perception** 15
- **Stealth** 9
- **Immune** fire | Golem Resilience
- **Senses** darkvision 120 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +12 |  -1 |  +5 |  -4 |  +0 |  -5 |

- **_Construct Nature._** The golem doesn't require air, food, drink, or sleep.
- **_Golem Resilience._** The golem is immune to poison and psychic damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and to the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Fire Absorption._** Whenever the golem is subjected to fire damage, it takes no damage and instead regains HP equal to the fire damage dealt.
- **_Immutable Form._** The golem is immune to any spell or effect that would alter its form.
- **_Magic Resistance._** The golem has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The golem's weapon attacks are magical.
- **_Warrior Stance._** At the start of each of its turns, the iron golem chooses one of the following fighting stances to adopt, which lasts until the start of the golem's next turn.
  - **Retributive.** The next time the golem is hit by a melee weapon attack from a creature within 5 feet of it before the start of its next turn, the golem can slam its shoulder into the attacker as a reaction. The attacker must succeed on a DC 18 STR save or be pushed up to 10 feet away from the golem and knocked prone.
  - **Aggressive.** When the golem uses Multiattack, it can replace one additional Spear Arm attack with a Shield Bash attack. If it does so, its AC is reduced by 2 until the start of its next turn.
  - **Defensive.** The golem's AC increases by 4, but it can't make Shield Bash attacks until the start of its next turn.

**Actions**

- **_Multiattack._** The golem makes four Spear Arm attacks. It can replace one Spear Arm attack with a Shield Bash attack.
- **_Shield Bash._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 29 (4d10+7) bludgeoning damage, and the target must succeed on a DC 18 STR save or be knocked prone.
- **_Spear Arm._** _Melee Weapon Attack:_ +12 to hit, reach 10 ft., one target. _Hit:_ 25 (4d8+7) piercing damage.
- **_Expel Poisonous Gas (Recharge 5 - 6)._** The golem vents poisonous gas from small holes across its body. Each creature within 15 feet of the golem must make a DC 18 CON save, taking 54 (12d8) poison damage on a failed save, or half as much damage on a successful one.

#### Stone Golem (CR 10)

_Large Construct (Golem)_

- **Armor Class** 17 (natural armor)
- **Hit Points** 176
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 9
- **Immune** Golem Resilience
- **Senses** darkvision 120 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +9 |  -4 |  +0 |  -5 |

- **_Construct Nature._** The golem doesn't require air, food, drink, or sleep.
- **_Golem Resilience._** The golem is immune to poison and psychic damage and to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to exhaustion and to the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Immutable Form._** The golem is immune to any spell or effect that would alter its form.
- **_Magic Resistance._** The golem has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The golem's weapon attacks are magical.

**Actions**

- **_Multiattack._** The golem makes three Slam attacks.
- **_Slam._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 21 (3d10+5) bludgeoning damage.
- **_Slow (Recharge 6)._** The golem shares the plodding perception of timeless stone with those nearby, slowing all life to a crawl. Each creature within 10 feet of the golem must make a DC 17 WIS save. On a failure, a creature can't use reactions, its speed is halved, and it can't make more than one attack on its turn. In addition, the creature can take either an action or a bonus action on its turn, not both. These effects last for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Bonus Actions**

- **_Rearrange Stone._** The stone golem rearranges some of the stone comprising its body, choosing one of the following arrangements. The arrangement lasts until the golem ends the effect as a bonus action, uses this bonus action again, or until it is incapacitated.
  - **Jagged Stones.** The golem turns several of the stones on its body to point outward. Its AC is reduced by 2, and each time a creature within 5 feet of the golem hits it with a melee attack, the attacker takes 5 (2d4) piercing damage.
  - **Protective Slabs.** The golem slides several flat stones around its body to protect its vulnerable areas. Its speed is reduced by 10 feet, and each time it takes damage, the damage is reduced by 5 (2d4).

### Gorgon (CR 5)

_Large Monstrosity_

- **Armor Class** 18 (natural armor)
- **Hit Points** 96
- **Speed** 40 ft.
- **Perception** 15
- **Stealth** 10
- **Resistant** Monstrosity Resilience
- **Immune** poison | petrified, poisoned
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +4 |  -4 |  +2 |  -2 |

- **_Monstrosity Resilience._** The gorgon is resistant to exhaustion and to the frightened condition.
- **_Trampling Charge._** If the gorgon moves at least 20 feet straight toward a creature and then hits it with a Gore attack on the same turn, that target must succeed on a DC 16 STR save or be knocked prone. If the target is prone, the gorgon can make one Hooves attack against it as a bonus action.

**Actions**

- **_Petrifying Breath (Recharge 5 - 6)._** The gorgon exhales poisonous, petrifying gas in a 30 - foot cone. Creatures in the area must make a DC 13 CON save. On a failure, a creature takes 21 (6d6) poison damage and is restrained as it begins to turn to stone. On a success, a creature takes half the damage and isn't restrained. A restrained creature must repeat the save at the end of its next turn. On a success, the effect ends on the creature. On a failure, the creature is petrified until freed by the greater restoration spell or other magic.
- **_Multiattack._** The gorgon makes one Gore attack and one Hooves attack.
- **_Gore._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 18 (2d12+5) piercing damage.
- **_Hooves._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 16 (2d10+5) bludgeoning damage.

**Reactions**

- **_Poisonous Retort._** When the gorgon is hit by an attack from a creature it can see within 10 feet of it, the gorgon can snort angrily, releasing a puff of poisonous gas at the creature. The attacker must succeed on a DC 16 CON save or be poisoned until the end of its next turn.

### Gray Ooze (CR 1/2)

_Medium Ooze_

- **Armor Class** 8
- **Hit Points** 29
- **Speed** 15 ft., climb 15 ft.
- **Perception** 8
- **Stealth** 12
- **Vulnerable** cold
- **Resistant** acid, fire | Ooze Resilience
- **Immune** Ooze Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  -2 |  +3 |  -5 |  -2 |  -4 |

- **_Amorphous._** The ooze can move through a space as narrow as 1 inch wide without squeezing.
- **_Corrode Metal._** Any nonmagical weapon made of metal that hits the ooze corrodes. After dealing damage, the weapon takes a permanent and cumulative -1 penalty to damage rolls. If its penalty drops to -5, the weapon is destroyed. Nonmagical ammunition made of metal that hits the ooze is destroyed after dealing damage. The ooze can eat through 2 - inch - thick, nonmagical metal in 1 round.
- **_False Appearance._** While the ooze remains motionless, it is indistinguishable from ordinary fresh or curing mortar.
- **_Ooze Nature._** The ooze doesn't require sleep.
- **_Ooze Resilience._** The ooze is resistant to the grappled and restrained conditions, and it is immune to exhaustion and to the blinded, charmed, deafened, frightened, and prone conditions.
- **_Spider Climb._** The ooze can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Pseudopod._** _Melee Weapon Attack:_ +3 to hit, reach 10 ft., one target. _Hit:_ 3 (1d4+1) bludgeoning damage plus 7 (2d6) acid damage, and if the target is wearing nonmagical metal armor, the armor is partly corroded and takes a permanent and cumulative -1 penalty to the AC it offers. Armor reduced to an AC of 10 is destroyed.

**Reactions**

- **_Solidify._** When the ooze is hit by an attack, it can partially solidify its body, reducing the damage it takes by 2 (1d4). If it has taken fire damage since the start of its last turn, the damage it takes is reduced by 3 (1d6) instead. The ooze can't use this reaction if it has taken cold damage since the start of its last turn.

### Grick (CR 2)

_Medium Monstrosity_

- **Armor Class** 14 (natural armor)
- **Hit Points** 57
- **Speed** 30 ft., climb 30 ft.
- **Perception** 12
- **Stealth** 12
- **Resistant** bludgeoning | Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +0 |  -4 |  +2 |  -3 |

- **_Monstrosity Resilience._** The grick is resistant to exhaustion and to the frightened condition.
- **_Spider Climb._** The grick can climb difficult surfaces, including upside ceilings, without needing to make an ability check.
- **_Stone Camouflage._** The grick's Stealth is 17 in rocky terrain.

**Actions**

- **_Multiattack._** The grick makes one Beak attack and one Tentacles attack.
- **_Beak._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 9 (2d6+2) piercing damage.
- **_Tentacles._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 12 (4d4+2) piercing damage.

### Griffon (CR 2)

_Large Monstrosity (Animal)_

- **Armor Class** 12
- **Hit Points** 63
- **Speed** 30 ft., fly 80 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +3 |  -4 |  +1 |  -1 |

- **_Heightened Sight._** The griffon's Perception is 18 when perceiving by sight.
- **_Monstrosity Resilience._** The griffon is resistant to exhaustion and to the frightened condition.
- **_Pack Tactics._** The griffon has advantage on attack rolls against a creature if at least one of the griffon's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Pounce._** If the griffon moves at least 20 feet straight toward a creature and then hits it with a Claws attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the griffon can make one Beak attack against it as a bonus action.

**Actions**

- **_Multiattack._** The griffon makes one Beak attack and one Claws attack.
- **_Beak._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (1d8+4) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.

### Grimlock (CR 1/4)

_Medium Humanoid_

- **Armor Class** 11
- **Hit Points** 17
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 13
- **Vulnerable** thunder | deafened
- **Immune** blinded
- **Senses** keensense 30 ft. (can't sense beyond this radius)
- **Languages** Dwarvish, Undercommon

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -1 |  +1 |  -2 |

- **_Heightened Hearing and Smell._** The grimlock's Perception is 16 when perceiving by hearing or smell.
- **_Stone Camouflage._** The grimlock's Stealth is 18 while in rocky terrain.
- **_Suppressed Senses._** The grimlock can't use its keensense while deafened and unable to smell.

**Actions**

- **_Spiked Club._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) bludgeoning damage plus 2 (1d4) piercing damage.

**Bonus Actions**

- **_Strange Bauble._** The grimlock reaches into a pocket, pulls out a small object, and throws it at a creature the grimlock can sense within 30 feet. The grimlock chooses one of the following objects:
  - **Flashing Rock.** The grimlock throws a warm, scintillating rock at the target that bursts with a myriad of colors. The target must succeed on a DC 11 DEX save or be blinded until the end of its next turn.
  - **Illusory Dancer.** The grimlock throws a small disk that emits a blurry, fractured illusion of a graceful, humanoid dancer. The target must succeed on a DC 11 CHA save or be incapacitated until the end of its next turn as it is mesmerized by the dance.
  - **Whirling Death.** The grimlock throws a small, bladed gear that grows larger and larger as it travels toward the target, threatening to slice the target into pieces. The target must succeed on a DC 11 WIS save or be frightened until the end of its next turn. On a success, the target realizes the gear's growth was a magical, illusory effect and that the gear never increased in size.

### Hags

#### Ambush Hag (CR 9)

_Medium Fey_

- **Armor Class** 16 (natural armor)
- **Hit Points** 156
- **Speed** 30 ft., climb 30 ft.
- **Perception** 16
- **Stealth** 18
- **Resistant** Fey Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft.
- **Languages** Common, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +8 |  +3 |  +3 |  +2 |  +8 |

- **_Fey Resilience._** The ambush hag is resistant to the charmed and unconscious conditions.
- **_Mimicry._** The hag can mimic Animal sounds and Humanoid voices. A creature that hears the sounds can tell they are imitations with a successful DC 16 WIS (Insight) check.
- **_Spider Climb._** The ambush hag can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Multiattack._** The ambush hag makes two Claw attacks or three Poison Spray attacks. It can replace one attack with a use of Spellcasting.
- **_Claw._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage plus 18 (4d8) poison damage, and the target must succeed on a DC 16 CON save or be paralyzed for 1 minute. The creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Poison Spray._** _Ranged Spell Attack:_ +8 to hit, range 60 ft., one target. _Hit:_ 22 (4d8+4) poison damage, and the target must succeed on a DC 16 STR save or be restrained until the end of its next turn.
- **_Spellcasting._** The ambush hag casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 16):
  - At will: _message_, _minor illusion_, _prestidigitation_
  - 3/day each: _blur_, _charm_, _hallucinatory terrain_ (as an action)
  - 1/day each: _hypnotic pattern_, _major image_, _seeming_

**Bonus Actions**

- **_Illusory Appearance._** The hag covers itself and anything it is wearing or carrying with a magical illusion that makes it look like another creature of its general size and humanoid shape. The illusion ends if the hag takes a bonus action to end it or if the hag dies.

  The changes wrought by this effect fail to hold up to physical inspection. For example, the hag could appear to have smooth skin, but someone touching it would feel its rough flesh. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 20 INT (Investigation) check to discern that the hag is disguised.

#### Green Hag (CR 3)

_Medium Fey_

- **Armor Class** 16 (natural armor)
- **Hit Points** 76
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 13
- **Resistant** Fey Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +3 |  +1 |  +2 |  +6 |

- **_Amphibious._** The hag can breathe air and water.
- **_Fey Resilience._** The hag is resistant to the charmed and unconscious conditions.
- **_Mimicry._** The hag can mimic Animal sounds and Humanoid voices. A creature that hears the sounds can tell they are imitations with a successful DC 14 WIS (Insight) check. Speak with Beasts. The hag can communicate with Beasts as if they shared a language.

**Actions**

- **_Multiattack._** The hag makes two Claw or Torment attacks. If two attacks hit one creature, the target must succeed on a DC 14 WIS save or be overwhelmed with pain and have disadvantage on attack rolls until the end of its next turn.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage.
- **_Torment._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 14 (3d6+4) psychic damage.
- **_Poisonous Allies (1/Day)._** The hag magically calls 1 **giant spider**, 2 **giant poisonous snakes**, or 2d4 **poisonous snakes**. They arrive in 1d4 rounds, acting as allies of the hag and obeying its spoken commands. The creatures remain for 1 hour, until the hag dies, or until the hag dismisses them as a bonus action.
- **_Invisible Passage._** The hag magically turns invisible until it attacks or casts a spell, or until its concentration ends (as if concentrating on a spell). While invisible, it leaves no physical evidence of its passage and can be tracked only by magic. Any equipment it wears or carries is invisible with it.
- **_Spellcasting._** The hag casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 14).
  - At will: _dancing lights_, _minor illusion_
  - 1/day: _bestow curse_

**Bonus Actions**

- **_Illusory Appearance._** The hag covers itself and anything it is wearing or carrying with a magical illusion that makes it look like another creature of its general size and Humanoid shape. The illusion ends if the hag takes a bonus action to end it or if the hag dies.

  The changes wrought by this effect fail to hold up to physical inspection. For example, the hag could appear to have smooth skin, but someone touching it would feel its rough flesh. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 20 INT (Investigation) check to discern that the hag is disguised.

#### Night Hag (CR 5)

_Medium Fiend_

- **Armor Class** 17 (natural armor)
- **Hit Points** 104
- **Speed** 30 ft.
- **Perception** 15
- **Stealth** 15
- **Resistant** cold, fire; bludgeoning, piercing, and slashing damage from onmagical attacks
- **Immune** charmed, unconscious
- **Senses** truesight 120 ft.
- **Languages** Abyssal, Common, Infernal, Primordial

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +3 |  +3 |  +2 |  +6 |

- **_Magic Resistance._** The hag has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The night hag can use Cause Sorrow. It then makes two Claw or Arcane Bolt attacks. It can replace one Claw or Arcane Bolt attack with a use of Spellcasting.
- **_Claw (Hag Form Only)._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 18 (4d6+4) slashing damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 19 (3d10+3) force damage.
- **_Cause Sorrow._** One creature the hag can see within 10 feet of it must succeed on a DC 14 CHA save or be filled with sorrow for 1 minute. While filled with sorrow, a creature is incapacitated and experiences visions or memories of sorrowful events. The target can repeat the save at the end of each of its turns (if conscious) or end of each hour (if unconscious), ending the effect on itself on a success.

  For each hour an unconscious creature is affected, its HP maximum is reduced by 5 (1d10). This reduction lasts until removed by the greater restoration spell or similar magic. The creature dies if this effect reduces its HP maximum to 0. If an unconscious creature suffers from least 1 hour, it doesn't gain any benefits from the rest. The hag can have only one creature filled with sorrow at a time. If it uses Cause Sorrow on another, the effect on the previous creature ends.Cause Sorrow for at

- **_Spellcasting._** The hag casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 14).
  - At will: _ray of enfeeblement_, _silent image_
  - 2/day each: _detect thoughts_, _plane shift_ (self only), _sleep_

**Bonus Actions**

- **_Change Shape._** The hag magically transforms into Medium or smaller Humanoid, or back into its true form, which is Fiend. Its statistics, other than its size, are the same in each form. Any equipment it is wearing or carrying transforms with it. It reverts to its true form if it dies.
- **_Etherealness._** The hag magically enters the Ethereal Plane from the Material Plane, or vice versa. The hag can use Cause Sorrow on an unconscious creature not on its plane; otherwise, the hag can't affect or be affected by anything on the other plane.

#### Sea Hag (CR 2)

_Medium Fey_

- **Armor Class** 14 (natural armor)
- **Hit Points** 51
- **Speed** 30 ft., swim 40 ft.
- **Perception** 11
- **Stealth** 13
- **Resistant** Fey Resilience
- **Immune** frightened
- **Senses** darkvision 60 ft.
- **Languages** Aquan, Common, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  +1 |  +1 |  +1 |

- **_Amphibious._** The sea hag can breathe air and water.
- **_Fey Resilience._** The sea hag is resistant to the charmed and unconscious conditions.
- **_Horrific Appearance._** When a Humanoid that can see the hag's true form starts its turn within 30 feet of the hag, the hag can force it to make a DC 12 WIS save. On a failure, the creature is frightened until the start of its next turn. Unless surprised or the revelation of the hag's true form is sudden, such as the ending of Illusory Appearance, a creature can avert its eyes to avoid the save at the start of its turn. If the creature does so, it can't see the hag until the start of its next turn, when it can avert its eyes again. If the creature looks at the hag in the meantime, it must immediately make the save.
- **_Underwater Camouflage._** The hag's Stealth is 18 while underwater and not using Illusory Appearance.

**Actions**

- **_Multiattack._** The hag uses Death Glare. It then makes two Claw attacks.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.
- **_Death Glare._** One creature the hag can see within 30 feet of it must succeed on a DC 12 WIS save or be frightened until the end of its next turn. If the target is already frightened and fails the save, it is reduced to 0 HP instead. If reduced to 0 HP in this way, the creature is stable.

**Bonus Actions**

- **_Illusory Appearance._** The hag covers itself and anything it is wearing or carrying with a magical illusion that makes it look like another creature of its general size and Humanoid shape. The illusion ends if the hag takes a bonus action to end it or if the hag dies.

  The changes from this effect fail to hold up to physical inspection. For example, the hag could appear to have smooth skin, but someone touching it would feel its scaly flesh. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 20 INT (Investigation) check to discern that the hag is disguised.

**Reactions**

- **_Barnacle Block._** When the hag takes damage from a source it can see, the hag can shift the barnacles and scales on its body to absorb some of the impact, reducing the damage by 4 (1d8).

### Harpy (CR 1)

_Medium Monstrosity_

- **Armor Class** 13
- **Hit Points** 38
- **Speed** 20 ft., fly 40 ft.
- **Perception** 10
- **Stealth** 13
- **Resistant** charmed | Monstrosity Resilience
- **Senses** darkvision 120 ft.
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +3 |  +1 |  -2 |  +0 |  +1 |

- **_Monstrosity Resilience._** The harpy is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The harpy makes two Claw or Screech attacks. If both Screech attacks hit one Giant or Humanoid, the target has disadvantage on the next save it makes against the harpy's Luring Song before the start of the harpy's next turn.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage.
- **_Screech._** _Ranged Spell Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 8 (2d6+1) thunder damage.

**Bonus Actions**

- **_Luring Song._** The harpy sings a magical melody. Every Humanoid and Giant within 300 feet of the harpy that can hear the song must succeed on a DC 11 WIS save or be charmed until the song ends. The harpy must use a bonus action on its subsequent turns to continue singing. It can stop singing at any time. The song ends if the harpy is incapacitated.

  While charmed by the harpy, a target is incapacitated and ignores the songs of other harpies. If the charmed target is more than 5 feet away from the harpy, the target must move on its turn toward the harpy by the most direct route, trying to get within 5 feet. It doesn't avoid opportunity attacks, but before moving into damaging terrain, such as lava or a pit, and whenever it takes damage from a source other than the harpy, the target can repeat the save. A charmed target can also repeat the save at the end of each of its turns. If the save is successful, the effect ends on it. A target that successfully saves is immune to this harpy's song for the next 24 hours.

### Hell Hound (CR 3)

_Medium Fiend_

- **Armor Class** 15 (natural armor)
- **Hit Points** 76
- **Speed** 50 ft.
- **Perception** 15
- **Stealth** 11
- **Immune** fire | charmed, frightened
- **Senses** darkvision 60 ft.
- **Languages** understands Infernal but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +1 |  +2 |  -2 |  +3 |  -2 |

- **_Pack Tactics._** The hound has advantage on an attack roll against a creature if at least one of the hound's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Prey Sense._** The hound can pinpoint, by scent, the location of Medium and smaller creatures within 30 feet of it.

**Actions**

- **_Multiattack._** The hell hound makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage plus 7 (2d6) fire damage.
- **_Fire Breath (Recharge 5 - 6)._** The hound exhales fire in a 15foot cone. Each creature in that area must make a DC 13 DEX save, taking 21 (6d6) fire damage on a failed save, or half as much damage on a successful one.

### Hippocampus (CR 1)

_Large Beast_

- **Armor Class** 11
- **Hit Points** 42
- **Speed** 10 ft., swim 60 ft.
- **Perception** 13
- **Stealth** 11
- **Resistant** cold
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +1 |  -4 |  +1 |  -1 |

- **_Amphibious._** The hippocampus can breathe air and water.
- **_Shared Breath._** The hippocampus's gills pull more air from the water than the hippocampus needs, expelling the excess as bubbles down its neck and across its back. If an air - breathing creature is riding the hippocampus, these bubbles can provide that creature a supply of fresh air when the hippocampus isn't in combat or traveling at a fast pace.

**Actions**

- **_Multiattack._** The hippocampus makes one Bite attack and one Tail Slap attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d6+4) piercing damage.
- **_Tail Slap._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 8 (1d8+4) bludgeoning damage.

**Bonus Actions**

- **_Rearing Kick._** The hippocampus rears up and kicks its forelegs at one creature it can see within 5 feet of it. The target must succeed on a DC 14 STR save or be knocked prone or pushed up to 10 feet away from the hippocampus (the hippocampus's choice).

### Hippogriff (CR 1)

_Large Monstrosity (Animal)_

- **Armor Class** 11
- **Hit Points** 44
- **Speed** 40 ft., fly 60 ft.
- **Perception** 13
- **Stealth** 10
- **Resistant** Monstrosity Resilience
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -4 |  +3 |  -1 |

- **_Heightened Sight._** The hippogriff's Perception is 18 when perceiving by sight.
- **_Monstrosity Resilience._** The hippogriff is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The hippogriff makes one Beak attack and one Claws attack.
- **_Beak._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (1d10+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.

**Bonus Actions**

- **_Dive (Recharge 5 - 6)._** While flying, the hippogriff dives onto a creature below it. The hippogriff moves at least 20 feet in a straight line toward a creature it can see. The target must succeed on a DC 13 STR save or take 7 (2d6) bludgeoning damage and be knocked prone.

### Hivebound (CR 5)

_Small Monstrosity_

- **Armor Class** 15 (natural armor)
- **Hit Points** 108
- **Speed** 25 ft., fly 40 ft.
- **Perception** 12
- **Stealth** 12
- **Resistant** bludgeoning | charmed | Monstrosity Resilience
- **Immune** blinded
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** understands Common but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +3 |  +4 |  -2 |  +2 |  -2 |

- **_Collective Mind._** The hivebound's individual insects and swarms under its control are connected via a hive mind. It can telepathically communicate with any of its individual insects and swarms within 1 mile of it, and it can't be surprised. It can have up to five swarms of insects under its control at a time.
- **_Monstrosity Resilience._** The hivebound is resistant to exhaustion and to the frightened condition.
- **_Reinforced Mind._** If the hivebound starts its turn afflicted by an ongoing effect that allows a repeated INT, WIS, or CHA save to end the effect, such as the hold spell, the hivebound can make the save at the start of the turn instead of the end and has advantage on the save.

**Actions**

- **_Multiattack._** The hivebound makes one Bite attack and two Claw attacks, or it makes three Spit Insect attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage plus 10 (3d6) poison damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage.
- **_Spit Insect._** _Ranged Weapon Attack:_ +6 to hit, range 30/120 ft., one target. _Hit:_ 5 (1d4+3) piercing damage plus 7 (2d6) poison damage, and the target must succeed on a DC 15 DEX save or be pestered until the end of its next turn. A pestered creature has disadvantage on the next attack roll it makes before the pester ends.
- **_Swarm Breath (Recharge 5 - 6)._** The hivebound exhales stinging insects in a 30 - foot cone. Each creature in the area must make a DC 15 DEX save, taking 10 (4d4) piercing damage and 17 (5d6) poison damage on a failed save, or half as much damage on a successful one. A swarm of insects under the hivebound's control then forms in an unoccupied space in that area.

**Bonus Actions**

- **_Swift Flight._** The hivebound flies up to half its speed without provoking opportunity attacks.

### Homunculus (CR 1)

_Tiny Construct_

- **Armor Class** 13
- **Hit Points** 34
- **Speed** 20 ft., fly 40 ft.
- **Perception** 12
- **Stealth** 15
- **Immune** Construct Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +3 |  +0 |  +2 |  +0 |  -2 |

- **_Bound Construct._** The homunculus serves another creature as a familiar, forming a magic, telepathic bond with that willing companion. While the two are bonded and on the same plane of existence, the companion can sense what the homunculus senses and the two can communicate telepathically. While the homunculus is within 100 feet of the companion, it can use a reaction to deliver any spell the companion casts that has a range of touch. If the spell requires an attack roll, the homunculus uses the companion's spell attack modifier for the roll. While the homunculus is within 10 feet of its companion, the companion has advantage on INT (Arcana) and INT (Investigation) checks. At any time and for any reason, the homunculus can end its service as a familiar, ending the telepathic bond.
- **_Construct Nature._** The homunculus doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The homunculus is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d4+3) piercing damage plus 5 (2d4) poison damage, and the target must succeed on a DC 12 CON save or be poisoned for 1 minute. If the save fails by 5 or more, the target is instead poisoned for 5 (1d10) minutes and unconscious while poisoned in this way.

### Hydra (CR 8)

_Huge Dragon_

- **Armor Class** 15 (natural armor)
- **Hit Points** 166
- **Speed** 30 ft., swim 30 ft.
- **Perception** 16
- **Stealth** 14
- **Resistant** Multiple Heads
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +1 |  +5 |  -4 |  +0 |  -2 |

- **_Hold Breath._** The hydra can hold its breath for 1 hour.
- **_Multiple Heads._** The hydra has five heads and is resistant to the blinded, charmed, deafened, frightened, stunned, and unconscious conditions.

  Whenever the hydra takes 25 or more damage in a single turn, one of its heads dies. If all its heads die, the hydra dies. At the end of its turn, it grows two heads for each of its heads that died since its last turn, unless it has taken fire damage since its last turn. The hydra regains 10 HP for each head regrown in this way.

- **_Reactive Heads._** For each head the hydra has beyond one, it gets an extra reaction that can be used only for opportunity attacks.
- **_Wakeful._** While the hydra sleeps, at least one of its heads is awake.

**Actions**

- **_Multiattack._** The hydra makes as many Bite attacks as it has heads.
- **_Bite._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 10 (1d10+5) piercing damage.
- **_Noxious Breath (Recharge Special)._** The hydra exhales poisonous gas in a 30 - foot cone. Each creature in that area must make a DC 16 CON save, taking 40 (9d8) poison damage on a failed save, or half as much damage on a successful one. While the hydra has five or more heads, this action has a recharge of 6. The recharge range increases for each head the hydra has below five. For example, a hydra that starts its turn with two heads can recharge this feature on a 3, 4, 5, or 6.

**Bonus Actions**

- **_Bloody Burst (Has Fewer Than Five Heads)._** The hydra squeezes the stumps of its severed heads, spraying blood and gore. Each creature within 5 feet of the hydra must succeed on a DC 16 CON save or be incapacitated until the end of its next turn and poisoned for 1 minute. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

### Insatiable Brood (CR 3)

_Medium Swarm of Tiny Aberrations_

- **Armor Class** 13
- **Hit Points** 63
- **Speed** 0 ft., fly 50 ft.
- **Perception** 11
- **Stealth** 15
- **Resistant** cold | Swarm Resilience
- **Immune** Swarm Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands Void Speech but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +5 |  +1 |  -3 |  +1 |  -2 |

- **_Aberrant Resilience._** The insatiable brood has advantage on saves against spells or effects that would alter its form.
- **_Magic Bites._** The insatiable brood's Bites attacks are magical.
- **_Siege Monster._** The insatiable brood deals double damage to objects and structures.
- **_Swarm._** The insatiable brood can occupy another creature's space and vice versa, and the brood can move through any opening large enough for a Tiny creature. The brood can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.
- **_Void Dweller._** The insatiable brood doesn't require air, food, drink, or sleep, and it is immune to the effects of Void terrain. In addition, it can fly through the Void as if through air.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +5 to hit, reach 0 ft., one creature in the swarm's space. _Hit:_ 14 (4d6) piercing damage plus 18 (4d8) force damage, or 7 (2d6) piercing damage plus 9 (2d8) force damage if the insatiable brood has half its HP or fewer.

**Bonus Actions**

- **_Void Gaze._** The insatiable brood turns all its individual heads in one direction, and its hundreds of Void - filled eyes stare at one creature the brood can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn. If the target fails the save by 5 or more, it suffers a random, short - term dread effect for 1 minute.

### Invisible Stalker (CR 6)

_Medium Elemental_

- **Armor Class** 14
- **Hit Points** 121
- **Speed** 50 ft., fly 50 ft. (hover)
- **Perception** 18
- **Stealth** 22
- **Resistant** Elemental Resilience
- **Immune** Elemental Resilience
- **Senses** darkvision 60 ft.
- **Languages** Auran, understands Common but can't speak it

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +4 |  +2 |  +0 |  +5 |  +0 |

- **_Elemental Nature._** The invisible stalker doesn't require air, food, drink, or sleep.
- **_Elemental Resilience._** The stalker is resistant to bludgeoning, piercing, and slashing damage from nonmagical attacks. In addition, it is immune to poison damage, to exhaustion, and to the grappled, paralyzed, petrified, poisoned, prone, restrained, and unconscious conditions.
- **_Faultless Tracker._** At the end of each long rest, the invisible stalker can choose a creature it knows or has seen to be its quarry. A stalker summoned by another creature can choose only the quarry specified by its summoner, but the stalker also knows the location of its summoner while it continues to serve the summoner. The stalker always knows the direction and distance to its quarry, provided the two are on the same plane of existence.
- **_Invisibility._** The stalker is invisible. The condition's effect on DEX (Stealth) checks has been included in the above Stealth value.

**Actions**

- **_Multiattack._** The stalker makes two Slam attacks.
- **_Slam._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage plus 9 (2d8) cold damage. If the target is the stalker's quarry, the target must succeed on a DC 15 DEX save or its speed is halved until the end of its next turn.

**Bonus Actions**

- **_Steal Breath._** The invisible stalker calls on the air in the lungs of one breathing creature it can see within 30 feet of it, causing the air to leave the creature. The target must succeed on a DC 15 CON save or be unable to speak or cast spells with verbal components until the end of its next turn. A creature that fails the save by 5 or more is also incapacitated and suffocating for the duration, as it coughs uncontrollably.

### Kobolds

#### Kobold (CR 1/8)

_Small Humanoid_

- **Armor Class** 12
- **Hit Points** 9
- **Speed** 30 ft.
- **Perception** 8
- **Stealth** 14
- **Senses** darkvision 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +4 |  -1 |  -1 |  -2 |  -1 |

- **_Pack Tactics._** The kobold has advantage on attack rolls against a creature if at least one of the kobold's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Sunlight Sensitivity._** While in sunlight, the kobold has disadvantage on attack rolls, and its Perception is 3 when perceiving by sight.

**Actions**

- **_Dagger._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 4 (1d4+2) piercing damage.
- **_Sling._** _Ranged Weapon Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage.

**Bonus Actions**

- **_Scurry._** The kobold moves up to 15 feet without provoking opportunity attacks. If the kobold is aware of traps in the area, the kobold can choose if this movement triggers any of them.

#### Kobold Swiftblade (CR 3)

_Small Humanoid_

- **Armor Class** 15 (leather armor)
- **Hit Points** 80
- **Speed** 30 ft., climb 15 ft.
- **Perception** 12
- **Stealth** 16
- **Senses** darkvision 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +6 |  +0 |  +1 |  +2 |  +0 |

- **_Pack Tactics._** The kobold has advantage on attack rolls against a creature if at least one of the kobold's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Sunlight Sensitivity._** While in sunlight, the kobold has disadvantage on attack rolls, and its Perception is 7 when perceiving by sight.

**Actions**

- **_Multiattack._** The kobold swiftblade makes two Scimitar or Hand Crossbow attacks.
- **_Scimitar._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage plus 7 (2d6) poison damage.
- **_Hand Crossbow._** _Ranged Weapon Attack:_ +6 to hit, range 30/120 ft., one target. _Hit:_ 7 (1d6+4) piercing damage plus 7 (2d6) poison damage.

**Bonus Actions**

- **_Hidden Scurry._** The swiftblade moves up to 15 feet without provoking opportunity attacks, and if it moves into a lightly or heavily obscured area, it takes the Hide action, using its **Stealth** value as the result of the check. If the swiftblade is aware of traps in the area, it can choose if this movement triggers any of them.

#### Kobold Witch (CR 5)

_Small Humanoid_

- **Armor Class** 13
- **Hit Points** 126
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 13
- **Senses** darkvision 60 ft.
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +3 |  +1 |  +0 |  +2 |  +7 |

- **_Pack Tactics._** The kobold has advantage on attack rolls against a creature if at least one of the kobold's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Sunlight Sensitivity._** While in sunlight, the kobold has disadvantage on attack rolls, and its Perception is 7 when perceiving by sight.

**Actions**

- **_Multiattack._** The kobold witch makes three Eldritch Burst attacks. It can replace one attack with a use of Spellcasting.
- **_Eldritch Burst._** _Melee or Ranged Spell Attack:_ +7 to hit, reach 5 ft. or range 60 ft., one target. _Hit:_ 13 (2d8+4) force damage.
- **_Spellcasting._** The kobold witch casts one of the following spells, using CHA as the spellcasting ability (spell save DC 15).
  - At will: _disguise self_, _druidcraft_, _guidance_
  - 2/day each: _command_, _ray of enfeeblement_
  - 1/day: _bestow curse_

**Bonus Actions**

- **_Scurry._** The kobold moves up to 15 feet without provoking opportunity attacks. If the kobold is aware of traps in the area, the kobold can choose if this movement triggers any of them.
- **_Witch's Cauldron._** The kobold witch ladles steaming brew out of a small cauldron it is holding and flings the substance at one friendly creature it can see within 15 feet of it. The target gains 5 (2d4) temporary HP until the start of the witch's next turn.

**Reactions**

- **_Hex._** When a creature the kobold witch can see within 60 feet of it makes an ability check, attack roll, or save, the target must roll a d6 and subtract the number rolled from that ability check, attack roll, or save.

### Kraken (CR 23)

_Gargantuan Monstrosity_

- **Armor Class** 18 (natural armor)
- **Hit Points** 475
- **Speed** 20 ft., swim 60 ft.
- **Perception** 21
- **Stealth** 17
- **Resistant** Monstrosity Resilience
- **Immune** lightning; bludgeoning, piercing, and slashing damage from onmagical attacks | frightened, paralyzed
- **Senses** keensense 60 ft., truesight 120 ft.
- **Languages** understands Abyssal, Celestial, Infernal, and Primordial but can't speak, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +17 |  +7 | +14 | +13 | +11 |  +5 |

- **_Amphibious._** The kraken can breathe air and water.
- **_Freedom of Movement._** The kraken ignores difficult terrain, and magical effects can't reduce its speed or cause it to be restrained. It can spend 5 feet of movement to escape from nonmagical restraints or being grappled.
- **_Legendary Resistance (3/Day)._** If the kraken fails a save, it can choose to succeed instead.
- **_Monstrosity Resilience._** The kraken is resistant to exhaustion and to the frightened condition.
- **_Siege Monster._** The kraken deals double damage to objects and structures.

**Actions**

- **_Multiattack._** The kraken makes three Tentacle attacks. It can replace one Tentacle attack with a Bite attack.
- **_Bite._** _Melee Weapon Attack:_ +17 to hit, reach 5 ft., one target. _Hit:_ 28 (4d8+10) piercing damage. If the target is a Large or smaller creature grappled by the kraken, that creature is swallowed, and the grapple ends. While swallowed, the creature is blinded and restrained, it has total cover against attacks and other effects outside the kraken, and it takes 42 (12d6) acid damage at the start of each of the kraken's turns. If the kraken takes 50 damage or more on a single turn from a creature inside it, the kraken must succeed on a DC 24 CON save at the end of that turn or regurgitate all swallowed creatures, which fall prone in a space within 10 feet of the kraken. If the kraken dies, a swallowed creature is no longer restrained by it and can escape from the corpse using 15 feet of movement, exiting prone.
- **_Tentacle._** _Melee Weapon Attack:_ +17 to hit, reach 30 ft., one target. _Hit:_ 24 (4d6+10) bludgeoning damage, and the target is grappled (escape DC 22). Until this grapple ends, the target is restrained. The kraken has ten tentacles, each of which can grapple one target.
- **_Ink Cloud (Recharge 6)._** While underwater, the kraken expels an ink cloud in a 30 - foot - radius centered on the kraken. The cloud spreads around corners, and the area is heavily obscured. Each creature in the area when it first appears must make a DC 22 CON save, taking 110 (20d10) poison damage on a failed save, or half as much damage on a successful one. A creature that enters the ink cloud for the first time on a turn or starts its turn there must succeed on a DC 22 CON save or take 11 (2d10) poison damage and be poisoned until the start of its next turn. The cloud lasts for 1 minute or until dispersed by a strong current.

**Bonus Actions**

- **_Fling._** One Large or smaller object held or creature grappled by the kraken is thrown up to 60 feet in a random direction and knocked prone. If a thrown target strikes a solid surface, the target takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target is thrown at another creature, that creature must succeed on a DC 22 DEX save or take the same damage and be knocked prone.
- **_Reel._** The kraken pulls up to two creatures grappled by it up to 25 feet straight toward it.

**Legendary Actions**

The kraken can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The kraken regains spent legendary actions at the start of its turn.

- **_Swim._** The kraken swims up to half its swimming speed without provoking opportunity attacks.
- **_Tentacle Attack._** The kraken makes one Tentacle attack.
- **_Lightning Storm (Costs 2 Actions)._** The Kraken Magically Calls Bolts Of lightning to strike up to two creatures it can see or sense within 120 feet of it. Each creature must make a DC 22 DEX save, taking 22 (4d10) lightning damage on a failed save, or half as much damage on a successful one.

### Lamia (CR 4)

_Large Monstrosity_

- **Armor Class** 13 (natural armor)
- **Hit Points** 95
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 13
- **Resistant** charmed | Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  +2 |  +2 |  +5 |

- **_Badlands Strider._** Difficult terrain composed of sand, mud, or rock doesn't cost the lamia extra movement. In addition, the lamia leaves no tracks or other traces of its passage when moving through sandy, muddy, or rocky terrain.
- **_Monstrosity Resilience._** The lamia is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The lamia makes two Hooves attacks and one Dagger attack, or it makes three Arcane Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Dagger._** _Melee or Ranged Weapon Attack:_ +5 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 5 (1d4+3) piercing damage.
- **_Hooves._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 14 (2d10+3) bludgeoning damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 12 (2d8+3) force damage.
- **_Spellcasting._** The lamia casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 13).
  - At will: _minor illusion_, _silent image_, _suggestion_
  - 3/day each: _charm_, _command_, _major image_
  - 1/day: _compulsion_

**Bonus Actions**

- **_Intoxicating Gaze._** The lamia gazes at one creature it can see within 30 feet of it. The target must succeed on a DC 13 CHA save or be charmed until the end of its next turn and cursed for 1 hour. While cursed, the target has disadvantage on WIS saves and on all ability checks.

### Lantern Hagfish (CR 1/8)

_Small Aberration_

- **Armor Class** 11
- **Hit Points** 9
- **Speed** 15 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 11
- **Resistant** cold | grappled, prone, restrained | Aberrant Resilience
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  +0 |  -4 |  +0 |  -5 |

- **_Aberrant Resilience._** The lantern hagfish is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Bioluminescent Slime._** The lantern hagfish sheds bright light in a 5- to 20 - foot radius and dim light for an additional number of feet equal to the chosen radius. The hagfish can alter the radius as a bonus action. In addition, the hagfish has advantage on attack rolls against a creature if at least one other hagfish is within 5 feet of the creature and that other hagfish isn't incapacitated.
- **_Void Dweller._** The lantern hagfish doesn't require air or sleep, and it is immune to the effects of Void terrain. In addition, it can swim through the Void as if through water.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) piercing damage. If the target is a prone creature that isn't a Construct or Undead, the hagfish can burrow into the creature's flesh. While burrowed into a creature, the hagfish can't attack, and at the start of each of the hagfish's turns, the target loses 3 (1d4+1) HP as the hagfish consumes it from the inside. The burrowed hagfish moves with the target whenever the target moves, requiring none of the hagfish's movement. It can detach itself by spending 5 feet of its movement on its turn. It does so after it consumes 6 HP worth of flesh from the target or the target dies. A creature, including the target, can take its action to extract the burrowed hagfish by succeeding on a DC 11 WIS (Medicine) check.

**Bonus Actions**

- **_Slime Slide._** While on a solid surface, the lantern hagfish slides up to 15 feet in a straight line and can move through the space of any creature without provoking opportunity attacks. Each space on that surface along that line is coated in slime until the start of the hagfish's next turn. Each creature in that line, and any creature that enters a slime - coated space for the first time on a turn must succeed on a DC 11 DEX save or fall prone.

### Liches

#### Lich (CR 21)

_Medium Undead_

- **Armor Class** 17 (natural armor)
- **Hit Points** 314
- **Speed** 30 ft.
- **Perception** 19
- **Stealth** 13
- **Resistant** cold, lightning, necrotic
- **Immune** bludgeoning, piercing, and slashing damage from nonmagical attacks | harmed, frightened, paralyzed | Undead Resilience
- **Senses** truesight 120 ft.
- **Languages** Common plus up to five other languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 | +10 | +12 |  +9 |  +3 |

- **_Arcane Mastery._** The lich can concentrate on two spells simultaneously. If it casts a third spell that requires concentration, the lich loses concentration on the oldest spell. If the lich is concentrating on two spells and loses concentration because of taking damage, it loses concentration only on the oldest spell.
- **_Legendary Resistance (3/Day)._** If the lich fails a save, it can choose to succeed instead.
- **_Rejuvenation._** If it has a phylactery, a destroyed lich gains a new body in 1d10 days, regaining all its HP and becoming active again. The new body appears within 5 feet of the phylactery.
- **_Turn Resistance._** The lich has advantage on saves against any effect that turns undead.
- **_Undead Nature._** The lich doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The lich is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The lich uses Lich's Gaze. It then makes four Arcane Death Burst attacks, or it makes three Arcane Death Burst attacks and one Death - Infused Rod attack. It can replace one attack with a use of Spellcasting.
- **_Arcane Death Burst._** _Melee or Ranged Spell Attack:_ +12 to hit, reach 5 ft. or range 120 ft., one target. _Hit:_ 23 (4d8+5) force damage plus 17 (5d6) necrotic damage.
- **_Death - Infused Rod._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 21 (4d8+3) bludgeoning damage plus 17 (5d6) necrotic damage, and the target must succeed on a DC 20 CON save or be paralyzed for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Lich's Gaze._** The lich fixes its gaze on one creature it can see within 30 feet of it. The target must succeed on a DC 20 CHA save or be charmed or frightened (the lich's choice) until the end of its next turn.
- **_Spellcasting._** The lich casts one of the following spells, using INT as the spellcasting ability (spell save DC 20).
  - At will: _detect magic_, _disguise self_, _mage hand_, _message_, _prestidigitation_
  - 3/day each: _charm_, _detect thoughts_, _dispel magic_, _invisibility_ (self only), _mirror image_
  - 2/day each: _bestow curse_, _cloudkill_, _dimension door_, _greater hold_
  - 1/day each: _plane shift_ (self only), _power word stun_, _wall of force_

**Bonus Actions**

- **_Levitate._** The lich can rise or descend vertically up to 20 feet and can remain suspended there. This bonus action works like the levitate spell, except there is no duration, and the lich doesn't need to concentrate to continue levitating each round.

**Reactions**

- **_Absorb Spell._** When a creature the lich can see within 60 feet of it casts a spell, the lich can absorb the spell's energy, countering it. This works like the counterspell spell, except the lich must always make a spellcasting ability check, no matter the spell's circle. Its ability check for this is +12. If it successfully counters the spell, the lich gains 5 temporary HP for each level of the spell.

**Legendary Actions**

The lich can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The lich regains spent legendary actions at the start of its turn.

- **_Move._** The lich moves up to its speed without provoking opportunity attacks. If the lich is levitating, it can use this legendary action to move horizontally, propelling itself with a blast of arcane power.
- **_Cast A Spell (Costs 2 Actions)._** The Lich Uses Spellcasting.
- **_Disrupt Life (Costs 3 Actions)._** Each Creature Within 20 Feet Of The lich that isn't Undead must make a DC 20 CON save, taking 21 (6d6) necrotic damage on a failed save, or half as much damage on a successful one. The lich regains HP equal to the single highest amount of necrotic damage dealt.

#### Virtuoso Lich (CR 12)

_Medium Undead_

- **Armor Class** 17 (natural armor)
- **Hit Points** 185
- **Speed** 30 ft.
- **Perception** 15
- **Stealth** 17
- **Resistant** necrotic; bludgeoning, piercing, and slashing damage from onmagical attacks
- **Immune** blinded, deafened, charmed, frightened, paralyzed | Undead Resilience
- **Senses** truesight 60 ft.
- **Languages** Common plus up to two other languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +7 |  +2 |  +2 |  +5 |  +9 |

- **_Legendary Resistance (3/Day)._** If the lich fails a save, it can choose to succeed instead.
- **_Rejuvenation._** If it has a phylactery, a destroyed lich gains a new body in 1d10 days, regaining all its HP and becoming active again. The new body appears within 5 feet of the phylactery.
- **_Turn Resistance._** The lich has advantage on saves against any effect that turns undead.
- **_Undead Nature._** The lich doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The lich is immune to poison damage, to exhaustion, and to the poisoned condition.
- **_Versatile Artist._** At the end of each long rest, the lich chooses one form of artistic expression, such as song, poetry, dance, fashion, paint, or similar. Until it finishes a long rest, the lich has immunity to one type of damage, which is associated with its artistic expression. For example, a lich expressing art through song or poetry has immunity to thunder damage, a lich expressing art through fashion has immunity to slashing damage, and a lich expressing art through paint has immunity to acid damage. This trait can't give the lich immunity to force, psychic, or radiant damage.

**Actions**

- **_Multiattack._** The virtuoso lich uses Corrupted Art. It then makes three Artistic Flourish attacks. It can replace one attack with a use of Spellcasting.
- **_Artistic Flourish._** _Melee or Ranged Spell Attack:_ +9 to hit, reach 5 ft. or range 60 ft., one target. _Hit:_ 18 (3d8+5) damage of the type chosen with the Versatile Artist trait plus 9 (2d8) force damage.
- **_Call Muse._** The lich chooses one Beast or Humanoid it can see within 30 feet of it to be its muse. The target must succeed on a DC 17 WIS save or become the lich's muse and be charmed by the lich for 1 minute. While charmed, the muse has a speed of 0 and is incapacitated as it watches or listens to the lich's artistic expression. The muse can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the lich's Call Muse for the next 24 hours. If the muse suffers harm from the lich, it is no longer charmed. The lich can have only one muse at a time. If it charms another, the effect on the previous muse ends. If the lich is within 30 feet of its muse and can see its muse, the lich has advantage on its first Artistic Flourish attack each round against a creature that isn't its muse.
- **_Corrupted Art._** The lich hums a discordant melody, paints a crumbling symbol of death in the air, performs a reality - bending pirouette, or emulates some other expression of corrupted or twisted art and targets one creature it can see, other than itself, within 60 feet. This action's effects change, depending on if the target is Undead.
- **Non - Undead.** The target must make a DC 17 WIS save. On a failure, a creature is blinded, charmed, or deafened (the lich's choice) until the end of its next turn. On a success, a creature takes half the damage and isn't incapacitated.
- **Undead.** The target regains 18 (4d8) HP. Healing that exceeds the target's HP maximum becomes temporary HP.
- **_Spellcasting._** The lich casts one of the following spells, using CHA as the spellcasting ability (spell save DC 17).
  - At will: _disguise self_, _mage hand_, _message_, _prestidigitation_
  - 3/day each: _charm_, _hideous laughter_, _hold_, _invisibility_ (self only)
  - 2/day each: _dispel magic_, _fear_, _dimension door_
  - 1/day each: _irresistible dance_, _programmed illusion_, _seeming_

**Legendary Actions**

The virtuoso lich can take 3 legendary actions, choosing from the options below. Only one legendary action can be used at a time and only at the end of another creature's turn. The lich regains spent legendary actions at the start of its turn.

- **_Call Muse._** The lich uses Call Muse.
- **_Move._** The lich moves up to its speed without provoking opportunity attacks.
- **_Cast A Spell (Costs 2 Actions)._** The Lich Uses Spellcasting.
- **_Unrestrained Art (Costs 3 Actions)._** The Lich Unleashes The Full Force of its artistic talents. Each creature with 15 feet of the lich must make a DC 17 DEX save. On a failure, a creature takes 9 (2d8) damage of the type chosen with the Versatile Artist trait and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone.

### Living Colossus (CR 15)

_Gargantuan Construct_

- **Armor Class** 18 (natural armor)
- **Hit Points** 261
- **Speed** 60 ft.
- **Perception** 17
- **Stealth** 9
- **Resistant** slashing
- **Immune** Construct Resilience
- **Senses** darkvision 120 ft., keensense 30 ft.
- **Languages** any languages the animating spirit knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  -1 | +10 |  +0 |  +2 |  +6 |

- **_Construct Nature._** The living colossus doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The living colossus is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_False Appearance._** While the living colossus remains motionless, it is indistinguishable from a normal statue or monument of the individual it represents.
- **_Immutable Form._** The living colossus is immune to any spell or effect that would alter its form.
- **_Siege Monster._** The living colossus deals double damage to objects and structures.

**Actions**

- **_Multiattack._** The living colossus makes three Slam attacks, or it makes four Spirit Blast attacks.
- **_Slam._** _Melee Weapon Attack:_ +15 to hit, reach 5 ft., one target. _Hit:_ 32 (4d10+10) bludgeoning damage.
- **_Spirit Blast._** _Ranged Spell Attack:_ +11 to hit, range 120 ft., one target. _Hit:_ 24 (4d8+6) psychic damage.
- **_Thunderous Clap (Recharge 5 - 6)._** The living colossus slams its hands together, creating a thunderous wave in a 30 - foot cone. Each creature in that area must make a DC 18 CON save, taking 59 (17d6) thunder damage on a failed save, or half as much damage on a successful one.

**Bonus Actions**

- **_Quake._** The living colossus strikes the ground with its foot. Each creature within 30 feet of the living colossus must succeed on a DC 18 STR save or be knocked prone and have the air knocked from its lungs, if it is a breathing creature, until the start of the living colossus's next turn. A creature with the air knocked from its lungs can't speak or cast spells with verbal components. If a creature fails the save by 5 or more, it is also stunned until the start of the living colossus's next turn.

**Reactions**

- **_Bolstering Spirit._** When a friendly creature the living colossus can see within 60 feet of it, other than itself, takes damage, the living colossus can share some of the life force of the spirit animating it with that friendly creature. The target gains 14 (4d6) temporary HP for 1 minute. If the target would take enough damage to reduce it to 0 HP, it instead regains 14 (4d8) HP.

### Lizardfolk

#### Lizardfolk (CR 1/2)

_Medium Humanoid_

- **Armor Class** 15 (natural armor, shield)
- **Hit Points** 22
- **Speed** 30 ft., climb 15 ft., swim 30 ft.
- **Perception** 13
- **Stealth** 14
- **Senses** -
- **Languages** Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -2 |  +3 |  -2 |

- **_Heightened Smell and Taste._** The lizardfolk's Perception is 18 when perceiving by smell or taste.
- **_Hold Breath._** The lizardfolk can hold its breath for 15 minutes.

**Actions**

- **_Multiattack._** The lizardfolk makes one Bite attack and one Heavy Club attack, or it makes two Javelin attacks.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Heavy Club._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) bludgeoning damage.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Reactions**

- **_Shoving Counter._** If a creature misses the lizardfolk with an attack and the lizardfolk is wielding a shield, the lizardfolk can shove its shield into the creature. The attacker must succeed on a DC 12 STR save or be pushed up to 10 feet away from the lizardfolk and knocked prone.

#### Lizardfolk Shaman (CR 2)

_Medium Humanoid_

- **Armor Class** 13 (natural armor)
- **Hit Points** 57
- **Speed** 30 ft., climb 15 ft., swim 30 ft.
- **Perception** 15
- **Stealth** 12
- **Resistant** poison | poisoned
- **Senses** -
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  +0 |  +5 |  +0 |

- **_Heightened Smell and Taste._** The lizardfolk's Perception is 20 when perceiving by smell or taste.
- **_Hold Breath._** The lizardfolk shaman can hold its breath for 15 minutes.

**Actions**

- **_Multiattack._** The lizardfolk makes one Bite attack and one Ritual Staff attack, or it makes two Swamp Bolt attacks.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Ritual Staff._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) bludgeoning damage plus 7 (2d6) poison damage.
- **_Swamp Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 10 (2d6+3) poison damage, and the target must succeed on a DC 13 CON save or be poisoned until the end of its next turn.
- **_Spellcasting._** The lizardfolk shaman casts one of the following spells, using WIS as the spellcasting ability (spell save DC 13).
  - At will: _druidcraft_, _guidance_, _mending_
  - 2/day each: _cure wounds_, _entangle_, _grease_
  - 1/day: _ray of enfeeblement_

**Bonus Actions**

- **_Poisoned Body (32 HP or Fewer)._** The shaman coats itself in poison until the start of its next turn. It takes 3 (1d6) poison damage. In addition, the next time a creature hits the shaman with a melee attack while within 5 feet of the shaman before the start of the shaman's next turn, the attacker takes 7 (2d6) poison damage.

#### Lizardfolk Ruler (CR 4)

_Medium Humanoid_

- **Armor Class** 15 (scale mail)
- **Hit Points** 100
- **Speed** 30 ft., climb 15 ft., swim 30 ft.
- **Perception** 12
- **Stealth** 10 (15 without armor)
- **Immune** charmed, frightened
- **Senses** -
- **Languages** Common, Draconic

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  +0 |  +2 |  +2 |

- **_Brutal._** A melee weapon deals one extra die of its damage when the lizardfolk ruler hits with it (included in the attack).
- **_Heightened Smell and Taste._** The lizardfolk's Perception is 17 when perceiving by smell or taste.
- **_Hold Breath._** The lizardfolk ruler can hold its breath for 15 minutes.
- **_Unshakable Command._** Each friendly creature within 30 feet of the lizardfolk ruler can't be charmed or frightened while the ruler isn't incapacitated.

**Actions**

- **_Multiattack._** The lizardfolk ruler makes two Bite attacks and one Greataxe attack, or it makes three Javelin attacks.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage.
- **_Greataxe._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 16 (2d12+3) slashing damage.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +5 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 10 (2d6+3) piercing damage in melee or 6 (1d6+3) piercing damage at range.

**Bonus Actions**

- **_Leader's Challenge._** The ruler hisses out a challenge or a threat (the ruler's choice) toward one creature it can see within 30 feet of it. The target must make a DC 13 CHA save. If the target fails the save against a challenge, the target has disadvantage on attack rolls against any creature other than the ruler until the start of the ruler's next turn. If the target fails the save against a threat, the ruler has advantage on the next attack roll it makes against the target before the start of its next turn.

**Reactions**

- **_Inspiring Hiss._** When a friendly lizardfolk the ruler can see within 30 feet of it is hit by an attack, the ruler can hiss out inspiring words to encourage the lizardfolk to keep going. The target gains 5 (2d4) temporary HP for 1 minute.

### Lycanthropes

#### Werebear (CR 5)

_Medium Humanoid (Lycanthrope)_

- **Armor Class** 10 in humanoid form, 11 (natural armor) in bear and hybrid form
- **Hit Points** 126
- **Speed** 30 ft. (40 ft., climb 30 ft. in bear or hybrid form)
- **Perception** 14
- **Stealth** 10
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Senses** -
- **Languages** Common (can't speak in bear form)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +3 |  +0 |  +4 |  +1 |

- **_Heightened Smell._** The werebear's Perception is 19 when perceiving by smell.

**Actions**

- **_Multiattack._** The werebear makes three Claw or Greataxe attacks. It can replace one attack with a Bite attack, provided it is in the appropriate form. If two Claw attacks hit one creature, the target is grappled (escape DC 15). The werebear can grapple only one creature at a time.
- **_Bite (Bear or Hybrid Form Only)._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 16 (2d10+5) piercing damage. If the target is a Humanoid, it must succeed on a DC 14 CON save or be cursed with the werebear lycanthropy curse (see Curse of Lycanthropy sidebar).
- **_Claw (Bear or Hybrid Form Only)._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 14 (2d8+5) slashing damage.
- **_Greataxe (Humanoid or Hybrid Form Only)._** Melee Weapon Attack: +8 to hit, reach 5 ft., one target. _Hit:_ 11 (1d12+5) slashing damage.

**Bonus Actions**

- **_Change Shape._** The werebear transforms into a Medum or Large bear, a Large bear - humanoid hybrid, or back into its true form, which is Humanoid. Its statistics, other than its size, speed, and AC, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.
- **_Pin._** One creature grappled by the werebear is knocked prone, and it is restrained until the grapple ends.

#### Wereboar (CR 4)

_Medium Humanoid (Lycanthrope)_

- **Armor Class** 10 in humanoid form, 11 (natural armor) in boar or hybrid form
- **Hit Points** 100
- **Speed** 30 ft. (40 ft. in boar or hybrid form)
- **Perception** 12
- **Stealth** 10
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Senses** -
- **Languages** Common (can't speak in boar form)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +2 |  +0 |  +0 |  -1 |

- **_Charge (Boar or Hybrid Form Only)._** If the wereboar moves at least 15 feet straight toward a target and then hits it with a Slam or Tusks attack on the same turn, the target takes an extra 7 (2d6) damage of the weapon's type. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.
- **_Relentless (Recharges after a Short or Long Rest)._** If the wereboar takes 14 damage or less that would reduce it to 0 HP, it is reduced to 1 HP instead.

**Actions**

- **_Multiattack (Humanoid or Hybrid Form Only)._** The wereboar makes three Maul or Slam attacks. It can replace one attack with a Tusks attack, provided it is in the appropriate form. If two Maul or Slam attacks hit one creature, the target must succeed on a DC 13 STR save or be knocked prone.
- **_Maul (Humanoid or Hybrid Form Only)._** Melee Weapon Attack: +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage.
- **_Slam (Boar or Hybrid Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage.
- **_Tusks (Boar or Hybrid Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage. If the target is a Humanoid, it must succeed on a DC 12 CON save or be cursed with the wereboar lycanthropy curse (see Curse of Lycanthropy sidebar).

**Bonus Actions**

- **_Challenging Snort (Boar or Hybrid Form Only)._** The wereboar snorts and stomps its feet at a creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn and have disadvantage on the next save it makes against being knocked prone by the wereboar.
- **_Change Shape._** The wereboar transforms into a Medum or Large boar, a Medium boar - humanoid hybrid, or back into its true form, which is Humanoid. Its statistics, other than its size, speed, and AC, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.

#### Wererat (CR 2)

_Medium Humanoid (Lycanthrope)_

- **Armor Class** 12
- **Hit Points** 57
- **Speed** 30 ft. (swim 30 ft. in rat or hybrid form)
- **Perception** 12
- **Stealth** 14
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Senses** darkvision 60 ft.
- **Languages** Common (can't speak in rat form)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +4 |  +1 |  +0 |  +0 |  -1 |

- **_Heightened Smell._** The wererat's Perception is 17 when perceiving by smell.
- **_Pack Tactics._** The wererat has advantage on attack rolls against a creature if at least one of the wererat's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Multiattack (Humanoid or Hybrid Form Only)._** The wererat makes three Claw or Shortsword attacks, or it makes three Hand Crossbow attacks. It can replace one attack with a Bite attack, provided it is in the appropriate form.
- **_Bite (Rat or Hybrid Form Only)._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) piercing damage. If the target is a Humanoid, it must succeed on a DC 11 CON save or be cursed with the wererat lycanthropy curse (see Curse of Lycanthropy sidebar).
- **_Claw (Rat or Hybrid Form Only)._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) slashing damage.
- **_Shortsword (Humanoid or Hybrid Form Only)._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Hand Crossbow (Humanoid or Hybrid Form Only)._** _Ranged Weapon Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Bonus Actions**

- **_Change Shape._** The wererat transforms into a Tiny or Small rat, a Medium rat - humanoid hybrid, or back into its true form, which is Humanoid. Its statistics, other than its size and speed, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.

#### Weretiger (CR 4)

_Medium Humanoid (Lycanthrope)_

- **Armor Class** 12
- **Hit Points** 95
- **Speed** 30 ft. (40 ft. in tiger form)
- **Perception** 13
- **Stealth** 14
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Senses** darkvision 60 ft.
- **Languages** Common (can't speak in tiger form)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +4 |  +3 |  +0 |  +1 |  +0 |

- **_Heightened Hearing and Smell._** The weretiger's Perception is 18 when perceiving by hearing or smell.
- **_Pounce (Tiger or Hybrid Form Only)._** If the weretiger moves at least 15 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the weretiger can make one Bite or Claw attack against it as a bonus action.

**Actions**

- **_Multiattack (Humanoid or Hybrid Form Only)._** The weretiger makes four Claw or Scimitar attacks, or it makes four Longbow attacks. It can replace one attack with a Bite attack, provided it is in the appropriate form.
- **_Bite (Tiger or Hybrid Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (1d10+3) piercing damage. If the target is a Humanoid, it must succeed on a DC 13 CON save or be cursed with the weretiger lycanthropy curse (see Curse of Lycanthropy sidebar).
- **_Claw (Tiger or Hybrid Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) slashing damage.
- **_Scimitar (Humanoid or Hybrid Form Only)._** Melee Weapon Attack: +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) slashing damage.
- **_Longbow (Humanoid or Hybrid Form Only)._** Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. _Hit:_ 6 (1d8+2) piercing damage.

**Bonus Actions**

- **_Bleed Prey._** The weretiger chooses a creature it can see within 30 feet of it to be its prey until the prey dies, until the weretiger dies, or until the weretiger uses this bonus action on another creature. While within 60 feet of its prey, the weretiger can pinpoint its prey's location. In addition, if the weretiger hits the prey with at least two melee weapon attacks, the weretiger rends the prey's flesh, and the prey must succeed on a DC 13 CON save or lose 7 (2d6) HP at the start of its next turn, as the wound bleeds excessively.
- **_Change Shape._** The weretiger transforms into a Large tiger, a Medium tiger - humanoid hybrid, or back into its true form, which is Humanoid. Its statistics, other than its size and speed, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.

#### Werewolf (CR 3)

_Medium Humanoid (Lycanthrope)_

- **Armor Class** 11 in humanoid form, 12 (natural armor) in wolf or hybrid form
- **Hit Points** 76
- **Speed** 30 ft. (40 ft. in wolf form)
- **Perception** 12
- **Stealth** 13
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Senses** -
- **Languages** Common (can't speak in wolf form)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +3 |  +0 |  +0 |  +0 |

- **_Heightened Hearing and Smell._** The werewolf's Perception is 17 while perceiving by hearing or smell.
- **_Pack Tactics._** The werewolf has advantage on attack rolls against a creature if at least one of the werewolf's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Multiattack (Humanoid or Hybrid Form Only)._** The werewolf makes three Claws or Spear attacks. It can replace one attack with a Bite attack, provided it is in the appropriate form.
- **_Bite (Wolf or Hybrid Form Only)._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 11 (2d8+2) piercing damage. If the target is a Humanoid, it must succeed on a DC 13 CON save or be cursed with the werewolf lycanthropy curse (see Curse of Lycanthropy sidebar).
- **_Claws (Hybrid Form Only)._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 9 (2d6+2) slashing damage.
- **_Spear (Humanoid Form Only)._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 5 (1d6+2) piercing damage, or 6 (1d8+2) piercing damage if used with two hands to make a melee attack.

**Bonus Actions**

- **_Change Shape._** The werewolf transforms into a Medum or Large wolf, a Medium wolf - humanoid hybrid, or back into its true form, which is Humanoid. Its statistics, other than its size, speed, and AC, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.
- **_Hungry Growl (Wolf and Hybrid Form Only)._** The werewolf stares down and growls at one creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn. The werewolf has advantage on the next attack roll it makes against the frightened creature.

### Magmin (CR 1/2)

_Small Elemental_

- **Armor Class** 14 (natural armor)
- **Hit Points** 22
- **Speed** 30 ft., burrow 15 ft.
- **Perception** 10
- **Stealth** 12
- **Immune** fire
- **Senses** darkvision 60 ft.
- **Languages** Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +2 |  +1 |  -1 |  +0 |  +0 |

- **_Death Burst._** When the magmin dies, it collapses into a Tiny cinder cone. On initiative count 20 after the magmin dies, the cinder cone erupts in a burst of fire and lava. Each creature within 10 feet of the cone must make a DC 11 DEX save, taking 7 (2d6) fire damage on a failed save, or half as much damage on a successful one. Flammable objects that aren't being worn or carried in that area are ignited.
- **_Hardened Magma._** While the magmin isn't ablaze, it is resistant to piercing and slashing damage from nonmagical attacks, and it is vulnerable to thunder damage.
- **_Molten Body._** While the magmin is ablaze, each creature that hits it with a melee attack while within 5 feet of it takes 3 (1d6) fire damage.

**Actions**

- **_Burning Slam._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage plus 3 (1d6) fire damage.

**Bonus Actions**

- **_Ignited Illumination._** The magmin sets itself ablaze or extinguishes its flames. While ablaze, the magmin sheds bright light in a 10 - foot radius and dim light for an additional 10 feet.

### Manticore (CR 3)

_Large Monstrosity_

- **Armor Class** 14 (natural armor)
- **Hit Points** 80
- **Speed** 30 ft., fly 50 ft.
- **Perception** 11
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +3 |  +3 |  -2 |  +1 |  -1 |

- **_Mimicry._** The manticore can mimic Humanoid voices. A creature that hears the sounds can tell they are imitations with a successful DC 13 WIS (Insight) check.
- **_Monstrosity Resilience._** The manticore is resistant to exhaustion and to the frightened condition.
- **_Tail Spike Regrowth._** The manticore has twenty - four tail spikes. Used spikes regrow when the manticore finishes a long rest.

**Actions**

- **_Multiattack._** The manticore makes one Bite attack and two Claw attacks, or it makes two Tail Spike attacks. If both Tail Spike attacks hit one creature, the target must succeed on a DC 13 CON save or be poisoned until the end of its next turn.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.
- **_Tail Spike._** _Ranged Weapon Attack:_ +5 to hit, range 100/200 ft., one target. _Hit:_ 7 (1d8+3) piercing damage plus 5 (2d4) poison damage.

**Reactions**

- **_Spiky Retaliation._** When a creature the manticore can see hits it with a melee attack while within 5 feet of it, the manticore can jab a spike into the attacker. The attacker must succeed on a DC 13 DEX save or take 5 (2d4) poison damage.

### Medusa (CR 6)

_Medium Monstrosity_

- **Armor Class** 15 (natural armor)
- **Hit Points** 112
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 15
- **Resistant** petrified | Monstrosity Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +4 |  +3 |  +2 |  +1 |  +6 |

- **_Monstrosity Resilience._** The medusa is resistant to exhaustion and to the frightened condition.
- **_Petrifying Gaze._** When a creature that can see the medusa's eyes starts its turn within 30 feet of the medusa, the medusa can force it to make a DC 14 CON save if the medusa isn't incapacitated and can see the creature. If the save fails by 5 or more, the creature is instantly petrified. Otherwise, a creature that fails the save begins to turn to stone and is restrained. The restrained creature must repeat the save at the end of its next turn, becoming petrified on a failure or ending the effect on itself on a success. The petrification lasts until the creature is freed by the greater restoration spell or other magic.

  Unless surprised, a creature can avert its eyes to avoid the save at the start of its turn. If the creature does so, it can't see the medusa until the start of its next turn, when it can avert its eyes again. If the creature looks at the medusa in the meantime, it must immediately make the save.

  If the medusa sees itself reflected on a polished surface within 30 feet of it and in an area of bright light, the medusa, due to its curse, is affected by its own gaze. A medusa isn't resistant to its own gaze.

- **_Snake Friend._** The medusa can communicate with snakes as if they shared a language, and snakes can't be petrified by the medusa's Petrifying Gaze.

**Actions**

- **_Multiattack._** The medusa makes one Snake Hair attack and two Shortsword attacks, or it makes three Longbow attacks.
- **_Snake Hair._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 6 (1d4+4) piercing damage plus 14 (4d6) poison damage.
- **_Shortsword._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) piercing damage plus 7 (2d6) poison damage.
- **_Longbow._** _Ranged Weapon Attack:_ +7 to hit, range 150/600 ft., one target. _Hit:_ 8 (1d8+4) piercing damage plus 7 (2d6) poison damage.

**Reactions**

- **_Interruptive Hiss._** When a creature the medusa can see targets it with an attack, the medusa's snakes can suddenly rise and hiss at the attacker. The attacker must succeed on a DC 14 WIS save or fail the attack roll.

### Mephits

#### Dust Mephit (CR 1/2)

_Small Elemental_

- **Armor Class** 12
- **Hit Points** 27
- **Speed** 30 ft., fly 30 ft. (hover)
- **Perception** 13
- **Stealth** 14
- **Vulnerable** fire, thunder
- **Immune** lightning, poison | poisoned, prone
- **Senses** darkvision 60 ft.
- **Languages** Auran, Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +0 |  -2 |  +1 |  +0 |

- **_Death Burst._** When the mephit dies, it explodes in a burst of dust. Each creature within 5 feet of it must succeed on a DC 11 DEX save or be blinded for 1 minute. A blinded creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_False Appearance._** While the mephit remains motionless and hovering, it is indistinguishable from an ordinary cloud of dust.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage, and the target loses 2 (1d4) HP at the start of its next turn, as sand and grit irritate the wound.
- **_Dust Blast._** _Ranged Weapon Attack:_ +4 to hit, range 20/60 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage, and the target loses 2 (1d4) HP at the start of its next turn, as sand and grit irritate the wound.
- **_Blinding Breath (Recharge 6)._** The mephit exhales blinding dust in a 15 - foot cone. Each creature in that area must make a DC 11 DEX save. On a failure, a creature takes 5 (2d4) bludgeoning damage and is blinded for 1 minute. On a success, a creature takes half the damage and isn't blinded. A blinded creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Bonus Actions**

- **_Sandman's Call (1/Day)._** The mephit casts the sleep spell (spell save DC 11), requiring no material components and using WIS as the spellcasting ability.

#### Ice Mephit (CR 1/2)

_Small Elemental_

- **Armor Class** 12
- **Hit Points** 27
- **Speed** 30 ft., fly 30 ft.
- **Perception** 12
- **Stealth** 14
- **Vulnerable** bludgeoning, fire
- **Immune** cold, poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** Aquan, Auran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +0 |  -2 |  +0 |  +1 |

- **_Death Burst._** When the mephit dies, it explodes in a burst of viscous ice. Each creature within 5 feet of it must succeed on a DC 11 DEX save or be restrained by ice for 1 minute. A creature, including the restrained creature, can take its action to free the restrained creature by succeeding on a DC 11 STR check. The ice melts immediately if the restrained creature takes fire damage, freeing the creature.
- **_False Appearance._** While the mephit remains motionless, it is indistinguishable from an ordinary shard of ice.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage plus 3 (1d6) cold damage.
- **_Ice Shard._** _Ranged Weapon Attack:_ +4 to hit, range 20/60 ft., one target. _Hit:_ 4 (1d4+2) piercing damage plus 3 (1d6) cold damage.
- **_Frost Breath (Recharge 6)._** The mephit exhales freezing fog in a 15 - foot cone. Each creature in that area must make a DC 11 CON save. On a failure, a creature takes 7 (2d6) cold damage and is restrained by ice until the end of its next turn. On a success, a creature takes half the damage and isn't restrained.

**Bonus Actions**

- **_Cloud of Snow (1/Day)._** The mephit casts the fog cloud spell, requiring no material components and using CHA as the spellcasting ability.

#### Magma Mephit (CR 1/2)

_Small Elemental_

- **Armor Class** 12 (natural armor)
- **Hit Points** 27
- **Speed** 30 ft., fly 30 ft.
- **Perception** 12
- **Stealth** 12
- **Vulnerable** bludgeoning, cold
- **Immune** fire, poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** Ignan, Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +0 |  -2 |  +0 |  +1 |

- **_Death Burst._** When the mephit dies, it explodes in a burst of lava. Each creature within 5 feet of it must succeed on a DC 11 DEX save or be pushed up to 10 feet away from the mephit, knocked prone, and catch on fire. Until a creature takes an action to douse the fire, the creature on fire takes 3 (1d6) fire damage at the start of each of its turns.
- **_False Appearance._** While the mephit remains motionless, it is indistinguishable from an ordinary mound of molten rock.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage plus 3 (1d6) fire damage.
- **_Lob Magma._** _Ranged Weapon Attack:_ +2 to hit, range 20/60 ft., one target. _Hit:_ 7 (2d6) fire damage.
- **_Pyroclastic Burst (Recharge 6)._** The mephit exhales an explosive blast of lava in a 15 - foot cone. Each creature in the area must make a DC 11 STR save. On a failure, a creature takes 7 (2d6) fire damage and is pushed up to 10 feet away from the mephit and knocked prone. On a success, a creature takes half the damage and isn't pushed or knocked prone.

**Bonus Actions**

- **_Pyrotechnic Display (1/Day)._** The mephit casts the color spray spell (spell save DC 11), requiring no material components and using CHA as the spellcasting ability.

#### Steam Mephit (CR 1/2)

_Small Elemental_

- **Armor Class** 12
- **Hit Points** 27
- **Speed** 30 ft., fly 30 ft. (hover)
- **Perception** 13
- **Stealth** 14
- **Vulnerable** cold, thunder
- **Immune** fire, poison | poisoned, prone
- **Senses** darkvision 60 ft.
- **Languages** Aquan, Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +0 |  -2 |  +1 |  +0 |

- **_Death Burst._** When the mephit dies, it explodes in a cloud of steam. Each creature within 5 feet of the mephit must succeed on a DC 11 DEX save or be scalded for 1 minute. A scalded creature has disadvantage on weapon attack rolls and on ability checks that require manual dexterity. A scalded creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_False Appearance._** While the mephit remains motionless and hovering, it is indistinguishable from an ordinary cloud of steam.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage plus 2 (1d4) fire damage.
- **_Steam Blast._** _Ranged Weapon Attack:_ +4 to hit, range 20/60 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage plus 2 (1d4) fire damage
- **_Steam Breath (Recharge 6)._** The mephit exhales superheated breath in a 15 - foot cone. Each creature in that area must make a DC 11 CON save. On a failure, a creature takes 5 (2d4) fire damage and suffers one level of exhaustion. On a success, a creature takes half the damage and doesn't suffer exhaustion. A creature can't suffer more than two levels of exhaustion from a steam mephit's Steam Breath, regardless of the number of times it fails the save or the number of steam mephits using Steam Breath against it.

**Bonus Actions**

- **_Hazy Form (1/Day)._** The mephit casts the blur spell, requiring no material components and using WIS as the spellcasting ability.

### Merfolk

#### Merfolk (CR 1/8)

_Medium Humanoid_

- **Armor Class** 12 (coral armor)
- **Hit Points** 9
- **Speed** 10 ft., swim 40 ft.
- **Perception** 12
- **Stealth** 12
- **Senses** darkvision 60 ft.
- **Languages** Aquan, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +1 |  +0 |  +0 |  +1 |

- **_Amphibious._** The merfolk can breathe air and water.

**Actions**

- **_Coral Spear._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 4 (1d6+1) piercing damage.
- **_Sharpened Shell._** _Ranged Weapon Attack:_ +3 to hit, range 20/60 ft., one target. _Hit:_ 3 (1d4+1) slashing damage.

**Bonus Actions**

- **_Nimble Rush._** The merfolk takes the Dash or Disengage action.

**Reactions**

- **_Coral Scrape._** When a creature the merfolk can see hits it with a melee attack while within 5 feet of it, the merfolk can twist its body to scrape the attacker's arm or similar attacking appendage across the rough coral of its armor. The attacker must succeed on a DC 11 DEX save or have disadvantage on the next attack roll it makes before the end of its next turn, as its attacking appendage hurts from the abrasion.

### Merrow (CR 2)

_Large Monstrosity_

- **Armor Class** 13 (natural armor)
- **Hit Points** 60
- **Speed** 10 ft., swim 40 ft.
- **Perception** 12
- **Stealth** 10
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** Aquan, Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +2 |  -1 |  +0 |  -1 |

- **_Amphibious._** The merrow can breathe air and water.
- **_Monstrosity Resilience._** The merrow is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The merrow makes one Bite attack and two Claw attacks. It can replace one Claw attack with a Harpoon attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (1d8+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage.
- **_Harpoon._** _Melee or Ranged Weapon Attack:_ +6 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 7 (1d6+4) piercing damage, and the harpoon sticks in the target. While the harpoon is stuck, the merrow can't make Harpoon attacks against other targets, and the target and merrow can't move farther than 60 feet away from each other. A creature, including the target, can take its action to detach the harpoon by succeeding on a DC 14 STR check. Alternatively, the cord connecting the merrow to the harpoon can be attacked and destroyed (AC 10; HP 15; immune to bludgeoning, poison, and psychic damage), dislodging the harpoon into an unoccupied space within 5 feet of the target and preventing the merrow from using Recall Harpoon.

**Bonus Actions**

- **_Shoving Rush._** The merrow takes the Dash action. If it moves, it can propel itself into one creature it can see along its path. The target must succeed on a DC 14 STR save or be knocked prone. This movement doesn't provoke opportunity attacks from a target that fails this save.
- **_Recall Harpoon._** The merrow pulls on the cord connected to its harpoon, returning the harpoon to its empty hand. If the harpoon is stuck in a creature, that creature must succeed on a DC 14 STR save or be pulled up to 20 feet toward the merrow. Regardless, the harpoon is dislodged and returned to the merrow's hand.

### Mimic (CR 2)

_Medium Monstrosity (Shapechanger)_

- **Armor Class** 12 (natural armor)
- **Hit Points** 58
- **Speed** 20 ft.
- **Perception** 11
- **Stealth** 13
- **Vulnerable** cold
- **Resistant** grappled | Monstrosity Resilience
- **Immune** acid | prone
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  -3 |  +1 |  -1 |

- **_Adhesive (Object Form Only)._** The mimic adheres to anything that touches it. A Huge or smaller creature adhered to the mimic is also grappled by it (escape DC 13). Ability checks made to escape this grapple have disadvantage.
- **_False Appearance (Object Form Only)._** While the mimic remains motionless, it is indistinguishable from an ordinary object.
- **_Grappler._** The mimic has advantage on attack rolls against any creature grappled by it.
- **_Monstrosity Resilience._** The mimic is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The mimic makes two Pseudopod attacks. If it is grappling a creature, it can replace one attack with a Bite attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one grappled creature. _Hit:_ 7 (1d8+3) piercing damage plus 7 (2d6) acid damage.
- **_Pseudopod._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage. If the mimic is in object form, the target is subjected to its Adhesive trait.

**Bonus Actions**

- **_Change Shape._** The mimic transforms into a Large or smaller object or back into its true, amorphous form, which is a Monstrosity. Its statistics are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.

**Reactions**

- **_Prey Shield._** When a creature the mimic can see hits it with an attack while it is grappling a creature, the mimic can roll the grappled creature in front of the blow, forcing the grappled creature to take the damage instead.

### Minotaur (CR 3)

_Large Monstrosity_

- **Armor Class** 14 (natural armor)
- **Hit Points** 80
- **Speed** 40 ft.
- **Perception** 17
- **Stealth** 10
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** Abyssal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +0 |  +3 |  -2 |  +3 |  -1 |

- **_Charge._** If the minotaur moves at least 10 feet straight toward a target and then hits it with a Gore attack on the same turn, the target takes an extra 7 (2d6) piercing damage. If the target is a creature, it must succeed on a DC 14 STR save or be pushed up to 10 feet away from the minotaur and knocked prone.
- **_Labyrinthine Recall._** The minotaur can perfectly recall any path it has traveled.
- **_Monstrosity Resilience._** The minotaur is resistant to exhaustion and to the frightened condition.
- **_Reckless._** At the start of its turn, the minotaur can gain advantage on all melee weapon attack rolls it makes during that turn, but attack rolls against it have advantage until the start of its next turn.
- **_Siege Monster._** The minotaur deals double damage to objects and structures.

**Actions**

- **_Multiattack._** The minotaur makes one Gore attack and one Greataxe attack.
- **_Gore._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) piercing damage.
- **_Greataxe._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 17 (2d12+4) slashing damage.

**Bonus Actions**

- **_Bleeding Frenzy (44 HP or Fewer)._** The minotaur enters a frenzy until the start of its next turn. Until the frenzy ends, the minotaur deals an extra 3 (1d6) damage of the weapon's type each time it hits with a melee weapon attack, and the minotaur takes an extra 3 (1d6) damage of the weapon's type the first time it is hit with a melee weapon attack before the frenzy ends.

### Mordovermis (CR 3)

_Large Aberration_

- **Armor Class** 13 (natural armor)
- **Hit Points** 72
- **Speed** 10 ft., fly 40 ft. (hover)
- **Perception** 14
- **Stealth** 12
- **Resistant** bludgeoning | Aberrant Resilience
- **Immune** prone
- **Senses** darkvision 120 ft.
- **Languages** Deep Speech, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -2 |  +2 |  +3 |

- **_Aberrant Resilience._** The mordovermis is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Sinuous Form._** The mordovermis can easily move through any opening large enough for a Small creature. It can squeeze through any opening large enough for a Tiny creature. The mordovermis's destination must still have suitable room to accommodate its volume.
- **_Sunlight Sensitivity._** While in sunlight, the mordovermis has disadvantage on attack rolls, and its Perception is 9 when perceiving by sight.

**Actions**

- **_Multiattack._** The mordovermis makes two Sting attacks. If both Sting attacks hit one Large or smaller creature, the mordovermis can use Consume on the creature without the need for the target to be incapacitated.
- **_Sting._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage.
- **_Consume._** The mordovermis wraps its body around an incapacitated creature. The target must make a DC 13 STR save. On a failure, the target takes 5 (2d4) piercing damage and 9 (2d8) acid damage and is grappled (escape DC 13). On a success, the target takes half the damage and isn't grappled. Until this grapple ends, the target is restrained and takes 18 (4d8) acid damage at the start of each of its turns, and the mordovermis can't use Consume.

**Bonus Actions**

- **_Transfixing Gaze._** The mordovermis focuses its gaze on one creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be charmed until the end of its next turn. While charmed, the creature is incapacitated and has a speed of 0.

### Mummies

#### Mummy (CR 3)

_Medium Undead_

- **Armor Class** 13 (natural armor)
- **Hit Points** 80
- **Speed** 20 ft.
- **Perception** 12
- **Stealth** 9
- **Vulnerable** fire
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Immune** necrotic | charmed, frightened, paralyzed | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  -1 |  +3 |  -2 |  +2 |  +1 |

- **_Undead Nature._** The mummy doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The mummy is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The mummy makes two Rotting Fist attacks. If both attacks hit one creature that isn't a Construct or Undead, the target must succeed on a DC 13 CON save or be cursed with mummy rot (see the Mummy Rot sidebar).
- **_Rotting Fist._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage plus 7 (2d6) necrotic damage.

**Bonus Actions**

- **_Dreadful Glare._** The mummy glares at one creature it can see within 60 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn. If the target fails the save by 5 or more, it is also paralyzed for the same duration.

#### Mummy Lord (CR 15)

_Medium Undead_

- **Armor Class** 17 (natural armor)
- **Hit Points** 270
- **Speed** 20 ft.
- **Perception** 19
- **Stealth** 10
- **Vulnerable** fire
- **Immune** necrotic; bludgeoning, piercing, and slashing damage from nonmagical ttacks | charmed, frightened, paralyzed | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +8 |  +5 |  +9 |  +8 |

- **_Legendary Resistance (3/Day)._** If the mummy lord fails a save, it can choose to succeed instead.
- **_Magic Resistance._** The mummy lord has advantage on saves against spells and other magical effects.
- **_Rejuvenation._** A destroyed mummy lord gains a new body in 24 hours if its heart is intact, regaining all its HP and becoming active again. The new body appears within 5 feet of the mummy lord's heart.
- **_Turning Defiance._** The mummy lord and any friendly Undead within 30 feet of it have advantage on saves against effects that turn undead.
- **_Undead Nature._** The mummy lord doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The mummy lord is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The mummy makes two Blessed Khopesh attacks and one Rotting Fist attack, or it makes four Divine Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Blessed Khopesh._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage plus 14 (4d6) necrotic damage or radiant damage (the mummy lord's choice).
- **_Rotting Fist._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage plus 21 (6d6) necrotic damage, and the target must succeed on a DC 17 CON save or be cursed with mummy rot (see the Mummy Rot sidebar).
- **_Divine Bolt._** _Ranged Spell Attack:_ +9 to hit, range 120 ft., one target. _Hit:_ 21 (5d6+4) necrotic damage or radiant damage (the mummy lord's choice).
- **_Undead Servitors._** The mummy lord magically calls 2d6 **skeletons** or **zombies**, 1d4 **specters**, or 2 **mummies**. The called creatures arrive in 1d4 rounds, acting as allies of the mummy lord and obeying its spoken commands. The Undead remain for 1 hour, until the mummy lord dies, or until the mummy lord dismisses them as a bonus action. The mummy lord can have any number of Undead under its control at one time, provided the combined total CR of the Undead is no higher than 6.
- **_Spellcasting._** The mummy lord casts one of the following spells, using WIS as the spellcasting ability (spell save DC 17).
  - At will: _command_, _guidance_, _thaumaturgy_
  - 3/day each: _dispel magic_, _hold_, _silence_
  - 1/day each: _contagion_, _insect plague_

**Bonus Actions**

- **_Bolster Undead._** The mummy lord sends necrotic power into up to three friendly Undead it can see, other than itself, within 30 feet of it. Each target regains 14 (4d6) HP and has advantage on the next attack roll it makes before the start of the mummy lord's next turn.
- **_Dreadful Glare._** The mummy lord glares at up to two creatures it can see within 60 feet of it. Each target must succeed on a DC 17 WIS save or be frightened until the end of its next turn. If the target fails the save by 5 or more, it is also paralyzed for the same duration.

**Legendary Actions**

The mummy lord can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The mummy lord regains spent legendary actions at the start of its turn.

- **_Detect Life._** The mummy lord automatically detects every creature that isn't a Construct or Undead within 30 feet of it, pinpointing the current location of each.
- **_Sandy Teleport._** The mummy lord transforms into loose sand and teleports up to 60 feet to an unoccupied space it can see, reforming in that space. Any equipment it is wearing or carrying transforms with it.
- **_Call Servitors (Costs 2 Actions)._** The Mummy Lord Uses Undead Servitors.
- **_Unleash Divine Energy (Costs 2 Actions)._** The Mummy Lord Unleashes A wave of divine energy. Each creature within 10 feet of it must make a DC 17 CON save. On a failure, a creature takes 14 (4d6) necrotic damage or radiant damage (the mummy lord's choice) and is stunned until the end of its next turn. On a success, a creature takes half the damage and isn't stunned.

### Mycolids

#### Mycolid Commoner (CR 1/2)

_Small Plant_

- **Armor Class** 12
- **Hit Points** 21
- **Speed** 15 ft.
- **Perception** 13
- **Stealth** 14
- **Resistant** poison | Plant Resilience
- **Senses** keensense 120 ft. (can't sense beyond this radius)
- **Languages** understands Sylvan but can't speak, telepathy 30 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +0 |  -2 |  +3 |  -3 |

- **_Fungal Toxicity._** A creature that hits the mycolid with a melee attack while within 5 feet of it must succeed on a DC 13 CON save or be poisoned for 1 hour. If the poison isn't neutralized before 1 hour has passed, the creature must succeed on a DC 13 CON save, taking 5 (2d4) poison damage on a failed save, or half as much damage on a successful one.
- **_Mycolid Connection._** The mycolid can pinpoint the location of each friendly mycolid within 120 feet of it. In addition, its telepathy range increases to 120 feet when communicating with other mycolids.
- **_Plant Resilience._** The mycolid is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Gardening Pick._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) piercing damage plus 5 (2d4) poison damage.
- **_Slowing Spores (Recharge 5 - 6)._** The mycolid ejects slowing spores from its body. Each creature that isn't a mycolid within 5 feet of the mycolid must make a DC 13 WIS save. On a failure, a creature takes 5 (2d4) poison damage and is slowed until the end of its next turn. On a success, a creature takes half the damage and isn't slowed. A slowed creature's speed is halved, and it can't take reactions.

**Bonus Actions**

- **_Fetid Feast._** The mycolid draws sustenance from a Medium or larger pile of carrion or rotting vegetation within 5 feet of it. It regains 5 (2d4) HP. The mycolid can't use Fetid Feast on a pile of carrion or vegetation if it or another mycolid has already used Fetid Feast on that pile.

#### Mycolid Spore Lord (CR 3)

_Medium Plant_

- **Armor Class** 14 (natural armor)
- **Hit Points** 68
- **Speed** 15 ft.
- **Perception** 14
- **Stealth** 12
- **Resistant** Plant Resilience
- **Immune** poison
- **Senses** keensense 120 ft. (can't sense beyond this radius)
- **Languages** understands Druidic and Sylvan but can't speak, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +1 |  -1 |  +4 |  -1 |

- **_Fungal Toxicity._** A creature that hits the mycolid with a melee attack while within 5 feet of it must succeed on a DC 13 CON save or be poisoned for 5 hours. If the poison isn't neutralized before 5 hours have passed, the creature must succeed on a DC 14 CON save, taking 9 (2d8) poison damage on a failed save, or half as much damage on a successful one.
- **_Mycolid Connection._** The spore lord can pinpoint the location of each friendly mycolid within 1 mile of it. In addition, its telepathy range increases to 1 mile when communicating with other mycolids.
- **_Plant Resilience._** The mycolid is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Multiattack._** The spore lord makes two Fungal Staff attacks or uses Hurl Sap twice.
- **_Fungal Staff._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) bludgeoning damage plus 9 (2d8) poison damage.
- **_Hurl Sap._** _Ranged Weapon Attack:_ +4 to hit, range 30/120 ft., one target. _Hit:_ 11 (2d8+2) poison damage, and the sap sticks to the target. While the sap is stuck, the target takes 4 (1d8) poison damage at the start of each of its turns. A creature can use an action to scrape away the sap, ending the effect.
- **_Mushroom Ring (Recharge 5 - 6)._** The spore lord causes fungal growth to erupt from a point on the ground it can sense within 120 feet of it. A ring of mushrooms sprouts in a 15 - foot radius around that point. Each creature that isn't a mycolid within that ring must make a DC 14 CON save, taking 13 (3d8) poison damage on a failed save, or half as much damage on a successful one. Each mycolid within that ring gains 5 (2d4) temporary HP.
- **_Slumber Spores (Recharge 5 - 6)._** The spore lord ejects sleep - inducing spores from its body. Each creature that isn't a mycolid within 10 feet of the spore lord must make a DC 14 WIS save. On a failure, a creature takes 9 (2d8) poison damage and falls unconscious for 1 minute. On a success, a creature takes half the damage and doesn't fall unconscious. The unconscious creature wakes if it takes damage or if a creature uses an action to wake it.

**Bonus Actions**

- **_Fetid Feast._** The spore lord draws sustenance from a Medium or larger pile of carrion or rotting vegetation within 5 feet of it. It regains 7 (2d6) HP. The spore lord can't use Fetid Feast on a pile of carrion or vegetation if it or another mycolid has already used Fetid Feast on that pile.

### Nagas

#### Guardian Naga (CR 10)

_Large Monstrosity_

- **Armor Class** 18 (natural armor)
- **Hit Points** 176
- **Speed** 40 ft.
- **Perception** 18
- **Stealth** 18
- **Resistant** necrotic, radiant | Monstrosity Resilience
- **Immune** poison | charmed, poisoned
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Celestial, Common, Infernal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +8 |  +7 |  +7 |  +8 |  +8 |

- **_Divine Strikes._** The naga's weapon attacks are magical. When the naga hits with any weapon attack, the weapon deals an extra 3d8 necrotic damage or radiant damage (included in the attack), the naga's choice.
- **_Monstrosity Resilience._** The naga is resistant to exhaustion and to the frightened condition.
- **_Rejuvenation._** If it dies, the naga returns to life in 1d6 days, regaining all its HP and becoming active again. Only a wish spell can prevent this trait from functioning.

**Actions**

- **_Multiattack._** The guardian naga makes three Slam or Spit Poison attacks, or it makes one Constrict attack and two Slam attacks. It can replace one attack with a use of Spellcasting.
- **_Constrict._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 8 (1d8+4) bludgeoning damage plus 13 (3d8) necrotic damage or radiant damage (the naga's choice), and the target is grappled (escape DC 16) if it is a Large or smaller creature. Until this grapple ends, the target is restrained, and the naga can't Constrict another target.
- **_Slam._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage plus 13 (3d8) necrotic damage or radiant damage (the naga's choice).
- **_Spit Poison._** _Ranged Weapon Attack:_ +8 to hit, range 20/60 ft., one target. _Hit:_ 11 (2d6+4) poison damage plus 13 (3d8) necrotic damage or radiant damage (the naga's choice).
- **_Spellcasting._** The guardian naga casts one of the following spells, requiring only verbal components and using WIS as the spellcasting ability (spell save DC 16).
  - At will: _augury_ (as an action), _command_, _mending_, _thaumaturgy_
  - 3/day each: _bestow curse_, _cure wounds_
  - 2/day each: _freedom of movement_, _hold_
  - 1/day: _geas_ (as an action)

**Bonus Actions**

- **_Protector's Step._** The naga magically teleports, along with any equipment it is wearing or carrying, up to 120 feet to an unoccupied space within the sacred site or temple it protects or within 30 feet of the exterior of such a site. Swirls of golden light or tendrils of inky shadow (the naga's choice) appear at the origin and destination when it uses this bonus action.

#### Spirit Naga (CR 8)

_Large Monstrosity_

- **Armor Class** 15 (natural armor)
- **Hit Points** 166
- **Speed** 40 ft.
- **Perception** 15
- **Stealth** 16
- **Vulnerable** radiant
- **Resistant** Monstrosity Resilience
- **Immune** necrotic, poison | charmed, poisoned
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Celestial, Common, Infernal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +6 |  +5 |  +3 |  +5 |  +6 |

- **_Guardian Projection._** The spirit naga's skeletal form is covered with a magical illusion that makes it look like the guardian naga it was in life. The naga can use a bonus action to dismiss this illusion until the end of its next turn. The changes wrought by this illusion fail to hold up to physical inspection. For example, a creature touching the spirit naga would feel its rough, dry scales and exposed bones instead of the smooth, cool scales of a guardian naga. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 20 INT (Investigation) check to discern the spirit naga's true appearance.
- **_Monstrosity Resilience._** The naga is resistant to exhaustion and to the frightened condition.
- **_Necrotic Strikes._** The naga's weapon attacks are magical. When the naga hits with any weapon attack, the weapon deals an extra 4d8 necrotic damage (included in the attack).
- **_Rejuvenation._** If it dies, the naga returns to life in 1d6 days, regaining all its HP and becoming active again. Only a wish spell can prevent this trait from functioning.

**Actions**

- **_Multiattack._** The spirit naga makes two Bite or Spit Poison attacks. If both attacks hit one creature, the target must succeed on a DC 14 CON save or be poisoned for 1 minute. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 6 (1d4+4) piercing damage plus 5 (2d4) poison damage and 18 (4d8) necrotic damage.
- **_Spit Poison._** _Ranged Weapon Attack:_ +6 to hit, range 20/60 ft., one target. _Hit:_ 10 (3d4+3) poison damage plus 18 (4d8) necrotic damage.
- **_Spellcasting._** The spirit naga casts one of the following spells, requiring only verbal components and using CHA as the spellcasting ability (spell save DC 14).
  - At will: _command_, _mage hand_, _minor illusion_
  - 3/day each: _augury_ (as an action), _charm_, _sleep_
  - 2/day each: _bestow curse_, _hold_
  - 1/day: _dominate_

**Bonus Actions**

- **_Hidden Step._** The spirit naga magically teleports, along with any equipment it is wearing or carrying, up to 30 feet to an unoccupied space it can see and takes the Hide action.

### Nightmare (CR 3)

_Large Fiend_

- **Armor Class** 13 (natural armor)
- **Hit Points** 76
- **Speed** 60 ft., fly 90 ft.
- **Perception** 11
- **Stealth** 12
- **Immune** fire
- **Senses** -
- **Languages** understands Abyssal, Common, and Infernal but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +3 |  +0 |  +1 |  +2 |

- **_Illumination._** The nightmare sheds bright light in a 10 - foot radius and dim light for an additional 10 feet.
- **_Riding Flames._** Any creature riding a willing nightmare is resistant to fire damage. A creature riding the nightmare without the nightmare's permission takes 3 (1d6) fire damage at the start of each of the nightmare's turns.

**Actions**

- **_Multiattack._** The nightmare makes two Flaming Hoof attacks.
- **_Flaming Hoof._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) bludgeoning damage plus 7 (2d6) fire damage.
- **_Ethereal Stride._** The nightmare and up to three willing creatures within 5 feet of it magically enter the Ethereal Plane from the Material Plane, or vice versa.

**Bonus Actions**

- **_Burning Hoofprints._** The nightmare increases the intensity of the heat on its hooves. Until the start of its next turn, it leaves burning hoofprints in any surface through which it walks, creating a trail of fire in its wake. A creature that enters a space with burning hoofprints for the first time on a turn or starts its turn there must succeed on a DC 13 DEX save or take 3 (1d6) fire damage. The hoofprints stop burning at the start of the nightmare's next turn.

### Ochre Jelly (CR 2)

_Large Ooze_

- **Armor Class** 8
- **Hit Points** 71
- **Speed** 15 ft., climb 15 ft.
- **Perception** 8
- **Stealth** 8
- **Resistant** acid | Ooze Resilience
- **Immune** lightning, slashing | grappled, poisoned | Ooze Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  -2 |  +2 |  -4 |  -2 |  -5 |

- **_Amorphous._** The ochre jelly can move through a space as narrow as 1 inch wide without squeezing.
- **_Ooze Nature._** The ochre jelly doesn't require sleep.
- **_Ooze Resilience._** The ochre jelly is resistant to the restrained condition, and it is immune to exhaustion and to the blinded, charmed, deafened, frightened, and prone conditions.
- **_Overwhelming Stench._** A creature that starts its turn within 10 feet of the ochre jelly must succeed on a DC 13 CON save or be poisoned until the start of its next turn. If a creature fails the save by 5 or more, it must spend its turn retching uncontrollably and be unable to move or act.
- **_Spider Climb._** The ochre jelly can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Pseudopod._** _Melee Weapon Attack:_ +5 to hit, reach 10 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage plus 7 (2d6) acid damage. If the target is poisoned, it must succeed on a DC 13 CON save or also take 5 (2d4) poison damage.

**Reactions**

- **_Split._** When an ochre jelly that is Medium or larger is subjected to lightning or slashing damage, it splits into two new ochre jellies if it has at least 10 HP. Each new jelly has HP equal to half the original jelly's, rounded down. New jellies are one size smaller than the original jelly.

### Ogre (CR 2)

_Large Giant_

- **Armor Class** 11 (hide armor)
- **Hit Points** 66
- **Speed** 40 ft.
- **Perception** 8
- **Stealth** 9
- **Vulnerable** Giant Attributes
- **Resistant** Giant Attributes
- **Senses** darkvision 60 ft.
- **Languages** Common, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -1 |  +3 |  -3 |  -2 |  -2 |

- **_Giant Attributes._** The ogre is resistant to the stunned condition, and it is vulnerable to the prone condition.

**Actions**

- **_Multiattack._** The ogre makes two Greatclub or Javelin attacks.
- **_Greatclub._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +6 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 11 (2d6+4) piercing damage.
- **_Bowling Sweep (Recharge 5 - 6)._** The ogre sweeps its weapon in a wide arc around it. Each creature within 10 feet of the ogre must make a DC 14 STR save. Small and smaller creatures have disadvantage on the save. On a failure, a creature takes 14 (4d6) bludgeoning damage, is pushed up to 10 feet away from the ogre, and is knocked prone. On a success, a creature takes half the damage and isn't pushed or knocked prone.

**Bonus Actions**

- **_Shoving Rush._** The ogre takes the Dash action. If it moves, it can propel itself into one creature it can see along its path. The target must succeed on a DC 14 STR save or be knocked prone. This movement doesn't provoke opportunity attacks from a target that fails this save.

### Oni (CR 7)

_Large Giant (Outsider)_

- **Armor Class** 16 (chain mail)
- **Hit Points** 134
- **Speed** 30 ft., fly 30 ft. (hover)
- **Perception** 14
- **Stealth** 13
- **Resistant** Giant Attributes
- **Immune** prone
- **Senses** darkvision 60 ft.
- **Languages** Common, Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +6 |  +2 |  +4 |  +6 |

- **_Empowered Weapons._** The oni's weapon attacks are magical. When the oni hits with any weapon, the weapon deals an extra 3d6 force damage (included in the attack).
- **_Giant Attributes._** The oni is resistant to the stunned condition.
- **_Regeneration._** The oni regains 10 HP at the start of its turn if it has at least 1 HP.

**Actions**

- **_Multiattack._** The oni makes two Claw or Glaive attacks, or it makes three Arcane Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Claw (True Form Only)._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage plus 10 (3d6) force damage.
- **_Glaive._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 15 (2d10+4) slashing damage, or 9 (1d10+4) slashing damage in a Medium or smaller form, plus 10 (3d6) force damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 17 (4d6+3) force damage.
- **_Whirling Glaive (Recharge 5 - 6)._** The oni channels its magic into its twirling glaive, creating magical wind in a 30 - foot cone. Each creature in the area must make a DC 14 STR save. On a failure, a creature takes 31 (9d6) cold damage and is pushed up to 15 feet away from the oni. On a success, a creature takes half the damage and isn't pushed.
- **_Spellcasting._** The oni casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 14).
  - At will: _darkness_, _invisibility_ (self only)
  - 1/day each: _charm_, _gaseous form_, _sleep_

**Bonus Actions**

- **_Change Shape._** The oni magically transforms into a Small or Medium Humanoid, a Large ogre, or back into its true form, which is Giant. Its statistics, other than its size, are the same in each form. Any equipment it is wearing or carrying transforms with it, except for its glaive, which adjusts to fit its new form. If the oni dies, it reverts to its true form, and the glaive reverts to its normal size.

### Orcs

#### Orc (CR 1/2)

_Medium Humanoid_

- **Armor Class** 13 (hide armor)
- **Hit Points** 25
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 11
- **Resistant** exhaustion
- **Senses** darkvision 60 ft.
- **Languages** Common, Orc

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +3 |  -2 |  +0 |  +0 |

- **_Stalwart._** If the orc starts its turn afflicted by an ongoing effect that allows for a repeated save to end the effect, such as the hold spell or the poison from an ettercap's Bite, the orc can make the save at the start of the turn instead of the end and has advantage on the save.

**Actions**

- **_Greataxe._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 9 (1d12+3) slashing damage.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +5 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.

**Bonus Actions**

- **_Warrior's Advance._** The orc moves up to its speed toward a hostile creature that it can see.

#### Orc Warlord (CR 4)

_Medium Humanoid_

- **Armor Class** 17 (half plate)
- **Hit Points** 90
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 7 (12 without armor)
- **Resistant** exhaustion
- **Immune** frightened
- **Senses** darkvision 60 ft.
- **Languages** Common, Orc

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +4 |  -1 |  +1 |  +1 |

- **_Martial Adept._** A melee or ranged weapon deals one extra die of its damage when the orc warlord hits with it (included in the attack).
- **_Stalwart._** As the **orc**.

**Actions**

- **_Multiattack._** The orc warlord makes two Longsword attacks and one Skull Club attack, or it makes three Longbow attacks.
- **_Longsword._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage.
- **_Skull Club._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) piercing damage.
- **_Longbow._** _Ranged Weapon Attack:_ +4 to hit, range 150/600 ft., one target. _Hit:_ 11 (2d8+2) piercing damage.

**Bonus Actions**

- **_Warrior's Advance._** As the **orc**.
- **_Warlord's Rally (Recharge 4 - 6)._** The warlord yells a rallying cry to its allies. Each friendly creature within 30 feet of the warlord that can hear the warlord has advantage on the next attack roll it makes before the start of the warlord's next turn.

### Otyugh (CR 5)

_Large Aberration_

- **Armor Class** 14 (natural armor)
- **Hit Points** 108
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 10
- **Resistant** Aberrant Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 120 ft.
- **Languages** Otyugh

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +7 |  -2 |  +1 |  -2 |

- **_Aberrant Resilience._** The otyugh is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Limited Telepathy._** The otyugh can magically transmit simple messages and images to any creature within 120 feet of it that can understand a language. This form of telepathy doesn't allow the receiving creature to telepathically respond.
- **_Stench._** Each creature that starts its turn within 10 feet of the otyugh must succeed on a DC 15 CON save or be poisoned until the start of its next turn.

**Actions**

- **_Multiattack._** The otyugh makes one Bite attack and two Tentacle attacks. It can replace both Tentacle attacks with a use of Tentacle Slam.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage. If the target is a creature, it must succeed on a DC 15 CON save or become infected with a disease. Until the disease is cured, the target is poisoned. Every 24 hours that elapse, the infected creature must repeat the save, reducing its HP maximum by 5 (1d10) on a failure. The disease is cured on a success. The creature dies if the disease reduces its HP maximum to 0. This reduction to the creature's HP maximum lasts until it finishes a long rest after the disease is cured.
- **_Tentacle._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 6 (1d6+3) bludgeoning damage plus 9 (2d8) piercing damage. If the target is Medium or smaller, it is grappled (escape DC 13). The otyugh has two tentacles, each of which can grapple one target.
- **_Tentacle Slam._** The otyugh slams creatures grappled by it into each other or into a solid surface. Each creature must make a DC 15 STR save. On a failure, a creature takes 14 (4d6) bludgeoning damage and is stunned until the end of its next turn. On a success, a creature takes half the damage and isn't stunned.

### Owlbear (CR 3)

_Large Monstrosity (Animal)_

- **Armor Class** 14 (natural armor)
- **Hit Points** 80
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 11
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +1 |  +3 |  -4 |  +1 |  -2 |

- **_Glide._** The owlbear has long, sturdy feathers along its forelimbs and sides that expand while falling to slow its rate of descent to 60 feet per round, landing on its feet and taking no falling damage. It can move up to 5 feet horizontally for every 1 foot it falls. The owlbear can't gain height with its gliding feathers alone. If subjected to a strong wind or lift of any kind, it can use the updraft to glide farther.
- **_Heightened Sight and Smell._** The owlbear's Perception is 18 when perceiving by sight or smell.
- **_Monstrosity Resilience._** The owlbear is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The owlbear makes one Beak attack and one Claws attack. If both attacks hit a Medium or smaller target, the target is grappled (escape DC 15).
- **_Beak._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 10 (1d10+5) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 14 (2d8+5) slashing damage.
- **_Vicious Bound (44 HP or Fewer)._** The owlbear roars and barrels through creatures. It moves up to 20 feet in a straight line and can move through the space of any Medium or smaller creature. The first time it enters a creature's space during this move, that creature must make a DC 15 STR save. On a failure, a creature takes 18 (4d8) bludgeoning damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone.

**Bonus Actions**

- **_Rend._** The owlbear violently wrenches a Medium or smaller creature it is currently grappling. The target must make a DC 15 STR save, taking 9 (2d8) slashing damage on a failed save, or half as much damage on a successful one.

### Pegasus (CR 2)

_Large Celestial (Animal)_

- **Armor Class** 12
- **Hit Points** 57
- **Speed** 60 ft., fly 90 ft.
- **Perception** 12
- **Stealth** 12
- **Resistant** Celestial Resilience
- **Immune** charmed
- **Senses** -
- **Languages** understands Celestial, Common, Elvish, and Sylvan but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +3 |  +0 |  +2 |  +1 |

- **_Celestial Resilience._** The pegasus is resistant to radiant damage.
- **_Diving Pounce._** If the pegasus is flying and moves at least 20 feet straight toward a creature and then hits it with a Hooves attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the pegasus can make one Hooves attack against it as a bonus action.
- **_Magic Resistance._** The pegasus has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The pegasus's weapon attacks are magical.

**Actions**

- **_Multiattack._** The pegasus makes two Hooves attacks.
- **_Hooves._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage.

**Reactions**

- **_Catch Rider._** If the pegasus's rider fails a check or save to remain in the saddle or is subjected to an effect that would dismount it, the pegasus can shift to catch the falling rider, preventing the rider from being dismounted.

### Phase Spider (CR 3)

_Large Monstrosity_

- **Armor Class** 13 (natural armor)
- **Hit Points** 73
- **Speed** 30 ft., climb 30 ft.
- **Perception** 10
- **Stealth** 15
- **Resistant** Monstrosity Resilience
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** Phase Spider

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +3 |  +1 |  -2 |  +0 |  -2 |

- **_Ethereal Sight._** The phase spider can see 60 feet into the Ethereal Plane when it is on the Material Plane, and vice versa.
- **_Monstrosity Resilience._** The phase spider is resistant to exhaustion and to the frightened condition.
- **_Spider Climb._** The spider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Web Walker._** The spider ignores movement restrictions caused by webbing.

**Actions**

- **_Multiattack._** The phase spider makes one Barbed Legs attack and one Bite attack. It can replace one attack with a Phasing Web attack.
- **_Barbed Legs._** _Melee Weapon Attack:_ +5 to hit, reach 10 ft., one target. _Hit:_ 8 (2d4+3) piercing damage.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d10+3) piercing damage, and the target must make a DC 13 CON save, taking 13 (3d8) poison damage on a failed save, or half as much damage on a successful one. If the poison damage reduces the target to 0 HP, the target is stable but poisoned for 1 hour, even after regaining HP, and is paralyzed while poisoned in this way.
- **_Phasing Web._** _Ranged Weapon Attack:_ +5 to hit, range 30/60 ft., one creature. _Hit:_ The target is restrained by webbing. While restrained in this way, the target can see and attack creatures on the Ethereal Plane, and the restrained target can be seen and attacked by creatures on the Ethereal Plane. A creature, including the restrained target, can take its action to free the target from the webbing by succeeding on a DC 13 STR check. The webbing can also be attacked and destroyed (AC 12; HP 10; vulnerability to fire damage; immunity to bludgeoning, poison, and psychic damage).

**Bonus Actions**

- **_Ethereal Jaunt._** The phase spider magically shifts from the Material Plane to the Ethereal Plane, or vice versa.

### Purple Worm (CR 15)

_Gargantuan Monstrosity_

- **Armor Class** 18 (natural armor)
- **Hit Points** 255
- **Speed** 50 ft., burrow 30 ft.
- **Perception** 14
- **Stealth** 8
- **Resistant** Monstrosity Resilience
- **Immune** prone
- **Senses** keensense 60 ft., tremorsense 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  -2 | +11 |  -5 |  +4 |  -3 |

- **_Monstrosity Resilience._** The purple worm is resistant to exhaustion and to the frightened condition.
- **_Tunneler._** The purple worm can burrow through solid rock at half its burrowing speed, and it leaves a 10 - foot - diameter tunnel in its wake.

**Actions**

- **_Multiattack._** The worm makes one Bite attack and one Tail Stinger attack.
- **_Bite._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one target. _Hit:_ 22 (3d8+9) piercing damage. If the target is a Large or smaller creature, it must succeed on a DC 19 DEX save or be swallowed by the purple worm.

  A swallowed creature is blinded and restrained, it has total cover against attacks and other effects outside of the worm, and it takes 21 (6d6) acid damage at the start of each of the worm's turns. If the worm takes 30 damage or more on a single turn from a creature inside it, the worm must succeed on a DC 21 CON save at the end of that turn or regurgitate all swallowed creatures, which fall prone in a space within 10 feet of the worm. If the worm dies, a swallowed creature is no longer restrained by it and can escape from the corpse by using 20 feet of movement, exiting prone.

- **_Tail Stinger._** _Melee Weapon Attack:_ +14 to hit, reach 10 ft., one creature. _Hit:_ 19 (3d6+9) piercing damage, and the target must make a DC 19 CON save, taking 42 (12d6) poison damage on a failed save, or half as much damage on a successful one.
- **_Thrash (Recharge 5 - 6)._** The purple worm convulses its large body, smashing everything around it. Each creature within 20 feet of the worm must make a DC 19 STR save. On a failure, a creature takes 54 (12d8) bludgeoning damage and is stunned until the end of its next turn. On a success, a creature takes half the damage and isn't stunned.

**Bonus Actions**

- **_Rapid Digestion._** The purple worm's digestive system absorbs some of the already digested material from creatures it has swallowed. If the purple worm has at least one swallowed creature inside it, the purple worm regains 9 (2d8) HP. This healing increases by 4 (1d8) for each creature currently inside the purple worm, to a maximum of 10d8.

### Rakshasa (CR 13)

_Medium Fiend_

- **Armor Class** 16 (natural armor)
- **Hit Points** 166
- **Speed** 40 ft., fly 30 ft. (hover)
- **Perception** 18
- **Stealth** 18
- **Vulnerable** piercing damage from magical attacks
- **Immune** bludgeoning, piercing, and slashing damage from nonmagical attacks | rone
- **Senses** truesight 60 ft.
- **Languages** Abyssal, Common, Infernal

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +8 |  +4 |  +1 |  +8 | +10 |

- **_Limited Magic Immunity._** The rakshasa can't be affected or detected by spells of 6th level or lower unless it wishes to be. It has advantage on saves against all other spells and magical effects.

**Actions**

- **_Multiattack._** The rakshasa makes four Claw or Arcane Bolt attacks. It can replace one attack with a use of Spellcasting. If two Claw attacks hit one creature, the target is cursed. While cursed, the target gains no benefit from finishing a short or long rest. The curse lasts until removed by the remove curse spell or similar magic.
- **_Claw._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) slashing damage plus 10 (3d6) force damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +10 to hit, range 60 ft., one target. _Hit:_ 22 (5d6+5) force damage.
- **_Travel the Planes (1/Day)._** The rakshasa magically transports itself to a different plane of existence. This works like the plane shift spell, except the rakshasa can affect only itself and can't use this action to banish an unwilling creature.
- **_Spellcasting._** The rakshasa casts one of the following spells, requiring no material components and using CHA as the spellcasting ability (spell save DC 18).
  - At will: _detect thoughts_, _mage hand_, _minor illusion_
  - 3/day each: _major image_, _suggestion_
  - 1/day: _dominate_

**Bonus Actions**

- **_Charming Gaze._** The rakshasa turns its gaze toward one creature it can see within 60 feet of it. If the target can see the rakshasa, the target must succeed on a DC 18 CHA save or be charmed for 1 minute. A charmed creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. The rakshasa can have up to three creatures charmed in this way at a time.
- **_Illusory Appearance._** The rakshasa covers itself and anything it is wearing or carrying with a magical illusion that makes it look like another creature of its general size and Humanoid shape. The illusion ends if the rakshasa takes a bonus action to end it or if the rakshasa dies. The changes wrought by this effect fail to hold up to physical inspection. For example, a creature touching the disguised rakshasa might feel its fur instead of Humanoid flesh. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 25 INT (Investigation) check to discern that the rakshasa is disguised.

### Remorhaz (CR 11)

_Huge Monstrosity_

- **Armor Class** 17 (natural armor)
- **Hit Points** 216
- **Speed** 30 ft., burrow 20 ft.
- **Perception** 10
- **Stealth** 15
- **Resistant** Monstrosity Resilience
- **Immune** cold, fire
- **Senses** darkvision 60 ft., tremorsense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +11 |  +1 |  +9 |  -3 |  +0 |  -3 |

- **_Heated Body._** A creature that touches the remorhaz or hits it with a melee attack while within 5 feet of it takes 7 (2d6) fire damage.
- **_Monstrosity Resilience._** The remorhaz is resistant to exhaustion and to the frightened condition.
- **_Tunneler._** The remorhaz can burrow through ice, snow, and permafrost, and it leaves a 5 - foot - diameter tunnel in its wake.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +11 to hit, reach 10 ft., one target. _Hit:_ 40 (6d10+7) piercing damage plus 10 (3d6) fire damage. If the target is a Medium or smaller creature, it must succeed on a DC 17 DEX save or be swallowed by the remorhaz. A swallowed creature is blinded and restrained, it has total cover against attacks and other effects outside the remorhaz, and it takes 10 (3d6) acid damage and 10 (3d6) fire damage at the start of each of the remorhaz's turns. If the remorhaz takes 30 damage or more on a single turn from a swallowed creature, the remorhaz must succeed on a DC 19 CON save at the end of that turn or regurgitate all swallowed creatures, which fall prone in a space within 10 feet of the remorhaz. If the remorhaz dies, a swallowed creature is no longer restrained by it and can escape from the corpse by using 15 feet of movement, exiting prone.

**Bonus Actions**

- **_Vent Heat (119 HP or Fewer)._** As the remorhaz's life force ebbs, its body generates more heat to protect itself. It can open valves in its carapace to vent this excess heat. Each creature within 5 feet of the remorhaz must succeed on a DC 17 CON save or suffer one level of exhaustion.

### Robot Drone (CR 1/2)

_Tiny Construct_

- **Armor Class** 15 (natural armor)
- **Hit Points** 21
- **Speed** 20 ft., fly 40 ft. (hover)
- **Perception** 15
- **Stealth** 15
- **Vulnerable** lightning
- **Immune** prone | Construct Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages of its creator but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +3 |  +1 |  -3 |  +1 |  -2 |

- **_Construct Nature._** The drone doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The drone is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Electrical Malfunction._** Whenever the drone takes lightning damage, it must succeed on a DC 11 WIS save or be incapacitated until the end of its next turn.
- **_Point - Blank Shots._** When the drone makes a ranged attack, it doesn't have disadvantage on the attack roll from being within 5 feet of a hostile creature, though it may still have disadvantage from other sources.

**Actions**

- **_Slam._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage.
- **_Flame Jet._** _Ranged Weapon Attack:_ +5 to hit, range 20/60 ft., one target. _Hit:_ 8 (2d4+3) fire damage.

**Bonus Actions**

- **_Fueled Escape._** The drone takes the Dash or Disengage action, leaving a small cloud of fuel fumes behind it. Each creature within 5 feet must succeed on a DC 13 CON save or be poisoned until the end of its next turn.

### Roc (CR 11)

_Gargantuan Monstrosity (Animal)_

- **Armor Class** 15 (natural armor)
- **Hit Points** 235
- **Speed** 20 ft., fly 120 ft.
- **Perception** 14
- **Stealth** 14
- **Vulnerable** blinded
- **Resistant** Monstrosity Resilience
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +9 |  +4 |  +9 |  -4 |  +4 |  +3 |

- **_Heightened Sight._** The roc's Perception is 19 when perceiving by sight.
- **_Monstrosity Resilience._** The roc is resistant to exhaustion and to the frightened condition.
- **_Seabird._** The roc can swim up to 60 feet on its turn, but it must start and end its movement either flying or on a solid surface, such as a ship or beach. If it is swimming at the end of its turn, it must succeed on a DC 19 CON save or it immediately begins to sink and suffocate. A suffocating roc must succeed on a DC 19 STR check to fly out of the substance where it is sinking.

**Actions**

- **_Multiattack._** The roc makes one Beak attack and two Talon attacks. If both Talon attacks hit one Huge or Gargantuan creature, the target is grappled (escape DC 17). Until this grapple ends, the target is restrained, and the roc can't use its Talons on another target.
- **_Beak._** _Melee Weapon Attack:_ +13 to hit, reach 10 ft., one target. _Hit:_ 27 (4d8+9) piercing damage.
- **_Talon._** _Melee Weapon Attack:_ +13 to hit, reach 5 ft., one target. _Hit:_ 23 (4d6+9) slashing damage, and the target is grappled (escape DC 17) if it is a Large or smaller creature. Until this grapple ends, the target is restrained, and the roc can't use its Talons on another target.

**Bonus Actions**

- **_Territorial Shriek._** The roc shrieks a territorial challenge at up to two creatures it can see within 60 feet of it. Each target must succeed on a DC 17 CHA save or be frightened until the end of its next turn. While frightened by this shriek, a creature must take the Dash action on its turn and move away from the roc by the safest available route, unless there is nowhere to move.

### Roper (CR 5)

_Large Monstrosity_

- **Armor Class** 20 (natural armor)
- **Hit Points** 111
- **Speed** 15 ft., climb 10 ft.
- **Perception** 16
- **Stealth** 15
- **Vulnerable** thunder
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  -1 |  +3 |  -2 |  +3 |  -2 |

- **_Climbing Tendrils._** If at least four of the roper's Grasping Tendrils aren't grappling creatures, the roper has a climbing speed of 30 feet.
- **_False Appearance._** While the roper remains motionless, it is indistinguishable from a normal conical or spire - like cave formation, such as a stalagmite or stalactite.
- **_Grasping Tendrils._** The roper can have up to six Grasping Tendrils at a time. Each Grasping Tendril can be attacked (AC 20; 10 HP; vulnerable to thunder damage; immune to poison and psychic damage). Destroying a Grasping Tendril deals no damage to the roper, which can extrude a replacement tendril on its next turn. A Grasping Tendril can also be broken if a creature takes an action and succeeds on a DC 15 STR check against it.
- **_Monstrosity Resilience._** The roper is resistant to exhaustion and to the frightened condition.
- **_Spider Climb._** The roper can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Multiattack._** The roper makes one Bite attack and three Grasping Tendril attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 22 (4d8+4) piercing damage.
- **_Grasping Tendril._** _Melee Weapon Attack:_ +7 to hit, reach 50 ft., one creature. _Hit:_ 6 (1d4+4) bludgeoning damage, and the target is grappled (escape DC 15). Until the grapple ends, the target is restrained and has disadvantage on STR checks and STR saves, and the roper can't use the same Grasping Tendril on another target. A creature immune to the poisoned condition doesn't have disadvantage on STR checks and STR saves from the tendril.

**Bonus Actions**

- **_Reel._** The roper pulls each creature grappled by it up to 25 feet straight toward it.

**Reactions**

- **_Snapping Tendril._** When a Grasping Tendril that is grappling a creature is destroyed, the roper can quickly pull the remains of that tendril back to it with a whipping snap. Each creature within 10 feet of the roper must succeed on a DC 15 DEX save or be knocked prone.

### Rust Monster (CR 1/2)

_Medium Monstrosity_

- **Armor Class** 14 (natural armor)
- **Hit Points** 23
- **Speed** 40 ft., climb 20 ft.
- **Perception** 11
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft., tremorsense 30 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +1 |  +1 |  -4 |  +1 |  -2 |

- **_Iron Scent._** The rust monster can pinpoint, by scent, the location of ferrous metal within 30 feet of it.
- **_Monstrosity Resilience._** The rust monster is resistant to exhaustion and to the frightened condition.
- **_Rust Metal._** Any nonmagical weapon made of metal that hits the rust monster corrodes. After dealing damage, the weapon takes a permanent and cumulative -1 penalty to damage rolls. If its penalty drops to -5, the weapon is destroyed. Nonmagical ammunition made of metal that hits the rust monster is destroyed after dealing damage.
- **_Spider Climb._** The rust monster can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 8 (2d6+1) piercing damage.
- **_Antennae._** The rust monster corrodes a nonmagical ferrous metal object it can see within 5 feet of it. If the object isn't being worn or carried, the touch destroys a 1 - foot cube of it. If the object is being worn or carried by a creature, the creature can make a DC 11 DEX save to avoid the rust monster's touch.

  If the object touched is either metal armor or a metal shield being worn or carried, it takes a permanent and cumulative -1 penalty to the AC it offers. Armor reduced to an AC of 10 or a shield that drops to a +0 bonus is destroyed. If the object touched is a held metal weapon, it rusts as described in the Rust Metal trait.

**Bonus Actions**

- **_Iron Dash._** The rust monster moves up to half its speed toward a source of ferrous metal it can sense.

### Sahuagin (CR 1/2)

_Medium Humanoid_

- **Armor Class** 12 (natural armor)
- **Hit Points** 25
- **Speed** 30 ft., swim 40 ft.
- **Perception** 15
- **Stealth** 12
- **Senses** darkvision 120 ft.
- **Languages** Sahuagin

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +0 |  +1 |  +1 |  +1 |  -1 |

- **_Blood Frenzy._** The sahuagin has advantage on melee attack rolls against any creature that doesn't have all its HP.
- **_Limited Amphibiousness._** The sahuagin can breathe air and water, but it needs to be submerged at least once every 4 hours to avoid suffocating.
- **_Shark Telepathy._** The sahuagin can magically command any shark within 120 feet of it, using a limited telepathy.

**Actions**

- **_Multiattack._** The sahuagin makes one Bite attack and one Claws or Trident attack.
- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d6) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 5 (2d4) slashing damage.
- **_Trident._** _Melee or Ranged Weapon Attack:_ +3 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 3 (1d6) piercing damage, or 4 (1d8) piercing damage if used with two hands to make a melee attack. If the target is wielding a weapon or shield, it must succeed on a DC 11 DEX save or drop the weapon or shield (the sahuagin's choice if the target is wielding both).

**Reactions**

- **_Circling Sharks._** If the sahuagin ends its turn within 10 feet of at least two other friendly sahuagin or sharks, the sahuagin can snap its teeth at one creature within 15 feet of it that it can see and that can see or hear it. The target must succeed on a DC 11 WIS save or be frightened until the end of its next turn.

### Salamander (CR 5)

_Large Elemental_

- **Armor Class** 15 (natural armor)
- **Hit Points** 114
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 12
- **Vulnerable** cold
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical attacks
- **Immune** fire
- **Senses** darkvision 60 ft.
- **Languages** Ignan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  +0 |  +0 |  +2 |

- **_Heated Body._** A creature that touches the salamander or hits it with a melee attack while within 5 feet of it takes 3 (1d6) fire damage.
- **_Heated Weapons._** When the salamander hits with a metal melee weapon, the weapon deals an extra 7 (2d6) fire damage (included in the attack).

**Actions**

- **_Multiattack._** The salamander makes one Trident attack and one Tail attack, or it makes three Fire Bolt attacks. It can replace one Trident attack with a Tail attack.
- **_Trident._** _Melee or Ranged Weapon Attack:_ +6 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 10 (2d6+3) piercing damage, or 12 (2d8+3) piercing damage if used with two hands to make a melee attack, plus 7 (2d6) fire damage. If the target is wielding a weapon or shield, it must succeed on a DC 14 DEX save or drop the weapon or shield (the salamander's choice if the target is wielding both).
- **_Tail._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage plus 7 (2d6) fire damage, and the target is grappled (escape DC 14). Until this grapple ends, the target is restrained, the salamander can automatically hit the target with its tail, and the salamander can't make tail attacks against other targets.
- **_Fire Bolt._** _Ranged Spell Attack:_ +5 to hit, ranged 60 ft., one target. _Hit:_ 12 (3d6+2) fire damage.

**Bonus Actions**

- **_Tighten Grip._** The salamander tightens its grip around one creature it is grappling. Until the start of the salamander's next turn, the target has disadvantage on any check made to escape the grapple, and other than a successful check to escape the grapple, the target can't be moved, knocked prone, or otherwise removed from the salamander's grasp without the salamander's permission.

### Satarre (CR 1)

_Medium Humanoid_

- **Armor Class** 12 (leather armor)
- **Hit Points** 40
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 11
- **Resistant** necrotic | Void Strength
- **Senses** darkvision 60 ft.
- **Languages** Common, Void Speech

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  +0 |  +0 |  +1 |

- **_Void Strength._** The satarre is resistant to the blinded, charmed, deafened, frightened, stunned, and unconscious conditions.
- **_Void Weapons._** The satarre's weapon attacks are magical. When the satarre hits with any weapon, the weapon deals an extra 1d6 necrotic damage (included in the attack).

**Actions**

- **_Multiattack._** The satarre makes two Claw or Spear attacks.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage plus 3 (1d6) necrotic damage.
- **_Spear._** _Melee or Ranged Weapon Attack:_ +4 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 5 (1d6+2) piercing damage plus 3 (1d6) necrotic damage.

### Satyr (CR 1/2)

_Medium Fey_

- **Armor Class** 13
- **Hit Points** 23
- **Speed** 40 ft.
- **Perception** 12
- **Stealth** 15
- **Resistant** Fey Resilience
- **Senses** -
- **Languages** Common, Elvish, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +3 |  +0 |  +1 |  +0 |  +5 |

- **_Fey Resilience._** The satyr is resistant to the charmed and unconscious conditions.
- **_Magic Resistance._** The satyr has advantage on saves against spells and other magical effects.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) bludgeoning damage.
- **_Intoxicating Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 7 (1d8+3) poison damage, and the target must succeed on a DC 13 CON save or be incapacitated until the end of its next turn.

**Bonus Actions**

- **_Revelries._** The satyr dances and plays a tune on its pipes, affecting one creature it can see within 30 feet of it in one of the following ways. The target must succeed on a DC 13 CHA save or gain the listed effect. A willing creature can choose to fail the save.
  - **Celebrate.** The target feels invigorated by the music, dancing along with it. Until the start of the satyr's next turn, the target has advantage on DEX saves and on the next attack roll it makes.
  - **Overindulge.** The satyr's song is laced with magical enchantments, and the target is forced to dance along with the music. Until the start of the satyr's next turn, the target is charmed, and its speed is reduced by 10 feet, as it dances uncontrollably.
  - **Unnerve.** The satyr's song and dance turn frightful with heavy stomps, shrill notes, and a rapid, staccato melody. The target is frightened until the end of its next turn.

### Shadow (CR 1/2)

_Medium Undead_

- **Armor Class** 12
- **Hit Points** 17
- **Speed** 40 ft., climb 20 ft.
- **Perception** 10
- **Stealth** 14
- **Vulnerable** radiant
- **Resistant** acid, cold, fire, lightning, thunder; bludgeoning, piercing, and lashing damage from nonmagical attacks
- **Immune** necrotic | frightened, grappled, paralyzed, petrified, prone, restrained | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +4 |  +1 |  -2 |  +0 |  -1 |

- **_Amorphous._** The shadow can move through a space as narrow as 1 inch wide without squeezing.
- **_Spider Climb._** The shadow can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Sunlight Weakness._** While in sunlight, the shadow has disadvantage on attack rolls, ability checks, and saves.
- **_Undead Nature._** The shadow doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The shadow is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Strength Drain._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 9 (2d6+2) necrotic damage, and the target's STR score is reduced by 1d4. The target dies if this reduces its STR to 0. Otherwise, the reduction lasts until the target finishes a short or long rest. If a Humanoid dies from this attack, a new shadow rises from the corpse 1d4 hours later.

**Bonus Actions**

- **_Shadow Bond._** One creature the shadow can see within 5 feet of it must succeed on a DC 12 WIS save or the shadow bonds with the target's shadow for 1 minute. While bonded with the target's shadow, the shadow can use this bonus action to teleport to an unoccupied space within 5 feet of that creature, provided the creature is within 120 feet of the shadow.
- **_Shadow Stealth._** The shadow takes the Hide action. It can use this bonus action only while in dim light or darkness.

### Shambling Mound (CR 5)

_Large Plant_

- **Armor Class** 15 (natural armor)
- **Hit Points** 110
- **Speed** 20 ft., swim 20 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** cold, fire | Plant Resilience
- **Immune** lightning | blinded, deafened
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -1 |  +3 |  -3 |  +0 |  -3 |

- **_Lightning Absorption._** Whenever the shambling mound is subjected to lightning damage, it takes no damage and regains HP equal to the lightning damage dealt.
- **_Plant Resilience._** The shambling mound is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.
- **_Rotting Vegetation._** The shambling mound emits the smell of rotting vegetation. A creature that starts its turn within 10 feet of the shambling mound must succeed on a DC 14 CON save or be poisoned until the start of its next turn.

**Actions**

- **_Multiattack._** The shambling mound makes two Slam attacks. If both attacks hit a Medium or smaller target, the target is grappled (escape DC 14).
- **_Slam._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage plus 7 (2d6) poison damage.

**Bonus Actions**

- **_Engulf._** The shambling mound engulfs a Medium or smaller creature grappled by it. In addition to being grappled, the engulfed target is blinded, restrained, and unable to breathe, and it must succeed on a DC 14 CON save at the start of each of the mound's turns or take 4 (1d8) bludgeoning damage and 3 (1d6) poison damage. If the mound moves, the engulfed target moves with it. The mound can have only one creature engulfed at a time.

### Shield Guardian (CR 7)

_Large Construct_

- **Armor Class** 17 (natural armor)
- **Hit Points** 139
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 9
- **Immune** Construct Resilience
- **Senses** keensense 10 ft., darkvision 60 ft.
- **Languages** understands the languages of its creator and the languages of the wearer of its amulet but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -1 |  +4 |  -2 |  +2 |  -4 |

- **_Bound._** The shield guardian is magically bound to an amulet. As long as the guardian and its amulet are on the same plane of existence, the guardian knows the distance and direction to the amulet's wearer, and the amulet's wearer can telepathically call the guardian, teleporting the guardian to an unoccupied space within 5 feet of the wearer after 1 minute. In addition, if the guardian is within 60 feet of the amulet's wearer, half of any damage the wearer takes (rounded up) is taken by the guardian instead.
- **_Construct Nature._** The shield guardian doesn't require air, food, drink, or sleep.
- **_Construct Resilience._** The shield guardian is immune to poison and psychic damage, and it is immune to exhaustion and the charmed, frightened, paralyzed, petrified, and poisoned conditions.
- **_Regeneration._** The shield guardian regains 10 HP at the start of its turn if it has at least 1 HP.
- **_Spell Storing._** A spellcaster who wears the shield guardian's amulet can cause the guardian to store one spell of 4th level or lower. To do so, the wearer must cast the spell on the guardian. The spell has no effect but is stored within the guardian. When commanded to do so by the wearer or when a situation arises that was predefined by the spellcaster, the guardian casts the stored spell, using the appropriate action required by the spell, with any parameters set by the original caster, requiring no components. When the spell is cast or a new spell is stored, any previously stored spell is lost.

**Actions**

- **_Multiattack._** The shield guardian makes two Runed Fist attacks, or it makes three Rune Bolt attacks.
- **_Runed Fist._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage plus 14 (4d8) force damage.
- **_Rune Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 16 (4d6+2) force damage.

**Bonus Actions**

- **_Protective Step._** The guardian teleports up to 60 feet to an unoccupied space it can see within 5 feet of the amulet's wearer.

**Reactions**

- **_Shield._** When a creature the guardian can see makes an attack against the amulet's wearer, the guardian grants a +2 bonus to the wearer's AC if the guardian is within 5 feet of the wearer.

### Skeletons

#### Skeleton (CR 1/4)

_Medium Undead_

- **Armor Class** 13 (armor scraps)
- **Hit Points** 14
- **Speed** 30 ft.
- **Perception** 9
- **Stealth** 14
- **Vulnerable** bludgeoning
- **Resistant** piercing
- **Immune** Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +2 |  -2 |  -1 |  -3 |

- **_False Appearance._** While the skeleton remains motionless and prone, it is indistinguishable from an inanimate Humanoid skeleton.
- **_Undead Nature._** The skeleton doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The skeleton is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Shortsword._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Shortbow._** _Ranged Weapon Attack:_ +4 to hit, range 80/320 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Reactions**

- **_Counterattack (Recharge 6)._** When a creature the skeleton can see hits it with an attack, the skeleton can make one Shortsword or Shortbow attack against the attacker.

#### Minotaur Skeleton (CR 2)

_Large Undead_

- **Armor Class** 12 (natural armor)
- **Hit Points** 63
- **Speed** 40 ft.
- **Perception** 9
- **Stealth** 10
- **Vulnerable** bludgeoning
- **Resistant** piercing
- **Immune** Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +2 |  -2 |  -1 |  -3 |

- **_Charge._** If the minotaur skeleton moves at least 10 feet straight toward a target and then hits it with a Gore attack on the same turn, the target takes an extra 7 (2d6) piercing damage. If the target is a creature, it must succeed on a DC 14 STR save or be pushed up to 10 feet away from the skeleton and knocked prone.
- **_False Appearance._** While the minotaur skeleton remains motionless and prone, it is indistinguishable from an inanimate minotaur skeleton.
- **_Labyrinthine Memories._** The minotaur skeleton has advantage on checks and saves to avoid becoming lost or to recall a path it has previously traveled.
- **_Undead Nature._** The skeleton doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The skeleton is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Greataxe._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 17 (2d12+4) slashing damage.
- **_Gore._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) piercing damage.

**Reactions**

- **_Counterattack (Recharge 6)._** When a creature the minotaur skeleton can see hits it with a melee attack while within 5 feet of it, the skeleton can make one Gore attack against the attacker.

#### War Horse Skeleton (CR 1/2)

_Large Undead_

- **Armor Class** 13 (barding scraps)
- **Hit Points** 25
- **Speed** 60 ft.
- **Perception** 11
- **Stealth** 13
- **Vulnerable** bludgeoning
- **Resistant** piercing
- **Immune** Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +2 |  -4 |  +1 |  -3 |

- **_False Appearance._** While the war horse skeleton remains motionless and prone, it is indistinguishable from an inanimate war horse skeleton.
- **_Undead Nature._** The skeleton doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The skeleton is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage.

**Bonus Actions**

- **_Counterattack (Recharge 6)._** When a creature the war horse skeleton can see hits it with a melee attack while within 5 feet of it, the skeleton can make one Hooves attack against the attacker.

### Specter (CR 1)

_Medium Undead_

- **Armor Class** 12
- **Hit Points** 27
- **Speed** 0 ft., fly 50 ft. (hover)
- **Perception** 10
- **Stealth** 12
- **Resistant** acid, cold, fire, lightning, thunder; bludgeoning, piercing, and lashing damage from nonmagical attacks
- **Immune** necrotic | charmed, grappled, paralyzed, petrified, prone, restrained, unconscious | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -5 |  +2 |  +0 |  +0 |  +0 |  +2 |

- **_Incorporeal Movement._** The specter can move through other creatures and objects as if they were difficult terrain. It takes 5 (1d10) force damage if it ends its turn inside an object.
- **_Sunlight Sensitivity._** While in sunlight, the specter has disadvantage on attack rolls, and its Perception is 5 when perceiving by sight.
- **_Undead Nature._** The specter doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The specter is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Life Drain._** Melee Spell Attack: +4 to hit, reach 5 ft., one creature. _Hit:_ 12 (3d6+2) necrotic damage. The target must succeed on a DC 12 CON save or its HP maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0.

**Reactions**

- **_Retributive Shriek._** When the specter takes damage from a creature it can see within 30 feet of it, the specter can shriek with the fury of its tormented existence. That creature must succeed on a DC 12 WIS save or be frightened until the end of its next turn.

### Sphinxes

#### Androsphinx (CR 17)

_Large Monstrosity_

- **Armor Class** 17 (natural armor)
- **Hit Points** 284
- **Speed** 40 ft., fly 60 ft.
- **Perception** 20
- **Stealth** 15
- **Resistant** Monstrosity Resilience
- **Immune** psychic; bludgeoning, piercing, and slashing damage from nonmagical ttacks | charmed, frightened
- **Senses** truesight 120 ft.
- **Languages** Common, Sphinx

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +5 | +11 |  +9 | +10 |  +6 |

- **_Inscrutable._** The sphinx is immune to any effect that would sense its emotions or read its thoughts, as well as any divination spell that it refuses. WIS (Insight) checks made to ascertain the sphinx's intentions or sincerity have disadvantage.
- **_Magical Claws._** The sphinx's Claw attacks are magical. When the sphinx hits with a Claw attack, the Claw deals an extra 2d8 force damage (included in the attack).
- **_Monstrosity Resilience._** The sphinx is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Multiattack._** The sphinx makes four Claw or Arcane Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Claw._** _Melee Weapon Attack:_ +12 to hit, reach 5 ft., one target. _Hit:_ 17 (2d10+6) slashing damage plus 9 (2d8) force damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +12 to hit, range 120 ft., one target. _Hit:_ 24 (4d8+6) force damage.
- **_Spellcasting._** The sphinx casts one of the following spells, requiring no material components and using WIS as the spellcasting ability (spell save DC 18).
  - At will: _command_, _detect evil and good_, _thaumaturgy_
  - 3/day each: _dispel magic_, _restoration_, _tongues_, _zone of truth_
  - 2/day each: _freedom of movement_, _greater restoration_
  - 1/day: _heal_

**Bonus Actions**

- **_Roar._** The sphinx emits one of the following magical roars. Each roar is audible up to 300 feet away. When it roars, the sphinx chooses up to three creatures it can see within 120 feet of it to be affected by the roar. A creature that fails a save and is affected by an ongoing effect can repeat the save at the end of each of its turns, ending the effect on itself on a success.
  - **Rumbling Roar.** This deep roar rumbles through each target's body, rattling it to its bones. Each target must succeed on a DC 18 CON save or deal only half damage with weapon attacks that use STR or DEX for 1 minute.
  - **Terrifying Roar.** This shrill roar tugs at the self - preservation instincts within creatures. Each target must succeed on a DC 18 WIS save or be frightened for 1 minute. While frightened, a creature's speed is 0. If a creature fails the save by 5 or more, it is also paralyzed while frightened.
  - **Thunderous Roar.** This booming roar slams against the chosen creatures. Each target must succeed on a DC 18 STR save or be pushed up to 15 feet away from the sphinx, knocked prone, and deafened for 1 minute.

**Legendary Actions**

The sphinx can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The sphinx regains spent legendary actions at the start of its turn.

- **_Teleport._** The sphinx magically teleports, along with any equipment it is wearing or carrying, up to 120 feet to an unoccupied space it can see.
- **_Cast A Spell (Costs 2 Actions)._** The Sphinx Uses Spellcasting.
- **_Lacerating Swipe (Costs 2 Actions)._** The Sphinx Rears Up On Its Hind legs, wings fluttering, and swipes in a wide arc with both its forepaws. Each creature in a 15 - foot cone must succeed on a DC 18 DEX save or take 11 (2d10) slashing damage and suffer a bleeding wound. A creature with a bleeding wound loses 5 (1d10) HP at the start of each of its turns. Any creature can take an action to stanch the wound with a successful DC 18 WIS (Medicine) check. The wound also closes if the bleeding creature receives magical healing.

#### Gynosphinx (CR 11)

_Large Monstrosity_

- **Armor Class** 17 (natural armor)
- **Hit Points** 204
- **Speed** 40 ft., fly 60 ft.
- **Perception** 18
- **Stealth** 12
- **Resistant** bludgeoning, piercing, and slashing damage from nonmagical ttacks | Monstrosity Resilience
- **Immune** psychic | charmed, frightened
- **Senses** truesight 120 ft.
- **Languages** Common, Sphinx, telepathy 120 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +2 |  +3 |  +8 |  +8 |  +5 |

- **_Inscrutable._** The sphinx is immune to any effect that would sense its emotions or read its thoughts, as well as any divination spell that it refuses. WIS (Insight) checks made to ascertain the sphinx's intentions or sincerity have disadvantage.
- **_Monstrosity Resilience._** The sphinx is resistant to exhaustion and to the frightened condition.
- **_Psychic Claws._** The sphinx's Claw attacks are magical. When the sphinx hits with a Claw attack, the Claw deals an extra 3d6 psychic damage (included in the attack).

**Actions**

- **_Multiattack._** The sphinx makes three Claw attacks, or it makes four Psychic Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Claw._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one target. _Hit:_ 15 (2d10+4) slashing damage plus 10 (3d6) psychic damage.
- **_Psychic Bolt._** _Ranged Spell Attack:_ +9 to hit, range 120 ft., one target. _Hit:_ 19 (4d6+5) psychic damage.
- **_Spellcasting._** The sphinx casts one of the following spells, requiring no spell components and using CHA as the spellcasting ability (spell save DC 17).
  - At will: _detect magic_, _minor illusion_, _prestidigitation_
  - 3/day each: _augury_ (as an action), _major image_, _suggestion_, _tongues_
  - 1/day: h*allucinatory terrain* (as an action)

**Bonus Actions**

- **_Psychic Connection._** One creature the sphinx can see within 60 feet of it must succeed on a DC 17 WIS save or be mentally connected to the sphinx until the sphinx chooses to end it or until the sphinx dies or the target dies. While connected in this way, the sphinx can cause the target to experience one of the following effects at the start of each of the target's turns. The effect lasts until the start of the target's next turn or until the connection ends. The target can repeat the save at the end of each of its turns, ending the connection on a success.
  - **Disoriented.** When the target moves, it moves in a random direction.
  - **Distracted.** When the target casts a spell, it must succeed on a DC 17 WIS save or be unable to cast the spell, using the action, bonus action, or reaction to cast the spell but not expending the spell slot or similar limited use of the spell.
  - **Seeing Double.** The target has disadvantage on weapon attack rolls.

**Legendary Actions**

The sphinx can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The sphinx regains spent legendary actions at the start of its turn.

- **_Teleport._** The sphinx magically teleports, along with any equipment it is wearing or carrying, up to 120 feet to an unoccupied space it can see.
- **_Cast A Spell (Costs 2 Actions)._** The Sphinx Uses Spellcasting.
- **_Psychic Burst (Costs 2 Actions)._** The Sphinx Sends Out A Burst Of psychic energy. Each creature within 20 feet of the sphinx that has an INT of 8 or higher must succeed on a DC 17 INT save or be incapacitated until the end of its next turn, as it reels from the psychic onslaught.

### Sporeborn

#### Skullbloom (CR 1/2)

_Medium Plant_

- **Armor Class** 11 (natural armor)
- **Hit Points** 23
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 12
- **Resistant** Plant Resilience
- **Senses** keensense 10 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +2 |  -4 |  -1 |  -3 |

- **_Heightened Hearing._** The skullbloom's Perception is 16 while perceiving by hearing.
- **_Plant Resilience._** The skullbloom is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Multiattack._** The skullbloom makes one Bite attack and one Slam attack. If the Bite and Slam attacks both hit one Humanoid, the target must succeed on a DC 12 CON save or be infected with apocalyptic fungus (see sidebar).
- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) piercing damage plus 2 (1d4) poison damage.
- **_Slam._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) bludgeoning damage.

**Bonus Actions**

- **_Instinct to Pursue._** The skullboom takes the Dash action toward an uninfected Humanoid it can see or sense.

#### Bloatblossom (CR 2)

_Medium Plant_

- **Armor Class** 15 (natural armor)
- **Hit Points** 60
- **Speed** 20 ft.
- **Perception** 11
- **Stealth** 12
- **Resistant** Plant Resilience
- **Senses** keensense 60 ft. (can't sense beyond this radius)
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +3 |  -4 |  -1 |  -3 |

- **_Heightened Hearing._** The bloatblossom's Perception is 16 while perceiving by hearing.
- **_Plant Resilience._** The bloatblossom is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Multiattack._** The bloatblossom makes one Bite attack and one Slam attack, or it makes two Toxic Nodule attacks. If the Bite and Slam attacks both hit one Humanoid, the target must succeed on a DC 13 CON save or be infected with apocalyptic fungus (see sidebar).
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage plus 4 (1d8) poison damage.
- **_Slam._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) bludgeoning damage plus 4 (1d8) poison damage. If the target is Medium or smaller, it is grappled (escape DC 13).
- **_Toxic Nodule._** _Ranged Weapon Attack:_ +5 to hit, range 30/60 ft., one target. _Hit:_ 12 (2d8+3) poison damage, and the target must succeed on a DC 13 CON save or be poisoned until the end of its next turn.

**Bonus Actions**

- **_Instinct to Pursue._** The bloatblossom takes the Dash action toward an uninfected Humanoid it can see or sense.

### Sprite (CR 1/4)

_Tiny Fey_

- **Armor Class** 14 (leather armor)
- **Hit Points** 13
- **Speed** 10 ft., fly 40 ft.
- **Perception** 11
- **Stealth** 17
- **Resistant** Fey Resilience
- **Senses** -
- **Languages** Common, Elvish, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +3 |  +0 |  +2 |  +1 |  +0 |

- **_Fey Resilience._** The sprite is resistant to the charmed and unconscious conditions.
- **_Speak with Beasts and Plants._** The sprite can communicate with Beasts and Plants as if they shared a language.

**Actions**

- **_Shortsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.
- **_Shortbow._** _Ranged Weapon Attack:_ +5 to hit, range 80/320 ft., one target. _Hit:_ 6 (1d6+3) piercing damage, and the target must succeed on a DC 13 CON save or be poisoned for 1 minute. If the save fails by 5 or more, the poisoned target falls unconscious for the same duration, or until it takes damage or another creature takes an action to shake it awake.
- **_Invisibility._** The sprite magically turns invisible until it attacks or casts a spell, or until its concentration ends (as if concentrating on a spell). Any equipment the sprite wears or carries is invisible with it.

**Bonus Actions**

- **_Heart Sight._** The sprite touches a creature and magically knows the creature's current emotional state. If the target fails a DC 13 CHA save, the sprite also knows if the creature has malign intentions or intends to commit malevolent acts within the next hour. Celestials, Fiends, and Undead automatically fail the save.
- **_Swift Flight._** The sprite moves up to half its speed without provoking opportunity attacks.

### Star Crow (CR 1/4)

_Tiny Aberration_

- **Armor Class** 15 (natural armor)
- **Hit Points** 12
- **Speed** 20 ft., fly 60 ft. (hover)
- **Perception** 13
- **Stealth** 15
- **Vulnerable** poison
- **Resistant** Aberrant Resilience
- **Immune** psychic, radiant | blinded, exhaustion, prone
- **Senses** truesight 120 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +3 |  +1 |  -5 |  +3 |  -5 |

- **_Aberrant Resilience._** The star crow is resistant to the charmed, frightened, paralyzed, and stunned conditions, and it has advantage on saves against spells or effects that would alter its form.
- **_Illumination._** The star crow sheds bright light in a 20 - foot radius and dim light for an additional 20 feet.

**Actions**

- **_Radiant Touch._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) radiant damage, and the star crow attaches to the target. While attached, the star crow can use only the Thought Share action and Blinding Burst bonus action, and it moves with the target whenever the target moves, requiring none of the star crow's movement. The star crow can detach itself by spending 5 feet of its movement. A creature, including the target, can take its action to detach the star crow by succeeding on a DC 13 STR check.
- **_Thought Share._** The star crow learns some of the attached target's memories, and the attached target experiences a rapid sequence of memories from other creatures the star crow has encountered. The target takes 5 (2d4) psychic damage and must succeed on a DC 13 CHA save or be stunned until the end of its next turn.

**Bonus Actions**

- **_Blinding Burst (Recharge 5 - 6)._** The star crow dims then suddenly bursts with blinding light. Each creature within 30 feet of the star crow must succeed on a DC 13 CON save or be blinded until the end of its next turn.

### Stirge (CR 1/8)

_Tiny Beast_

- **Armor Class** 14 (natural armor)
- **Hit Points** 7
- **Speed** 10 ft., fly 40 ft.
- **Perception** 9
- **Stealth** 12
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +0 |  -4 |  -1 |  -2 |

**Actions**

- **_Blood Drain._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 4 (1d4+2) piercing damage, and the stirge attaches to the target. While attached, the stirge can't attack, and at the start of each of the stirge's turns, the target loses 4 (1d4+2) HP due to blood loss. The attached stirge moves with the target whenever the target moves, requiring none of the stirge's movement. If can detach itself by spending 5 feet of its movement on its turn. It does so after it drains 8 HP of blood from the target or the target dies. A creature, including the target, can use its action to detach the stirge.

**Reactions**

- **_Reactive Wiggle._** When the stirge is the target of an attack from a creature within 5 feet of it while it is attached to a creature, the stirge can wiggle, exposing the flesh where it is attached. The attacker must succeed on a DC 12 DEX save or the attack targets the creature to which the stirge is attached instead of the stirge.

### Succubus (CR 4)

_Medium Fiend (Shapechanger)_

- **Armor Class** 15 (natural armor)
- **Hit Points** 79
- **Speed** 30 ft., fly 60 ft.
- **Perception** 15
- **Stealth** 15
- **Resistant** cold, fire, lightning, poison; bludgeoning, piercing, and lashing damage from nonmagical attacks | frightened, poisoned
- **Immune** charmed
- **Senses** darkvision 60 ft.
- **Languages** Abyssal, Common, Infernal, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +3 |  +1 |  +2 |  +1 |  +7 |

- **_Telepathic Bond._** The succubus ignores the range restriction on its telepathy when communicating with a creature it has charmed. The two don't even need to be on the same plane of existence.

**Actions**

- **_Multiattack._** The succubus makes two Claw attacks or one Claw attack and one Draining Kiss attack. It can replace one attack with Charm.
- **_Claw (Fiend Form Only)._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage plus 7 (2d6) psychic damage.
- **_Draining Kiss._** Melee Spell Attack: +7 to hit, reach 5 ft., one willing creature, or a creature that is charmed, incapacitated, or restrained. _Hit:_ 15 (3d6+5) psychic damage, and the target's HP maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0.
- **_Charm._** One Humanoid the succubus can see within 30 feet of it must succeed on a DC 15 WIS save or be magically charmed for 1 day, until the succubus dies, or until the succubus takes a bonus action to end the effect. The charmed target obeys the succubus's verbal or telepathic commands. If the target suffers any harm or receives a suicidal command, it can repeat the save, ending the effect on itself on a success. If the target successfully saves against the effect, or if the effect on it ends, the target is immune to this succubus's Charm for the next 24 hours.

  The succubus can have only one target charmed at a time. If it charms another, the effect on the previous target ends.

**Bonus Actions**

- **_Change Shape._** The succubus transforms into a Small or Medium Humanoid or back into its true form, which is Fiend. Without wings, it loses its flying speed. Its statistics, other than its size, are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.
- **_Etherealness._** The succubus magically enters the Ethereal Plane from the Material Plane, or vice versa.

**Reactions**

- **_Defend Me, Love!_** When a creature the succubus can see within 5 feet of a creature charmed by the succubus attacks the succubus, the succubus can command the charmed creature to use its reaction to make one melee weapon attack against the attacker.

### Tarrasque (CR 30)

_Gargantuan Monstrosity_

- **Armor Class** 25 (natural armor)
- **Hit Points** 680
- **Speed** 40 ft., burrow 30 ft.
- **Perception** 19
- **Stealth** 13
- **Vulnerable** thunder
- **Resistant** Monstrosity Resilience
- **Immune** fire, poison; bludgeoning, piercing, and slashing damage from nonmagical attacks | charmed, frightened, paralyzed, poisoned
- **Senses** keensense 120 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
| +10 |  +3 | +10 |  +5 |  +9 |  +9 |

- **_Legendary Resistance (3/Day)._** If the tarrasque fails a save, it can choose to succeed instead.
- **_Magic Resistance._** The tarrasque has advantage on saves against spells and other magical effects.
- **_Monstrosity Resilience._** The tarrasque is resistant to exhaustion.
- **_Reflective Hide._** Any time the tarrasque is targeted by a magic missile spell, a line spell, or a spell that requires a ranged attack roll, roll a d6. On a 1 to 5, the tarrasque is unaffected. On a 6, the tarrasque is unaffected, and the effect is reflected back at the caster as though it originated from the tarrasque, turning the caster into the target.
- **_Siege Behemoth._** The tarrasque deals triple damage to objects and structures.

**Actions**

- **_Multiattack._** The tarrasque uses its Frightful Presence. It then makes one Bite attack, four Claw attacks, and one Spiked Tail attack, or it makes five Acid Spit attacks.
- **_Bite._** _Melee Weapon Attack:_ +19 to hit, reach 10 ft., one target. _Hit:_ 36 (4d12+10) piercing damage. If the target is a creature, it must succeed on a DC 27 DEX save or be swallowed by the tarrasque. A swallowed creature is blinded and restrained, it has total cover against attacks and other effect outside of the tarrasque, and it takes 42 (12d6) acid damage at the start of each of the tarrasque's turns. If the tarrasque takes 60 damage or more on a single turn from a creature inside it, the tarrasque must succeed on a DC 20 CON save at the end of that turn or regurgitate all swallowed creatures, which fall prone in a space within 10 feet of the tarrasque. If the tarrasque dies, a swallowed creature is no longer restrained by it and can escape from the corpse using 20 feet of movement, exiting prone.
- **_Claw._** _Melee Weapon Attack:_ +19 to hit, reach 15 ft., one target. _Hit:_ 28 (4d8+10) slashing damage.
- **_Spiked Tail._** _Melee Weapon Attack:_ +19 to hit, reach 20 ft., one target. _Hit:_ 20 (3d6+10) bludgeoning damage and 13 (3d8) piercing damage. If the target is a creature, it must succeed on a DC 27 STR save or be knocked prone.
- **_Acid Spit._** _Ranged Weapon Attack:_ +12 to hit, range 100/400 ft., one target. _Hit:_ 36 (6d10+3) acid damage.
- **_Frightful Presence._** Each creature of the tarrasque's choice within 120 feet of it and aware of it must succeed on a DC 27 WIS save or be frightened for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to the tarrasque's Frightful Presence for the next 24 hours.

**Legendary Actions**

The tarrasque can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The tarrasque regains spent legendary actions at the start of its turn.

- **_Detect._** The tarrasque automatically detects every creature and trap within 60 feet of it, pinpointing the current location of each.
- **_Move._** The tarrasque moves up to its speed without provoking opportunity attacks.
- **_Tail Attack._** The tarrasque makes one Tail attack.
- **_Tail Swipe (Costs 2 Actions)._** The Tarrasque Whips Its Spiked Tail In A wide arc, flailing it in a 30 - foot cone. Each creature in that area must make a DC 27 DEX save. On a failure, a creature takes 45 (10d8) piercing damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone.

### Treant (CR 9)

_Huge Plant_

- **Armor Class** 16 (natural armor)
- **Hit Points** 185
- **Speed** 30 ft.
- **Perception** 17
- **Stealth** 9
- **Vulnerable** fire
- **Resistant** bludgeoning, piercing | Plant Resilience
- **Senses** tremorsense 30 ft.
- **Languages** Common, Druidic, Elvish, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  -1 |  +9 |  +1 |  +7 |  +1 |

- **_False Appearance._** While the treant remains motionless, it is indistinguishable from a normal tree.
- **_Plant Resilience._** The treant is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.
- **_Siege Monster._** The treant deals double damage to objects and structures.
- **_Speak with Plants._** The treant can communicate with Plants and nonmagical plants as if they shared a language.

**Actions**

- **_Multiattack._** The treant makes three Slam attacks, or it makes two Throw Rock attacks. If two Slam attacks hit one creature, the target must succeed on a DC 17 STR save or be knocked prone.
- **_Slam._** _Melee Weapon Attack:_ +10 to hit, reach 5 ft., one target. _Hit:_ 22 (4d6+6) bludgeoning damage.
- **_Throw Rock._** _Ranged Weapon Attack:_ +10 to hit, range 60/180 ft., one target. _Hit:_ 33 (5d10+6) bludgeoning damage.
- **_Animate Trees (1/Day)._** The treant magically animates 2 trees or 2d6 shrubs it can see within 60 feet of it. The trees use the statistics of an **awakened tree**, and the shrubs use the statistics of an **awakened shrub**. The animated plants act as allies of the treant, obeying its spoken commands. The plants remain for 1 hour, until the treant dies, or until the treant dismisses them as a bonus action.

**Bonus Actions**

- **_Halt Intruders._** The treant calls to the roots beneath up to two creatures it can see within 30 feet of it. Each target must succeed on a DC 17 STR save or be restrained by roots until the end of its next turn. The treant can target only creatures in contact with the ground and can't target creatures in contact with a manufactured floor, such as the wooden floor of a building.

### Troll (CR 5)

_Large Giant_

- **Armor Class** 15 (natural armor)
- **Hit Points** 94
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 13
- **Vulnerable** Giant Attributes
- **Resistant** Giant Attributes
- **Senses** darkvision 60 ft.
- **Languages** Giant

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +5 |  -2 |  -1 |  -2 |

- **_Giant Attributes._** The troll is resistant to the stunned condition, and it is vulnerable to the prone condition.
- **_Heightened Smell._** The troll's Perception is 17 while perceiving by smell.
- **_Regeneration._** The troll regains 10 HP at the start of its turn. If the troll takes acid or fire damage, this trait doesn't function at the start of the troll's next turn. The troll dies only if it starts its turn with 0 HP and doesn't regenerate.

**Actions**

- **_Multiattack._** The troll makes one Bite attack and two Claw attacks.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +7 to hit, reach 10 ft., one target. _Hit:_ 11 (2d6+4) slashing damage.

**Bonus Actions**

- **_Ravenous Frenzy (52 HP or Fewer)._** Desperate for a meal as its injuries mount, the troll moves up to half its speed and makes one Bite attack against a creature it can see within range. The troll then regains HP equal to half the damage dealt.

### Unicorn (CR 5)

_Large Celestial_

- **Armor Class** 12
- **Hit Points** 92
- **Speed** 50 ft.
- **Perception** 16
- **Stealth** 12
- **Resistant** Celestial Resilience
- **Immune** poison | charmed, frightened, paralyzed, poisoned
- **Senses** darkvision 60 ft.
- **Languages** Celestial, Elvish, Sylvan, telepathy 60 ft.

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +2 |  +0 |  +6 |  +6 |

- **_Celestial Resilience._** The unicorn is resistant to radiant damage.
- **_Magic Resistance._** The unicorn has advantage on saves against spells and other magical effects.
- **_Magic Weapons._** The unicorn's weapon attacks are magical.
- **_Sense the Unnatural._** The unicorn can pinpoint the location of Aberrations and Undead within 60 feet of it.
- **_Speak with Beasts and Plants._** The unicorn can communicate with Beasts and Plants as if they shared a language.
- **_Woodland Walk._** Difficult terrain composed of nonmagical plants doesn't cost the unicorn extra movement. In addition, the unicorn can pass through nonmagical plants without being slowed by them and without taking damage from them if they have thorns, spines, or a similar hazard.

**Actions**

- **_Multiattack._** The unicorn makes one Hooves attack and one Horn attack, or it makes two Horn Bolt attacks.
- **_Hooves._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage.
- **_Horn._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 8 (1d8+4) piercing damage plus 10 (3d6) radiant damage.
- **_Horn Bolt._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 13 (3d6+3) radiant damage.
- **_Unicorn Magic._** The unicorn can cast the dancing lights and druidcraft cantrips at will, requiring no material components and using WIS as the spellcasting ability.
- **_Healing Touch (3/Day)._** The unicorn touches another creature with its horn. The target magically regains 11 (2d8+2) HP and is freed from all curses, diseases, and poisons afflicting it.

**Reactions**

- **_Shimmering Shield._** When a creature the unicorn can see within 30 feet of it, including the unicorn, is attacked, the unicorn can surround it with a shimmering shield of radiant light. The target adds 3 to its AC against the attack.

**Legendary Actions**

The unicorn can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The unicorn regains spent legendary actions at the start of its turn.

- **_Canter._** The unicorn moves up to half is speed without provoking opportunity attacks.
- **_Radiant Stomp (Costs 2 Actions)._** The Unicorn Raises Its Hooves Glowing with golden light and brings them down with a reverberating stomp. Each hostile creature within 10 feet of the unicorn must make a DC 14 STR save. On a failure, a creature takes 10 (3d6) radiant damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone.
- **_Heal Self (Costs 3 Actions)._** The Unicorn Magically Regains 11 (2d8+2) HP.

### Vampires

#### Vampire (CR 13)

_Medium Undead (Shapechanger)_

- **Armor Class** 16 (natural armor)
- **Hit Points** 177
- **Speed** 30 ft., climb 30 ft. (40 ft. in wolf form, fly 30 ft. in bat form, wim 20 ft. in rat form)
- **Perception** 17
- **Stealth** 19
- **Resistant** necrotic; bludgeoning, piercing, and slashing damage from onmagical attacks | charmed
- **Immune** Vampiric Resilience
- **Senses** darkvision 120 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +9 |  +4 |  +3 |  +7 |  +9 |

- **_Hungry Dead Nature._** The vampire doesn't require air or sleep. In addition, it must consume at least 80 ounces of blood (approximately half the blood in a Medium Humanoid's body) every 24 hours, or it loses its immunity to exhaustion and risks starvation until it does so. While it has any levels of exhaustion from starvation, the vampire can't remove levels of exhaustion until it consumes at least 160 ounces of blood.
- **_Legendary Resistance (3/Day)._** If the vampire fails a save, it can choose to succeed instead.
- **_Misty Escape._** When it drops to 0 HP outside its resting place, the vampire transforms into a cloud of mist (as in the Mist Form bonus action) instead of falling unconscious, provided it isn't in sunlight or running water. If it can't transform, it is destroyed. While it has 0 HP in mist form, it can't revert to its vampire form, and it must reach its resting place within 2 hours or be destroyed. Once in its resting place, it reverts to its vampire form. It is then paralyzed until it regains at least 1 HP. After spending 1 hour in its resting place with 0 HP, it regains 1 HP.
- **_Regeneration._** The vampire regains 20 HP at the start of its turn if it has at least 1 HP and isn't in sunlight or running water. If the vampire takes radiant damage or damage from holy water, this trait doesn't function at the start of the vampire's next turn.
- **_Resting Place._** The vampire has a coffin, grave, sarcophagus, or similar location just large enough for it to lie down designated as its resting place. While in its resting place, the vampire doesn't suffer exhaustion levels from starvation and has keensense out to a range of 120 feet.
- **_Spider Climb._** The vampire can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Vampire Weaknesses._** The vampire has the following flaws:
- **Forbiddance.** The vampire can't enter a residence without an invitation from one of the occupants.
- **Harmed by Running Water.** The vampire takes 20 acid damage if it ends its turn in running water.
- **_Stake to the Heart._** If a piercing weapon made of wood is driven into the vampire's heart while the vampire is incapacitated in its resting place, the vampire is paralyzed until the stake is removed.
- **_Sunlight Hypersensitivity._** The vampire takes 20 radiant damage when it starts its turn in sunlight. While in sunlight, it has disadvantage on attack rolls and ability checks.
- **_Vampiric Resilience._** The vampire is immune to exhaustion.

**Actions**

- **_Multiattack._** The vampire can use Charm. It then makes three Bite or Claw attacks. It can replace one attack with a Draining Bite attack. If two Claw attacks hit one Large or smaller creature, the target is grappled (escape DC 17).
- **_Bite (Bat, Rat, or Wolf Form Only)._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) piercing damage plus 14 (4d6) necrotic damage.
- **_Claw (Vampire Form Only)._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 11 (2d6+4) slashing damage plus 14 (4d6) necrotic damage.
- **_Draining Bite (Bat or Vampire Form Only)._** Melee Weapon Attack: +9 to hit, reach 5 ft., one willing creature, or a creature that is grappled by the vampire, incapacitated, or restrained. _Hit:_ 9 (2d4+4) piercing damage plus 14 (4d6) necrotic damage. The target's HP maximum is reduced by an amount equal to the necrotic damage taken, and the vampire regains HP equal to that amount. The reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0. A Humanoid slain in this way and then fed at least one drop of the vampire's blood rises the following night as a **vampire spawn** under the vampire's control.
- **_Charm (Vampire Form Only)._** One Humanoid the vampire can see within 30 feet of it must succeed on a DC 17 WIS save or be magically charmed for 1 day, until the vampire dies, or until the vampire takes a bonus action to end the effect. The charmed target obeys the vampire's verbal commands and is a willing target for the vampire's Draining Bite attack. If the target suffers any harm or receives a suicidal command, it can repeat the save, ending the effect on itself on a success.

  The vampire can have up to two creatures charmed in this way at a time. If it charms a third, the effect on the first target ends.

- **_Children of the Night._** The vampire magically calls 2d4 **swarms of bats** or **rats**, provided that the sun isn't up. While outdoors, the vampire can call 3d6 **wolves** instead. The called creatures arrive in 1d4 rounds, acting as allies of the vampire and obeying its spoken commands. The Beasts remain for 1 hour, until the vampire dies, or until the vampire dismisses them as a bonus action. The vampire can have any number of such Beasts under its control at one time, provided the combined total CR of the Beasts is no higher than 4.

**Bonus Actions**

- **_Change Shape._** The vampire transforms into a Tiny bat, Tiny rat, Medium wolf, or back into its true form, which is Undead. Its statistics, other than its size and speed, are the same in each form. Any equipment it is wearing transforms with it, but anything it is carrying doesn't transform with it. It reverts to its true form if it dies.
- **_Mist Form._** The vampire transforms into a Medium cloud of mist or back into its true form, which is Undead. While in mist form, it can't take any actions, speak, or manipulate objects. It is weightless, has a flying speed of 20 feet, can hover, and can enter a hostile creature's space and stop there. In addition, if air can pass through a space, the mist can do so without squeezing, and it can't pass through water. It has advantage on STR, DEX, and CON saves, and it is immune to all nonmagical damage, except the damage it takes from sunlight.

**Legendary Actions**

The vampire can take 3 legendary actions, choosing from the options below. Only one legendary action option can be used at a time and only at the end of another creature's turn. The vampire regains spent legendary actions at the start of its turn.

- **_Move._** The vampire moves up to its speed without provoking opportunity attacks.
- **_Call Children (Costs 2 Actions)._** The Vampire Uses Children Of The Night.
- **_Excessive Bleeding (Costs 2 Actions)._** Each Creature Within 15 Feet Of the vampire that doesn't have all its HP must succeed on a DC 17 CON save or lose 14 (4d6) HP as its wounds bleed profusely. Before the end of its next turn, the vampire has advantage on the next attack roll it makes against a creature that failed this save.

#### Vampire Spawn (CR 5)

_Medium Undead_

- **Armor Class** 15 (natural armor)
- **Hit Points** 91
- **Speed** 30 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 16
- **Resistant** necrotic; bludgeoning, piercing, and slashing damage from onmagical attacks
- **Immune** Vampiric Resilience
- **Senses** darkvision 60 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +6 |  +3 |  +0 |  +3 |  +1 |

- **_Hungry Dead Nature._** As the **vampire**.
- **_Regeneration._** The vampire spawn regains 10 HP at the start of its turn if it has at least 1 HP and isn't in sunlight or running water. If the vampire takes radiant damage or damage from holy water, this trait doesn't function at the start of the vampire's next turn.
- **_Resting Place._** As the **vampire**.
- **_Spider Climb._** As the **vampire**.
- **_Vampire Weaknesses._** As the **vampire**.
- **_Vampiric Resilience._** The vampire is immune to exhaustion.

**Actions**

- **_Multiattack._** The vampire spawn makes two Claw attacks. It can replace one attack with a Draining Bite attack. If both Claw attacks hit one Large or smaller creature, the target is grappled (escape DC 14).
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 8 (2d4+3) slashing damage plus 10 (3d6) necrotic damage.
- **_Draining Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one willing creature, or a creature that is grappled by the vampire, incapacitated, or restrained. _Hit:_ 8 (2d4+3) piercing damage plus 10 (3d6) necrotic damage. The target's HP maximum is reduced by an amount equal to the necrotic damage taken, and the vampire regains HP equal to that amount. The reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0.

**Bonus Actions**

- **_Call Blood._** The vampire calls to the blood within one injured creature it can see within 10 feet of it, causing blood to pour from the creature's wounds. If the target doesn't have all its HP, it must make a DC 14 CON save, losing 7 (2d6) HP on a failed save, or losing half as much HP on a successful one. Before the end of its next turn, the vampire has advantage on the next attack roll it makes against a creature that failed the save.

#### Vampire Thrall (CR 1)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13
- **Hit Points** 40
- **Speed** 30 ft., climb 10 ft.
- **Perception** 13
- **Stealth** 14
- **Resistant** exhaustion
- **Senses** darkvision 30 ft.
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +5 |  +4 |  +0 |  +1 |  +2 |

- **_Blood - Bound._** If the thrall has not consumed 1 ounce of blood from a vampire within the past week, it is poisoned for 1 week, and it loses darkvision and its Limited Regeneration, Spider Climb, and Sunlight Sensitivity traits until it consumes 1 ounce of vampire blood.
- **_Limited Regeneration._** The thrall regains 2 HP at the start of its turn if it has at least 1 HP and isn't in sunlight. If the thrall takes radiant damage, this trait doesn't function at the start of the thrall's next turn.
- **_Spider Climb._** The thrall can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Sunlight Sensitivity._** While in sunlight, the thrall has disadvantage on attack rolls, and its Perception is 8 when perceiving by sight.

**Actions**

- **_Multiattack._** The vampire thrall makes two Rapier attacks.
- **_Rapier._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) piercing damage.

**Reactions**

- **_Repay the Gift._** When a friendly vampire the thrall can see within 5 feet of it is hit by an attack that would reduce the vampire to 0 HP, the thrall can give some of its life force to save the vampire. The thrall loses 10 (3d6) HP, and the vampire regains HP equal to that amount.

### Wight (CR 3)

_Medium Undead_

- **Armor Class** 14 (studded leather)
- **Hit Points** 69
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 14
- **Resistant** necrotic; bludgeoning, piercing, and slashing damage from onmagical attacks
- **Immune** Undead Resilience | frightened
- **Senses** darkvision 60 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +3 |  +0 |  +1 |  +2 |

- **_Martial Adept._** A manufactured weapon, such as a sword or bow, deals one extra die of its damage when the wight hits with it (included in the attack).
- **_Sunlight Sensitivity._** While in sunlight, the wight has disadvantage on attack rolls, and its Perception is 8 when perceiving by sight.
- **_Undead Nature._** The wight doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The wight is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The wight makes two Longsword or Longbow attacks. It can replace one attack with a Life Drain attack.
- **_Life Drain._** Melee Spell Attack: +5 to hit, reach 5 ft., one creature. _Hit:_ 10 (2d6+3) necrotic damage. The target must succeed on a DC 13 CON save or its HP maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0.

  A Humanoid slain by this attack rises 24 hours later as a zombie under the wight's control, unless the Humanoid is restored to life or its body is destroyed. The wight can have no more than twelve zombies under its control at one time.

- **_Longsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) slashing damage, or 14 (2d10+3) slashing damage if used with two hands.
- **_Longbow._** _Ranged Weapon Attack:_ +4 to hit, range 150/600 ft., one target. _Hit:_ 11 (2d8+2) piercing damage.

**Bonus Actions**

- **_Command Horde._** The wight commands up to five friendly skeletons or zombies to do one of the following:
  - **Protect.** Until the start of the wight's next turn, each time a friendly creature within 5 feet of a target is attacked, the target can use its reaction to intercept the attack, becoming the target instead.
  - **Overwhelm.** Until the start of the wight's next turn, each target has advantage on attack rolls against a creature on its turn if at least one other target is within 5 feet of the creature and the allied target isn't incapacitated.
  - **Shamble.** Each target uses its reaction to move up to its speed in a direction chosen by the wight. If this movement provokes an opportunity attack, that attack is made with disadvantage.

### Will - o'-Wisp (CR 2)

_Tiny Undead_

- **Armor Class** 17 (Ephemeral)
- **Hit Points** 31
- **Speed** 0 ft., fly 50 ft. (hover)
- **Perception** 13
- **Stealth** 14
- **Resistant** acid, cold, fire, necrotic, thunder; bludgeoning, piercing, and lashing damage from nonmagical attacks
- **Immune** lightning | grappled, paralyzed, prone, restrained, unconscious | Undead Resilience
- **Senses** darkvision 120 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -5 |  +4 |  +0 |  +1 |  +3 |  +0 |

- **_Ephemeral._** The will - o'-wisp can't wear or carry anything. In addition, it adds its WIS modifier to its AC (included above).
- **_Incorporeal Movement._** The will - o'-wisp can move through other creatures and objects as if they were difficult terrain. It takes 5 (1d10) force damage if it ends its turn inside an object.
- **_Variable Illumination._** The will - o'-wisp sheds bright light in a 5- to 20 - foot radius and dim light for an additional number of feet equal to the chosen radius. The will - o'-wisp can alter the radius as a bonus action.
- **_Undead Nature._** The will - o'-wisp doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The will - o'-wisp is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The will - o'-wisp makes two Shock attacks.
- **_Shock._** Melee Spell Attack: +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) lightning damage.
- **_Invisibility._** The will - o'-wisp and its light magically become invisible until it attacks or uses its Beckon, or until its concentration ends (as if concentrating on a spell).

**Bonus Actions**

- **_Beckon._** The will - o'-wisp pulses its lightly gently toward one creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or use its reaction to move up to its speed toward the will - o'-wisp by the most direct route. It doesn't avoid opportunity attacks or damaging terrain when moving.

**Reactions**

- **_Consume Life._** When a creature the will - o'-wisp can see within 15 feet of it is reduced to 0 HP, the will - o'-wisp can consume some of that creature's fading life. The will - o'-wisp gains 7 (2d6) temporary HP, and the creature has disadvantage on the next death save it makes before the end of the wisp's next turn.

### Winter Wolf (CR 3)

_Large Monstrosity_

- **Armor Class** 13 (natural armor)
- **Hit Points** 76
- **Speed** 50 ft.
- **Perception** 15
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Immune** cold
- **Senses** -
- **Languages** Common, Giant, Winter Wolf

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  -2 |  +1 |  -1 |

- **_Heightened Hearing and Smell._** The winter wolf's Perception is 20 when perceiving by hearing or smell.
- **_Monstrosity Resilience._** The winter wolf is resistant to exhaustion and to the frightened condition.
- **_Pack Tactics._** The winter wolf has advantage on attack rolls against a creature if at least one of the winter wolf's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Snow Camouflage._** The winter wolf's Stealth is 18 while in snowy terrain.

**Actions**

- **_Multiattack._** The winter wolf makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage plus 4 (1d8) cold damage. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.
- **_Cold Breath (Recharge 5 - 6)._** The winter wolf exhales a blast of freezing wind in a 15 - foot cone. Each creature in that area must make a DC 13 DEX save, taking 18 (4d8) cold damage on a failed save, or half as much damage on a successful one.

**Bonus Actions**

- **_Freezing Nose._** The winter wolf touches its nose to a creature it can see within 5 feet of it. The target must succeed on a DC 13 CON save or one of the following parts of its body (the winter wolf's choice) is encased in ice for 1 minute. The target can repeat the save at the end of each of its turns, ending the effect on itself on a success. If the target takes fire damage, it has advantage on the next save it makes to end the effect.
  - **Body.** The target has disadvantage on CON saves and is vulnerable to the first instance of cold damage it takes each turn.
  - **Head.** The target can't breathe or speak.
  - **Lower Limb.** The target's speed is reduced to 0, and it has disadvantage on DEX checks and DEX saves.
  - **Upper Limb.** The target has disadvantage on weapon attack rolls made with that limb.

### Wood Herald (CR 1/2)

_Small Plant_

- **Armor Class** 13 (natural armor)
- **Hit Points** 27
- **Speed** 20 ft., climb 20 ft.
- **Perception** 11
- **Stealth** 13
- **Vulnerable** fire
- **Resistant** Plant Resilience
- **Senses** darkvision 60 ft.
- **Languages** Common, Sylvan

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  +0 |  +1 |  +0 |

- **_Plant Camouflage._** The wood herald's Stealth is 18 while in any terrain with ample, obscuring plant life.
- **_Plant Resilience._** The wood herald is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.
- **_Woodland Walk._** Difficult terrain composed of nonmagical plants doesn't cost the wood herald extra movement. In addition, the herald can pass through nonmagical plants without being slowed by them and without taking damage from them if they have thorns, spines, or a similar hazard.

**Actions**

- **_Slam._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) bludgeoning damage.
- **_Wooden Greataxe._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 8 (1d12+2) slashing damage.
- **_Hurl Thorn._** _Ranged Weapon Attack:_ +3 to hit, range 30/120 ft., one target. _Hit:_ 6 (2d4+1) piercing damage.

**Reactions**

- **_Brambly Bark._** When a creature the wood herald can see hits it with a melee attack while within 5 feet of it, the herald can extend sharp brambles along its body, dealing 2 (1d4) piercing damage to the attacker.

### Worg (CR 1/2)

_Large Monstrosity (Animal)_

- **Armor Class** 13 (natural armor)
- **Hit Points** 25
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 13
- **Resistant** Monstrosity Resilience
- **Senses** darkvision 60 ft.
- **Languages** Goblin, Worg

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -2 |  +0 |  -1 |

- **_Heightened Hearing and Smell._** The worg's Perception is 19 while perceiving by hearing or smell.
- **_Monstrosity Resilience._** The worg is resistant to exhaustion and to the frightened condition.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) piercing damage. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.

**Bonus Actions**

- **_Loathsome Howl (1/Day)._** The worg unleashes an unnatural howl audible out to a distance of 300 feet. Each creature of the worg's choice within 30 feet of it must succeed on a DC 13 CHA save or be frightened of it for 1 minute. A frightened creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. Until it finishes a long rest, the worg can sense the direction but not the exact location of each creature that was frightened by Loathsome Howl.

### Wraith (CR 5)

_Medium Undead_

- **Armor Class** 14
- **Hit Points** 85
- **Speed** 0 ft., fly 60 ft. (hover)
- **Perception** 12
- **Stealth** 17
- **Vulnerable** radiant
- **Resistant** acid, cold, fire, lightning, thunder; bludgeoning, piercing, and lashing damage from nonmagical attacks
- **Immune** necrotic | charmed, grappled, paralyzed, petrified, prone, restrained | Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** the languages it knew in life

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +4 |  +3 |  +1 |  +2 |  +2 |

- **_Incorporeal Movement._** The wraith can move through other creatures and objects as if they were difficult terrain. It takes 5 (1d10) force damage if it ends its turn inside an object.
- **_Sunlight Sensitivity._** While in sunlight, the wraith has disadvantage on attack rolls, and its Perception is 7 when perceiving by sight.
- **_Undead Nature._** The wraith doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The wraith is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The wraith makes two Life Drain attacks.
- **_Life Drain._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 18 (4d6+4) necrotic damage. The target must succeed on a DC 15 CON save or its HP maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if this effect reduces its HP maximum to 0.
- **_Create Specter._** The wraith targets one Humanoid it can see within 10 feet of it that has been dead for no longer than 1 minute and died violently. The target's spirit rises as a **specter** in the space of its corpse or in the nearest unoccupied space. The **specter** is under the wraith's control. The wraith can have no more than seven specters under its control at one time.

**Bonus Actions**

- **_Trail of Death (Recharge 4 - 6)._** The wraith moves up to 30 feet in a straight line. This distance is not reduced by moving through creatures or objects, and this movement doesn't provoke opportunity attacks. The first time it enters a creature's space during this move, that creature must succeed on a DC 15 DEX save or be afflicted with wasting doom. While afflicted with wasting doom, a creature takes 3 (1d6) necrotic damage at the start of each of its turns. Wasting doom ends if a creature starts its turn in sunlight or regains HP.

**Reactions**

- **_Unravel Life._** When a creature the wraith can see within 30 feet of it and that isn't a Construct or Undead regains HP, the wraith can corrupt the healing energies, halving the amount of healing that creature receives.

### Wyrdling (CR 1)

_Medium Humanoid_

- **Armor Class** 12
- **Hit Points** 40
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** psychic | charmed, frightened
- **Senses** -
- **Languages** Common

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +1 |  +1 |  +5 |  +2 |

- **_Intuition._** The wyrdling rolls two dice for initiative, taking the higher number. In addition, the wyrdling has advantage on WIS (Insight) checks.
- **_Read Fate._** The wyrdling can spend 1 minute communing with fate on behalf of one creature that remains within 10 feet of it for the duration. The creature must ask a single question concerning a specific goal, event, or activity to occur within 7 days. At the end of the minute, the wyrdling pronounces the result of the target's inquiry. This trait works like the divination spell, except it can't be used to answer a specific creature's question more than once every 3 days, regardless if the creature asks a different question.

**Actions**

- **_Psychic Burst._** _Melee or Ranged Spell Attack:_ +5 to hit, reach 5 ft. or range 60 ft., one target. _Hit:_ 13 (3d6+3) psychic damage.

**Bonus Actions**

- **_Pronounce Fate._** The wyrdling pronounces the fate, either fortune or doom (the wyrdling's choice), of one creature it can see within 30 feet of it. The target rolls a d4 and adds (fortune) or subtracts (doom) the number rolled to the next attack roll or save it makes before the start of the wyrdling's next turn.

**Reactions**

- **_Call on Fate._** When the wyrdling is attacked by a creature it can see, it can pluck the strands of fate around the creature, imposing disadvantage on that attack roll. If the attack misses, the wyrdling or one friendly creature it can see within 30 feet of it has advantage on the next attack roll it makes against the attacker before the end of the wyrdling's next turn.

### Wyvern (CR 6)

_Large Dragon_

- **Armor Class** 13 (natural armor)
- **Hit Points** 147
- **Speed** 20 ft., fly 80 ft.
- **Perception** 14
- **Stealth** 10
- **Vulnerable** Clumsy
- **Immune** poison | poisoned
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +3 |  -3 |  +1 |  -2 |

- **_Clumsy._** While not flying, the wyvern is vulnerable to the grappled, prone, and restrained conditions.

**Actions**

- **_Multiattack._** The wyvern makes one Bite attack and one Stinger attack. While flying, it can replace one attack with a Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 11 (2d6+4) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) slashing damage.
- **_Stinger._** _Melee Weapon Attack:_ +7 to hit, reach 15 ft., one creature. _Hit:_ 15 (2d10+4) piercing damage plus 18 (4d8) poison damage. The target must succeed on a DC 15 CON save or be poisoned for 1 minute. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Reactions**

- **_Reflexive Tail Whip._** When a creature moves into a space within 15 feet of the wyvern, it can whip its tail at the creature. The target must succeed on a DC 15 STR save or be knocked prone.

### Xorn (CR 5)

_Medium Elemental_

- **Armor Class** 19 (natural armor)
- **Hit Points** 111
- **Speed** 20 ft., burrow 20 ft.
- **Perception** 16
- **Stealth** 13
- **Vulnerable** thunder
- **Resistant** piercing and slashing damage from nonmagical attacks
- **Senses** darkvision 60 ft., tremorsense 60 ft.
- **Languages** Terran

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +6 |  +0 |  +0 |  +0 |

- **_Earth Glide._** The xorn can burrow through nonmagical, unworked earth and stone. While doing so, the xorn doesn't disturb the material through which it moves.
- **_Stone Camouflage._** The xorn's Stealth is 18 while in rocky terrain.
- **_Treasure Sense._** The xorn can pinpoint, by scent, the location of precious metals and stones, such as coins and gems, within 60 feet of it.

**Actions**

- **_Multiattack._** The xorn makes one Bite attack and three Claw attacks, or it makes three Lob Stone attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (3d6+3) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) slashing damage.
- **_Lob Stone._** _Ranged Weapon Attack:_ +6 to hit, range 20/60 ft., one target. _Hit:_ 12 (2d8+3) bludgeoning damage.

**Bonus Actions**

- **_Shard Belch._** The xorn belches a mixture of stomach gas and crystalline shards in a 15 - foot cone. Each creature in the area must succeed on a DC 14 DEX save or be coated in miniscule, crystalline shards until the end of its next turn. A creature coated in shards suffers bouts of pain each time it moves, reducing its speed by 10 feet and imposing disadvantage on all weapon attack rolls.

### Zombies

#### Zombie (CR 1/4)

_Medium Undead_

- **Armor Class** 8
- **Hit Points** 16
- **Speed** 20 ft.
- **Perception** 10
- **Stealth** 8
- **Immune** Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands the languages it knew in life but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  -2 |  +3 |  -4 |  +0 |  -3 |

- **_Undead Fortitude._** If damage reduces the zombie to 0 HP, it must make a CON save with a DC equal to 5 + the damage taken, unless the damage is radiant or from a critical hit. On a success, the zombie drops to 1 HP instead.
- **_Undead Nature._** The zombie doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The zombie is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Slam._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) bludgeoning damage. The target is grappled (escape DC 12) if it is a Medium or smaller creature, and the zombie doesn't already have a creature grappled.

**Bonus Actions**

- **_Rotten Hold._** The zombie gnaws idly on the creature grappled by it. The target must succeed on a DC 12 CON save or take 2 (1d4) poison damage. A Humanoid slain by this bonus action rises 24 hours later as a zombie, unless the Humanoid is restored to life or its body is destroyed.

#### Ogre Zombie (CR 2)

_Large Undead_

- **Armor Class** 8
- **Hit Points** 72
- **Speed** 30 ft.
- **Perception** 8
- **Stealth** 8
- **Immune** Undead Resilience
- **Senses** darkvision 60 ft.
- **Languages** understands Common and Giant but can't speak

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -2 |  +4 |  -4 |  -2 |  -3 |

- **_Undead Fortitude._** If damage reduces the zombie to 0 HP, it must make a CON save with a DC equal to 5 + the damage taken, unless the damage is radiant or from a critical hit. On a success, the zombie drops to 1 HP instead.
- **_Undead Nature._** The zombie doesn't require air, food, drink, or sleep.
- **_Undead Resilience._** The zombie is immune to poison damage, to exhaustion, and to the poisoned condition.

**Actions**

- **_Multiattack._** The ogre zombie makes two Greatclub attacks.
- **_Greatclub._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 13 (2d8+4) bludgeoning damage.
- **_Lumbering Charge (Recharge 5 - 6)._** The ogre zombie shoulders its weapon and charges forward, shoving into creatures on its way. It moves up to 20 feet in a straight line and can move through the space of any Medium or smaller creature. The first time it enters a creature's space during this move, that creature must make a DC 14 STR save. On a failure, a creature takes 14 (4d6) bludgeoning damage and is knocked prone. On a success, a creature takes half the damage and isn't knocked prone.

## Animals

### Ape (CR 1/2)

_Medium Beast_

- **Armor Class** 12
- **Hit Points** 25
- **Speed** 30 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** stunned
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +2 |  +2 |  -2 |  +1 |  -2 |

**Actions**

- **_Multiattack._** The ape makes two Fist attacks. If both Fist attacks hit one Medium or smaller creature, the target is grappled (escape DC 13), and the ape can't grapple another creature.
- **_Fist._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) bludgeoning damage.
- **_Rock._** _Ranged Weapon Attack:_ +5 to hit, range 25/50 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage.

### Ape, Giant (CR 7)

_Huge Beast_

- **Armor Class** 12
- **Hit Points** 176
- **Speed** 40 ft., climb 40 ft.
- **Perception** 14
- **Stealth** 12
- **Resistant** stunned
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  +2 |  +4 |  -2 |  +1 |  -2 |

**Actions**

- **_Multiattack._** The ape makes two Fist or Rock attacks. If both Fist attacks hit one Large or smaller creature, the target is grappled (escape DC 16). The ape has two fists, each of which can grapple only one target.
- **_Fist._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target. _Hit:_ 27 (4d10+5) bludgeoning damage.
- **_Rock._** _Ranged Weapon Attack:_ +8 to hit, range 50/100 ft., one target. _Hit:_ 23 (4d8+5) bludgeoning damage.

**Bonus Actions**

- **_Throw._** One Large or smaller creature grappled by the ape is thrown up to 50 feet in a random direction and knocked prone. If a thrown target strikes a solid surface, the target takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target is thrown at another creature, that creature must succeed on a DC 16 DEX save or take the same damage and be knocked prone.

### Awakened Shrub (CR 0)

_Small Plant_

- **Armor Class** 10
- **Hit Points** 9
- **Speed** 20 ft.
- **Perception** 10
- **Stealth** 10
  _Vulnerable_ fire
- **Resistant** piercing | Plant Resilience
- **Senses** -
- **Languages** one language known by its creator

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  +0 |  +0 |  +0 |  -2 |

- **_False Appearance._** While the shrub remains motionless, it is indistinguishable from a normal shrub.
- **_Plant Resilience._** The shrub is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Rake._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) slashing damage.
- **_Thorn._** _Ranged Weapon Attack:_ +2 to hit, range 15/30 ft., one target. _Hit:_ 2 (1d4) piercing damage.

### Awakened Tree (CR 2)

_Huge Plant_

- **Armor Class** 13 (natural armor)
- **Hit Points** 60
- **Speed** 20 ft.
- **Perception** 10
- **Stealth** 8
  _Vulnerable_ fire
- **Resistant** bludgeoning, piercing | Plant Resilience
- **Senses** -
- **Languages** one language known by its creator

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  -2 |  +2 |  +0 |  +0 |  -2 |

- **_False Appearance._** While the tree remains motionless, it is indistinguishable from a normal tree.
- **_Plant Resilience._** The tree is resistant to exhaustion and to the paralyzed, petrified, and unconscious conditions.

**Actions**

- **_Slam._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 22 (4d8+4) bludgeoning damage.
- **_Broken Branch._** _Ranged Weapon Attack:_ +6 to hit, range 20/60 ft., one target. _Hit:_ 18 (4d6+4) piercing damage.

**Bonus Actions**

- **_Entangling Roots._** One creature on the ground the tree can see within 10 feet of it must succeed on a DC 14 STR save or be restrained by roots until the end of its next turn.

### Axe Beak (CR 1/4)

_Large Beast_

- **Armor Class** 11
- **Hit Points** 13
- **Speed** 50 ft.
- **Perception** 12
- **Stealth** 11
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  -4 |  +0 |  -3 |

**Actions**

- **_Beak._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) slashing damage.

**Bonus Actions**

- **_Evasive._** The axe beak takes the Disengage or Dodge action.

### Baboon (CR 1/8)

_Small Beast_

- **Armor Class** 11
- **Hit Points** 10
- **Speed** 30 ft., climb 30 ft.
- **Perception** 11
- **Stealth** 11
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +1 |  +0 |  -3 |  +1 |  -2 |

- **_Pack Tactics._** The baboon has advantage on attack rolls against a creature if at least one of the baboon's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage.

**Reactions**

- **_Startling Display._** When a creature the baboon can see attacks it while within 5 feet of it, the baboon can bare its teeth, puff its chest, or emit a quick series of barks. The attacker must succeed on a DC 11 WIS save or have disadvantage on the attack roll.

### Badger (CR 0)

_Tiny Beast_

- **Armor Class** 10
- **Hit Points** 9
- **Speed** 20 ft., burrow 10 ft.
- **Perception** 11
- **Stealth** 10
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |   0 |  +1 |  -4 |  +1 |  -3 |

- **_Grumpy._** When in combat, the badger attacks the creature that most recently dealt damage to it, provided that creature is within range or moving to it doesn't cause the badger to provoke opportunity attacks. The badger otherwise attacks the nearest hostile creature.
- **_Heightened Smell._** The badger's Perception is 16 when perceiving by smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) piercing damage.

### Badger, Giant (CR 1/4)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 15
- **Speed** 30 ft., burrow 15 ft.
- **Perception** 11
- **Stealth** 10
- **Resistant** frightened
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +2 |  -4 |  +1 |  -3 |

- **_Grumpy._** When in combat, the badger attacks the creature that most recently dealt damage to it, provided that creature is within range or moving to it doesn't cause the badger to provoke opportunity attacks. The badger otherwise attacks the nearest hostile creature.
- **_Heightened Smell._** The badger's Perception is 16 when perceiving by smell.

**Actions**

- **_Multiattack._** The badger makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 4 (1d6+1) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) slashing damage.

### Bat (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 5 ft., fly 30 ft.
- **Perception** 11
- **Stealth** 13
  _Vulnerable_ deafened
- **Resistant** blinded
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  -1 |  -4 |  +1 |  -3 |

- **_Echolocation._** The bat can't use its keensense while deafened.
- **_Heightened Hearing._** The bat's Perception is 16 when perceiving by hearing.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage.

### Bat, Giant (CR 1/4)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 15
- **Speed** 10 ft., fly 60 ft.
- **Perception** 11
- **Stealth** 14
  _Vulnerable_ deafened
- **Resistant** blinded
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +0 |  -4 |  +1 |  -2 |

- **_Echolocation._** The bat can't use its keensense while deafened.
- **_Heightened Hearing._** The bat's Perception is 16 when perceiving by hearing.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage.

**Bonus Actions**

- **_Dizzying Screech._** The bat releases a dizzying screech at one creature within 10 feet of it. If the target can hear the screech, it must succeed on a DC 12 CON save or be disoriented until the end of its next turn. When a disoriented creature moves, it moves in a random direction.

### Bat, Swarm of Bats (CR 1/4)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 12
- **Hit Points** 14
- **Speed** 0 ft., fly 30 ft.
- **Perception** 11
- **Stealth** 14
  _Vulnerable_ deafened
- **Resistant** blinded | Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +0 |  -4 |  +1 |  -3 |

- **_Cacophonous Swarm._** A creature in the swarm's space that casts a spell with a verbal component must succeed on a DC 12 CON save or the spell fails to cast, expending the action required to cast it but not the spell slot or daily use.
- **_Echolocation._** The swarm can't use its keensense while deafened.
- **_Heightened Hearing._** The swarm's Perception is 16 when perceiving by hearing.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny bat. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +4 to hit, reach 0 ft., one creature in the swarm's space. _Hit:_ 7 (2d6) piercing damage, or 3 (1d6) piercing damage if the swarm has half of its HP or fewer.

### Bear, Black (CR 1/2)

_Medium Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 25
- **Speed** 40 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +2 |  -4 |  +1 |  -2 |

- **_Heightened Smell._** The bear's Perception is 18 when perceiving by smell.

**Actions**

- **_Multiattack._** The bear makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage.

### Bear, Brown (CR 1)

_Large Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 44
- **Speed** 40 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +3 |  -4 |  +1 |  -2 |

- **_Heightened Smell._** The bear's Perception is 18 when perceiving by smell.

**Actions**

- **_Multiattack._** The brown bear makes one Bite attack and one Claws attack. If both attacks hit one creature, the target is grappled (escape DC 14). The bear can grapple only one creature at a time.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 8 (1d8+4) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) slashing damage.

### Bear, Polar (CR 2)

_Large Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 60
- **Speed** 40 ft., swim 30 ft.
- **Perception** 13
- **Stealth** 10
- **Resistant** cold
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +0 |  +3 |  -4 |  +1 |  -2 |

- **_Heightened Smell._** The bear's Perception is 18 when perceiving by smell.

**Actions**

- **_Multiattack._** The polar bear makes one Bite attack and one Claws attack. If both attacks hit one creature, the target is grappled (escape DC 15). The bear can grapple only one creature at a time.
- **_Bite._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one creature. _Hit:_ 9 (1d8+5) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) slashing damage.

### Boar (CR 1/4)

_Medium Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 15
- **Speed** 40 ft.
- **Perception** 9
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -4 |  -1 |  -3 |

- **_Charge._** If the boar moves at least 20 feet straight toward a target and then hits it with a Tusk attack on the same turn, the target takes an extra 3 (1d6) slashing damage. If the target is a creature, it must succeed on a DC 12 STR save or be knocked prone.
- **_Relentless (Recharges after a Short or Long Rest)._** If the boar takes 4 damage or less that would reduce it to 0 HP, it is reduced to 1 HP instead.

**Actions**

- **_Tusk._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) slashing damage.

### Boar, Giant (CR 2)

_Large Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 63
- **Speed** 40 ft.
- **Perception** 8
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +3 |  -4 |  -2 |  -3 |

- **_Charge._** If the boar moves at least 20 feet straight toward a target and then hits it with a Tusk attack on the same turn, the target takes an extra 7 (2d6) slashing damage. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.
- **_Relentless (Recharges after a Short or Long Rest)._** If the boar takes 10 damage or less that would reduce it to 0 HP, it is reduced to 1 HP instead.

**Actions**

- **_Multiattack._** The giant boar makes two Tusk attacks. If both attacks hit one creature, the target must succeed on a DC 13 STR save or be knocked prone.
- **_Tusk._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.

**Bonus Actions**

- **_Challenging Snort._** The boar snorts and stomps its feet at a creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn and have disadvantage on the next save it makes against being knocked prone by the boar.

### Camel (CR 1/8)

_Large Beast_

- **Armor Class** 10
- **Hit Points** 10
- **Speed** 50 ft.
- **Perception** 9
- **Stealth** 10
- **Resistant** Camel Resilience
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +2 |  -4 |  -1 |  -3 |

- **_Camel Resilience._** The camel is resistant to exhaustion, and it requires only half the amount of water that a typical Beast of its size needs.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 4 (1d4+2) bludgeoning damage.
- **_Bile Spit._** _Ranged Weapon Attack:_ +2 to hit, range 20/60 ft., one creature. _Hit:_ 2 (1d4) acid damage, and the target must succeed on a DC 12 CON save or be smelly for 1 hour or until a creature spends 1 minute cleaning off the spit. A smelly creature has disadvantage on CHA checks.

### Cat (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 40 ft., climb 30 ft.
- **Perception** 13
- **Stealth** 13
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  +0 |  -4 |  +1 |  -2 |

- **_Heightened Smell._** The cat's Perception is 18 when perceiving by smell.

**Actions**

- **_Claws._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) slashing damage.

**Bonus Actions**

- **_Charming Mewl._** The cat emits a soft, high - pitched meow at a creature it can see within 10 feet of it. The target must succeed on a DC 11 CHA save or be charmed until the end of its next turn. If a creature's save is successful or the effect ends for it, the creature is immune to the cat's Charming Mewl for the next 24 hours.

### Crab (CR 0)

_Tiny Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 9
- **Speed** 20 ft., swim 20 ft.
- **Perception** 9
- **Stealth** 12
  _Vulnerable_ bludgeoning
- **Resistant** slashing
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  +0 |  -5 |  -1 |  -4 |

- **_Amphibious._** The crab can breathe air and water.

**Actions**

- **_Claw._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) bludgeoning damage, and the crab attaches to the target. While attached, the crab can't attack, and at the start of each of the crab's turns, the target takes 2 (1d4) bludgeoning damage. The attached crab moves with the target whenever the target moves, requiring none of the crab's movement. It can detach itself by spending 5 feet of its movement on its turn. A creature, including the target, can use its action to detach the crab.

### Crab, Giant (CR 1/4)

_Medium Beast_

- **Armor Class** 15 (natural armor)
- **Hit Points** 13
- **Speed** 30 ft., swim 30 ft.
- **Perception** 9
- **Stealth** 14
  _Vulnerable_ bludgeoning
- **Resistant** slashing
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +0 |  -5 |  -1 |  -4 |

- **_Amphibious._** The crab can breathe air and water.

**Actions**

- **_Pincer._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) bludgeoning damage, and the target is grappled (escape DC 12). The crab has two pincers, each of which can grapple only one target.

**Bonus Actions**

- **_Pincer Pinch._** One breathing creature grappled by the crab must succeed on a DC 12 STR save or be unable to speak or cast spells with verbal components and begin suffocating, as the crab squeezes the air from the target's lungs. This effect lasts until the grapple ends.

### Crocodile (CR 1/2)

_Large Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 25
- **Speed** 20 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** charmed
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -4 |  +0 |  -3 |

- **_Hold Breath._** The crocodile can hold its breath for 15 minutes.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) piercing damage, and the target is grappled (escape DC 12). Until this grapple ends, the target is restrained, and the crocodile can't Bite another target.

**Bonus Actions**

- **_Death Roll._** One creature grappled by the crocodile must make a DC 12 STR save, taking 5 (2d4) slashing damage on a failed save, or half as much damage on a successful one.

### Crocodile, Giant (CR 5)

_Huge Beast_

- **Armor Class** 14 (natural armor)
- **Hit Points** 120
- **Speed** 30 ft., swim 50 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** charmed
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +8 |  -1 |  +3 |  -4 |  +0 |  -2 |

- **_Hold Breath._** The crocodile can hold its breath for 30 minutes.

**Actions**

- **_Multiattack._** The crocodile makes one Bite attack and one Tail attack.
- **_Bite._** _Melee Weapon Attack:_ +8 to hit, reach 5 ft., one creature. _Hit:_ 21 (3d10+5) piercing damage, and the target is grappled (escape DC 16). Until this grapple ends, the target is restrained, and the crocodile can't Bite another target.
- **_Tail._** _Melee Weapon Attack:_ +8 to hit, reach 10 ft., one target not grappled by the crocodile. _Hit:_ 14 (2d8+5) bludgeoning damage. If the target is a creature, it must succeed on a DC 16 STR save or be knocked prone.

**Bonus Actions**

- **_Death Roll._** One creature grappled by the crocodile must make a DC 16 STR save, taking 7 (2d6) slashing damage on a failed save, or half as much damage on a successful one.

### Deer (CR 0)

_Medium Beast_

- **Armor Class** 13
- **Hit Points** 8
- **Speed** 50 ft.
- **Perception** 12
- **Stealth** 13
  _Vulnerable_ frightened
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +0 |  -4 |  +2 |  -3 |

**Actions**

- **_Kick._** \_Melee Weapon Attack:_+2 to hit, reach 5 ft., one creature. \_Hit:_ 2 (1d4) bludgeoning damage, and if the target is a Large or smaller creature, it must succeed on a DC 10 STR save or be knocked prone.

**Bonus Actions**

- **_Skittish._** The deer takes the Dash or Disengage action.

### Eagle (CR 0)

_Small Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 10 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 11
  _Vulnerable_ blinded
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +1 |  +0 |  -4 |  +2 |  -2 |

- **_Heightened Sight._** The eagle's Perception is 19 when perceiving by sight.
- **_Seabird._** The eagle can swim up to 30 feet on its turn, but it must start and end its movement either flying or on a solid surface, such as a ship or beach. If it is swimming at the end of its turn, it must succeed on a DC 10 CON save or it immediately begins to sink and suffocate. A suffocating eagle must succeed on a DC 8 STR check to fly out of the substance where it is sinking.

**Actions**

- **_Talons._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) slashing damage.

### Eagle, Giant (CR 1)

_Large Beast_

- **Armor Class** 13
- **Hit Points** 40
- **Speed** 10 ft., fly 80 ft.
- **Perception** 14
- **Stealth** 13
  _Vulnerable_ blinded
- **Senses** -
- **Languages** Giant Eagle, understands Common and Auran but can't speak them

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +3 |  +1 |  -1 |  +2 |  +0 |

- **_Heightened Sight._** The eagle's Perception is 19 when perceiving by sight.
- **_Seabird._** The eagle can swim up to 40 feet on its turn, but it must start and end its movement either flying or on a solid surface, such as a ship or beach. If it is swimming at the end of its turn, it must succeed on a DC 11 CON save or it immediately begins to sink and suffocate. A suffocating eagle must succeed on a DC 13 STR check to fly out of the substance where it is sinking.

**Actions**

- **_Multiattack._** The eagle makes one Beak attack and one Talons attack.
- **_Beak._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.
- **_Talons._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage, and the target is grappled (escape DC 13) if it is a Medium or smaller creature. Until this grapple ends, the target is restrained, and the eagle can't use its Talons on another target.

### Elephant (CR 4)

_Huge Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 105
- **Speed** 40 ft.
- **Perception** 12
- **Stealth** 9
- **Resistant** prone
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +3 |  -4 |  +0 |  -2 |

- **_Trampling Charge._** If the elephant moves at least 20 feet straight toward a creature and then hits it with a Gore attack on the same turn, that target must succeed on a DC 15 STR save or be knocked prone. If the target is prone, the elephant can make one Stomp attack against it as a bonus action.

**Actions**

- **_Multiattack._** The elephant makes two Gore attacks.
- **_Gore._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 16 (2d10+5) piercing damage.
- **_Stomp._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one prone creature. _Hit:_ 14 (2d8+5) bludgeoning damage.

**Bonus Actions**

- **_Trunk Grab._** The elephant grabs one Large or smaller creature within 10 feet of it. The target must succeed on a DC 15 STR save or be grappled (escape DC 15). The elephant can grapple only one creature at a time.

### Elk (CR 1/4)

_Large Beast_

- **Armor Class** 10
- **Hit Points** 15
- **Speed** 50 ft.
- **Perception** 10
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -4 |  +0 |  -2 |

- **_Charge._** If the elk moves at least 20 feet straight toward a target and then hits it with a Ram attack on the same turn, the target takes an extra 3 (1d6) bludgeoning damage. If the target is a creature, it must succeed on a DC 12 STR save or be knocked prone.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) bludgeoning damage.
- **_Kick._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage, and the target must succeed on a DC 12 STR save or be pushed up to 10 feet away from the elk.

### Elk, Giant (CR 2)

_Huge Beast_

- **Armor Class** 14 (natural armor)
- **Hit Points** 60
- **Speed** 60 ft.
- **Perception** 14
- **Stealth** 13
- **Senses** -
- **Languages** Giant Elk, understands Common, Elvish, and Sylvan but can't speak hem

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +3 |  +2 |  -2 |  +2 |  +0 |

- **_Charge._** If the elk moves at least 20 feet straight toward a target and then hits it with a Ram attack on the same turn, the target takes an extra 7 (2d6) bludgeoning damage. If the target is a creature, it must succeed on a DC 14 STR save or be knocked prone.

**Actions**

- **_Multiattack._** The elk makes one Ram attack and one Kick attack.
- **_Ram._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one target. _Hit:_ 11 (2d6+4) bludgeoning damage.
- **_Kick._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) bludgeoning damage, and the target must succeed on a DC 14 STR save or be pushed up to 15 feet away from the elk.

**Bonus Actions**

- **_Bolstering Bugle (27 HP or Higher)._** The elk bugles its might at its opponents, bolstering its confidence. It has advantage on the next attack roll it makes before the start of its next turn.

### Frog (CR 0)

_Tiny Beast_

- **Armor Class** 10
- **Hit Points** 9
- **Speed** 20 ft., swim 20 ft.
- **Perception** 11
- **Stealth** 10
- **Resistant** grappled
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -5 |  +0 |  -1 |  -5 |  -1 |  -4 |

- **_Amphibious._** The frog can breathe air and water.
- **_Standing Leap._** The frog's long jump is up to 10 feet and its high jump is up to 5 feet, with or without a running start.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) bludgeoning damage.

### Frog, Giant (CR 1/4)

_Medium Beast_

- **Armor Class** 11
- **Hit Points** 15
- **Speed** 20 ft., swim 40 ft.
- **Perception** 12
- **Stealth** 11
- **Resistant** grappled
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +0 |  -4 |  +0 |  -4 |

- **_Amphibious._** The frog can breathe air and water.
- **_Standing Leap._** The frog's long jump is up to 20 feet and its high jump is up to 10 feet, with or without a running start.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage, and the target is grappled (escape DC 12). Until this grapple ends, the target is restrained, and the frog can't Bite another target.
- **_Swallow._** The frog makes one Bite attack against a Small or smaller target it is grappling. If the attack hits, the target is swallowed, and the grapple ends. The swallowed target is blinded and restrained, it has total cover against attacks and other effects outside the frog, and it takes 5 (2d4) acid damage at the start of each of the frog's turns. The frog can have only one target swallowed at a time. If the frog takes any damage from the swallowed creature, the frog must succeed on a DC 10 CON save at the end of that turn or regurgitate the creature, which falls prone in a space within 5 feet of the frog. If the frog dies, a swallowed creature is no longer restrained by it and can escape from the corpse using 5 feet of movement, exiting prone.

**Bonus Actions**

- **_Reeling Tongue._** The frog lashes out its tongue at one Medium or smaller creature it can see within 15 feet of it. The target must succeed on a DC 12 STR save or be pulled up to 10 feet closer to the frog.

### Frog, Giant Poisonous (CR 1)

_Large Beast_

- **Armor Class** 11
- **Hit Points** 44
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 11
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -4 |  +0 |  -4 |

- **_Amphibious._** The frog can breathe air and water.
- **_Standing Leap._** The frog's long jump is up to 20 feet and its high jump is up to 10 feet, with or without a running start.
- **_Toxic Skin._** The frog's skin is coated in a hallucinogenic toxin. A creature that touches the frog or hits it with a melee attack while within 5 feet of it must make a DC 13 CON save. On a failure, a creature is poisoned until the end of its next turn and experiences mild hallucinations while poisoned.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 8 (1d10+3) piercing damage plus 5 (1d10) poison damage, and the target is grappled (escape DC 13). Until this grapple ends, the target is restrained, and the frog can't Bite another target.
- **_Swallow._** The frog makes one Bite attack against a Medium or smaller target it is grappling. If the attack hits, the target is swallowed, and the grapple ends. The swallowed target is blinded and restrained, it has total cover against attacks and other effects outside the frog, and it takes 7 (2d6) acid damage at the start of each of the frog's turns. The frog can have only one target swallowed at a time. If the frog takes any damage from the swallowed creature, the frog must succeed on a DC 11 CON save at the end of that turn or regurgitate the creature, which falls prone in a space within 5 feet of the frog. If the frog dies, a swallowed creature is no longer restrained by it and can escape from the corpse using 5 feet of movement, exiting prone.

**Bonus Actions**

- **_Reeling Tongue._** The frog lashes out its tongue at one Large or smaller creature it can see within 20 feet of it. The target must succeed on a DC 13 STR save or be pulled up to 15 feet closer to the frog.

### Goat (CR 0)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 8
- **Speed** 40 ft.
- **Perception** 10
- **Stealth** 10
- **Resistant** prone
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +0 |  -4 |  +0 |  -3 |

- **_Charge._** If the goat moves at least 20 feet straight toward a target and then hits it with a Ram attack on the same turn, the target takes an extra 2 (1d4) bludgeoning damage. If the target is a creature, it must succeed on a DC 11 STR save or be knocked prone.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) bludgeoning damage.

### Goat, Giant (CR 1/2)

_Large Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 25
- **Speed** 40 ft.
- **Perception** 11
- **Stealth** 10
- **Resistant** prone
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +1 |  -4 |  +1 |  -2 |

- **_Charge._** If the goat moves at least 20 feet straight toward a target and then hits it with a Ram attack on the same turn, the target takes an extra 5 (2d4) bludgeoning damage. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 8 (2d4+3) bludgeoning damage.

**Reactions**

- **_Terrifying Scream._** When the goat takes damage, it can release a high - pitched scream, frightening creatures within 10 feet of it. Each creature in that area that can hear the scream must succeed on a DC 13 WIS save or be frightened until the end of its next turn. A creature frightened in this way can't be frightened by this goat's Terrifying Scream again for the next 24 hours.

### Hawk (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 7
- **Speed** 10 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 11
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +1 |  -1 |  -4 |  +2 |  -2 |

- **_Heightened Sight._** The hawk's Perception is 19 when perceiving by sight.

**Actions**

- **_Talons._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) slashing damage.

**Bonus Actions**

- **_Evasive Flight._** The hawk takes the Disengage or Dodge action. It can use this bonus action only while flying.

### Hawk, Blood (CR 1/8)

_Small Beast_

- **Armor Class** 12
- **Hit Points** 8
- **Speed** 10 ft., fly 60 ft.
- **Perception** 14
- **Stealth** 12
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +2 |  +0 |  -4 |  +2 |  -3 |

- **_Heightened Sight._** The hawk's Perception is 19 when perceiving by sight.
- **_Pack Tactics._** The hawk has advantage on attack rolls against a creature if at least one of the hawk's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Beak._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) piercing damage.

**Bonus Actions**

- **_Evasive Flight._** The hawk takes the Disengage or Dodge action. It can use this bonus action only while flying.

### Horse, Draft (CR 1/4)

_Large Beast_

- **Armor Class** 10
- **Hit Points** 15
- **Speed** 40 ft.
- **Perception** 12
- **Stealth** 10
  _Vulnerable_ frightened
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +1 |  -4 |  +0 |  -2 |

- **_Draft Animal._** The draft horse can push, drag, or lift weight in pounds equal to three times its carrying capacity.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) bludgeoning damage.

### Horse, Riding (CR 1/4)

_Large Beast_

- **Armor Class** 10
- **Hit Points** 15
- **Speed** 60 ft.
- **Perception** 10
- **Stealth** 10
  _Vulnerable_ frightened
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +1 |  -4 |  +0 |  -2 |

- **_Easy Gait._** The horse's steps are smooth and steady. A creature riding the horse has advantage on saves against exhaustion caused by a Forced March.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) bludgeoning damage.

### Horse, War (CR 1/2)

_Large Beast_

- **Armor Class** 15 (scale mail barding)
- **Hit Points** 22
- **Speed** 60 ft.
- **Perception** 11
- **Stealth** 11
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +1 |  -4 |  +1 |  -2 |

- **_Trampling Charge._** If the horse moves at least 20 feet straight toward a creature and then hits it with a Hooves attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the horse can make another Hooves attack against it as a bonus action.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 8 (1d8+4) bludgeoning damage.

**Reactions**

- **_Trained Shift._** If the horse's rider is subjected to an effect that would knock it prone or dismount it, the horse can shift its body to assist the rider. The rider has advantage on the check or save to avoid the effect.

### Hyena (CR 0)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 8
- **Speed** 50 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +0 |  +1 |  -4 |  +1 |  -3 |

- **_Cackling Chorus._** If three or more hyenas are all within 30 feet of each other, their cackling, grunts, whoops, and yips create a deafening chorus. A creature that starts its turn within 10 feet of such a hyena must succeed on a DC 10 CON save or be deafened until the start of its next turn. The DC is equal to 8 plus the number of participating hyenas.
- **_Pack Tactics._** The hyena has advantage on attack rolls against a creature if at least one of the hyena's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d6) piercing damage.

### Hyena, Giant (CR 1)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 42
- **Speed** 50 ft.
- **Perception** 13
- **Stealth** 12
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -4 |  +1 |  -2 |

- **_Cackling Chorus._** If three or more hyenas are all within 30 feet of each other, their cackling, grunts, whoops, and yips create a deafening chorus. A creature that starts its turn within 10 feet of such a hyena must succeed on a CON save or be deafened until the start of its next turn. The DC is equal to 8 plus the number of participating hyenas.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 10 (2d6+3) piercing damage.

**Bonus Actions**

- **_Warning Yip._** The hyena can emit a brief yip at one friendly hyena or gnoll it can see within 30 feet of it, warning the target of danger. The next attack roll against the target before the start of the hyena's turn has disadvantage.

**Reactions**

- **_Rampage._** When the hyena reduces a creature to 0 HP, it can move up to half its speed and make one Bite attack. If it does, attack rolls against it have advantage until the start of its next turn.

### Insect, Giant Centipede (CR 1/4)

_Small Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 14
- **Speed** 30 ft., climb 30 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** prone
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +2 |  +1 |  -5 |  -2 |  -4 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage, and the target must succeed on a DC 11 CON save or take 7 (2d6) poison damage. If the poison damage reduces the target to 0 HP, the target is stable but poisoned for 1 hour, even after regaining HP, and is paralyzed while poisoned in this way.

**Bonus Actions**

- **_Swift Hunter._** The centipede moves up to its speed toward a hostile creature that it can see.

### Insect, Giant Fire Beetle (CR 0)

_Small Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 7
- **Speed** 30 ft.
- **Perception** 8
- **Stealth** 10
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +0 |  +1 |  -5 |  -2 |  -4 |

- **_Illumination._** The beetle sheds bright light in a 10 - foot radius and dim light for an additional 10 feet.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) slashing damage.
- **_Igniting Mucus._** _Ranged Weapon Attack:_ +2 to hit, range 15/30 ft., one target. _Hit:_ 2 (1d4) poison damage, and the target is covered in mucus that ignites after 1d4 rounds or if the target takes fire damage. An ignited creature takes 2 (1d4) fire damage at the start of each of its turns until a creature takes an action to douse the fire. A creature can remove the mucus before it ignites by taking an action.

### Insect, Giant Scorpion (CR 3)

_Large Beast_

- **Armor Class** 15 (natural armor)
- **Hit Points** 76
- **Speed** 40 ft., burrow 20 ft.
- **Perception** 11
- **Stealth** 13
- **Resistant** poison | poisoned
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +2 |  -5 |  -1 |  -4 |

**Actions**

- **_Multiattack._** The giant scorpion makes two Claw attacks and one Sting attack.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) bludgeoning damage, and the target is grappled (escape DC 12). The scorpion has two claws, each of which can grapple only one target.
- **_Sting._** _Melee Weapon Attack:_ +4 to hit, reach 10 ft., one creature. _Hit:_ 7 (1d10+2) piercing damage plus 7 (2d6) poison damage, and the target must succeed on a DC 12 CON save or be poisoned until the end of its next turn.

**Reactions**

- **_Reflexive Sting._** When a creature the scorpion can see attacks it while within 10 feet of the scorpion, the scorpion can whip its tail defensively at the creature. The attacker must succeed on a DC 12 DEX save or take 5 (1d10) piercing damage.

### Insect, Giant Wasp (CR 1/2)

_Medium Beast_

- **Armor Class** 12
- **Hit Points** 25
- **Speed** 10 ft., fly 50 ft.
- **Perception** 10
- **Stealth** 12
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +0 |  -5 |  +0 |  -4 |

**Actions**

- **_Sting._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) piercing damage, and the target must succeed on a DC 12 CON save or take 10 (3d6) poison damage. If the poison damage reduces the target to 0 HP, the target is stable but poisoned for 1 hour, even after regaining HP, and is paralyzed while poisoned in this way.

**Reactions**

- **_Assailing Pheromone._** When the wasp takes damage, it can release a scent perceptible only to other wasps. Each wasp within 10 feet of this wasp has advantage on the next attack roll it makes before the end of its next turn.

### Insect, Scorpion (CR 0)

_Tiny Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 8
- **Speed** 10 ft.
- **Perception** 9
- **Stealth** 12
- **Resistant** poison | poisoned
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  -1 |  -5 |  -1 |  -4 |

**Actions**

- **_Sting._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) piercing damage, and the target must succeed on a DC 10 CON save or take 2 (1d4) poison damage.

### Insect, Swarm of Insects (CR 1/2)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 12 (natural armor)
- **Hit Points** 24
- **Speed** 20 ft., climb 20 ft.
- **Perception** 8
- **Stealth** 11
- **Resistant** Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  +0 |  -5 |  -2 |  -5 |

- **_Crawling Swarm._** A creature in the swarm's space is covered in crawling and buzzing insects. If the creature casts a spell with a somatic component, it must succeed on a DC 11 CON save or the spell fails to cast, expending the action required to cast it but not the spell slot or daily use.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +3 to hit, reach 0 ft., one target in the swarm's space. _Hit:_ 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its HP or fewer.

### Jackal (CR 0)

_Small Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 11
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +1 |  +0 |  -4 |  +1 |  -2 |

- **_Heightened Hearing and Smell._** The jackal's Perception is 18 when perceiving by hearing or smell.
- **_Pack Tactics._** The jackal has advantage on attack rolls against a creature if at least one of the jackal's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage, and the target must succeed on a DC 10 CON save or contract shriveling fever disease, named for the way the disease causes an infected creature's muscles to shrivel. Until the disease is cured, the creature is poisoned, and at the end of each long rest, the infected creature must succeed on a DC 10 CON save or its STR score is reduced by 1d4. This reduction lasts until the creature finishes a long rest after the disease is cured. If the disease reduces the creature's STR to 0, the creature dies. A creature that succeeds on two saves recovers from the disease.

### Lion (CR 1)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 42
- **Speed** 50 ft.
- **Perception** 13
- **Stealth** 16
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +1 |  -4 |  +1 |  -1 |

- **_Heightened Smell._** The lion's Perception is 18 when perceiving by smell.
- **_Pack Tactics._** The lion has advantage on attack rolls against a creature if at least one of the lion's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Pounce._** If the lion moves at least 20 feet straight toward a creature and then hits it with a Claws attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the lion can make one Bite attack against it as a bonus action.
- **_Running Leap._** With a 10 - foot running start, the lion can long jump up to 25 feet.

**Actions**

- **_Multiattack._** The lion makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d8+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) slashing damage.

**Bonus Actions**

- **_Rattling Roar (Recharge 4 - 6)._** The lion releases a bone - shaking roar in a 15 - foot cone. Each creature in the area must succeed on a DC 13 CON save or have disadvantage on attack rolls until the end of its next turn.

### Lizard (CR 0)

_Tiny Beast_

- **Armor Class** 10
- **Hit Points** 9
- **Speed** 20 ft., climb 20 ft.
- **Perception** 9
- **Stealth** 12
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  +0 |  -5 |  -1 |  -4 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) piercing damage.

**Reactions**

- **_Detach Tail (5 HP or Fewer, Recharges after a Short or Long Rest)._** When the lizard takes damage, it can detach its tail, reducing the damage by 2 (1d4), and immediately move up to its speed without provoking opportunity attacks.

### Lizard, Giant (CR 1/4)

_Large Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 15
- **Speed** 30 ft., climb 30 ft.
- **Perception** 10
- **Stealth** 13
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  -4 |  +0 |  -3 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) piercing damage.

**Reactions**

- **_Detach Tail (9 HP or Fewer, Recharges after a Short or Long Rest)._** When the lizard takes damage, it can detach its tail, reducing the damage by 4 (1d8), and immediately move up to its speed without provoking opportunity attacks.

### Mammoth (CR 6)

_Huge Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 133
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 9
- **Resistant** cold | prone
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  -1 |  +5 |  -4 |  +0 |  -2 |

- **_Trampling Charge._** If the mammoth moves at least 20 feet straight toward a creature and then hits it with a Gore attack on the same turn, that target must succeed on a DC 17 STR save or be knocked prone. If the target is prone, the mammoth can make one Stomp attack against it as a bonus action.

**Actions**

- **_Multiattack._** The mammoth makes two Gore attacks.
- **_Gore._** _Melee Weapon Attack:_ +9 to hit, reach 10 ft., one target. _Hit:_ 22 (3d10+6) piercing damage.
- **_Stomp._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one prone creature. _Hit:_ 19 (3d8+6) bludgeoning damage.

**Bonus Actions**

- **_Trunk Grab._** The mammoth grabs one Large or smaller creature within 10 feet of it. The target must succeed on a DC 17 STR save or be grappled (escape DC 17). Until this grapple ends, the target is restrained, and the mammoth can't use Trunk Grab on another creature.

### Mastiff (CR 1/8)

_Medium Beast_

- **Armor Class** 12
- **Hit Points** 9
- **Speed** 40 ft.
- **Perception** 11
- **Stealth** 12
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +2 |  +1 |  -4 |  +1 |  -2 |

- **_Heightened Hearing and Smell._** The mastiff's Perception is 16 when perceiving by hearing or smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) piercing damage. If the target is a creature, it must succeed on a DC 12 STR save or be knocked prone. 364

**Reactions**

- **_Protect Friend._** When a friendly Humanoid the mastiff can see is hit by an attack from a creature within 5 feet of the mastiff, the mastiff can make one Bite attack against that attacking creature.

### Mule (CR 1/8)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 10
- **Speed** 40 ft.
- **Perception** 10
- **Stealth** 10
- **Resistant** exhaustion, prone
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -4 |  +0 |  -3 |

- **_Beast of Burden._** The mule is considered to be a Large animal for the purpose of determining its carrying capacity.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage.

### Octopus (CR 0)

_Small Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 5 ft., swim 30 ft.
- **Perception** 12
- **Stealth** 13
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +1 |  +0 |  -4 |  +0 |  -3 |

- **_Hold Breath._** While out of water, the octopus can hold its breath for 30 minutes.
- **_Underwater Camouflage._** The octopus's Stealth is 18 while underwater.
- **_Water Breathing._** The octopus can breathe only underwater.

**Actions**

- **_Tentacles._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) bludgeoning damage, and the target is grappled (escape DC 11), if it is a Medium or smaller creature. Until this grapple ends, the octopus can't use its Tentacles on another target.

**Reactions**

- **_Ink Dash (Recharge 6)._** When a creature the octopus can see deals damage to it, the octopus can release a 5 - foot - radius cloud of ink all around itself, if it is underwater. The area is heavily obscured until the end of the octopus's next turn, although a significant current can disperse the ink. Then, the octopus can swim up to its swimming speed. If it does so, it immediately releases any creature it is grappling.

### Octopus, Giant (CR 1)

_Large Beast_

- **Armor Class** 11
- **Hit Points** 44
- **Speed** 10 ft., swim 60 ft.
- **Perception** 14
- **Stealth** 13
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  -3 |  +0 |  -3 |

- **_Hold Breath._** While out of water, the octopus can hold its breath for 1 hour.
- **_Underwater Camouflage._** The octopus's Stealth is 18 while underwater.
- **_Water Breathing._** The octopus can breathe only underwater.

**Actions**

- **_Tentacles._** _Melee Weapon Attack:_ +5 to hit, reach 15 ft., one target. _Hit:_ 10 (2d6+3) bludgeoning damage, and the target is grappled (escape DC 13), if it is a Huge or smaller creature. Until this grapple ends, the target is restrained. The octopus can grapple up to two creatures at one time.

**Bonus Actions**

- **_Tentacle Slam._** The octopus slams a Medium or smaller creature it is grappling into a solid surface. The target must make a DC 13 STR save, taking 7 (2d6) bludgeoning damage on a failed save, or half as much damage on a successful one.

**Reactions**

- **_Ink Dash (Recharge 4 - 6)._** When a creature the octopus can see deals damage to it, the octopus can release a 20 - foot- radius cloud of ink all around itself, if it is underwater. The area is heavily obscured until the end of the octopus's next turn, although a significant current can disperse the ink. Then, the octopus can swim up to its swimming speed. If it does so, it immediately releases any creatures it is grappling.

### Orca (CR 3)

_Huge Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 80
- **Speed** 0 ft., swim 60 ft.
- **Perception** 13
- **Stealth** 10
- **Resistant** cold
- **Senses** keensense 120 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +0 |  +1 |  -4 |  +1 |  -2 |

- **_Echolocation._** The orca can't use its keensense while deafened.
- **_Heightened Hearing._** The orca's Perception is 18 when perceiving by hearing.
- **_Hold Breath._** The orca can hold its breath for 30 minutes.

**Actions**

- **_Multiattack._** The orca makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 14 (3d6+4) piercing damage.

**Bonus Actions**

- **_Tail Slap._** The orca slaps one creature it can see within 15 feet of it with its tail. The target must succeed on a DC 14 STR save or be pushed up to 15 feet away from the orca and knocked prone. A creature that fails this save by 5 or more is also stunned until the end of its next turn.

### Owl (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 5 ft., fly 60 ft.
- **Perception** 13
- **Stealth** 13
- **Senses** darkvision 120 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  -1 |  -4 |  +1 |  -2 |

- **_Flyby._** The owl doesn't provoke opportunity attacks when it flies out of an enemy's reach.
- **_Heightened Hearing and Sight._** The owl's Perception is 18 when perceiving by hearing or sight.
- **_Quiet Wings._** The owl's Stealth is 18 while flying.

**Actions**

- **_Talons._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) slashing damage.

### Owl, Giant (CR 1/4)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 15
- **Speed** 5 ft., fly 60 ft.
- **Perception** 15
- **Stealth** 14
- **Senses** darkvision 120 ft.
- **Languages** Giant Owl, understands Common, Elvish, and Sylvan but can't speak hem

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +2 |  +1 |  -1 |  +1 |  +0 |

- **_Flyby._** The owl doesn't provoke opportunity attacks when it flies out of an enemy's reach.
- **_Heightened Hearing and Sight._** The owl's Perception is 20 when perceiving by hearing or sight.
- **_Quiet Wings._** The owl's Stealth is 19 while flying.

**Actions**

- **_Talons._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) slashing damage.

**Reactions**

- **_Puffed Up Display._** When a creature the owl is aware of and that is within 30 feet of it attacks it, the owl can suddenly turn its piercing gaze on the creature, puff up its feathers, and release a quick hiss, startling the creature. The attacker has disadvantage on the attack roll.

### Panther (CR 1/4)

_Medium Beast_

- **Armor Class** 12
- **Hit Points** 15
- **Speed** 50 ft., climb 40 ft.
- **Perception** 14
- **Stealth** 16
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +0 |  -4 |  +2 |  -2 |

- **_Heightened Smell._** The panther's Perception is 19 when perceiving by smell.
- **_Pounce._** If the panther moves at least 20 feet straight toward a creature and then hits it with a Claw attack on the same turn, that target must succeed on a DC 12 STR save or be knocked prone. If the target is prone, the panther can make one Bite attack against it as a bonus action.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage.
- **_Claw._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) slashing damage.

**Bonus Actions**

- **_Stealthy Hunter._** The panther takes the Hide action.

### Pony (CR 1/8)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 10
- **Speed** 40 ft.
- **Perception** 10
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +1 |  -4 |  +0 |  -2 |

- **_Draft Animal._** The draft horse can push, drag, or lift weight in pounds equal to three times its carrying capacity.

**Actions**

- **_Hooves._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 4 (1d4+2) bludgeoning damage.

### Quipper (CR 0)

_Tiny Beast_

- **Armor Class** 10
- **Hit Points** 8
- **Speed** 0 ft., swim 40 ft.
- **Perception** 8
- **Stealth** 10
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  +0 |  -5 |  -2 |  -4 |

- **_Blood Frenzy._** The quipper has advantage on melee attack rolls against any creature that doesn't have all its HP.
- **_Heightened Smell._** The quipper's Perception is 13 when perceiving by smell.
- **_Water Breathing._** The quipper can breathe only underwater.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) piercing damage.

### Quipper, Swarm of Quippers (CR 1)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 13
- **Hit Points** 34
- **Speed** 0 ft., swim 40 ft.
- **Perception** 10
- **Stealth** 13
- **Resistant** Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +3 |  +0 |  -5 |  +0 |  -4 |

- **_Blood Frenzy._** The swarm has advantage on melee attack rolls against any creature that doesn't have all its HP.
- **_Heightened Smell._** The swarm's Perception is 15 when perceiving by smell.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny quipper. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.
- **_Water Breathing._** The swarm can breathe only underwater.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +5 to hit, reach 0 ft., one creature in the swarm's space. _Hit:_ 18 (4d8) piercing damage, or 9 (2d8) piercing damage if the swarm has half of its HP or fewer, and the target must succeed on a DC 13 DEX save or have its flesh shredded by the attack. A creature with shredded flesh loses 4 (1d8) HP at the start of each of its turns as the wound bleeds profusely. Any creature can take an action to stanch the wound with a successful DC 10 WIS (Medicine) check. The wound also closes if the target receives magical healing.

### Rat (CR 0)

_Tiny Beast_

- **Armor Class** 10
- **Hit Points** 9
- **Speed** 20 ft., swim 20 ft.
- **Perception** 10
- **Stealth** 12
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  -1 |  -4 |  +0 |  -3 |

- **_Accustomed to Filth._** The rat has advantage on saves against contracting diseases.
- **_Heightened Smell._** The rat's Perception is 15 while perceiving by smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) piercing damage.

### Rat, Giant (CR 1/4)

_Small Beast_

- **Armor Class** 13
- **Hit Points** 14
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 15
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +3 |  +0 |  -4 |  +0 |  -3 |

- **_Accustomed to Filth._** The rat has advantage on saves against contracting diseases.
- **_Heightened Smell._** The rat's Perception is 15 while perceiving by smell.
- **_Pack Tactics._** The rat has advantage on attack rolls against a creature if at least one of the rat's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) piercing damage. If the target is a creature, it must make a DC 13 CON save. On a failure, the target contracts the rat plague disease (see Diseased Rats sidebar) or is poisoned until the end of its next turn (the GM's choice).

### Rat, Swarm of Rats (CR 1/4)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 10
- **Hit Points** 14
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 12
- **Resistant** Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +0 |  -1 |  -4 |  +0 |  -4 |

- **_Accustomed to Filth._** The swarm has advantage on saves against contracting diseases.
- **_Heightened Smell._** The swarm's Perception is 15 when perceiving by smell.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny rat. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +2 to hit, reach 0 ft., one target in the swarm's space. _Hit:_ 7 (2d6) piercing damage, or 3 (1d6) piercing damage if the swarm has half of its HP or fewer. If the target is a creature, it must make a DC 9 CON save. On a failure, the target contracts the rat plague disease (see Diseased Rats sidebar) or is poisoned until the end of its next turn (the GM's choice).

### Raven (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 10 ft., fly 50 ft.
- **Perception** 13
- **Stealth** 11
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  -1 |  -3 |  +1 |  +0 |

- **_Carrion Sense._** The raven can pinpoint, by scent, the location of carrion, dead creatures, and Undead without the Incorporeal Movement trait within 60 feet of it.
- **_Mimicry._** The raven can mimic simple sounds it has heard, such as a chord of a flute melody, a baby crying, or an animal chittering. A creature that hears the sounds can tell they are imitations with a successful DC 10 WIS (Insight) check.
- **_Recollection._** The raven knows up to 20 words in any language it has heard and can repeat those words in the voices it heard them, using its Mimicry trait.

**Actions**

- **_Beak._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) piercing damage.

### Raven, Swarm of Ravens (CR 1/4)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 12
- **Hit Points** 13
- **Speed** 10 ft., fly 50 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +2 |  -1 |  -4 |  +1 |  -1 |

- **_Carrion Sense._** The swarm can pinpoint, by scent, the location of carrion, dead creatures, and Undead without the Incorporeal Movement trait within 60 feet of it.
- **_Pilfering Swarm._** A creature in the swarm's space is surrounded by ravens pecking and pulling at its clothing, hair, fur, and belongings. If a creature in the swarm's space casts a spell with a material component, it must succeed on a DC 12 DEX save or the spell fails to cast, expending the action required to cast it but not the spell slot or daily use, as the ravens steal the component.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny raven. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.

**Actions**

- **_Beaks._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target in the swarm's space. _Hit:_ 9 (2d8) piercing damage, or 4 (1d8) piercing damage if the swarm has half of its HP or fewer.

### Rhinoceros (CR 2)

_Large Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 63
- **Speed** 40 ft.
- **Perception** 11
- **Stealth** 9
- **Resistant** bludgeoning | stunned
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  -1 |  +2 |  -4 |  +1 |  -2 |

- **_Charge._** If the rhinoceros moves at least 20 feet straight toward a target and then hits it with a Gore attack on the same turn, the target takes an extra 7 (2d6) piercing damage. If the target is a creature, it must succeed on a DC 15 STR save or be pushed up to 10 feet away from the rhinoceros and knocked prone.

**Actions**

- **_Multiattack._** The rhinoceros makes two Gore attacks.
- **_Gore._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 12 (2d6+5) bludgeoning damage.

**Bonus Actions**

- **_Quaking Stomp._** The rhinoceros rears up and slams its forefeet on the ground, shaking the area. Each creature within 10 feet of the rhinoceros must succeed on a DC 15 DEX save or be knocked prone.

### Seahorse (CR 0)

_Tiny Beast_

- **Armor Class** 11 (natural armor)
- **Hit Points** 9
- **Speed** 0 ft., swim 20 ft.
- **Perception** 10
- **Stealth** 12
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -5 |  +0 |  -1 |  -5 |  +0 |  -4 |

- **_Underwater Camouflage._** The seahorse's Stealth is 17 while underwater.
- **_Water Breathing._** The seahorse can breathe only underwater.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) bludgeoning damage.

### Seahorse, Giant (CR 1/2)

_Large Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 25
- **Speed** 0 ft., swim 40 ft.
- **Perception** 11
- **Stealth** 14
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +2 |  +0 |  -4 |  +1 |  -3 |

- **_Charge._** If the seahorse moves at least 20 feet straight toward a target and then hits it with a Ram attack on the same turn, the target takes an extra 5 (2d4) bludgeoning damage. If the target is a creature, it must succeed on a DC 12 STR save or be knocked prone.
- **_Underwater Camouflage._** The seahorse's Stealth is 19 while underwater.
- **_Water Breathing._** The seahorse can breathe only underwater.

**Actions**

- **_Ram._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) bludgeoning damage.

**Bonus Actions**

- **_Grasping Tail._** The seahorse grabs one Medium or smaller creature within 10 feet of it. The target must succeed on a DC 12 STR save or be grappled (escape DC 12). Until this grapple ends, the target is restrained, and the seahorse can't use Grasping Tail on another creature.

### Shark, Giant (CR 5)

_Huge Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 126
- **Speed** 0 ft., swim 50 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** keensense 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +6 |  +0 |  +5 |  -5 |  +0 |  -3 |

- **_Blood Frenzy._** The shark has advantage on melee attack rolls against any creature that doesn't have all its HP.
- **_Blood Sense._** The shark can pinpoint, by scent, the location of creatures that don't have all of their HP within 120 feet of it and can sense the general direction of such creatures within 1 mile of it.
- **_Electrical Sensitivity._** Whenever the shark takes lightning damage, it must succeed on a DC 15 CON save or be incapacitated until the end of its next turn.
- **_Water Breathing._** The shark can breathe only underwater.

**Actions**

- **_Multiattack._** The shark makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +9 to hit, reach 5 ft., one target. _Hit:_ 19 (3d8+6) piercing damage.

**Bonus Actions**

- **_Swift Hunter._** The shark moves up to half its speed toward a hostile creature that it can see. This movement doesn't provoke opportunity attacks.

### Shark, Hunter (CR 2)

_Large Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 63
- **Speed** 0 ft., swim 40 ft.
- **Perception** 12
- **Stealth** 11
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +2 |  -5 |  +0 |  -3 |

- **_Blood Frenzy._** The shark has advantage on melee attack rolls against any creature that doesn't have all its HP.
- **_Blood Sense._** The shark can pinpoint, by scent, the location of creatures that don't have all of their HP within 60 feet of it and can sense the general direction of such creatures within 1 mile of it.
- **_Electrical Sensitivity._** Whenever the shark takes lightning damage, it must succeed on a DC 12 CON save or be incapacitated until the end of its next turn.
- **_Water Breathing._** The shark can breathe only underwater.

**Actions**

- **_Multiattack._** The shark makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 12 (2d8+3) piercing damage.

**Bonus Actions**

- **_Swift Hunter._** The shark moves up to half its speed toward a hostile creature that it can see. This movement doesn't provoke opportunity attacks.

### Shark, Reef (CR 1/2)

_Medium Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 27
- **Speed** 0 ft., swim 40 ft.
- **Perception** 12
- **Stealth** 11
- **Senses** keensense 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  -5 |  +0 |  -3 |

- **_Blood Sense._** The shark can pinpoint, by scent, the location of creatures that don't have all of their HP within 60 feet of it and can sense the general direction of such creatures within 1 mile of it.
- **_Electrical Sensitivity._** Whenever the shark takes lightning damage, it must succeed on a DC 11 CON save or be incapacitated until the end of its next turn.
- **_Pack Tactics._** The shark has advantage on attack rolls against a creature if at least one of the shark's allies is within 5 feet of the creature and the ally isn't incapacitated.
- **_Water Breathing._** The shark can breathe only underwater.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) piercing damage.

**Bonus Actions**

- **_Stealthy Hunter._** The shark takes the Hide action.

### Snake, Constrictor (CR 1/4)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 15
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 12
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +1 |  -5 |  +0 |  -4 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage.
- **_Constrict._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d8+2) bludgeoning damage, and the target is grappled (escape DC 12), if it is a Large or smaller creature. Until this grapple ends, the creature is restrained, and the snake can't Constrict another target.

**Bonus Actions**

- **_Crush._** One creature grappled by the snake must succeed on a DC 12 STR or take 4 (1d8) bludgeoning damage and begin suffocating. The creature continues suffocating until the grapple ends.

### Snake, Flying (CR 1/8)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 10
- **Speed** 30 ft., fly 60 ft., swim 30 ft.
- **Perception** 11
- **Stealth** 13
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -3 |  +1 |  +0 |  -4 |  +1 |  -3 |

- **_Flyby._** The snake doesn't provoke opportunity attacks when it flies out of an enemy's reach.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage, and the target must succeed on a DC 11 CON save or take 5 (2d4) poison damage.

**Reactions**

- **_Reflexive Escape._** When a creature the snake can see attacks it, the snake can move up to 5 feet. If this movement puts the snake out of reach of the attack, the attack misses.

### Snake, Giant Constrictor (CR 2)

_Huge Beast_

- **Armor Class** 12
- **Hit Points** 63
- **Speed** 30 ft., swim 30 ft.
- **Perception** 12
- **Stealth** 12
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +1 |  -5 |  +0 |  -4 |

**Actions**

- **_Multiattack._** The snake makes one Bite attack and one Constrict attack, or it makes two Bite attacks.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 10 ft., one creature. _Hit:_ 10 (2d6+3) piercing damage.
- **_Constrict._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 12 (2d8+3) bludgeoning damage, and the target is grappled (escape DC 14). Until this grapple ends, the creature is restrained, and the snake can't Constrict another target.

**Bonus Actions**

- **_Crush._** One creature grappled by the snake must succeed on a DC 14 STR or take 9 (2d8) bludgeoning damage and begin suffocating. The creature continues suffocating until the grapple ends.

### Snake, Giant Poisonous (CR 1/4)

_Medium Beast_

- **Armor Class** 12
- **Hit Points** 14
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 14
- **Resistant** poison | poisoned
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +1 |  -4 |  +0 |  -4 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 10 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage, and the target must make a DC 11 CON save, taking 5 (2d4) poison damage on a failed save, or half as much damage on a successful one.

**Reactions**

- **_Reflexive Nip._** When a creature the snake can see hits it with a melee attack while within 5 feet of it, the snake can make a quick nip at the creature. The attacker must succeed on a DC 11 CON save or be poisoned until the end of its next turn.

### Snake, Poisonous (CR 1/8)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 9
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 13
- **Resistant** poison | poisoned
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  +0 |  -5 |  +0 |  -4 |

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage, and the target must succeed on a DC 10 CON save or take 2 (1d4) poison damage.

**Reactions**

- **_Reflexive Nip._** When a creature the snake can see hits it with a melee attack while within 5 feet of it, the snake can make a quick nip at the creature. The attacker must succeed on a DC 10 CON save or be poisoned until the end of its next turn.

### Snake, Swarm of Poisonous Snakes (CR 2)

_Medium Swarm of Tiny Beasts_

- **Armor Class** 14
- **Hit Points** 48
- **Speed** 30 ft., swim 30 ft.
- **Perception** 10
- **Stealth** 14
- **Resistant** poison | poisoned | Swarm Resilience
  _Immune_ Swarm Resilience
- **Senses** keensense 10 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +4 |  +0 |  -5 |  +0 |  -4 |

- **_Poisonous Swarm._** The hissing, spitting, and constant nipping of snakes in the swarm leaves the swarm's space dripping with poison. A creature that starts its turn in the swarm's space must succeed on a DC 14 CON save or be poisoned until the start of its next turn.
- **_Swarm._** The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny snake. The swarm can't regain HP or gain temporary HP.
- **_Swarm Resilience._** The swarm is resistant to bludgeoning, piercing, and slashing damage, and it is immune to the charmed, frightened, grappled, paralyzed, petrified, prone, restrained, and stunned conditions.

**Actions**

- **_Bites._** _Melee Weapon Attack:_ +6 to hit, reach 0 ft., one creature in the swarm's space. _Hit:_ 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its HP or fewer. The target must make a DC 14 CON save, taking 18 (4d8) poison damage on a failed save, or half as much damage on a successful one.

### Spider (CR 0)

_Tiny Beast_

- **Armor Class** 12 (natural armor)
- **Hit Points** 8
- **Speed** 20 ft., climb 20 ft.
- **Perception** 10
- **Stealth** 14
- **Senses** darkvision 30 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +0 |  -1 |  -5 |  +0 |  -4 |

- **_Spider Climb._** The spider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Web Sense._** While in contact with a web, the spider knows the exact location of any other creature in contact with the same web.
- **_Web Walker._** The spider ignores movement restrictions caused by webbing.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one creature. _Hit:_ 2 (1d4) piercing damage, and the target must succeed on a DC 9 CON save or take 2 (1d4) poison damage.

**Bonus Actions**

- **_Web Shot (Recharge 4 - 6)._** The spider launches a gob of webbing at one creature it can see within 15 feet of it. The target must succeed on a DC 9 DEX save or have its speed reduced by 10 feet. A creature can take an action to remove the webbing, ending the effect.

### Spider, Giant (CR 1)

_Large Beast_

- **Armor Class** 15 (natural armor)
- **Hit Points** 40
- **Speed** 30 ft., climb 30 ft.
- **Perception** 10
- **Stealth** 17
- **Senses** keensense 10 ft., darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +3 |  +1 |  -4 |  +0 |  -3 |

- **_Spider Climb._** The spider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Web Sense._** While in contact with a web, the spider knows the exact location of any other creature in contact with the same web.
- **_Web Walker._** The spider ignores movement restrictions caused by webbing.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 7 (1d8+3) piercing damage, and the target must make a DC 13 CON save, taking 10 (3d6) poison damage on a failed save, or half as much damage on a successful one. If the poison damage reduces the target to 0 HP, the target is stable but poisoned for 1 hour, even after regaining HP, and is paralyzed while poisoned in this way.

**Bonus Actions**

- **_Web (Recharge 4 - 6)._** The spider launches a gob of webbing at one creature it can see within 30 feet of it. The target must succeed on a DC 12 DEX save or be restrained. A creature, including the restrained target, can take its action to free the target from the webbing by succeeding on a DC 12 STR check. The webbing can also be attacked and destroyed (AC 10; HP 5; vulnerability to fire damage; immunity to bludgeoning, poison, and psychic damage).

### Spider, Giant Wolf (CR 1/4)

_Medium Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 14
- **Speed** 40 ft., climb 40 ft.
- **Perception** 13
- **Stealth** 16
- **Senses** keensense 10 ft., darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +2 |  +1 |  -4 |  +1 |  -3 |

- **_Spider Climb._** The spider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.
- **_Standing Leap._** The spider's long jump is up to 20 feet and its high jump is up to 10 feet, with or without a running start.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one creature. _Hit:_ 5 (1d6+2) piercing damage, and the target must succeed on a DC 12 CON save or take 5 (2d4) poison damage. If the poison damage reduces the target to 0 HP, the target is stable but poisoned for 1 hour, even after regaining HP, and is paralyzed while poisoned in this way.

**Bonus Actions**

- **_Hunter's Leap._** The spider jumps up to 20 feet horizontally or up to 10 feet vertically toward a hostile creature that it can see. This movement doesn't provoke opportunity attacks.

### Tiger (CR 1)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 38
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 16
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -4 |  +1 |  -1 |

- **_Heightened Smell._** The tiger's Perception is 18 when perceiving by smell.
- **_Pounce._** If the tiger moves at least 20 feet straight toward a creature and then hits it with a Claws attack on the same turn, that target must succeed on a DC 13 STR save or be knocked prone. If the target is prone, the tiger can make one Bite attack against it as a bonus action.

**Actions**

- **_Multiattack._** The tiger makes one Bite attack and one Claws attack. If both attacks hit one creature, the target must succeed on a DC 13 CON save at the start of its next turn or lose 5 (2d4) HP, as the wound continues bleeding.
- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one creature. _Hit:_ 6 (1d6+3) piercing damage.
- **_Claws._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) slashing damage.

### Tiger, Saber - Toothed (CR 2)

_Large Beast_

- **Armor Class** 12
- **Hit Points** 63
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 16
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +2 |  +2 |  -4 |  +1 |  -1 |

- **_Heightened Smell._** The tiger's Perception is 18 when perceiving by smell.
- **_Pounce._** If the tiger moves at least 20 feet straight toward a creature and then hits it with a Claws attack on the same turn, that target must succeed on a DC 14 STR save or be knocked prone. If the target is prone, the tiger can make one Claws attack against it as a bonus action.

**Actions**

- **_Multiattack._** The tiger makes one Bite attack and one Claws attack.
- **_Bite._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one creature. _Hit:_ 9 (1d10+4) piercing damage, and the target must succeed on a DC 14 DEX save or suffer a puncture wound. A creature suffering a puncture wound loses 5 (1d10) HP at the start of each of its turns as the wound bleeds excessively. Any creature can take an action to stanch the wound with a successful DC 12 WIS (Medicine) check. The wound also closes if the target receives magical healing.
- **_Claws._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) slashing damage.

### Vulture (CR 0)

_Medium Beast_

- **Armor Class** 10
- **Hit Points** 8
- **Speed** 10 ft., fly 50 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -2 |  +0 |  +1 |  -4 |  +1 |  -3 |

- **_Carrion Sense._** The vulture can pinpoint, by scent, the location of carrion, dead creatures, and Undead without the Incorporeal Movement trait within 60 feet of it.
- **_Heightened Sight and Smell._** The vulture's Perception is 18 when perceiving by sight or smell.
- **_Pack Tactics._** The vulture has advantage on attack rolls against a creature if at least one of the vulture's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Beak._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) piercing damage.

**Reactions**

- **_Defensive Bile._** When a creature the vulture can see hits it with a melee attack while within 5 feet of it, the vulture can spit partially digested carrion at the creature. The attacker must succeed on a DC 11 CON save or be incapacitated until the end of its next turn.

### Vulture, Giant (CR 1)

_Large Beast_

- **Armor Class** 10
- **Hit Points** 46
- **Speed** 10 ft., fly 60 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +2 |  -4 |  +1 |  -2 |

- **_Carrion Sense._** The vulture can pinpoint, by scent, the location of carrion, dead creatures, and Undead without the Incorporeal Movement trait within 60 feet of it.
- **_Heightened Sight and Smell._** The vulture's Perception is 18 when perceiving by sight or smell.
- **_Pack Tactics._** The vulture has advantage on attack rolls against a creature if at least one of the vulture's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Multiattack._** The vulture makes one Beak attack and one Talons attack.
- **_Beak._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) piercing damage.
- **_Talons._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) slashing damage.

**Reactions**

- **_Defensive Bile._** When a creature the vulture can see hits it with a melee attack while within 5 feet of it, the vulture can spit partially digested carrion at the creature. The attacker must succeed on a DC 13 CON save or take 5 (2d4) acid damage and be incapacitated until the end of its next turn.

### Weasel (CR 0)

_Tiny Beast_

- **Armor Class** 11
- **Hit Points** 8
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 13
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -4 |  +1 |  -1 |  -4 |  +1 |  -4 |

- **_Heightened Hearing and Smell._** The weasel's Perception is 18 when perceiving by hearing or smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one creature. _Hit:_ 3 (1d4+1) piercing damage. Instead of dealing damage, the weasel can steal one item the target is wearing or carrying, provided the item weighs no more than 5 pounds, can fit in one hand, isn't a weapon, and isn't wrapped around or firmly attached to the target. For example, a weasel could steal a hat or belt pouch but not a creature's shirt or armor.

### Weasel, Giant (CR 1/4)

_Medium Beast_

- **Armor Class** 13
- **Hit Points** 14
- **Speed** 40 ft.
- **Perception** 13
- **Stealth** 15
- **Senses** darkvision 60 ft.
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +3 |  +0 |  -3 |  +1 |  -3 |

- **_Heightened Hearing and Smell._** The weasel's Perception is 18 when perceiving by hearing or smell.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 5 (1d4+3) piercing damage. Instead of dealing damage, the weasel can steal one item the target is wearing or carrying, provided the item weighs no more than 10 pounds, isn't a weapon, and isn't wrapped around or firmly attached to the target. For example, a weasel could steal a hat or belt pouch but not a creature's shirt or armor.

**Reactions**

- **_Repellent Spray._** When a creature the weasel can see moves to a space within 15 feet of it, the weasel can release a pungent spray at the creature. The target must succeed on a DC 13 CON save or be poisoned until the end of its next turn. While poisoned, the creature can't move to a space within 5 feet of the weasel.

### Wolf (CR 1/4)

_Medium Beast_

- **Armor Class** 13 (natural armor)
- **Hit Points** 14
- **Speed** 40 ft.
- **Perception** 11
- **Stealth** 14
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +2 |  +1 |  -4 |  +1 |  -2 |

- **_Heightened Hearing and Smell._** The wolf's Perception is 16 while perceiving by hearing or smell.
- **_Pack Tactics._** The wolf has advantage on attack rolls against a creature if at least one of the wolf's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 6 (1d8+2) piercing damage. If the target is a creature, it must succeed on a DC 12 STR save or be knocked prone.

### Wolf, Dire (CR 1)

_Large Beast_

- **Armor Class** 14 (natural armor)
- **Hit Points** 40
- **Speed** 50 ft.
- **Perception** 13
- **Stealth** 14
- **Resistant** frightened
- **Senses** -
- **Languages** -

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +2 |  -4 |  +1 |  -2 |

- **_Heightened Hearing and Smell._** The wolf's Perception is 18 when perceiving by hearing or smell.
- **_Pack Tactics._** The wolf has advantage on an attack roll against a creature if at least one of the wolf's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Bite._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 12 (2d8+3) piercing damage. If the target is a creature, it must succeed on a DC 13 STR save or be knocked prone.

**Bonus Actions**

- **_Hungry Growl._** The wolf stares down and growls at one creature it can see within 30 feet of it. The target must succeed on a DC 13 WIS save or be frightened until the end of its next turn. The wolf has advantage on the next attack roll it makes against the frightened creature.

## NPCs

### Acolyte (CR 1/4)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 10
- **Hit Points** 15
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 10
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +0 |  +0 |  +0 |  +4 |  +0 |

- **_Divine Providence._** Each friendly creature within 20 feet of the acolyte that isn't a Construct or Undead has advantage on death saves.

**Actions**

- **_Mace._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 3 (1d6) bludgeoning damage plus 3 (1d6) necrotic or radiant damage (the acolyte's choice).
- **_Radiant Bolt._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 6 (1d4+4) radiant damage.
- **_Spellcasting._** The acolyte casts one of the following spells using WIS as the spellcasting ability (spell save DC 13).
  - At will: _light_, _thaumaturgy_
  - 3/day each: _bless_, _cure wounds_, _sanctuary_

### Archdruid (CR 12)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 17 (Nature's Champion)
- **Hit Points** 210
- **Speed** 30 ft.
- **Perception** 19
- **Stealth** 12
- **Resistant** Nature's Champion
- **Senses** -
- **Languages** Common, Druidic, plus any one language

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +2 |  +1 |  +6 |  +9 |  +1 |

- **_Nature's Champion._** While the archdruid is conscious, wearing no armor, and in a natural environment or terrain, such as a desert, forest, or mountain, it adds its WIS modifier to its AC (included above). In addition, it is resistant to cold, fire, lightning, poison, and thunder damage.
- **_Nature's Weapons._** When the archdruid hits with any weapon, the weapon deals an extra 4d8 cold, fire, lightning, poison, or thunder damage (included in the attack), the archdruid's choice.

**Actions**

- **_Multiattack._** The archdruid makes three Thorned Staff or Nature's Wrath attacks. It can replace one attack with a use of Spellcasting.
- **_Thorned Staff._** _Melee Weapon Attack:_+7 to hit, reach 5. ft., one target. _Hit:_ 10 (2d6+3) piercing damage plus 18 (4d8) cold, fire, lightning, poison, or thunder damage (the archdruid's choice).
- **_Nature's Wrath._** _Ranged Spell Attack:_+9 to hit, range 120 ft., one target. _Hit:_ 27 (5d8+5) cold, fire, lightning, poison, or thunder damage (the archdruid's choice).
- **_Spellcasting._** The archdruid casts one of the following spells, using WIS as the spellcasting ability (spell save DC 17).
  - At will: _animal friendship_, _druidcraft_, _entangle_, _speak with animals_
  - 3/day each: _heat metal_, _spike growth_, _plant growth_, _speak with plants_
  - 1/day each: _polymorph_, _insect plague_

**Bonus Actions**

- **_Change Shape._** The archdruid magically transforms into a Beast that has a challenge rating no higher than its own, or back into its true form, which is Humanoid. Any equipment it is wearing or carrying transforms with it. It reverts to its true form if it dies. In a new form, the archdruid retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA modifiers, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form. The archdruid can choose to instead magically transform into an Elemental that has a challenge rating no higher than 6, or back into its true form. If it transforms into an Elemental, the archdruid can remain in that form for up to 6 hours then must finish a short or long rest before it can transform into an Elemental again.

### Archmage (CR 12)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 17 (Magic Ward)
- **Hit Points** 212
- **Speed** 30 ft.
- **Perception** 16
- **Stealth** 12
- **Resistant** Magic Ward
- **Senses** -
- **Languages** any six languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +1 |  +9 |  +6 |  +3 |

- **_Magic Resistance._** The archmage has advantage on saves against spells and other magical effects.
- **_Magic Ward._** While the archmage is conscious, wearing no armor, and not inside of an antimagic effect, it adds its INT modifier to its AC (included above). In addition, it is resistant to force damage.

**Actions**

- **_Multiattack._** The archmage makes three Arcane Blast attacks. It can replace one attack with a use of Spellcasting.
- **_Arcane Blast._** _Melee or Ranged Spell Attack:_ +9 to hit, reach 5 ft. or range 60 ft., one target. _Hit:_ 27 (4d10+5) force damage, and the target must succeed on a DC 17 STR save or be pushed up to 10 feet away from the archmage and knocked prone.
- **_Burst of Magic (Recharge 5 - 6)._** The archmage releases a burst of swirling, multicolored, magical energy on a point it can see within 60 feet of it. Each creature within 20 feet of that point must make a DC 17 DEX save, taking 33 (6d10) force damage and 18 (4d8) acid, cold, fire, lightning, or thunder damage (the archmage's choice) on a failed save, or half as much damage on a successful one.
- **_Spellcasting._** The archmage casts one of the following spells, using INT as the spellcasting ability (spell save DC 17).
  - At will: _detect magic_, _disguise self_, _mage hand_, _prestidigitation_
  - 3/day each: _charm_, _dispel magic_, _fly_, _invisibility_ (self only), _mirror image_
  - 1/day each: _dimension door_, _greater hold_, _wall of force_

**Bonus Actions**

- **_Shimmering Step._** The archmage teleports, along with any equipment it is wearing or carrying, up to 30 feet to an unoccupied space it can see. Sparks of arcane energy appear at the origin and destination when it uses this bonus action.

**Reactions**

- **_Counter Spell._** When a creature the archmage can see within 30 feet of it casts a spell, the archmage can counter the spell, interrupting the casting. This reaction works like the counterspell spell with a +5 spellcasting ability check, except the archmage must always make the ability check, regardless of the spell's circle. The archmage has advantage on this check if the spell is on the Arcane source spell list.

### Assassin (CR 8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 15 (studded leather)
- **Hit Points** 157
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 19
- **Resistant** poison | poisoned
- **Senses** -
- **Languages** Thieves' Cant plus any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +6 |  +2 |  +4 |  +0 |  +0 |

- **_Evasion._** If the assassin is subjected to an effect that allows it to make a DEX save to take only half damage, the assassin instead takes no damage if it succeeds on the save, and only half damage if it fails.
- **_Poisoned Weapons._** The assassin's weapons are coated in poison. When it hits with any weapon, the weapon deals an extra 3d8 poison damage (included in the attack). In addition, at the start of each of its turns, the assassin can choose which of the following poisons is active on its weapons. The poison remains on the weapons until the start of the assassin's next turn.
- **Assassin's Friend.** A creature poisoned by a weapon coated with this poison takes an extra 4 (1d8) poison damage each time it takes damage while poisoned.
- **Buyer's Mercy.** A creature poisoned by a weapon coated with this poison falls unconscious while poisoned or until it takes damage or another creature uses an action to wake it.
- **Meddler's Fate.** A creature poisoned by a weapon coated with this poison has its speed halved while poisoned.

**Actions**

- **_Multiattack._** The assassin makes three Shortsword or Hand Crossbow attacks.
- **_Shortsword._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage plus 13 (3d8) poison damage, and the target must succeed on a DC 14 CON save or be poisoned for 1 minute. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.
- **_Hand Crossbow._** _Ranged Weapon Attack:_ +6 to hit, range 30/120 ft., one target. _Hit:_ 6 (1d6+3) piercing damage plus 13 (3d8) poison damage, and the target must succeed on a DC 14 CON save or be poisoned for 1 minute. A poisoned creature can repeat the save at the end of each of its turns, ending the effect on itself on a success.

**Bonus Actions**

- **_Hidden Step._** The assassin magically teleports, along with any equipment it is wearing or carrying, up to 30 feet to an unoccupied space it can see and takes the Hide action.

### Bandit (CR 1/8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 12 (leather armor)
- **Hit Points** 9
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 13
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +1 |  +1 |  +0 |  +0 |  +0 |

- **_Opportunist._** The bandit has advantage on opportunity attacks.

**Actions**

- **_Scimitar._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 4 (1d6+1) slashing damage.
- **_Light Crossbow._** _Ranged Weapon Attack:_ +3 to hit, range 80/320 ft., one target. _Hit:_ 5 (1d8+1) piercing damage.

**Bonus Actions**

- **_Steal Item._** The bandit steals an object from one creature it can see within 5 feet of it. The target must succeed on a DC 11 DEX save or lose one object it is wearing or carrying of the bandit's choice. The object must weigh no more than 10 pounds, can't be a weapon, and can't be wrapped around or firmly attached to the target, such as a shirt or armor.

### Bandit Captain (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 16 (studded leather)
- **Hit Points** 51
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 16
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +4 |  +2 |  +2 |  +0 |  +2 |

- **_Opportunist._** The bandit captain has advantage on opportunity attacks.

**Actions**

- **_Multiattack._** The bandit captain makes one Dagger attack and two Scimitar attacks, or it makes three Dagger attacks.
- **_Dagger._** _Melee or Ranged Weapon Attack:_ +6 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 6 (1d4+4) piercing damage.
- **_Scimitar._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 7 (1d6+4) slashing damage.

**Bonus Actions**

- **_Reposition Forces (Recharge 5 - 6)._** Each friendly bandit and thug under the bandit captain's command moves up to half its speed in a direction of the captain's choice. This movement doesn't provoke opportunity attacks.
- **_Steal Item._** The bandit captain steals an object from one creature it can see within 5 feet of it. The target must succeed on a DC 14 DEX save or lose one object it is wearing or carrying of the bandit captain's choice. The object must weigh no more than 10 pounds, can't be a weapon, and can't be wrapped around or firmly attached to the target, such as a shirt or armor.

**Reactions**

- **_Parry._** The bandit captain adds 2 to its AC against one melee attack that would hit it. To do so, the captain must see the attacker and be wielding a melee weapon.

### Bard (CR 5)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 15 (studded leather)
- **Hit Points** 114
- **Speed** 30 ft.
- **Perception** 14
- **Stealth** 16
- **Resistant** Artistic Expression
- **Senses** -
- **Languages** Common plus any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +6 |  +1 |  +2 |  +1 |  +7 |

- **_Artistic Expression._** The bard has one primary form of artistic expression, such as song, poetry, dance, fashion, paint, or similar. It is resistant to one type of damage associated with that artistic expression. For example, a bard expressing art through song or oration is resistant to thunder damage, a bard expressing art through paint is resistant to acid or poison damage (the bard's choice), and a bard expressing art through witty discourse or clever quips is resistant to psychic damage. This trait can't make the bard resistant to force, necrotic, or radiant damage.
- **_Expressive Weapons._** When the bard hits with any weapon, the weapon deals an extra 3d8 damage of the type determined by Artistic Expression.

**Actions**

- **_Multiattack._** The bard makes two Rapier or Hand Crossbow attacks. It can replace one attack with a use of Spellcasting.
- **_Rapier._** _Melee Weapon Attack:_ +6 to hit, reach 5. ft., one target. _Hit:_ 7 (1d8+3) piercing damage plus 13 (3d8) damage of the type determined by Artistic Expression.
- **_Hand Crossbow._** _Ranged Weapon Attack:_+6 to hit, range 30/120 ft., one target. _Hit:_ 6 (1d6+3) piercing damage plus 13 (3d8) damage of the type determined by Artistic Expression.
- **_Dissonant Outburst (Recharge 4 - 6)._** Each creature within 30 feet of the bard and that can see or hear it must make a DC 15 WIS save. On a failure, a creature takes 14 (4d6) thunder damage and 7 (2d6) psychic damage and has disadvantage on attack rolls and ability checks until the end of its next turn. On a success, a creature takes half the damage and doesn't have disadvantage on attack rolls and ability checks.
- **_Spellcasting._** The bard casts one of the following spells, using CHA as the spellcasting ability (spell save DC 15).
  - At will: dancing lights, mage hand, message
  - 3/day each: _faerie fire_, _hold_, _suggestion_
  - 1/day each: _confusion_, _greater invisibility_

### Berserker (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13 (hide armor)
- **Hit Points** 60
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 11
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +4 |  +1 |  +3 |  -1 |  +0 |  -1 |

- **_Reckless._** At the start of its turn, the berserker can gain advantage on all melee weapon attack rolls it makes during that turn, but attack rolls against it have advantage until the start of its next turn.
- **_Stalwart._** If the berserker starts its turn afflicted by an ongoing effect that allows for a repeated save to end the effect, such as the hold spell or the poison from an ettercap's Bite, the gladiator can make the save at the start of the turn instead of the end and has advantage on the save.

**Actions**

- **_Multiattack._** The berserker makes two Greataxe attacks.
- **_Greataxe._** _Melee Weapon Attack:_ +6 to hit, reach 5 ft., one target. _Hit:_ 10 (1d12+4) slashing damage.

### Commoner (CR 0)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 10
- **Hit Points** 8
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 10
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +0 |  +0 |  +0 |  +0 |  +0 |

**Actions**

- **_Club._** _Melee Weapon Attack:_ +2 to hit, reach 5 ft., one target. _Hit:_ 2 (1d4) bludgeoning damage.
- **_Sling._** _Ranged Weapon Attack:_ +2 to hit, range 30/120 ft., one target. _Hit:_ 2 (1d4) bludgeoning damage.
- **_Angry Mob (1/Day)._** The commoner moves up to half its speed toward a creature it can see. Each friendly commoner within 30 feet of the commoner can use its reaction to join the angry mob and move up to half its speed toward the same target. This movement doesn't provoke opportunity attacks. If the initiating commoner is within 5 feet of the target, the target must make a DC 10 DEX save, taking 2 (1d4) bludgeoning damage on a failed save, or half as much damage on a successful one. For each commoner after the first that participated in the angry mob and that is within 10 feet of the target, the damage increases by 1 as stones, clubs, sticks, and similar "weapons" fly at the target from all angles. Afterwards, each commoner after the first that participated in the mob can't use Angry Mob until it finishes a short or long rest.

### Cultist (CR 1/8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13 (studded leather)
- **Hit Points** 9
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 11
- **Resistant** Dark Devotion
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +1 |  +1 |  +0 |  +1 |  +2 |

- **_Dark Devotion._** The cultist is resistant to the charmed and frightened conditions.

**Actions**

- **_Sacrificial Dagger._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 3 (1d4+1) slashing damage. If the target is paralyzed, prone, stunned, or unconscious, it takes an extra 2 (1d4) slashing damage.

**Reactions**

- **_For the Cause!_** When a friendly creature the cultist can see within 5 feet of it is hit by an attack that would reduce that creature to 0 HP, the cultist can leap in front of the attack, taking the damage instead.

### Cultist, Fanatic (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 14 (studded leather)
- **Hit Points** 60
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 12
- **Resistant** Dark Devotion
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +1 |  +0 |  +3 |  +3 |

- **_Dark Devotion._** The fanatic is resistant to the charmed and frightened conditions.
- **_Unholy Weapons._** The fanatic's weapons are coated in dark, magical flames. When the fanatic hits with any weapon, the weapon deals an extra 2d6 fire damage or necrotic damage (included in the attack), the fanatic's choice.

**Actions**

- **_Multiattack._** The fanatic makes two Sacrificial Dagger or Unholy Bolt attacks.
- **_Sacrificial Dagger._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 4 (1d4+2) slashing damage plus 7 (2d6) fire damage or necrotic damage (the fanatic's choice). If the target is paralyzed, prone, stunned, or unconscious, it takes an extra 2 (1d4) slashing damage.
- **_Unholy Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 10 (2d6+3) fire damage or necrotic damage (the fanatic's choice).
- **_Spellcasting._** The fanatic casts one of the following spells, using WIS as the spellcasting ability (spell save DC 13).
  - At will: _light_, _thaumaturgy_
  - 3/day each: _bane_, _command_
  - 2/day: _hold_

**Bonus Actions**

- **_Unholy Brand (Recharge 5 - 6)._** One creature the fanatic can see within 30 feet of it must succeed on a DC 13 CHA save or be marked with an unholy brand until the start of the fanatic's next turn. While the creature is branded, Fiends and cultists have advantage on attack rolls against it.

### Druid (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 11 (16 with barkskin)
- **Hit Points** 66
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 11
- **Senses** -
- **Languages** Druidic plus any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +1 |  +1 |  +1 |  +3 |  +0 |

**Actions**

- **_Multiattack._** The druid makes two Flowering Quarterstaff or Poison Bolt attacks.
- **_Flowering Quarterstaff._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage plus 5 (2d4) poison damage.
- **_Poison Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 10 (3d4+3) poison damage.
- **_Spellcasting._** The druid casts one of the following spells, using WIS as the spellcasting ability (spell save DC 13).
  - At will: druidcraft, speak with animals
  - 3/day each: _entangle_, _cure wounds_, _thunderwave_
  - 2/day each: _barkskin_, _spike growth_

**Bonus Actions**

- **_Change Shape._** The druid magically transforms into a Medium or smaller Beast that has a challenge rating no higher than its own, or back into its true form, which is Humanoid. Any equipment it is wearing or carrying transforms with it. It reverts to its true form if it dies. In a new form, the druid retains its HP, ability to speak, proficiencies, and INT, WIS, and CHA modifiers, as well as this bonus action. Its statistics and capabilities are otherwise replaced by those of the new form, except any class features or legendary actions of that form.

### Gladiator (CR 5)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 16 (studded leather, shield)
- **Hit Points** 108
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 12
- **Resistant** frightened
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +7 |  +2 |  +6 |  +0 |  +1 |  +2 |

- **_Brutal._** A melee weapon deals one extra die of its damage when the gladiator hits with it (included in the attack).

**Actions**

- **_Multiattack._** The gladiator makes two Shield Bash attacks and two Spear attacks, or it makes three Spear attacks.
- **_Shield Bash._** _Melee Weapon Attack:_ +7 to hit, reach 5 ft., one target. _Hit:_ 9 (2d4+4) bludgeoning damage. If the target is a Medium or smaller creature, it must succeed on a DC 15 STR save or be knocked prone.
- **_Spear._** _Melee or Ranged Weapon Attack:_ +7 to hit, reach 5 ft. and range 20/60 ft., one target. _Hit:_ 11 (2d6+4) piercing damage, or 13 (2d8+4) piercing damage if used with two hands to make a melee attack.

**Bonus Actions**

- **_Entertaining Display._** The gladiator slams its spear against its shield, twirls its spear, or roars while flexing, entertaining or intimidating up to two creatures it can see within 15 feet of it. Each target must succeed on a DC 15 CHA save or be charmed or frightened (the gladiator's choice) until the end of its next turn.

**Reactions**

- **_Parry._** The gladiator adds 3 to its AC against one melee attack that would hit it. To do so, the gladiator must see the attacker and be wielding a melee weapon.

### Guard (CR 1/8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 14 (chain shirt)
- **Hit Points** 8
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 11
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +1 |  +1 |  +0 |  +1 |  +0 |

**Actions**

- **_Spear._** _Melee or Ranged Weapon Attack:_ +3 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 4 (1d6+1) piercing damage, or 5 (1d8+1) piercing damage if used with two hands to make a melee attack.

**Reactions**

- **_Protector's Parry._** When a friendly creature the guard can see within 5 feet of it is the target of an attack, the guard can interpose its weapon between the creature and the attacker. The friendly creature adds 2 to its AC against that attack. To use this reaction, the guard must be able to see the attacker and be wielding a melee weapon.

### Knight (CR 3)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 18 (plate)
- **Hit Points** 68
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 5 (10 without armor)
- **Resistant** charmed, frightened
- **Senses** -
- **Languages** Common and one other language

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +0 |  +2 |  +1 |  +1 |  +2 |

- **_Chivalrous Presence._** The knight exudes a powerful presence. At the start of each of the knight's turns, it chooses one of the following presences, which lasts until the start of the knight's next turn.
  - **Empowering Presence.** Each friendly creature that starts its turn within 15 feet of the knight has advantage on the first attack roll it makes before this presence ends.
  - **Protective Presence.** Hostile creatures have disadvantage on attack rolls against friendly creatures within 5 feet of the knight.
  - **Unwavering Presence.** Each friendly creature within 15 feet of the knight is resistant to the charmed and frightened conditions.

**Actions**

- **_Multiattack._** The knight makes three Greatsword attacks, or it makes four Javelin attacks.
- **_Greatsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 10 (2d6+3) slashing damage.
- **_Javelin._** _Melee or Ranged Weapon Attack:_ +5 to hit, reach 5 ft. or range 30/120 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.

**Bonus Actions**

- **_Champion's Challenge._** The knight challenges one creature it can see within 30 feet of it. The target must succeed on a DC 13 CHA save or have disadvantage on attack rolls against creatures that aren't the knight until the end of its next turn.

### Mage (CR 6)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 10 (13 with mage armor)
- **Hit Points** 70
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 12
- **Senses** -
- **Languages** any four languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +0 |  +0 |  +6 |  +1 |  +0 |

- **_Arcane Weapons._** The mage's weapon attacks are magical. When the mage hits with any weapon, the weapon deals an extra 3d8 force damage (included in the attack).
- **_Magic Resistance._** The mage has advantage on saves against spells and other magical effects.

**Actions**

- **_Multiattack._** The mage makes three Dagger or Arcane Bolt attacks. It can replace one attack with a use of Spellcasting.
- **_Dagger._** _Melee or Ranged Weapon Attack:_ +3 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 2 (1d4) piercing damage plus 13 (3d8) force damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +6 to hit, range 60 ft., one target. _Hit:_ 16 (3d8+3) force damage.
- **_Spellcasting._** The mage casts one of the following spells, using INT as the spellcasting ability (spell save DC 14).
  - At will: _detect magic_, _light_, _mage hand_, _prestidigitation_
  - 3/day each: _fly_, _mage armor_, _mirror image_
  - 2/day each: _fireball_, _haste_, _slow_
  - 1/day each: _cone of cold_, _greater invisibility_

### Mage Apprentice (CR 1)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 10 (13 with mage armor)
- **Hit Points** 40
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 11
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  -1 |  +1 |  +1 |  +4 |  +1 |  +0 |

- **_Arcane Weapons._** The mage apprentice's weapon attacks are magical. When the mage hits with any weapon, the weapon deals an extra 2d8 force damage (included in the attack).
- **_Reckless Show - Off._** If it can see a fellow apprentice or its magical teacher at the start of its turn, the mage apprentice has advantage on the first spell attack roll it makes during that turn, but attack rolls against it also have advantage until the start of its next turn.

**Actions**

- **_Dagger._** _Melee or Ranged Weapon Attack:_ +3 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 2 (1d4) piercing damage plus 9 (2d8) force damage.
- **_Arcane Bolt._** _Ranged Spell Attack:_ +4 to hit, range 60 ft., one target. _Hit:_ 11 (2d8+2) force damage.
- **_Spellcasting._** The mage apprentice casts one of the following spells, using INT as the spellcasting ability (spell save DC 12).
  - At will: _mage hand_, _minor illusion_
  - 1/day each: _color spray_, _mage armor_, _sleep_

### Master Alchemist (CR 7)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 16 (studded leather)
- **Hit Points** 152
- **Speed** 30 ft.
- **Perception** 11
- **Stealth** 14
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +4 |  +6 |  +7 |  +1 |  +2 |

- **_Tools of the Trade._** The master alchemist is proficient with alchemist's supplies and doubles its proficiency bonus for any ability check it makes with alchemist's supplies.

**Actions**

- **_Multiattack._** The master alchemist makes three Hasty Concoction attacks.
- **_Hasty Concoction._** _Melee or Ranged Weapon Attack:_ +7 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 17 (3d8+4) acid, cold, fire, or poison damage (the alchemist's choice). The concoction then causes one of the following effects of the master alchemist's choice.
  - **Disorienting Vapors.** Overly sweet - smelling, pink vapors erupt from where the concoction hit the target. The target and each creature within 5 feet of it must make a DC 15 INT save. When a creature that failed this save moves on its next turn, it moves in a random direction.
  - **Poisonous Cloud.** An acrid - smelling, green gas pours out from where the concoction hit the target. The gas fills a 10 - foot - radius sphere centered on the target. The gas spreads around corners, and its area is lightly obscured. A creature that enters the gas for the first time on a turn or starts its turn there must succeed on a DC 15 CON save or be poisoned until the end of its next turn. The gas disperses at the start of the master alchemist's next turn.
  - **Slick Floor.** A thick, purple foam bursts out from where the concoction hit the target. The floor within 10 feet of the target is coated in slick goop until the start of the master alchemist's next turn, when the foam dries. For the duration, when a creature moves through the area, it must succeed on a DC 15 DEX save or fall prone. When the master alchemist makes a Hasty Concoction attack, it can choose to target a point on the ground it can see within 60 feet instead. If it does so, the concoction causes only one of the above effects centered on that point instead of dealing damage.
- **_Explosive Flask (Recharge 5 - 6)._** The master alchemist throws an explosive flask at a point it can see within 30 feet of it. Each creature within 10 feet of that point must make a DC 15 DEX save, taking 31 (7d8) fire damage on a failed save, or half as much damage on a successful one.
- **_Healing Unguent (3/Day)._** The master alchemist rubs a greasy unguent on a creature's wounds. The target regains 14 (4d6) HP.

**Bonus Actions**

- **_Protective Draught (Recharge 4 - 6)._** The master alchemist drinks one of its brews and gains resistance to acid, cold, fire, or poison damage (the master alchemist's choice) until the end of its next turn.

### Mechanist (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 15 (scale mail)
- **Hit Points** 60
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 11
- **Senses** -
- **Languages** Common, plus any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  +1 |  +1 |  +5 |  +0 |  +0 |

- **_Tools of the Trade._** The mechanist is proficient with tinker tools and doubles its proficiency bonus for any ability check it makes with tinker tools.

**Actions**

- **_Multiattack._** The mechanist makes two Warhammer or Light Crossbow attacks.
- **_Warhammer._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) bludgeoning damage, or 8 (1d10+3) bludgeoning damage if used with two hands.
- **_Light Crossbow._** _Ranged Weapon Attack:_ +3 to hit, range 80/320 ft., one target. _Hit:_ 5 (1d8+1) piercing damage.
- **_Repair (Recharge 4 - 6)._** The mechanist touches one friendly Construct it can see. The target regains 5 (2d4) HP.

**Bonus Actions**

- **_Quick Creation (Recharge 4 - 6)._** The mechanist cobbles together various machine parts it is carrying and creates a Tiny Construct. The Construct obeys the mechanist's spoken commands. It uses the statistics of a solodron but it isn't a mechadron or part of the Plan. The mechanist can have up to two such Constructs under its control at one time. Each Construct remains for 1 minute, until the mechanist dies, or until the mechanist uses this bonus action again to dismiss one or both of them.

**Reactions**

- **_Magnetic Pulse._** When a creature the mechanist can see attacks it with a weapon made at least partially of metal while within 5 feet of it, the mechanist can release a magical, magnetic pulse. The attacker must succeed on a DC 13 DEX save or have disadvantage on the attack roll.

### Noble (CR 1/8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 14 (Impenetrable Ego)
- **Hit Points** 7
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 11
- **Resistant** Impenetrable Ego
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +1 |  +0 |  +1 |  +2 |  +5 |

- **_Impenetrable Ego._** While the noble is conscious and wearing no armor and wielding no shield, it adds its CHA modifier to its AC (included above). In addition, it is resistant to the charmed and frightened conditions.

**Actions**

- **_Rapier._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 5 (1d8+1) piercing damage.

**Reactions**

- **_Parry._** The noble adds 2 to its AC against one melee attack that would hit it. To do so, the noble must see the attacker and be wielding a melee weapon.

### Priest (CR 2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13 (chain shirt)
- **Hit Points** 57
- **Speed** 30 ft.
- **Perception** 15
- **Stealth** 10
- **Resistant** Divine Blessing
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +1 |  +1 |  +5 |  +1 |

- **_Divine Blessing._** The priest is resistant to necrotic damage or radiant damage, as appropriate for the priest's deity.
- **_Divine Weapons._** The priest's weapons are shrouded in dark or golden flames, as appropriate for the priest's deity. When the priest hits with any weapon, the weapon deals an extra 2d6 necrotic damage or radiant damage (included in the attack), the priest's choice.

**Actions**

- **_Multiattack._** The priest makes two Mace or Divine Bolt attacks.
- **_Mace._** _Melee Weapon Attack:_ +3 to hit, reach 5 ft., one target. _Hit:_ 4 (1d6+1) bludgeoning damage plus 7 (2d6) necrotic damage or radiant damage (the priest's choice).
- **_Divine Bolt._** _Ranged Spell Attack:_ +5 to hit, range 60 ft., one target. _Hit:_ 10 (2d6+3) necrotic damage or radiant damage (the priest's choice).
- **_Spellcasting._** The priest casts one of the following spells, using WIS as the spellcasting ability (spell save DC 13).
  - At will: _guidance_, _light_, _thaumaturgy_
  - 2/day each: _bane_, _bless_, _cure wounds_
  - 1/day each: _dispel magic_, _restoration_

### Scout (CR 1/2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13 (leather armor)
- **Hit Points** 25
- **Speed** 30 ft.
- **Perception** 13
- **Stealth** 16
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +2 |  +1 |  +0 |  +3 |  +0 |

- **_Heightened Hearing and Sight._** The scout's Perception is 18 when perceiving by hearing or sight.

**Actions**

- **_Multiattack._** The scout makes two Shortsword or Shortbow attacks.
- **_Shortsword._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.
- **_Shortbow._** _Ranged Weapon Attack:_ +4 to hit, ranged 80/320 ft., one target. _Hit:_ 5 (1d6+2) piercing damage.

**Bonus Actions**

- **_Escape to Report._** The scout takes the Dash or Disengage action.

### Spy (CR 1)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 13
- **Hit Points** 40
- **Speed** 30 ft.
- **Perception** 16
- **Stealth** 17
- **Senses** -
- **Languages** any two languages

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +0 |  +5 |  +0 |  +1 |  +2 |  +3 |

**Actions**

- **_Multiattack._** The spy makes two Shortsword or Hand Crossbow attacks.
- **_Shortsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.
- **_Hand Crossbow._** _Ranged Weapon Attack:_ +5 to hit, range 30/120 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.

**Bonus Actions**

- **_Cunning Action._** The spy takes the Dash, Disengage, or Hide action.
- **_Feint (Recharge 4 - 6)._** The spy makes a feint at one creature within 5 feet of it, pretending to go in for an attack in one direction only to change it up at the last moment. The target must succeed on a DC 13 WIS save or the spy has advantage on the next attack roll it makes against the target.

### Thug (CR 1/2)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 11 (leather armor)
- **Hit Points** 25
- **Speed** 30 ft.
- **Perception** 10
- **Stealth** 12
- **Senses** -
- **Languages** any one language (usually Common)

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +0 |  +2 |  +0 |  +0 |  +0 |

- **_Brutal._** A melee weapon deals one extra die of its damage when the thug hits with it (included in the attack).
- **_Pack Tactics._** The thug has advantage on attack rolls against a creature if at least one of the thug's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Club._** _Melee Weapon Attack:_ +4 to hit, reach 5 ft., one target. _Hit:_ 7 (2d4+2) bludgeoning damage.
- **_Heavy Crossbow._** _Ranged Weapon Attack:_ +2 to hit, range 100/400 ft., one target. _Hit:_ 5 (1d10) piercing damage.

**Bonus Actions**

- **_Sucker Punch._** The thug employs unscrupulous tactics to hit its opponent in a vulnerable spot. One creature the thug can see within 5 feet of it must make a DC 12 DEX save. On a failure, the target takes 2 (1d4) bludgeoning damage.

### Veteran (CR 3)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 16 (breastplate)
- **Hit Points** 68
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 14
- **Senses** -
- **Languages** Common plus any one language

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +5 |  +2 |  +2 |  +0 |  +0 |  +0 |

**Actions**

- **_Multiattack._** The veteran makes two Longsword attacks and two Shortsword attacks, or it makes three Longsword attacks.
- **_Longsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 7 (1d8+3) slashing damage, or 8 (1d10+3) slashing damage if used with two hands.
- **_Shortsword._** _Melee Weapon Attack:_ +5 to hit, reach 5 ft., one target. _Hit:_ 6 (1d6+3) piercing damage.
- **_Heavy Crossbow._** _Ranged Weapon Attack:_ +4 to hit, range 100/400 ft., one target. _Hit:_ 7 (1d10+2) piercing damage.

**Bonus Actions**

- **_Shoulder._** The veteran shoves a creature it can see within 5 feet of it. The target must succeed on a DC 13 STR save or be knocked prone.

**Reactions**

- **_Parry._** The veteran adds 2 to its AC against one melee attack that would hit it. To do so, the veteran must see the attacker and be wielding a melee weapon.

### Wild Warrior (CR 1/8)

_Medium Humanoid (Any Lineage)_

- **Armor Class** 12 (hide armor)
- **Hit Points** 9
- **Speed** 30 ft.
- **Perception** 12
- **Stealth** 12
- **Senses** -
- **Languages** any one language

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +1 |  +0 |  +1 |  -1 |  +0 |  -1 |

- **_Home in the Wilds._** The wild warrior automatically discerns true north when outside, and checks to follow its tracks in forest, grassland, hills, or mountain terrain have disadvantage, unless the wild warrior chooses to leave obvious signs of its passage.
- **_Pack Tactics._** The wild warrior has advantage on attack rolls against a creature if at least one of the warrior's allies is within 5 feet of the creature and the ally isn't incapacitated.

**Actions**

- **_Spear._** _Melee or Ranged Weapon Attack:_ +3 to hit, reach 5 ft. or range 20/60 ft., one target. _Hit:_ 4 (1d6+1) piercing damage, or 5 (1d8+1) piercing damage if used with two hands to make a melee attack.

**Bonus Actions**

- **_Quick Trap._** The wild warrior cobbles together a makeshift trap with materials at hand and throws the trap at a creature it can see within 15 feet of it. The target must succeed on a DC 11 DEX save or be restrained until the end of its next turn.
